/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveReader;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.ISubqueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.BaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.IDataExtractionTask;
import org.eclipse.birt.report.engine.api.IExtractionResults;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IResultMetaData;
import org.eclipse.birt.report.engine.api.IResultSetItem;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.api.impl.EngineTask;
import org.eclipse.birt.report.engine.api.impl.ExtractionResults;
import org.eclipse.birt.report.engine.api.impl.ReportRunnable;
import org.eclipse.birt.report.engine.api.impl.ResultMetaData;
import org.eclipse.birt.report.engine.api.impl.ResultSetItem;
import org.eclipse.birt.report.engine.data.IDataEngine;
import org.eclipse.birt.report.engine.data.dte.DteMetaInfoIOUtil;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.mozilla.javascript.Scriptable;

public class DataExtractionTaskV1
extends EngineTask
implements IDataExtractionTask {
    protected IReportDocument reportDocReader;
    protected Report report;
    protected InstanceID instanceId;
    protected String resultSetName;
    protected String[] selectedColumns;
    protected IExtractionResults currentResult = null;
    protected IFilterDefinition[] filterExpressions = null;
    protected boolean isMetaDataPrepared = false;
    protected HashMap rsetName2IdMapping = new HashMap();
    protected HashMap rsetId2queryIdMapping = new HashMap();
    protected HashMap queryId2NameMapping = new HashMap();
    protected HashMap queryId2QueryMapping = new HashMap();
    protected ArrayList resultMetaList = new ArrayList();
    protected static Logger logger;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.birt.report.engine.api.impl.DataExtractionTaskV1");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.birt.report.engine.data.dte.DteDataEngine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz2.getName());
    }

    public DataExtractionTaskV1(IReportEngine engine, IReportRunnable runnable, IReportDocument reader) throws EngineException {
        super(engine, runnable);
        this.report = ((ReportRunnable)runnable).getReportIR();
        this.reportDocReader = reader;
        this.executionContext.setReportDocument(this.reportDocReader);
        this.executionContext.setFactoryMode(false);
        this.executionContext.setPresentationMode(true);
        this.setParameterValues(this.reportDocReader.getParameterValues());
        this.setParameterDisplayTexts(this.reportDocReader.getParameterDisplayTexts());
        this.usingParameterValues();
        this.executionContext.registerGlobalBeans(this.reportDocReader.getGlobalVariables(null));
        Map appContext = this.executionContext.getAppContext();
        IDataEngine dataEngine = this.executionContext.getDataEngine();
        dataEngine.prepare(this.report, appContext);
    }

    private void prepareMetaData() {
        if (this.isMetaDataPrepared) {
            return;
        }
        HashMap queryIds = this.report.getQueryIDs();
        HashMap query2itemMapping = this.report.getReportItemToQueryMap();
        Iterator iter = queryIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            IDataQueryDefinition baseQuery = (IDataQueryDefinition)entry.getKey();
            if (!(baseQuery instanceof IQueryDefinition)) continue;
            IQueryDefinition query = (IQueryDefinition)baseQuery;
            String queryId = (String)entry.getValue();
            ReportItemDesign item = (ReportItemDesign)query2itemMapping.get(query);
            String queryName = item.getName();
            if (queryName == null) {
                queryName = "ELEMENT_" + item.getID();
            }
            this.queryId2NameMapping.put(queryId, queryName);
            this.queryId2QueryMapping.put(queryId, query);
        }
        try {
            this.loadResultSetMetaData();
        }
        catch (EngineException e) {
            logger.log(Level.WARNING, e.getMessage(), (Throwable)((Object)e));
            this.executionContext.addException(e);
        }
        this.isMetaDataPrepared = true;
    }

    private String getQueryName(String queryId) {
        return (String)this.queryId2NameMapping.get(queryId);
    }

    private IQueryDefinition getQuery(String queryId) {
        return (IQueryDefinition)this.queryId2QueryMapping.get(queryId);
    }

    private void loadResultSetMetaData() throws EngineException {
        try {
            HashMap query2ResultMetaData = this.report.getResultMetaData();
            IDocArchiveReader reader = this.reportDocReader.getArchive();
            HashMap<String, Integer> queryCounts = new HashMap<String, Integer>();
            ArrayList result = DteMetaInfoIOUtil.loadDteMetaInfo(reader);
            if (result != null) {
                HashSet<String> dteMetaInfoSet = new HashSet<String>();
                int i = 0;
                while (i < result.size()) {
                    String[] rsetRelation = (String[])result.get(i);
                    String dteMetaInfoString = this.getDteMetaInfoString(rsetRelation);
                    if (!dteMetaInfoSet.contains(dteMetaInfoString)) {
                        ResultMetaData metaData;
                        dteMetaInfoSet.add(dteMetaInfoString);
                        String queryId = rsetRelation[2];
                        String rsetId = rsetRelation[3];
                        IQueryDefinition query = this.getQuery(queryId);
                        this.rsetId2queryIdMapping.put(rsetId, queryId);
                        int count = -1;
                        Integer countObj = (Integer)queryCounts.get(queryId);
                        if (countObj != null) {
                            count = countObj;
                        }
                        String rsetName = this.getQueryName(queryId);
                        if (++count > 0) {
                            rsetName = String.valueOf(rsetName) + "_" + count;
                        }
                        queryCounts.put(queryId, new Integer(count));
                        this.rsetName2IdMapping.put(rsetName, rsetId);
                        if (query2ResultMetaData != null && (metaData = (ResultMetaData)query2ResultMetaData.get(query)) != null && metaData.getColumnCount() > 0) {
                            ResultSetItem resultItem = new ResultSetItem(rsetName, metaData);
                            this.resultMetaList.add(resultItem);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ioe.getMessage(), ioe);
        }
    }

    private String getDteMetaInfoString(String[] rsetRelation) {
        StringBuffer buffer = new StringBuffer();
        String pRsetId = rsetRelation[0];
        String rowId = rsetRelation[1];
        String queryId = rsetRelation[2];
        String rsetId = rsetRelation[3];
        buffer.setLength(0);
        buffer.append(pRsetId);
        buffer.append(".");
        buffer.append(rowId);
        buffer.append(".");
        buffer.append(queryId);
        buffer.append(".");
        buffer.append(rsetId);
        return buffer.toString();
    }

    InstanceID[] getAncestors(InstanceID id) {
        LinkedList<InstanceID> iids = new LinkedList<InstanceID>();
        while (id != null) {
            iids.addFirst(id);
            id = id.getParentID();
        }
        return iids.toArray(new InstanceID[0]);
    }

    IBaseResultSet executeQuery(IBaseResultSet prset, InstanceID iid) throws BirtException {
        IDataQueryDefinition query;
        long id;
        ReportItemDesign design;
        DataID dataId = iid.getDataID();
        if (dataId != null && prset != null) {
            if (prset instanceof IQueryResultSet) {
                ((IQueryResultSet)prset).skipTo(dataId.getRowID());
            } else if (prset instanceof ICubeResultSet) {
                ((ICubeResultSet)prset).skipTo(dataId.getCellID());
            }
        }
        if ((design = (ReportItemDesign)this.report.getReportItemByID(id = iid.getComponentID())) != null && (query = design.getQuery()) != null) {
            return this.executionContext.getDataEngine().execute(prset, query, false);
        }
        return prset;
    }

    protected String instanceId2RsetName(InstanceID iid) {
        InstanceID[] iids = this.getAncestors(iid);
        ArrayList<IBaseResultSet> rsets = new ArrayList<IBaseResultSet>();
        IBaseResultSet prset = null;
        IBaseResultSet rset = null;
        String rsetName = null;
        try {
            int i = 0;
            while (i < iids.length) {
                rset = this.executeQuery(prset, iids[i]);
                if (rset != null && rset != prset) {
                    rsets.add(rset);
                }
                prset = rset;
                ++i;
            }
            if (rset != null) {
                rsetName = rset.getID().getDataSetName();
            }
        }
        catch (BirtException ex) {
            logger.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
        }
        int i = 0;
        while (i < rsets.size()) {
            rset = (IBaseResultSet)rsets.get(i);
            rset.close();
            ++i;
        }
        if (rsetName != null) {
            return this.rsetId2Name(rsetName);
        }
        return rsetName;
    }

    protected String queryId2rsetId(String id) {
        Iterator iter = this.rsetId2queryIdMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String queryId = (String)entry.getValue();
            String rsetId = (String)entry.getKey();
            if (!queryId.equals(id)) continue;
            return rsetId;
        }
        return null;
    }

    protected String rsetId2Name(String id) {
        Iterator iter = this.rsetName2IdMapping.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String rsetId = (String)entry.getValue();
            String rsetName = (String)entry.getKey();
            if (!rsetId.equals(id)) continue;
            return rsetName;
        }
        return null;
    }

    protected String rsetName2Id(String name) {
        return (String)this.rsetName2IdMapping.get(name);
    }

    public void setInstanceID(InstanceID iid) {
        if (!$assertionsDisabled && iid == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        this.instanceId = iid;
        this.resultSetName = null;
        this.selectedColumns = null;
    }

    public void selectResultSet(String displayName) {
        if (!$assertionsDisabled && displayName == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        if (displayName.startsWith("InstanceId:")) {
            this.resultSetName = null;
            this.instanceId = InstanceID.parse(displayName.substring(11));
        } else {
            this.resultSetName = displayName;
            this.instanceId = null;
        }
        this.selectedColumns = null;
    }

    public List getMetaData() throws EngineException {
        return this.getResultSetList();
    }

    public List getResultSetList() throws EngineException {
        this.prepareMetaData();
        if (this.instanceId != null) {
            ArrayList<ResultSetItem> rsetList = new ArrayList<ResultSetItem>();
            IResultMetaData metaData = this.getMetaDateByInstanceID(this.instanceId);
            if (metaData != null) {
                rsetList.add(new ResultSetItem("InstanceId:" + this.instanceId.toUniqueString(), metaData));
            }
            return rsetList;
        }
        return this.resultMetaList;
    }

    protected IResultMetaData getResultMetaData(String rsetName) {
        Iterator iter = this.resultMetaList.iterator();
        while (iter.hasNext()) {
            IResultSetItem rsetItem = (IResultSetItem)iter.next();
            if (!rsetItem.getResultSetName().equals(rsetName)) continue;
            return rsetItem.getResultMetaData();
        }
        return null;
    }

    public void selectColumns(String[] columnNames) {
        this.selectedColumns = columnNames;
    }

    public IExtractionResults extract() throws EngineException {
        try {
            String rsetName = this.resultSetName;
            if (rsetName == null && this.instanceId != null) {
                rsetName = this.instanceId2RsetName(this.instanceId);
            }
            if (rsetName != null) {
                return this.extractByResultSetName(rsetName);
            }
            if (this.instanceId != null) {
                return this.extractByInstanceID(this.instanceId);
            }
            return null;
        }
        catch (BirtException ex) {
            throw new EngineException(ex.getLocalizedMessage(), ex);
        }
    }

    private IExtractionResults extractByResultSetName(String rsetName) throws BirtException {
        if (!$assertionsDisabled && rsetName == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.executionContext.getDataEngine() == null) {
            throw new AssertionError();
        }
        this.prepareMetaData();
        DataRequestSession dataSession = this.executionContext.getDataEngine().getDTESession();
        String rsetId = this.rsetName2Id(rsetName);
        if (rsetId != null) {
            IResultMetaData metaData;
            IQueryResults results = null;
            if (this.filterExpressions == null) {
                results = dataSession.getQueryResults(rsetId);
            } else {
                String queryId = (String)this.rsetId2queryIdMapping.get(rsetId);
                QueryDefinition query = (QueryDefinition)this.getQuery(queryId);
                QueryDefinition newQuery = this.cloneQuery(query);
                if (newQuery == null) {
                    return null;
                }
                int iNum = 0;
                while (iNum < this.filterExpressions.length) {
                    newQuery.getFilters().add(this.filterExpressions[iNum]);
                    ++iNum;
                }
                this.filterExpressions = null;
                newQuery.setQueryResultsID(rsetId);
                Scriptable scope = this.executionContext.getSharedScope();
                IPreparedQuery preparedQuery = dataSession.prepare((IQueryDefinition)newQuery);
                results = preparedQuery.execute(scope);
            }
            if (results != null && (metaData = this.getResultMetaData(rsetName)) != null) {
                return new ExtractionResults(results, metaData, this.selectedColumns);
            }
        }
        return null;
    }

    private IExtractionResults extractByInstanceID(InstanceID instanceId) throws BirtException {
        InstanceID iid = instanceId;
        while (iid != null) {
            long id = iid.getComponentID();
            ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
            IDataQueryDefinition dataQuery = design.getQuery();
            if (dataQuery != null) {
                if (!(dataQuery instanceof IBaseQueryDefinition)) {
                    return null;
                }
                IBaseQueryDefinition query = (IBaseQueryDefinition)dataQuery;
                if (this.filterExpressions != null) {
                    query = this.cloneQuery(query);
                    int i = 0;
                    while (i < this.filterExpressions.length) {
                        query.getFilters().add(this.filterExpressions[i]);
                        ++i;
                    }
                }
                while (iid != null) {
                    DataID dataId = iid.getDataID();
                    if (dataId != null) {
                        DataSetID dataSetId = dataId.getDataSetID();
                        long rowId = dataId.getRowID();
                        IResultIterator dataIter = this.executeSubQuery(dataSetId, rowId, (ISubqueryDefinition)query);
                        IResultMetaData metaData = this.getMetaDateByInstanceID(instanceId);
                        if (dataIter != null && metaData != null) {
                            return new ExtractionResults(dataIter, metaData, this.selectedColumns);
                        }
                        return null;
                    }
                    iid = iid.getParentID();
                }
                return null;
            }
            iid = iid.getParentID();
        }
        return null;
    }

    private IResultMetaData getMetaDateByInstanceID(InstanceID iid) {
        while (iid != null) {
            long id = iid.getComponentID();
            ReportItemDesign design = (ReportItemDesign)this.report.getReportItemByID(id);
            IDataQueryDefinition query = design.getQuery();
            if (query != null) {
                HashMap query2ResultMetaData = this.report.getResultMetaData();
                if (query2ResultMetaData != null) {
                    return (ResultMetaData)query2ResultMetaData.get(query);
                }
                return null;
            }
            iid = iid.getParentID();
        }
        return null;
    }

    private IResultIterator executeQuery(String rset, QueryDefinition query) throws BirtException {
        query.setQueryResultsID(rset);
        DataRequestSession dataSession = this.executionContext.getDataEngine().getDTESession();
        Scriptable scope = this.executionContext.getSharedScope();
        Map appContext = this.executionContext.getAppContext();
        IPreparedQuery pQuery = dataSession.prepare((IQueryDefinition)query, appContext);
        IQueryResults results = pQuery.execute(scope);
        return results.getResultIterator();
    }

    private IResultIterator executeSubQuery(DataSetID dataSet, long rowId, ISubqueryDefinition query) throws BirtException {
        IResultIterator rsetIter = null;
        String rset = dataSet.getDataSetName();
        rsetIter = rset != null ? this.executeQuery(rset, (QueryDefinition)query.getParentQuery()) : this.executeSubQuery(dataSet.getParentID(), dataSet.getRowID(), (ISubqueryDefinition)query.getParentQuery());
        rsetIter.moveTo((int)rowId);
        String queryName = query.getName();
        Scriptable scope = this.executionContext.getSharedScope();
        return rsetIter.getSecondaryIterator(queryName, scope);
    }

    private BaseQueryDefinition cloneQuery(IBaseQueryDefinition query) {
        if (query instanceof SubqueryDefinition) {
            return this.cloneQuery((SubqueryDefinition)query);
        }
        if (query instanceof QueryDefinition) {
            return this.cloneQuery((QueryDefinition)query);
        }
        return null;
    }

    private SubqueryDefinition cloneQuery(SubqueryDefinition query) {
        BaseQueryDefinition parent = this.cloneQuery(query.getParentQuery());
        SubqueryDefinition newQuery = new SubqueryDefinition(query.getName(), (IBaseQueryDefinition)parent);
        newQuery.getBindings().putAll(query.getBindings());
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getSubqueries().addAll(query.getSubqueries());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        parent.getSubqueries().add(newQuery);
        return newQuery;
    }

    private QueryDefinition cloneQuery(QueryDefinition query) {
        QueryDefinition newQuery = new QueryDefinition();
        newQuery.getBindings().putAll(query.getBindings());
        newQuery.getSorts().addAll(query.getSorts());
        newQuery.getFilters().addAll(query.getFilters());
        newQuery.getGroups().addAll(query.getGroups());
        newQuery.setUsesDetails(query.usesDetails());
        newQuery.setMaxRows(query.getMaxRows());
        newQuery.setDataSetName(query.getDataSetName());
        newQuery.setAutoBinding(query.needAutoBinding());
        newQuery.setColumnProjection(query.getColumnProjection());
        return newQuery;
    }

    public void setFilters(IFilterDefinition[] simpleFilterExpression) {
        this.filterExpressions = simpleFilterExpression;
    }
}

