/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.IParameterSelectionChoice;
import org.eclipse.birt.report.model.api.ReportDesignHandle;

public class ParameterSelectionChoice
implements IParameterSelectionChoice,
Cloneable {
    protected Locale locale;
    protected ReportDesignHandle design;
    protected String label;
    protected String labelKey;
    protected Object value;
    protected Logger log;
    static /* synthetic */ Class class$0;

    public ParameterSelectionChoice(ReportDesignHandle handle) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.impl.ParameterSelectionChoice");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.log = Logger.getLogger(clazz.getName());
        this.design = handle;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLabel(String lableKey, String label) {
        this.label = label;
        this.labelKey = lableKey;
    }

    public void setValue(String value, int type) {
        try {
            switch (type) {
                case 5: {
                    this.value = DataTypeUtil.toBoolean((Object)value);
                    break;
                }
                case 4: {
                    this.value = DataTypeUtil.toDate((Object)value);
                    break;
                }
                case 3: {
                    this.value = DataTypeUtil.toBigDecimal((Object)value);
                    break;
                }
                case 2: {
                    this.value = DataTypeUtil.toDouble((Object)value);
                    break;
                }
                case 6: {
                    this.value = DataTypeUtil.toInteger((Object)value);
                    break;
                }
                case 7: {
                    this.value = DataTypeUtil.toSqlDate((Object)value);
                }
                case 8: {
                    this.value = DataTypeUtil.toSqlTime((Object)value);
                }
                default: {
                    this.value = DataTypeUtil.toString((Object)value);
                    break;
                }
            }
        }
        catch (BirtException e) {
            this.log.log(Level.SEVERE, e.getLocalizedMessage(), e);
            this.value = null;
        }
    }

    public String getLabel() {
        if (this.labelKey == null) {
            return this.label;
        }
        String ret = this.design.getMessage(this.labelKey, this.locale == null ? Locale.getDefault() : this.locale);
        return ret == null || ret.length() == 0 ? this.label : ret;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Object getValue() {
        return this.value;
    }
}

