/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;

public class DynamicTextItemExecutor
extends QueryItemExecutor {
    DynamicTextItemExecutor(ExecutorManager manager) {
        super(manager, 5);
    }

    public IContent execute() {
        Object content;
        String rawType;
        DynamicTextItemDesign textDesign = (DynamicTextItemDesign)this.getDesign();
        IForeignContent textContent = this.report.createForeignContent();
        this.setContent(textContent);
        this.executeQuery();
        this.initializeContent(textDesign, textContent);
        this.processStyle(textDesign, textContent);
        this.processBookmark(textDesign, textContent);
        this.processVisibility(textDesign, textContent);
        this.processAction(textDesign, textContent);
        String contentType = textDesign.getContentType();
        if (contentType == null) {
            contentType = "auto";
        }
        if ("text/plaintext".equals(rawType = ForeignContent.getTextRawType(contentType, content = this.context.evaluate(textDesign.getContent())))) {
            rawType = "binary/value";
        }
        textContent.setRawType(rawType);
        textContent.setRawValue(content);
        if (this.context.isInFactory()) {
            this.handleOnCreate(textContent);
        }
        this.startTOCEntry(textContent);
        return textContent;
    }

    public void close() {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
    }
}

