/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v3;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.archive.IDocArchiveWriter;
import org.eclipse.birt.core.archive.RAOutputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.api.impl.ReportDocumentWriter;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.IReportContentWriter;

public class ReportContentWriterV3
implements IReportContentWriter {
    protected static Logger logger;
    protected ReportDocumentWriter document;
    protected RAOutputStream cntStream;
    protected long cntOffset;
    protected long rootOffset;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private DataOutputStream bufferStream = new DataOutputStream(this.buffer);
    protected Stack contents = new Stack();
    static final long OFFSET_PARENT = 0L;
    static final long OFFSET_NEXT = 8L;
    static final long OFFSET_CHILD = 16L;
    static final int INDEX_ENTRY_SIZE = 24;
    static final int VERSION_SIZE = 4;
    protected static final int VERSION_1 = 1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.internal.document.IReportContentWriter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public ReportContentWriterV3(ReportDocumentWriter document) {
        this.document = document;
    }

    public void open(String name) throws IOException {
        IDocArchiveWriter archive = this.document.getArchive();
        this.cntStream = archive.createRandomAccessStream(name);
        this.cntStream.writeInt(1);
        this.cntOffset = 0L;
        this.rootOffset = -1L;
    }

    public void close() {
        if (this.cntStream != null) {
            try {
                this.cntStream.close();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Failed in close the writer", ex);
            }
            this.cntStream = null;
        }
    }

    public long getOffset() {
        return this.cntOffset;
    }

    public long writeContent(IContent content) throws IOException {
        this.updateIndex(content);
        this.buffer.reset();
        IOUtil.writeInt((OutputStream)this.bufferStream, (int)content.getContentType());
        content.writeContent(this.bufferStream);
        this.bufferStream.flush();
        byte[] values = this.buffer.toByteArray();
        this.cntStream.seek(this.cntOffset + 4L);
        this.cntStream.writeInt(values.length);
        this.cntStream.write(values);
        this.cntOffset = this.cntOffset + 4L + (long)values.length;
        DocumentExtension docExt = (DocumentExtension)content.getExtension(0);
        if (docExt != null) {
            return docExt.getIndex();
        }
        return -1L;
    }

    public long writeFullContent(IContent content) throws IOException {
        long offset = this.writeContent(content);
        Iterator iter = content.getChildren().iterator();
        while (iter.hasNext()) {
            IContent child = (IContent)iter.next();
            this.writeFullContent(child);
        }
        return offset;
    }

    protected void updateIndex(IContent content) throws IOException {
        long index = this.cntOffset;
        long parent = -1L;
        long previous = -1L;
        IContent pContent = (IContent)content.getParent();
        if (pContent != null) {
            DocumentExtension pDocExt = (DocumentExtension)pContent.getExtension(0);
            if (pDocExt != null) {
                parent = pDocExt.getIndex();
                long lastChild = pDocExt.getLastChild();
                if (lastChild != -1L) {
                    previous = lastChild;
                }
                pDocExt.setLastChild(index);
            } else {
                previous = this.rootOffset;
                this.rootOffset = index;
            }
        } else {
            previous = this.rootOffset;
            this.rootOffset = index;
        }
        DocumentExtension docExt = new DocumentExtension(index);
        docExt.setParent(parent);
        docExt.setPrevious(previous);
        content.setExtension(0, docExt);
        this.cntStream.seek(4L + index);
        this.cntStream.writeLong(parent);
        this.cntStream.writeLong(-1L);
        this.cntStream.writeLong(-1L);
        this.cntOffset += 24L;
        if (previous == -1L) {
            if (parent != -1L) {
                this.cntStream.seek(4L + parent + 16L);
                this.cntStream.writeLong(index);
            }
        } else {
            this.cntStream.seek(4L + previous + 8L);
            this.cntStream.writeLong(index);
        }
    }
}

