/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.report.engine.api.DataID;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;
import org.eclipse.birt.report.engine.extension.ICubeResultSet;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.DocumentExtension;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.doc.Fragment;
import org.eclipse.birt.report.engine.internal.executor.doc.Segment;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.presentation.InstanceIndex;

public class ExtendedItemExecutor
extends ContainerExecutor {
    protected static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.internal.document.v4.ExtendedItemExecutor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public ExtendedItemExecutor(ExecutorManager manager) {
        super(manager, 8);
    }

    public void close() {
        this.closeQuery();
        super.close();
    }

    protected IReportItemExecutor prepareChildExecutor() throws Exception {
        IContent childContent;
        if (this.prepareFirstChild) {
            DocumentExtension docExt;
            if (this.fragment == null && this.nextOffset == -1L && (docExt = (DocumentExtension)this.content.getExtension(0)) != null) {
                this.nextOffset = docExt.getFirstChild();
            }
            if (this.fragment != null && this.sections == null) {
                this.sections = this.fragment.getSections();
                this.nextSection = -1;
                this.useNextSection = true;
            }
            this.prepareFirstChild = false;
        }
        if (this.fragment != null && this.useNextSection) {
            this.useNextSection = false;
            ++this.nextSection;
            if (this.sections == null || this.nextSection >= this.sections.length) {
                return null;
            }
            Object leftEdge = this.sections[this.nextSection][0];
            if (leftEdge == Segment.LEFT_MOST_EDGE) {
                DocumentExtension docExt = (DocumentExtension)this.content.getExtension(0);
                if (docExt != null) {
                    this.nextOffset = docExt.getFirstChild();
                }
            } else {
                InstanceIndex leftIndex = (InstanceIndex)leftEdge;
                InstanceID leftId = leftIndex.getInstanceID();
                this.nextOffset = leftIndex.getOffset();
                this.uniqueId = leftId.getUniqueID();
            }
        }
        if (this.nextOffset == -1L) {
            return null;
        }
        ReportItemExecutor childExecutor = this.doCreateExecutor(this.nextOffset);
        if (childExecutor != null && (childContent = childExecutor.execute()) != null) {
            DocumentExtension docExt;
            if (this.fragment != null) {
                InstanceIndex rightIndex;
                InstanceID rightId;
                Object rightEdge;
                InstanceID childId = childContent.getInstanceID();
                Fragment childFragment = this.fragment.getFragment(childId);
                if (childFragment != null) {
                    childExecutor.setFragment(childFragment);
                }
                if ((rightEdge = this.sections[this.nextSection][1]) != Segment.RIGHT_MOST_EDGE && this.isSameInstance(rightId = (rightIndex = (InstanceIndex)rightEdge).getInstanceID(), childId)) {
                    this.useNextSection = true;
                }
            }
            if ((docExt = (DocumentExtension)childContent.getExtension(0)) != null) {
                this.nextOffset = docExt.getNext();
            }
        }
        return childExecutor;
    }

    public IContent execute() {
        if (!this.executed) {
            this.executed = true;
            try {
                if (this.offset != -1L) {
                    this.generateUniqueID();
                    this.content = this.reader.loadContent(this.offset);
                    this.content.setGenerateBy(this.design);
                    this.instanceId = this.content.getInstanceID();
                    IContent pContent = this.getParentContent();
                    if (pContent != null) {
                        this.content.setParent(pContent);
                        this.instanceId = new InstanceID(pContent.getInstanceID(), this.instanceId.getUniqueID(), this.instanceId.getComponentID(), this.instanceId.getDataID());
                        this.content.setInstanceID(this.instanceId);
                    }
                    this.doExecute();
                }
            }
            catch (Exception ex) {
                logger.log(Level.WARNING, ex.getMessage(), ex);
                this.context.addException(new EngineException(ex.getLocalizedMessage()));
            }
        }
        return this.content;
    }

    protected void doExecute() throws Exception {
        InstanceID iid = this.content.getInstanceID();
        DataID dataId = iid.getDataID();
        if (dataId != null) {
            IBaseResultSet rset = this.getResultSet();
            if (rset == null) {
                rset = this.restoreParentResultSet();
            }
            if (rset != null) {
                if (rset instanceof IQueryResultSet) {
                    IQueryResultSet qrset = (IQueryResultSet)rset;
                    long rowId = dataId.getRowID();
                    if (rowId != -1L) {
                        qrset.skipTo(rowId);
                    }
                } else if (rset instanceof ICubeResultSet) {
                    ICubeResultSet crset = (ICubeResultSet)rset;
                    String cid = dataId.getCellID();
                    if (cid != null) {
                        crset.skipTo(cid);
                    }
                }
            }
        }
        this.executeQuery();
    }

    protected void executeQuery() {
        this.getParentResultSet();
        if (this.design != null) {
            boolean useCache = this.design.useCachedResult();
            IDataQueryDefinition[] queries = this.design.getQueries();
            if (queries != null) {
                this.rsets = new IBaseResultSet[queries.length];
                try {
                    IBaseResultSet prset = this.restoreParentResultSet();
                    int i = 0;
                    while (i < queries.length) {
                        this.rsets[i] = this.context.executeQuery(prset, queries[i], useCache);
                        ++i;
                    }
                    this.context.setResultSets(this.rsets);
                }
                catch (BirtException ex) {
                    this.context.addException(ex);
                }
            }
        }
    }

    protected IContent doCreateContent() {
        throw new IllegalStateException("can't create the content for extended item");
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        if (offset != -1L) {
            IContent content = this.reader.loadContent(offset);
            InstanceID iid = content.getInstanceID();
            ReportItemDesign design = (ReportItemDesign)this.report.getDesign().getReportItemByID(iid.getComponentID());
            return this.manager.createExecutor(this, design, offset);
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID id, long offset) throws Exception {
    }
}

