/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.internal.document.v4;

import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.internal.document.v4.ContainerExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.ExecutorManager;
import org.eclipse.birt.report.engine.internal.document.v4.ReportItemExecutor;
import org.eclipse.birt.report.engine.internal.document.v4.RowExecutor;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;

public class GridItemExecutor
extends ContainerExecutor {
    private int nextItem = 0;

    public GridItemExecutor(ExecutorManager manager) {
        super(manager, 0);
    }

    protected IContent doCreateContent() {
        return this.report.createTableContent();
    }

    protected void doExecute() throws Exception {
        GridItemDesign gridDesign = (GridItemDesign)this.getDesign();
        ITableContent tableContent = (ITableContent)this.content;
        this.executeQuery();
        if (tableContent.getColumnCount() == 0) {
            int i = 0;
            while (i < gridDesign.getColumnCount()) {
                ColumnDesign columnDesign = gridDesign.getColumn(i);
                Column column = new Column(this.report);
                column.setGenerateBy(columnDesign);
                InstanceID iid = new InstanceID(null, columnDesign.getID(), null);
                column.setInstanceID(iid);
                tableContent.addColumn(column);
                ++i;
            }
        } else {
            int columnCount = tableContent.getColumnCount();
            int i = 0;
            while (i < columnCount) {
                Column column = (Column)tableContent.getColumn(i);
                InstanceID iid = column.getInstanceID();
                if (iid != null) {
                    long componentId = iid.getComponentID();
                    ReportElementDesign element = this.report.getDesign().getReportItemByID(componentId);
                    column.setGenerateBy(element);
                }
                ++i;
            }
        }
    }

    public void close() {
        this.nextItem = 0;
        this.closeQuery();
        super.close();
    }

    protected ReportItemExecutor doCreateExecutor(long offset) throws Exception {
        GridItemDesign gridDesign = (GridItemDesign)this.getDesign();
        if (this.nextItem < gridDesign.getRowCount()) {
            RowDesign design = gridDesign.getRow(this.nextItem);
            ++this.nextItem;
            RowExecutor rowExecutor = (RowExecutor)this.manager.createExecutor(this, design, offset);
            rowExecutor.setRowId(this.nextItem);
            return rowExecutor;
        }
        return null;
    }

    protected void doSkipToExecutor(InstanceID id, long offset) throws Exception {
        GridItemDesign gridDesign = (GridItemDesign)this.getDesign();
        int rowCount = gridDesign.getRowCount();
        long rowId = id.getComponentID();
        int i = 0;
        while (i < rowCount) {
            RowDesign rowDesign = gridDesign.getRow(i);
            if (rowId == rowDesign.getID()) {
                this.nextItem = i;
                return;
            }
            ++i;
        }
        this.nextItem = rowCount;
    }
}

