/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.ir;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.ir.ActionDesign;
import org.eclipse.birt.report.engine.ir.AutoTextItemDesign;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.CellDesign;
import org.eclipse.birt.report.engine.ir.ColumnDesign;
import org.eclipse.birt.report.engine.ir.DataItemDesign;
import org.eclipse.birt.report.engine.ir.DefaultReportItemVisitorImpl;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.ir.DrillThroughActionDesign;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;
import org.eclipse.birt.report.engine.ir.ExtendedItemDesign;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.GraphicMasterPageDesign;
import org.eclipse.birt.report.engine.ir.GridItemDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.HighlightDesign;
import org.eclipse.birt.report.engine.ir.HighlightRuleDesign;
import org.eclipse.birt.report.engine.ir.IOConstants;
import org.eclipse.birt.report.engine.ir.ImageItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.ListBandDesign;
import org.eclipse.birt.report.engine.ir.ListGroupDesign;
import org.eclipse.birt.report.engine.ir.ListItemDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.MapDesign;
import org.eclipse.birt.report.engine.ir.MapRuleDesign;
import org.eclipse.birt.report.engine.ir.MasterPageDesign;
import org.eclipse.birt.report.engine.ir.PageSetupDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.ir.ReportElementDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.ir.RowDesign;
import org.eclipse.birt.report.engine.ir.SimpleMasterPageDesign;
import org.eclipse.birt.report.engine.ir.StyledElementDesign;
import org.eclipse.birt.report.engine.ir.TableBandDesign;
import org.eclipse.birt.report.engine.ir.TableGroupDesign;
import org.eclipse.birt.report.engine.ir.TableItemDesign;
import org.eclipse.birt.report.engine.ir.TemplateDesign;
import org.eclipse.birt.report.engine.ir.TextItemDesign;
import org.eclipse.birt.report.engine.ir.VisibilityDesign;
import org.eclipse.birt.report.engine.ir.VisibilityRuleDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ImageHandle;

public class EngineIRWriter
implements IOConstants {
    public void write(OutputStream out, Report design) throws IOException {
        DataOutputStream dos = new DataOutputStream(out);
        IOUtil.writeLong((DataOutputStream)dos, (long)3L);
        IOUtil.writeString((DataOutputStream)dos, (String)"3.2.15");
        Map styles = design.getStyles();
        IOUtil.writeInt((OutputStream)dos, (int)styles.size());
        Iterator iter = styles.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String styleName = (String)entry.getKey();
            IStyle style = (IStyle)entry.getValue();
            IOUtil.writeString((DataOutputStream)dos, (String)styleName);
            this.writeStyle(dos, style);
        }
        String rootStyleName = design.getRootStyleName();
        IOUtil.writeString((DataOutputStream)dos, (String)rootStyleName);
        Map namedExpressions = design.getNamedExpressions();
        IOUtil.writeMap((DataOutputStream)dos, (Map)namedExpressions);
        ReportItemWriter writer = new ReportItemWriter(dos);
        PageSetupDesign pageSetup = design.getPageSetup();
        int masterPageCount = pageSetup.getMasterPageCount();
        IOUtil.writeInt((OutputStream)dos, (int)masterPageCount);
        int i = 0;
        while (i < masterPageCount) {
            SimpleMasterPageDesign masterPage = (SimpleMasterPageDesign)pageSetup.getMasterPage(i);
            writer.writeMasterPage(masterPage);
            ++i;
        }
        int count = design.getContentCount();
        IOUtil.writeInt((OutputStream)dos, (int)count);
        int i2 = 0;
        while (i2 < count) {
            ReportItemDesign item = design.getContent(i2);
            writer.write(item);
            ++i2;
        }
        dos.flush();
    }

    protected void writeReportElement(DataOutputStream out, ReportElementDesign design) throws IOException {
        Map customProperties;
        Map namedExpression;
        String javaClass;
        String ext;
        String name;
        long id = design.getID();
        if (id != -1L) {
            IOUtil.writeShort((OutputStream)out, (short)0);
            IOUtil.writeLong((DataOutputStream)out, (long)id);
        }
        if ((name = design.getName()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)1);
            IOUtil.writeString((DataOutputStream)out, (String)name);
        }
        if ((ext = design.getExtends()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)2);
            IOUtil.writeString((DataOutputStream)out, (String)ext);
        }
        if ((javaClass = design.getJavaClass()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)3);
            IOUtil.writeString((DataOutputStream)out, (String)javaClass);
        }
        if ((namedExpression = design.getNamedExpressions()) != null && !namedExpression.isEmpty()) {
            IOUtil.writeShort((OutputStream)out, (short)4);
            IOUtil.writeMap((DataOutputStream)out, (Map)namedExpression);
        }
        if ((customProperties = design.getCustomProperties()) != null && !customProperties.isEmpty()) {
            IOUtil.writeShort((OutputStream)out, (short)5);
            IOUtil.writeMap((DataOutputStream)out, (Map)customProperties);
        }
    }

    protected void writeStyledElement(DataOutputStream out, StyledElementDesign design) throws IOException {
        HighlightDesign highlight;
        MapDesign map;
        this.writeReportElement(out, design);
        String styleName = design.getStyleName();
        if (styleName != null) {
            IOUtil.writeShort((OutputStream)out, (short)6);
            IOUtil.writeString((DataOutputStream)out, (String)styleName);
        }
        if ((map = design.getMap()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)7);
            this.writeMap(out, map);
        }
        if ((highlight = design.getHighlight()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)8);
            this.writeHighlight(out, highlight);
        }
    }

    protected void writeReportItem(DataOutputStream out, ReportItemDesign design) throws IOException {
        boolean useCachedResult;
        ActionDesign action;
        VisibilityDesign visibility;
        String onPageBreak;
        String onRender;
        String onCreate;
        String toc;
        String bookmark;
        DimensionType width;
        DimensionType height;
        DimensionType y;
        this.writeStyledElement(out, design);
        DimensionType x = design.getX();
        if (x != null) {
            IOUtil.writeShort((OutputStream)out, (short)20);
            this.writeDimension(out, x);
        }
        if ((y = design.getY()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)21);
            this.writeDimension(out, y);
        }
        if ((height = design.getHeight()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)22);
            this.writeDimension(out, height);
        }
        if ((width = design.getWidth()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)23);
            this.writeDimension(out, width);
        }
        if ((bookmark = design.getBookmark()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)24);
            IOUtil.writeString((DataOutputStream)out, (String)bookmark);
        }
        if ((toc = design.getTOC()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)25);
            IOUtil.writeString((DataOutputStream)out, (String)toc);
        }
        if ((onCreate = design.getOnCreate()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)26);
            IOUtil.writeString((DataOutputStream)out, (String)onCreate);
        }
        if ((onRender = design.getOnRender()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)27);
            IOUtil.writeString((DataOutputStream)out, (String)onRender);
        }
        if ((onPageBreak = design.getOnPageBreak()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)28);
            IOUtil.writeString((DataOutputStream)out, (String)onPageBreak);
        }
        if ((visibility = design.getVisibility()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)29);
            this.writeVisibility(out, visibility);
        }
        if ((action = design.getAction()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)112);
            this.writeAction(out, action);
        }
        if (useCachedResult = design.useCachedResult()) {
            IOUtil.writeShort((OutputStream)out, (short)230);
            IOUtil.writeBool((OutputStream)out, (boolean)useCachedResult);
        }
    }

    protected void writeMasterPage(DataOutputStream out, MasterPageDesign design) throws IOException {
        String bodyStyleName;
        this.writeStyledElement(out, design);
        String pageType = design.getPageType();
        if (pageType != null) {
            IOUtil.writeShort((OutputStream)out, (short)200);
            IOUtil.writeString((DataOutputStream)out, (String)pageType);
        }
        DimensionType width = design.getPageWidth();
        DimensionType height = design.getPageHeight();
        IOUtil.writeShort((OutputStream)out, (short)201);
        this.writeDimension(out, width);
        this.writeDimension(out, height);
        DimensionType top = design.getTopMargin();
        DimensionType left = design.getLeftMargin();
        DimensionType bottom = design.getBottomMargin();
        DimensionType right = design.getRightMargin();
        IOUtil.writeShort((OutputStream)out, (short)202);
        this.writeDimension(out, top);
        this.writeDimension(out, left);
        this.writeDimension(out, bottom);
        this.writeDimension(out, right);
        String orientation = design.getOrientation();
        if (orientation != null) {
            IOUtil.writeShort((OutputStream)out, (short)203);
            IOUtil.writeString((DataOutputStream)out, (String)orientation);
        }
        if ((bodyStyleName = design.getBodyStyleName()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)204);
            IOUtil.writeString((DataOutputStream)out, (String)bodyStyleName);
        }
    }

    protected void writeSimpleMasterPage(DataOutputStream out, SimpleMasterPageDesign design) throws IOException {
        DimensionType footerHeigh;
        DimensionType headerHeight;
        boolean floatingFooter;
        boolean showFooterOnLast;
        this.writeMasterPage(out, design);
        boolean showHeaderOnFirst = design.isShowHeaderOnFirst();
        if (!showHeaderOnFirst) {
            IOUtil.writeShort((OutputStream)out, (short)210);
            IOUtil.writeBool((OutputStream)out, (boolean)showHeaderOnFirst);
        }
        if (!(showFooterOnLast = design.isShowFooterOnLast())) {
            IOUtil.writeShort((OutputStream)out, (short)211);
            IOUtil.writeBool((OutputStream)out, (boolean)showFooterOnLast);
        }
        if (floatingFooter = design.isFloatingFooter()) {
            IOUtil.writeShort((OutputStream)out, (short)212);
            IOUtil.writeBool((OutputStream)out, (boolean)floatingFooter);
        }
        if ((headerHeight = design.getHeaderHeight()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)213);
            this.writeDimension(out, headerHeight);
        }
        if ((footerHeigh = design.getFooterHeight()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)214);
            this.writeDimension(out, footerHeigh);
        }
    }

    protected void writeGraphicMasterPage(DataOutputStream out, GraphicMasterPageDesign design) throws IOException {
        DimensionType columnSpacing;
        this.writeMasterPage(out, design);
        int columns = design.getColumns();
        if (columns != -1) {
            IOUtil.writeShort((OutputStream)out, (short)70);
            IOUtil.writeInt((OutputStream)out, (int)columns);
        }
        if ((columnSpacing = design.getColumnSpacing()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)220);
            this.writeDimension(out, columnSpacing);
        }
    }

    protected void writeListing(DataOutputStream out, ListingDesign listing) throws IOException {
        this.writeReportItem(out, listing);
        boolean repeatHeader = listing.isRepeatHeader();
        int pageBreakInterval = listing.getPageBreakInterval();
        if (repeatHeader) {
            IOUtil.writeShort((OutputStream)out, (short)31);
            IOUtil.writeBool((OutputStream)out, (boolean)repeatHeader);
        }
        if (pageBreakInterval != -1) {
            IOUtil.writeShort((OutputStream)out, (short)30);
            IOUtil.writeInt((OutputStream)out, (int)pageBreakInterval);
        }
    }

    protected void writeGroup(DataOutputStream out, GroupDesign group) throws IOException {
        this.writeReportItem(out, group);
        int groupLevel = group.getGroupLevel();
        String pageBreakBefore = group.getPageBreakBefore();
        String pageBreakAfter = group.getPageBreakAfter();
        String pageBreakInside = group.getPageBreakInside();
        boolean hideDetail = group.getHideDetail();
        boolean headerRepeat = group.isHeaderRepeat();
        if (groupLevel != -1) {
            IOUtil.writeShort((OutputStream)out, (short)40);
            IOUtil.writeInt((OutputStream)out, (int)groupLevel);
        }
        if (pageBreakBefore != null) {
            IOUtil.writeShort((OutputStream)out, (short)41);
            IOUtil.writeString((DataOutputStream)out, (String)pageBreakBefore);
        }
        if (pageBreakAfter != null) {
            IOUtil.writeShort((OutputStream)out, (short)42);
            IOUtil.writeString((DataOutputStream)out, (String)pageBreakAfter);
        }
        if (pageBreakInside != null) {
            IOUtil.writeShort((OutputStream)out, (short)45);
            IOUtil.writeString((DataOutputStream)out, (String)pageBreakInside);
        }
        if (headerRepeat) {
            IOUtil.writeShort((OutputStream)out, (short)43);
            IOUtil.writeBool((OutputStream)out, (boolean)headerRepeat);
        }
        if (hideDetail) {
            IOUtil.writeShort((OutputStream)out, (short)44);
            IOUtil.writeBool((OutputStream)out, (boolean)hideDetail);
        }
    }

    protected void writeBand(DataOutputStream out, BandDesign band) throws IOException {
        this.writeReportItem(out, band);
        int bandType = band.getBandType();
        if (bandType != -1) {
            IOUtil.writeShort((OutputStream)out, (short)50);
            IOUtil.writeInt((OutputStream)out, (int)bandType);
        }
    }

    protected void writeList(DataOutputStream out, ListItemDesign list) throws IOException {
        this.writeListing(out, list);
    }

    protected void writeListGroup(DataOutputStream out, ListGroupDesign group) throws IOException {
        this.writeGroup(out, group);
    }

    protected void writeListBand(DataOutputStream out, ListBandDesign listBand) throws IOException {
        this.writeBand(out, listBand);
    }

    protected void writeTable(DataOutputStream out, TableItemDesign table) throws IOException {
        this.writeListing(out, table);
        String captionKey = table.getCaptionKey();
        String caption = table.getCaption();
        if (caption != null || captionKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)60);
            IOUtil.writeString((DataOutputStream)out, (String)captionKey);
            IOUtil.writeString((DataOutputStream)out, (String)caption);
        }
        int columnCount = table.getColumnCount();
        IOUtil.writeShort((OutputStream)out, (short)70);
        IOUtil.writeInt((OutputStream)out, (int)columnCount);
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        DataOutputStream buffer = new DataOutputStream(bo);
        int i = 0;
        while (i < columnCount) {
            ColumnDesign column = table.getColumn(i);
            bo.reset();
            this.writeColumn(buffer, column);
            buffer.flush();
            IOUtil.writeBytes((DataOutputStream)out, (byte[])bo.toByteArray());
            ++i;
        }
    }

    protected void writeTableGroup(DataOutputStream out, TableGroupDesign group) throws IOException {
        this.writeGroup(out, group);
    }

    protected void writeTableBand(DataOutputStream out, TableBandDesign listBand) throws IOException {
        this.writeBand(out, listBand);
    }

    protected void writeGrid(DataOutputStream out, GridItemDesign grid) throws IOException {
        this.writeReportItem(out, grid);
        int columnCount = grid.getColumnCount();
        IOUtil.writeShort((OutputStream)out, (short)70);
        IOUtil.writeInt((OutputStream)out, (int)columnCount);
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        DataOutputStream buffer = new DataOutputStream(bo);
        int i = 0;
        while (i < columnCount) {
            ColumnDesign column = grid.getColumn(i);
            bo.reset();
            this.writeColumn(buffer, column);
            buffer.flush();
            IOUtil.writeBytes((DataOutputStream)out, (byte[])bo.toByteArray());
            ++i;
        }
    }

    protected void writeColumn(DataOutputStream out, ColumnDesign column) throws IOException {
        boolean hasDataItemsInDetail;
        VisibilityDesign visibility;
        boolean suppressDuplicate;
        this.writeStyledElement(out, column);
        DimensionType width = column.getWidth();
        if (width != null) {
            IOUtil.writeShort((OutputStream)out, (short)23);
            this.writeDimension(out, width);
        }
        if (suppressDuplicate = column.getSuppressDuplicate()) {
            IOUtil.writeShort((OutputStream)out, (short)80);
            IOUtil.writeBool((OutputStream)out, (boolean)suppressDuplicate);
        }
        if ((visibility = column.getVisibility()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)29);
            this.writeVisibility(out, visibility);
        }
        if (hasDataItemsInDetail = column.hasDataItemsInDetail()) {
            IOUtil.writeShort((OutputStream)out, (short)81);
            IOUtil.writeBool((OutputStream)out, (boolean)hasDataItemsInDetail);
        }
    }

    protected void writeRow(DataOutputStream out, RowDesign row) throws IOException {
        this.writeReportItem(out, row);
        boolean isStartOfGroup = row.isStartOfGroup();
        if (isStartOfGroup) {
            IOUtil.writeShort((OutputStream)out, (short)90);
            IOUtil.writeBool((OutputStream)out, (boolean)isStartOfGroup);
        }
    }

    protected void writeCell(DataOutputStream out, CellDesign cell) throws IOException {
        boolean displayGroupIcon;
        String drop;
        int rowSpan;
        int colSpan;
        this.writeReportItem(out, cell);
        int column = cell.getColumn();
        if (column != -1) {
            IOUtil.writeShort((OutputStream)out, (short)100);
            IOUtil.writeInt((OutputStream)out, (int)column);
        }
        if ((colSpan = cell.getColSpan()) != 1) {
            IOUtil.writeShort((OutputStream)out, (short)101);
            IOUtil.writeInt((OutputStream)out, (int)colSpan);
        }
        if ((rowSpan = cell.getRowSpan()) != 1) {
            IOUtil.writeShort((OutputStream)out, (short)102);
            IOUtil.writeInt((OutputStream)out, (int)rowSpan);
        }
        if ((drop = cell.getDrop()) != null) {
            IOUtil.writeShort((OutputStream)out, (short)103);
            IOUtil.writeString((DataOutputStream)out, (String)drop);
        }
        if (displayGroupIcon = cell.getDisplayGroupIcon()) {
            IOUtil.writeShort((OutputStream)out, (short)104);
            IOUtil.writeBool((OutputStream)out, (boolean)displayGroupIcon);
        }
    }

    protected void writeFreeForm(DataOutputStream out, FreeFormItemDesign freeForm) throws IOException {
        this.writeReportItem(out, freeForm);
    }

    protected void writeLabel(DataOutputStream out, LabelItemDesign label) throws IOException {
        this.writeReportItem(out, label);
        String text = label.getText();
        String textKey = label.getTextKey();
        String helpText = label.getHelpText();
        String helpTextKey = label.getHelpTextKey();
        if (text != null || textKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)110);
            IOUtil.writeString((DataOutputStream)out, (String)textKey);
            IOUtil.writeString((DataOutputStream)out, (String)text);
        }
        if (helpText != null || helpTextKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)111);
            IOUtil.writeString((DataOutputStream)out, (String)helpTextKey);
            IOUtil.writeString((DataOutputStream)out, (String)helpText);
        }
    }

    protected void writeData(DataOutputStream out, DataItemDesign data) throws IOException {
        this.writeReportItem(out, data);
        String bindingColumn = data.getBindingColumn();
        String helpText = data.getHelpText();
        String helpTextKey = data.getHelpTextKey();
        boolean suppressDuplicate = data.getSuppressDuplicate();
        boolean needRefreshMapping = data.needRefreshMapping();
        if (bindingColumn != null) {
            IOUtil.writeShort((OutputStream)out, (short)121);
            IOUtil.writeString((DataOutputStream)out, (String)bindingColumn);
        }
        if (helpText != null || helpTextKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)111);
            IOUtil.writeString((DataOutputStream)out, (String)helpTextKey);
            IOUtil.writeString((DataOutputStream)out, (String)helpText);
        }
        if (suppressDuplicate) {
            IOUtil.writeShort((OutputStream)out, (short)80);
            IOUtil.writeBool((OutputStream)out, (boolean)suppressDuplicate);
        }
        if (needRefreshMapping) {
            IOUtil.writeShort((OutputStream)out, (short)122);
            IOUtil.writeBool((OutputStream)out, (boolean)needRefreshMapping);
        }
    }

    protected void writeText(DataOutputStream out, TextItemDesign design) throws IOException {
        this.writeReportItem(out, design);
        String textType = design.getTextType();
        String textKey = design.getTextKey();
        String text = design.getText();
        if (textType != null) {
            IOUtil.writeShort((OutputStream)out, (short)130);
            IOUtil.writeString((DataOutputStream)out, (String)textType);
        }
        if (text != null || textKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)110);
            IOUtil.writeString((DataOutputStream)out, (String)textKey);
            IOUtil.writeString((DataOutputStream)out, (String)text);
        }
    }

    protected void writeDynamicText(DataOutputStream out, DynamicTextItemDesign design) throws IOException {
        this.writeReportItem(out, design);
        String contentType = design.getContentType();
        String content = design.getContent();
        if (contentType != null) {
            IOUtil.writeShort((OutputStream)out, (short)140);
            IOUtil.writeString((DataOutputStream)out, (String)contentType);
        }
        if (content != null) {
            IOUtil.writeShort((OutputStream)out, (short)141);
            IOUtil.writeString((DataOutputStream)out, (String)content);
        }
    }

    protected void writeImage(DataOutputStream out, ImageItemDesign image) throws IOException {
        this.writeReportItem(out, image);
        IOUtil.writeShort((OutputStream)out, (short)150);
        int imageSource = image.getImageSource();
        IOUtil.writeInt((OutputStream)out, (int)imageSource);
        switch (imageSource) {
            case 1: {
                String imageName = image.getImageName();
                DesignElementHandle handle = image.getHandle();
                if (handle instanceof ImageHandle) {
                    String designImageName = image.getImageName();
                    if (imageName != null && imageName.equals(designImageName)) {
                        imageName = null;
                    }
                }
                IOUtil.writeString((DataOutputStream)out, (String)imageName);
                break;
            }
            case 3: {
                IOUtil.writeString((DataOutputStream)out, (String)image.getImageUri());
                break;
            }
            case 0: {
                IOUtil.writeString((DataOutputStream)out, (String)image.getImageUri());
                break;
            }
            case 2: {
                IOUtil.writeString((DataOutputStream)out, (String)image.getImageExpression());
                IOUtil.writeString((DataOutputStream)out, (String)image.getImageFormat());
            }
        }
        String altText = image.getAltText();
        String altTextKey = image.getAltTextKey();
        String helpText = image.getHelpText();
        String helpTextKey = image.getHelpTextKey();
        if (altText != null || altTextKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)151);
            IOUtil.writeString((DataOutputStream)out, (String)altTextKey);
            IOUtil.writeString((DataOutputStream)out, (String)altText);
        }
        if (helpText != null || helpText != null) {
            IOUtil.writeShort((OutputStream)out, (short)111);
            IOUtil.writeString((DataOutputStream)out, (String)helpTextKey);
            IOUtil.writeString((DataOutputStream)out, (String)helpText);
        }
    }

    protected void writeExtended(DataOutputStream out, ExtendedItemDesign extended) throws IOException {
        this.writeReportItem(out, extended);
        String altText = extended.getAltText();
        String altTextKey = extended.getAltTextKey();
        if (altText != null || altTextKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)151);
            IOUtil.writeString((DataOutputStream)out, (String)altTextKey);
            IOUtil.writeString((DataOutputStream)out, (String)altText);
        }
    }

    protected void writeAutoText(DataOutputStream out, AutoTextItemDesign design) throws IOException {
        this.writeReportItem(out, design);
        String type = design.getType();
        if (type != null) {
            IOUtil.writeShort((OutputStream)out, (short)160);
            IOUtil.writeString((DataOutputStream)out, (String)type);
        }
        String text = design.getText();
        String textKey = design.getTextKey();
        if (text != null || textKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)110);
            IOUtil.writeString((DataOutputStream)out, (String)textKey);
            IOUtil.writeString((DataOutputStream)out, (String)text);
        }
    }

    protected void writeTemplate(DataOutputStream out, TemplateDesign design) throws IOException {
        this.writeReportItem(out, design);
        String allowedType = design.getAllowedType();
        if (allowedType != null) {
            IOUtil.writeShort((OutputStream)out, (short)170);
            IOUtil.writeString((DataOutputStream)out, (String)allowedType);
        }
        String promptText = design.getPromptText();
        String promptTextKey = design.getPromptTextKey();
        if (promptText != null || promptTextKey != null) {
            IOUtil.writeShort((OutputStream)out, (short)171);
            IOUtil.writeString((DataOutputStream)out, (String)promptTextKey);
            IOUtil.writeString((DataOutputStream)out, (String)promptText);
        }
    }

    protected void writeDimension(DataOutputStream out, DimensionType dimension) throws IOException {
        IOUtil.writeBool((OutputStream)out, (dimension != null ? 1 : 0) != 0);
        dimension.writeObject(out);
    }

    protected void writeVisibility(DataOutputStream out, VisibilityDesign visibility) throws IOException {
        int ruleCount = visibility.count();
        IOUtil.writeInt((OutputStream)out, (int)ruleCount);
        int i = 0;
        while (i < ruleCount) {
            VisibilityRuleDesign rule = visibility.getRule(i);
            IOUtil.writeString((DataOutputStream)out, (String)rule.getFormat());
            IOUtil.writeString((DataOutputStream)out, (String)rule.getExpression());
            ++i;
        }
    }

    protected void writeMap(DataOutputStream out, MapDesign map) throws IOException {
        int ruleCount = map.getRuleCount();
        IOUtil.writeInt((OutputStream)out, (int)ruleCount);
        int i = 0;
        while (i < ruleCount) {
            MapRuleDesign rule = map.getRule(i);
            IOUtil.writeString((DataOutputStream)out, (String)rule.getTestExpression());
            IOUtil.writeString((DataOutputStream)out, (String)rule.getOperator());
            IOUtil.writeString((DataOutputStream)out, (String)rule.getValue1());
            IOUtil.writeString((DataOutputStream)out, (String)rule.getValue2());
            IOUtil.writeString((DataOutputStream)out, (String)rule.getDisplayText());
            IOUtil.writeString((DataOutputStream)out, (String)rule.getDisplayKey());
            ++i;
        }
    }

    protected void writeHighlight(DataOutputStream out, HighlightDesign highlight) throws IOException {
        int ruleCount = highlight.getRuleCount();
        IOUtil.writeInt((OutputStream)out, (int)ruleCount);
        int i = 0;
        while (i < ruleCount) {
            HighlightRuleDesign rule = highlight.getRule(i);
            IOUtil.writeString((DataOutputStream)out, (String)rule.getTestExpression());
            IOUtil.writeString((DataOutputStream)out, (String)rule.getOperator());
            IOUtil.writeString((DataOutputStream)out, (String)rule.getValue1());
            IOUtil.writeString((DataOutputStream)out, (String)rule.getValue2());
            this.writeStyle(out, rule.getStyle());
            ++i;
        }
    }

    protected void writeStyle(DataOutputStream out, IStyle style) throws IOException {
        IOUtil.writeString((DataOutputStream)out, (String)style.getCssText());
    }

    protected void writeAction(DataOutputStream out, ActionDesign action) throws IOException {
        int actionType = action.getActionType();
        IOUtil.writeInt((OutputStream)out, (int)actionType);
        switch (actionType) {
            case 2: {
                String bookmark = action.getBookmark();
                IOUtil.writeString((DataOutputStream)out, (String)bookmark);
                break;
            }
            case 3: {
                DrillThroughActionDesign drillThrough = action.getDrillThrough();
                this.writeDrillThrough(out, drillThrough);
                break;
            }
            case 1: {
                String hyperlink = action.getHyperlink();
                IOUtil.writeString((DataOutputStream)out, (String)hyperlink);
            }
        }
        String targetWindow = action.getTargetWindow();
        IOUtil.writeString((DataOutputStream)out, (String)targetWindow);
    }

    protected void writeDrillThrough(DataOutputStream out, DrillThroughActionDesign drillThrough) throws IOException {
        String reportName = drillThrough.getReportName();
        Map parameters = drillThrough.getParameters();
        Map search = drillThrough.getSearch();
        String format = drillThrough.getFormat();
        boolean isBookmark = drillThrough.isBookmark();
        String bookmark = drillThrough.getBookmark();
        IOUtil.writeString((DataOutputStream)out, (String)reportName);
        IOUtil.writeMap((DataOutputStream)out, (Map)parameters);
        IOUtil.writeMap((DataOutputStream)out, (Map)search);
        IOUtil.writeString((DataOutputStream)out, (String)format);
        IOUtil.writeBool((OutputStream)out, (boolean)isBookmark);
        IOUtil.writeString((DataOutputStream)out, (String)bookmark);
    }

    private class ReportItemWriter
    extends DefaultReportItemVisitorImpl {
        DataOutputStream dos;
        ByteArrayOutputStream bout;
        DataOutputStream bdos;

        ReportItemWriter(DataOutputStream dos) {
            this.dos = dos;
            this.bout = new ByteArrayOutputStream();
            this.bdos = new DataOutputStream(this.bout);
        }

        public void write(ReportItemDesign design) throws IOException {
            Object exception = design.accept(this, null);
            if (exception != null) {
                throw (IOException)exception;
            }
        }

        public void writeMasterPage(SimpleMasterPageDesign masterPage) throws IOException {
            Object exception;
            ReportItemDesign item;
            this.bout.reset();
            EngineIRWriter.this.writeSimpleMasterPage(this.bdos, masterPage);
            this.bdos.flush();
            IOUtil.writeShort((OutputStream)this.dos, (short)2);
            IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
            int count = masterPage.getHeaderCount();
            IOUtil.writeInt((OutputStream)this.dos, (int)count);
            int i = 0;
            while (i < count) {
                item = masterPage.getHeader(i);
                exception = item.accept(this, null);
                if (exception != null) {
                    throw (IOException)exception;
                }
                ++i;
            }
            count = masterPage.getFooterCount();
            IOUtil.writeInt((OutputStream)this.dos, (int)count);
            i = 0;
            while (i < count) {
                item = masterPage.getFooter(i);
                exception = item.accept(this, null);
                if (exception != null) {
                    throw (IOException)exception;
                }
                ++i;
            }
        }

        public Object visitAutoTextItem(AutoTextItemDesign autoText, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeAutoText(this.bdos, autoText);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)21);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitCell(CellDesign cell, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeCell(this.bdos, cell);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)7);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                int contentCount = cell.getContentCount();
                IOUtil.writeInt((OutputStream)this.dos, (int)contentCount);
                int i = 0;
                while (i < contentCount) {
                    ReportItemDesign content = cell.getContent(i);
                    value = content.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitDataItem(DataItemDesign data, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeData(this.bdos, data);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)16);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitExtendedItem(ExtendedItemDesign item, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeExtended(this.bdos, item);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)20);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                List childrenDesigns = item.getChildren();
                IOUtil.writeInt((OutputStream)this.dos, (int)childrenDesigns.size());
                int i = 0;
                while (i < childrenDesigns.size()) {
                    ((ReportItemDesign)childrenDesigns.get(i)).accept(this, value);
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitFreeFormItem(FreeFormItemDesign container, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeFreeForm(this.bdos, container);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)4);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                int contentCount = container.getItemCount();
                IOUtil.writeInt((OutputStream)this.dos, (int)contentCount);
                int i = 0;
                while (i < contentCount) {
                    ReportItemDesign content = container.getItem(i);
                    value = content.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitGridItem(GridItemDesign grid, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeGrid(this.bdos, grid);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)3);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                int rowCount = grid.getRowCount();
                IOUtil.writeInt((OutputStream)this.dos, (int)rowCount);
                int i = 0;
                while (i < rowCount) {
                    RowDesign row = grid.getRow(i);
                    value = ((ReportItemDesign)row).accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitImageItem(ImageItemDesign image, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeImage(this.bdos, image);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)18);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitLabelItem(LabelItemDesign label, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeLabel(this.bdos, label);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)14);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitListBand(ListBandDesign band, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeListBand(this.bdos, band);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)10);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                int count = band.getContentCount();
                IOUtil.writeInt((OutputStream)this.dos, (int)count);
                int i = 0;
                while (i < count) {
                    ReportItemDesign content = band.getContent(i);
                    value = content.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitListGroup(ListGroupDesign group, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeListGroup(this.bdos, group);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)9);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                BandDesign header = group.getHeader();
                IOUtil.writeBool((OutputStream)this.dos, (header != null ? 1 : 0) != 0);
                if (header != null && (value = header.accept(this, value)) != null) {
                    return value;
                }
                BandDesign footer = group.getFooter();
                IOUtil.writeBool((OutputStream)this.dos, (footer != null ? 1 : 0) != 0);
                if (footer != null && (value = footer.accept(this, value)) != null) {
                    return value;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitListItem(ListItemDesign list, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeList(this.bdos, list);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)8);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                BandDesign header = list.getHeader();
                IOUtil.writeBool((OutputStream)this.dos, (header != null ? 1 : 0) != 0);
                if (header != null && (value = header.accept(this, value)) != null) {
                    return value;
                }
                int count = list.getGroupCount();
                IOUtil.writeInt((OutputStream)this.dos, (int)count);
                int i = 0;
                while (i < count) {
                    GroupDesign group = list.getGroup(i);
                    value = group.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
                BandDesign detail = list.getDetail();
                IOUtil.writeBool((OutputStream)this.dos, (detail != null ? 1 : 0) != 0);
                if (detail != null && (value = detail.accept(this, value)) != null) {
                    return value;
                }
                BandDesign footer = list.getFooter();
                IOUtil.writeBool((OutputStream)this.dos, (footer != null ? 1 : 0) != 0);
                if (footer != null && (value = footer.accept(this, value)) != null) {
                    return value;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitDynamicTextItem(DynamicTextItemDesign multiLine, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeDynamicText(this.bdos, multiLine);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)17);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitRow(RowDesign row, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeRow(this.bdos, row);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)6);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                int count = row.getCellCount();
                IOUtil.writeInt((OutputStream)this.dos, (int)count);
                int i = 0;
                while (i < count) {
                    CellDesign cell = row.getCell(i);
                    value = cell.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitTableBand(TableBandDesign band, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeTableBand(this.bdos, band);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)13);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                int rowCount = band.getRowCount();
                IOUtil.writeInt((OutputStream)this.dos, (int)rowCount);
                int i = 0;
                while (i < rowCount) {
                    RowDesign row = band.getRow(i);
                    value = ((ReportItemDesign)row).accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitTableGroup(TableGroupDesign group, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeTableGroup(this.bdos, group);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)12);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                BandDesign header = group.getHeader();
                IOUtil.writeBool((OutputStream)this.dos, (header != null ? 1 : 0) != 0);
                if (header != null && (value = header.accept(this, value)) != null) {
                    return value;
                }
                BandDesign footer = group.getFooter();
                IOUtil.writeBool((OutputStream)this.dos, (footer != null ? 1 : 0) != 0);
                if (footer != null && (value = footer.accept(this, value)) != null) {
                    return value;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitTableItem(TableItemDesign table, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeTable(this.bdos, table);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)11);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
                BandDesign header = table.getHeader();
                IOUtil.writeBool((OutputStream)this.dos, (header != null ? 1 : 0) != 0);
                if (header != null && (value = header.accept(this, value)) != null) {
                    return value;
                }
                int count = table.getGroupCount();
                IOUtil.writeInt((OutputStream)this.dos, (int)count);
                int i = 0;
                while (i < count) {
                    GroupDesign group = table.getGroup(i);
                    value = group.accept(this, value);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
                BandDesign detail = table.getDetail();
                IOUtil.writeBool((OutputStream)this.dos, (detail != null ? 1 : 0) != 0);
                if (detail != null && (value = detail.accept(this, value)) != null) {
                    return value;
                }
                BandDesign footer = table.getFooter();
                IOUtil.writeBool((OutputStream)this.dos, (footer != null ? 1 : 0) != 0);
                if (footer != null && (value = footer.accept(this, value)) != null) {
                    return value;
                }
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitTemplate(TemplateDesign template, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeTemplate(this.bdos, template);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)19);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }

        public Object visitTextItem(TextItemDesign text, Object value) {
            try {
                this.bout.reset();
                EngineIRWriter.this.writeText(this.bdos, text);
                this.bdos.flush();
                IOUtil.writeShort((OutputStream)this.dos, (short)15);
                IOUtil.writeBytes((DataOutputStream)this.dos, (byte[])this.bout.toByteArray());
            }
            catch (IOException ex) {
                return ex;
            }
            return null;
        }
    }
}

