/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import java.util.HashMap;
import java.util.Locale;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IReportContent;
import org.eclipse.birt.report.engine.emitter.IContentEmitter;
import org.eclipse.birt.report.engine.executor.IReportExecutor;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.internal.executor.dom.DOMReportItemExecutor;
import org.eclipse.birt.report.engine.layout.ILayoutManager;
import org.eclipse.birt.report.engine.layout.ILayoutPageHandler;
import org.eclipse.birt.report.engine.layout.IReportLayoutEngine;
import org.eclipse.birt.report.engine.layout.pdf.PDFAbstractLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutManagerFactory;
import org.eclipse.birt.report.engine.layout.pdf.PDFPageLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.font.FontHandler;
import org.eclipse.birt.report.engine.presentation.IPageHint;

public class PDFReportLayoutEngine
implements IReportLayoutEngine {
    protected IReportExecutor executor;
    protected PDFLayoutEngineContext context;
    protected PDFLayoutManagerFactory factory;
    protected ILayoutPageHandler handle;
    protected HashMap options = new HashMap();
    protected Locale locale;

    public PDFReportLayoutEngine() {
        this.context = new PDFLayoutEngineContext(this);
        this.factory = new PDFLayoutManagerFactory(this.context);
        this.context.setFactory(this.factory);
    }

    protected PDFLayoutManagerFactory createLayoutManagerFactory(PDFLayoutEngineContext context) {
        return new PDFLayoutManagerFactory(this.context);
    }

    protected void layoutReport(IReportContent report, IReportExecutor executor, IContentEmitter output) {
        if (output == null) {
            return;
        }
        FontHandler.prepareFonts();
        PDFPageLM pageLM = new PDFPageLM(this, this.context, report, output, executor);
        while (pageLM.layout()) {
        }
    }

    public void layout(IReportExecutor executor, IReportContent report, IContentEmitter output, boolean pagination) {
        this.context.setAllowPageBreak(pagination);
        this.executor = executor;
        this.context.setReport(report);
        this.setupLayoutOptions();
        if (this.locale != null) {
            this.context.setLocale(this.locale);
        } else {
            this.context.setLocale(Locale.getDefault());
        }
        if (output != null) {
            this.context.setFormat(output.getOutputFormat());
        }
        this.layoutReport(report, executor, output);
        executor.close();
    }

    public void layout(ILayoutManager parent, IReportItemExecutor executor, IContentEmitter emitter) {
        IContent content = executor.execute();
        PDFAbstractLM layoutManager = this.factory.createLayoutManager((PDFStackingLM)parent, content, executor);
        layoutManager.layout();
        layoutManager.close();
    }

    public void layout(ILayoutManager parent, IContent content, IContentEmitter output) {
        DOMReportItemExecutor executor = new DOMReportItemExecutor(content);
        this.layout(parent, executor, output);
        executor.close();
    }

    public void setPageHandler(ILayoutPageHandler handle) {
        this.handle = handle;
    }

    public ILayoutPageHandler getPageHandler() {
        return this.handle;
    }

    public void cancel() {
        if (this.context != null) {
            this.context.setCancel(true);
        }
    }

    protected void setupLayoutOptions() {
        Object bidiProcessing;
        Object fontSubstitution;
        Object textWrapping;
        Object outputDisplayNone;
        Object pageBreakOnly;
        Object fitToPage = this.options.get("pdfRenderOption.fitToPage");
        if (fitToPage != null && fitToPage instanceof Boolean && ((Boolean)fitToPage).booleanValue()) {
            this.context.setFitToPage(true);
        }
        if ((pageBreakOnly = this.options.get("pdfRenderOption.pagebreakPaginationOnly")) != null && pageBreakOnly instanceof Boolean && ((Boolean)pageBreakOnly).booleanValue()) {
            this.context.setPagebreakPaginationOnly(true);
        }
        if ((outputDisplayNone = this.options.get("org.eclipse.birt.report.engine.api.IRenderOption.outputDisplayNone")) instanceof Boolean && ((Boolean)outputDisplayNone).booleanValue()) {
            this.context.setOutputDisplayNone(true);
        }
        if ((textWrapping = this.options.get("pdfRenderOption.textWrapping")) != null && textWrapping instanceof Boolean && !((Boolean)textWrapping).booleanValue()) {
            this.context.setTextWrapping(false);
        }
        if ((fontSubstitution = this.options.get("pdfRenderOption.fontSubstitution")) != null && fontSubstitution instanceof Boolean && !((Boolean)fontSubstitution).booleanValue()) {
            this.context.setFontSubstitution(false);
        }
        if ((bidiProcessing = this.options.get("pdfRenderOption.bidiProcessing")) != null && bidiProcessing instanceof Boolean && !((Boolean)bidiProcessing).booleanValue()) {
            this.context.setBidiProcessing(false);
        }
    }

    public void setOption(String name, Object value) {
        this.options.put(name, value);
    }

    public Object getOption(String name) {
        return this.options.get(name);
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLayoutPageHint(IPageHint pageHint) {
        this.context.setLayoutPageHint(pageHint);
    }
}

