/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.impl.ActionContent;
import org.eclipse.birt.report.engine.content.impl.CellContent;
import org.eclipse.birt.report.engine.content.impl.Column;
import org.eclipse.birt.report.engine.content.impl.ReportContent;
import org.eclipse.birt.report.engine.content.impl.RowContent;
import org.eclipse.birt.report.engine.content.impl.TableContent;
import org.eclipse.birt.report.engine.executor.buffermgr.Cell;
import org.eclipse.birt.report.engine.executor.buffermgr.Row;
import org.eclipse.birt.report.engine.executor.buffermgr.Table;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.engine.layout.pdf.util.HTML2Content;
import org.eclipse.birt.report.engine.layout.pdf.util.PropertyUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class TableProcessor {
    private static final String ATTRIBUTE_COLSPAN = "colspan";
    private static final String ATTRIBUTE_ROWSPAN = "rowspan";
    static /* synthetic */ Class class$0;

    public static void processTable(Element ele, Map cssStyles, IContent content, IContent inlineParent, ActionContent action) {
        TableState tableState = new TableState(ele, cssStyles, content, inlineParent, action);
        tableState.processNodes();
        Table table = new Table(tableState.getRowCount(), tableState.getColumnCount());
        TableContent tableContent = (TableContent)tableState.getContent();
        Iterator rows = tableContent.getChildren().iterator();
        while (rows.hasNext()) {
            RowContent row = (RowContent)rows.next();
            table.createRow(row);
            Iterator cells = row.getChildren().iterator();
            while (cells.hasNext()) {
                CellContent cell = (CellContent)cells.next();
                int rowSpan = cell.getRowSpan();
                int colSpan = cell.getColSpan();
                table.createCell(-1, rowSpan, colSpan, new InternalCellContent(cell));
            }
        }
        TableProcessor.normalize(table, tableContent, tableState);
    }

    protected static void normalize(Table table, TableContent tableContent, TableState tableState) {
        ReportContent report = (ReportContent)tableContent.getReportContent();
        int i = 0;
        while (i < table.getRowCount()) {
            Row row = table.getRow(i);
            RowContent rowContent = (RowContent)row.getContent();
            Collection children = rowContent.getChildren();
            children.clear();
            int j = 0;
            while (j < table.getColCount()) {
                Cell cell = row.getCell(j);
                CellContent cellContent = null;
                int status = cell.getStatus();
                if (status == 0 || status == 2) {
                    cellContent = new CellContent(report);
                    cellContent.setRowSpan(1);
                    cellContent.setColSpan(1);
                    cellContent.setColumn(j);
                } else if (status == 1) {
                    cellContent = ((InternalCellContent)cell.getContent()).cell;
                    cellContent.setColSpan(cell.getColSpan());
                    cellContent.setRowSpan(cell.getRowSpan());
                    cellContent.setColumn(j);
                }
                children.add(cellContent);
                cellContent.setParent(rowContent);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < table.getColCount()) {
            Column column = new Column(report);
            column.setWidth(tableState.getColumnWidth(i));
            tableContent.addColumn(column);
            ++i;
        }
    }

    private static class CellState
    extends State {
        private CellContent cell;

        public CellState(Element element, Map cssStyles, IContent parent, IContent inlineParent, ActionContent action) {
            super(element, cssStyles, inlineParent, action);
            this.cell = new CellContent((ReportContent)parent.getReportContent());
            this.content = this.cell;
            this.setParent(parent);
            HTML2Content.handleStyle(element, cssStyles, this.content);
            this.cell.setRowSpan(PropertyUtil.getIntAttribute(element, TableProcessor.ATTRIBUTE_ROWSPAN));
            this.cell.setColSpan(PropertyUtil.getIntAttribute(element, TableProcessor.ATTRIBUTE_COLSPAN));
        }

        public void processNodes() {
            HTML2Content.processNodes(this.element, this.cssStyles, this.content, this.inlineParent, this.action);
        }

        public int getColSpan() {
            return this.cell.getColSpan();
        }
    }

    private static class InternalCellContent
    implements Cell.Content {
        CellContent cell;

        InternalCellContent(CellContent cell) {
            this.cell = cell;
        }

        public boolean isEmpty() {
            return this.cell != null;
        }

        public void reset() {
        }
    }

    private static class RowState
    extends State {
        private int columnCount;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.util.TableProcessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public RowState(Element element, Map cssStyles, IContent parent, IContent inlineParent, ActionContent action) {
            super(element, cssStyles, inlineParent, action);
            this.content = new RowContent((ReportContent)parent.getReportContent());
            this.setParent(parent);
            HTML2Content.handleStyle(element, cssStyles, this.content);
            this.content.setHeight(PropertyUtil.getDimensionAttribute(element, "height"));
        }

        public void processNodes() {
            Node node = this.element.getFirstChild();
            while (node != null) {
                if (!$assertionsDisabled && node.getNodeType() != 1) {
                    throw new AssertionError();
                }
                Element element = (Element)node;
                String tagName = element.getTagName();
                if (!$assertionsDisabled && !"td".equals(tagName)) {
                    throw new AssertionError();
                }
                CellState cellState = new CellState(element, this.cssStyles, this.content, this.inlineParent, this.action);
                cellState.processNodes();
                this.columnCount += cellState.getColSpan();
                node = node.getNextSibling();
            }
        }

        public int getColumnCount() {
            return this.columnCount;
        }
    }

    private static class State {
        protected Element element;
        protected Map cssStyles;
        protected IContent inlineParent;
        protected IContent content;
        protected ActionContent action;

        public State(Element element, Map cssStyles, IContent inlineParent, ActionContent action) {
            this.element = element;
            this.cssStyles = cssStyles;
            this.inlineParent = inlineParent;
            this.action = action;
        }

        protected void setParent(IContent parent) {
            parent.getChildren().add(this.content);
            this.content.setParent(parent);
        }

        public IContent getContent() {
            return this.content;
        }
    }

    public static class TableState
    extends State {
        private int columnCount;
        private int rowCount;
        private List columnWidth;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.layout.pdf.util.TableProcessor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public TableState(Element element, Map cssStyles, IContent parent, IContent inlineParent, ActionContent action) {
            super(element, cssStyles, inlineParent, action);
            this.content = new TableContent((ReportContent)parent.getReportContent());
            this.setParent(parent);
            this.content.setWidth(PropertyUtil.getDimensionAttribute(element, "width"));
            HTML2Content.handleStyle(element, cssStyles, this.content);
            this.columnWidth = new ArrayList();
        }

        public void processNodes() {
            Element ele = this.element;
            this.processNodes(ele);
        }

        private void processNodes(Element ele) {
            Node node = ele.getFirstChild();
            while (node != null) {
                if (!$assertionsDisabled && node.getNodeType() != 1) {
                    throw new AssertionError();
                }
                Element element = (Element)node;
                String tagName = element.getTagName();
                if ("tr".equals(tagName)) {
                    RowState rowState = new RowState(element, this.cssStyles, this.content, this.inlineParent, this.action);
                    rowState.processNodes();
                    this.columnCount = Math.max(this.columnCount, rowState.getColumnCount());
                    ++this.rowCount;
                } else if ("col".equals(tagName)) {
                    this.columnWidth.add(PropertyUtil.getDimensionAttribute(element, "width"));
                } else if ("tbody".equals(tagName) || "thead".equals(tagName) || "tfoot".equals(tagName)) {
                    this.processNodes(element);
                }
                node = node.getNextSibling();
            }
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        public int getRowCount() {
            return this.rowCount;
        }

        public DimensionType getColumnWidth(int column) {
            if (column >= this.columnWidth.size()) {
                return null;
            }
            return (DimensionType)this.columnWidth.get(column);
        }
    }
}

