/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class PlainTextParser {
    protected static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.parser.PlainTextParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    private Document parsePlainText(Reader reader) {
        try {
            String content;
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element body = doc.createElement("body");
            doc.appendChild(body);
            LineNumberReader lReader = new LineNumberReader(reader);
            while ((content = lReader.readLine()) != null) {
                this.appendChild(doc, body, content);
                body.appendChild(doc.createElement("br"));
            }
            if (body.getLastChild() != null) {
                body.removeChild(body.getLastChild());
            }
            return doc;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    private void appendChild(Document doc, Node body, String buf) {
        if (buf.length() > 0) {
            Text textNode = doc.createTextNode(buf);
            body.appendChild(textNode);
        }
    }

    Document parsePlainText(String text) {
        return this.parsePlainText(new StringReader(text));
    }

    Document parsePlainText(InputStream in) {
        try {
            return this.parsePlainText(new BufferedReader(new InputStreamReader(in, "UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }
}

