/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.data.engine.api.script.IBaseDataSourceEventHandler;
import org.eclipse.birt.data.engine.api.script.IDataSourceInstanceHandle;
import org.eclipse.birt.report.engine.api.script.eventhandler.IDataSourceEventHandler;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.DtEScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.instance.DataSourceInstance;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.mozilla.javascript.Scriptable;

public class DataSourceScriptExecutor
extends DtEScriptExecutor
implements IBaseDataSourceEventHandler {
    protected DataSourceHandle dataSourceHandle;
    protected IDataSourceEventHandler eventHandler;
    static /* synthetic */ Class class$0;

    public DataSourceScriptExecutor(DataSourceHandle dataSourceHandle, ExecutionContext context) {
        super(context);
        this.dataSourceHandle = dataSourceHandle;
        String className = dataSourceHandle.getEventHandlerClass();
        this.initEventHandler(className);
    }

    protected void initEventHandler(String className) {
        if (className != null) {
            try {
                this.eventHandler = (IDataSourceEventHandler)DataSourceScriptExecutor.getInstance(className, this.context);
            }
            catch (ClassCastException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.IScriptedDataSetEventHandler");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                DataSourceScriptExecutor.addClassCastException(this.context, e, className, clazz);
            }
        }
    }

    public void handleBeforeOpen(IDataSourceInstanceHandle dataSource) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.JSScriptStatus status = this.handleJS(dataSource.getScriptScope(), dataSource.getName(), "beforeOpen", this.dataSourceHandle.getBeforeOpen());
            if (status.didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.beforeOpen(new DataSourceInstance(dataSource), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSourceScriptExecutor.addException(this.context, e);
        }
    }

    public void handleBeforeClose(IDataSourceInstanceHandle dataSource) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.JSScriptStatus status = this.handleJS(dataSource.getScriptScope(), dataSource.getName(), "beforeClose", this.dataSourceHandle.getBeforeClose());
            if (status.didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.beforeClose(new DataSourceInstance(dataSource), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSourceScriptExecutor.addException(this.context, e);
        }
    }

    public void handleAfterOpen(IDataSourceInstanceHandle dataSource) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.JSScriptStatus status = this.handleJS(dataSource.getScriptScope(), dataSource.getName(), "afterOpen", this.dataSourceHandle.getAfterOpen());
            if (status.didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.afterOpen(new DataSourceInstance(dataSource), this.reportContext);
            }
        }
        catch (Exception e) {
            DataSourceScriptExecutor.addException(this.context, e);
        }
    }

    public void handleAfterClose(IDataSourceInstanceHandle dataSource) {
        if (this.reportContext == null) {
            return;
        }
        try {
            ScriptExecutor.JSScriptStatus status = this.handleJS(dataSource.getScriptScope(), dataSource.getName(), "afterClose", this.dataSourceHandle.getAfterClose());
            if (status.didRun()) {
                return;
            }
            if (this.eventHandler != null) {
                this.eventHandler.afterClose(this.reportContext);
            }
        }
        catch (Exception e) {
            DataSourceScriptExecutor.addException(this.context, e);
        }
    }

    protected ScriptExecutor.JSScriptStatus handleJS(Scriptable scope, String name, String method, String script) {
        return this.handleJS(scope, "DataSource", name, method, script);
    }
}

