/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.ILabelEventHandler;
import org.eclipse.birt.report.engine.content.ILabelContent;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.Label;
import org.eclipse.birt.report.engine.script.internal.instance.LabelInstance;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;

public class LabelScriptExecutor
extends ScriptExecutor {
    static /* synthetic */ Class class$0;

    public static void handleOnPrepare(LabelHandle labelHandle, ExecutionContext context) {
        try {
            Label label = new Label(labelHandle);
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelHandle, context);
            if (eh != null) {
                eh.onPrepare(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnCreate(ILabelContent content, ExecutionContext context) {
        try {
            ReportItemDesign labelDesign = (ReportItemDesign)content.getGenerateBy();
            if (!LabelScriptExecutor.needOnCreate(labelDesign)) {
                return;
            }
            LabelInstance label = new LabelInstance(content, context);
            if (LabelScriptExecutor.handleJS(label, labelDesign.getOnCreate(), context).didRun()) {
                return;
            }
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelDesign, context);
            if (eh != null) {
                eh.onCreate(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnRender(ILabelContent content, ExecutionContext context) {
        try {
            ReportItemDesign labelDesign = (ReportItemDesign)content.getGenerateBy();
            if (!LabelScriptExecutor.needOnRender(labelDesign)) {
                return;
            }
            LabelInstance label = new LabelInstance(content, context);
            if (LabelScriptExecutor.handleJS(label, labelDesign.getOnRender(), context).didRun()) {
                return;
            }
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelDesign, context);
            if (eh != null) {
                eh.onRender(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e);
        }
    }

    public static void handleOnPageBreak(ILabelContent content, ExecutionContext context) {
        try {
            ReportItemDesign labelDesign = (ReportItemDesign)content.getGenerateBy();
            if (!LabelScriptExecutor.needOnPageBreak(labelDesign)) {
                return;
            }
            LabelInstance label = new LabelInstance(content, context);
            if (LabelScriptExecutor.handleJS(label, labelDesign.getOnPageBreak(), context).didRun()) {
                return;
            }
            ILabelEventHandler eh = LabelScriptExecutor.getEventHandler(labelDesign, context);
            if (eh != null) {
                eh.onPageBreak(label, context.getReportContext());
            }
        }
        catch (Exception e) {
            LabelScriptExecutor.addException(context, e);
        }
    }

    private static ILabelEventHandler getEventHandler(ReportItemDesign design, ExecutionContext context) {
        try {
            return (ILabelEventHandler)LabelScriptExecutor.getInstance(design, context);
        }
        catch (ClassCastException e) {
            String string = design.getJavaClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.ILabelEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LabelScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }

    private static ILabelEventHandler getEventHandler(LabelHandle handle, ExecutionContext context) {
        try {
            return (ILabelEventHandler)LabelScriptExecutor.getInstance((DesignElementHandle)handle, context);
        }
        catch (ClassCastException e) {
            String string = handle.getEventHandlerClass();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.birt.report.engine.api.script.eventhandler.ILabelEventHandler");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            LabelScriptExecutor.addClassCastException(context, e, string, clazz);
            return null;
        }
    }
}

