/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import org.eclipse.birt.report.engine.api.script.eventhandler.IReportEventHandler;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.eclipse.birt.report.engine.script.internal.element.ReportDesign;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.simpleapi.IDesignElement;
import org.eclipse.birt.report.model.api.simpleapi.SimpleElementFactory;

public class ReportScriptExecutor
extends ScriptExecutor {
    public static void handleInitialize(ReportDesignHandle report, ExecutionContext context) {
        try {
            if (ReportScriptExecutor.handleJS(null, report.getInitialize(), context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.initialize(context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e);
        }
    }

    public static void handleBeforeFactory(ReportDesignHandle report, ExecutionContext context) {
        try {
            IDesignElement element = SimpleElementFactory.getInstance().getElement((DesignElementHandle)report);
            ReportDesign reportDesign = new ReportDesign(report);
            if (ReportScriptExecutor.handleJS(element, report.getBeforeFactory(), context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.beforeFactory(reportDesign, context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e);
        }
    }

    public static void handleAfterFactory(ReportDesignHandle report, ExecutionContext context) {
        try {
            if (ReportScriptExecutor.handleJS(null, report.getAfterFactory(), context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.afterFactory(context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e);
        }
    }

    public static void handleBeforeRender(ReportDesignHandle report, ExecutionContext context) {
        try {
            if (ReportScriptExecutor.handleJS(null, report.getBeforeRender(), context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.beforeRender(context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e);
        }
    }

    public static void handleAfterRender(ReportDesignHandle report, ExecutionContext context) {
        try {
            if (ReportScriptExecutor.handleJS(null, report.getAfterRender(), context).didRun()) {
                return;
            }
            IReportEventHandler eh = (IReportEventHandler)ReportScriptExecutor.getInstance((DesignElementHandle)report, context);
            if (eh != null) {
                eh.afterRender(context.getReportContext());
            }
        }
        catch (Exception e) {
            ReportScriptExecutor.addException(context, e);
        }
    }
}

