/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.consumer.services.impl;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.consumer.services.IPropertyProvider;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.ExtensionExplorer;
import org.eclipse.datatools.connectivity.oda.consumer.util.manifest.PropertyProviderManifest;
import org.eclipse.datatools.connectivity.oda.util.logging.LogManager;
import org.eclipse.datatools.connectivity.oda.util.logging.Logger;

public class ProviderUtil {
    private static final String sm_loggerName = "org.eclipse.datatools.connectivity.oda.consumer";

    public static IPropertyProvider createPropertyProvider(String applicationId) throws OdaException {
        String methodName = "ProviderUtil.getPropertyProvider( String )\t";
        if (applicationId == null || applicationId.length() == 0) {
            ProviderUtil.log("ProviderUtil.getPropertyProvider( String )\t", "No application id specified in method argument.");
            return null;
        }
        PropertyProviderManifest providerManifest = ExtensionExplorer.getInstance().getPropertyProviderManifest(applicationId);
        if (providerManifest == null) {
            ProviderUtil.log("ProviderUtil.getPropertyProvider( String )\t", "No IPropertyProvider found for " + applicationId + ".");
            return null;
        }
        IPropertyProvider extnProvider = providerManifest.createProvider();
        ProviderUtil.log("ProviderUtil.getPropertyProvider( String )\t", "Returning IPropertyProvider instance (" + extnProvider + ") of application id (" + applicationId + ").");
        return extnProvider;
    }

    private static void log(String context, String msg) {
        Logger logger = ProviderUtil.getLogger();
        if (logger != null) {
            logger.fine(context + msg);
        }
    }

    private static Logger getLogger() {
        return LogManager.getLogger((String)sm_loggerName);
    }
}

