/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.framework.osgi;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.IPlatformContext;
import org.eclipse.birt.core.framework.PlatformConfig;

public class OSGILauncher {
    private static Logger logger;
    private static final String ECLIPSE_STARTER = "org.eclipse.core.runtime.adaptor.EclipseStarter";
    private static String PluginId;
    private PlatformConfig platformConfig;
    private File platformDirectory;
    private URL osgiFramework;
    private ClassLoader frameworkClassLoader;
    private ClassLoader frameworkContextClassLoader;
    private HashMap properties;
    private Object bundleContext;
    private static final String PROP_OSGI_INSTALL_AREA = "osgi.install.area";
    private static final String PROP_OSGI_INSTANCE_AREA = "osgi.instance.area";
    private static final String PROP_OSGI_CONFIGURATION_AREA = "osgi.configuration.area";
    private static final String PROP_ECLIPSE_IGNOREAPP = "eclipse.ignoreApp";
    private static final String PROP_OSGI_NOSHUTDOWN = "osgi.noShutdown";
    private static final String PROP_OSGI_CLEAN = "osgi.clean";
    private static final String CONFIG_FILE = "config.ini";
    private static final String CONFIG_FOLDER = "configuration";
    private static final String INSTANCE_FOLDER = "workspace";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.birt.core.framework.osgi.OSGILauncher");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        PluginId = "org.eclipse.birt.core";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void startup(PlatformConfig config) throws BirtException {
        if (this.frameworkClassLoader != null) {
            logger.log(Level.WARNING, "Framework is already started");
            return;
        }
        this.platformConfig = config;
        IPlatformContext context = config.getPlatformContext();
        if (context == null) {
            throw new BirtException(PluginId, "PlatformContext is not setted - {0}", new Object[]{"PlatformConfig"});
        }
        String root = context.getPlatform();
        this.platformDirectory = new File(root);
        if (!this.platformDirectory.exists()) throw new BirtException(PluginId, "Could not start the Framework - {0}" + root, root);
        if (!this.platformDirectory.isDirectory()) {
            throw new BirtException(PluginId, "Could not start the Framework - {0}" + root, root);
        }
        String path = new File(this.platformDirectory, "plugins").toString();
        if ((path = this.searchFor("org.eclipse.osgi", path)) == null) {
            throw new BirtException(PluginId, "Could not find the Framework - {0}", "org.eclipse.osgi");
        }
        try {
            this.osgiFramework = new File(path).toURL();
        }
        catch (MalformedURLException malformedURLException) {}
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> clazz;
                Method initPropertiesMethod;
                ClassLoader loader = this.getClass().getClassLoader();
                this.frameworkClassLoader = new ChildFirstURLClassLoader(new URL[]{this.osgiFramework}, loader);
                try {
                    loader.loadClass("org.mozilla.javascript.Context");
                    loader.loadClass("org.mozilla.javascript.Scriptable");
                    loader.loadClass("org.mozilla.javascript.ScriptableObject");
                }
                catch (Exception exception) {}
                Class<?> clazz2 = this.frameworkClassLoader.loadClass(ECLIPSE_STARTER);
                this.setupOSGiProperties();
                Class[] classArray = new Class[1];
                Class clazz3 = class$1;
                if (clazz3 == null) {
                    Class clazz4;
                    try {
                        clazz4 = Class.forName("java.util.Map");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz3 = classArray[0] = (class$1 = clazz4);
                }
                if ((initPropertiesMethod = clazz2.getMethod("setInitialProperties", classArray)) != null) {
                    System.setProperty("osgi.framework.useSystemProperties", "false");
                    this.properties.put("osgi.framework.useSystemProperties", "false");
                    initPropertiesMethod.invoke(null, this.properties);
                } else {
                    Iterator iter = this.properties.entrySet().iterator();
                    while (true) {
                        if (!iter.hasNext()) {
                            System.setProperty("osgi.framework.useSystemProperties", "true");
                            break;
                        }
                        Map.Entry entry = iter.next();
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        System.setProperty(key, value);
                    }
                }
                Class[] classArray2 = new Class[2];
                Class clazz5 = class$2;
                if (clazz5 == null) {
                    Class clazz6;
                    try {
                        clazz6 = Class.forName("[Ljava.lang.String;");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz5 = classArray2[0] = (class$2 = clazz6);
                }
                if ((clazz = class$3) == null) {
                    Class<?> clazz7;
                    try {
                        clazz7 = Class.forName("java.lang.Runnable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$3 = clazz7;
                }
                classArray2[1] = clazz;
                Method runMethod = clazz2.getMethod("startup", classArray2);
                Object[] objectArray = new Object[2];
                objectArray[0] = new String[0];
                this.bundleContext = runMethod.invoke(null, objectArray);
                this.frameworkContextClassLoader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception e) {
                throw new BirtException(PluginId, "Can not start up OSGI - {0}", e.getLocalizedMessage());
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            Thread.currentThread().setContextClassLoader(original);
            throw throwable;
        }
        {
            Object var13_16 = null;
            Thread.currentThread().setContextClassLoader(original);
            return;
        }
    }

    private void setupOSGiProperties() {
        String instanceArea;
        this.properties = new HashMap();
        Properties systemProperties = System.getProperties();
        if (systemProperties != null) {
            Iterator<Map.Entry<Object, Object>> it = systemProperties.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Object, Object> entry = it.next();
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (value != null && !(value instanceof String)) continue;
                if (!(key.startsWith("osgi.") || key.startsWith("eclipse.") || key.startsWith("org.osgi."))) {
                    this.properties.put(key, value);
                    continue;
                }
                this.properties.put(key, null);
            }
        }
        File configFolder = new File(this.platformDirectory, CONFIG_FOLDER);
        try {
            HashMap configProps = this.loadConfiguration(configFolder.toURL());
            this.properties.putAll(configProps);
        }
        catch (Exception exception) {}
        Map osgiConfig = this.platformConfig.getOSGiConfig();
        if (osgiConfig != null) {
            Iterator iter = osgiConfig.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!(key instanceof String) || value != null && !(value instanceof String)) continue;
                this.properties.put(key, value);
            }
        }
        this.properties.put(PROP_OSGI_INSTALL_AREA, this.platformDirectory.getAbsolutePath());
        this.properties.put("osgi.framework", this.osgiFramework.toExternalForm());
        String configArea = this.getProperty(this.properties, PROP_OSGI_CONFIGURATION_AREA);
        if (configArea == null) {
            File configDirectory = new File(this.platformDirectory, CONFIG_FOLDER);
            this.properties.put(PROP_OSGI_CONFIGURATION_AREA, configDirectory.getAbsolutePath());
        }
        if ((instanceArea = this.getProperty(this.properties, PROP_OSGI_INSTANCE_AREA)) == null) {
            File workspaceDirectory = new File(this.platformDirectory, INSTANCE_FOLDER);
            if (!workspaceDirectory.exists()) {
                workspaceDirectory.mkdirs();
            }
            this.properties.put(PROP_OSGI_INSTANCE_AREA, workspaceDirectory.getAbsolutePath());
        }
        this.properties.put(PROP_ECLIPSE_IGNOREAPP, "true");
        this.properties.put(PROP_OSGI_NOSHUTDOWN, "true");
        String clean = this.getProperty(this.properties, PROP_OSGI_CLEAN);
        if (clean == null) {
            this.properties.put(PROP_OSGI_CLEAN, "true");
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private HashMap loadConfiguration(URL url) {
        HashMap<Object, Object> result = null;
        if (url == null) {
            return result;
        }
        try {
            url = new URL(url, CONFIG_FILE);
        }
        catch (MalformedURLException malformedURLException) {
            return result;
        }
        Properties tempProp = new Properties();
        try {
            result = new HashMap<Object, Object>();
            InputStream is = null;
            try {
                is = url.openStream();
                tempProp.load(is);
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var5_8 = null;
                if (is != null) {
                    try {}
                    catch (IOException iOException) {}
                    is.close();
                }
            }
        }
        catch (IOException iOException) {}
        Iterator<Map.Entry<Object, Object>> ti = tempProp.entrySet().iterator();
        while (ti.hasNext()) {
            Map.Entry<Object, Object> entry = ti.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            result.put(key, value);
        }
        return result;
    }

    private String getProperty(Map properties, String name) {
        Object value = properties.get(name);
        if (value instanceof String) {
            String strValue = (String)value;
            if ((strValue = strValue.trim()).length() > 0) {
                return strValue;
            }
        }
        return null;
    }

    public ClassLoader getFrameworkContextClassLoader() {
        return this.frameworkContextClassLoader;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void shutdown() {
        if (this.platformDirectory == null) {
            logger.log(Level.WARNING, "Shutdown unnecessary. (not deployed)");
            return;
        }
        if (this.frameworkClassLoader == null) {
            logger.log(Level.WARNING, "Framework is already shutdown");
            return;
        }
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Class<?> clazz = this.frameworkClassLoader.loadClass(ECLIPSE_STARTER);
                Method method = clazz.getDeclaredMethod("shutdown", null);
                Thread.currentThread().setContextClassLoader(this.frameworkContextClassLoader);
                method.invoke(clazz, null);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error while stopping Framework", e);
                Object var4_5 = null;
                this.frameworkClassLoader = null;
                this.frameworkContextClassLoader = null;
                Thread.currentThread().setContextClassLoader(original);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
            throw throwable;
        }
        {
            Object var4_7 = null;
            this.frameworkClassLoader = null;
            this.frameworkContextClassLoader = null;
            Thread.currentThread().setContextClassLoader(original);
            return;
        }
    }

    protected String searchFor(final String target, String start) {
        FileFilter filter = new FileFilter(){

            public boolean accept(File candidate) {
                return candidate.getName().equals(target) || candidate.getName().startsWith(String.valueOf(target) + "_");
            }
        };
        File[] candidates = new File(start).listFiles(filter);
        if (candidates == null) {
            return null;
        }
        String[] arrays = new String[candidates.length];
        int i = 0;
        while (i < arrays.length) {
            arrays[i] = candidates[i].getName();
            ++i;
        }
        int result = this.findMax(arrays);
        if (result == -1) {
            return null;
        }
        return String.valueOf(candidates[result].getAbsolutePath().replace(File.separatorChar, '/')) + (candidates[result].isDirectory() ? "/" : "");
    }

    protected int findMax(String[] candidates) {
        int result = -1;
        Object[] maxVersion = null;
        int i = 0;
        while (i < candidates.length) {
            String name = candidates[i];
            String version = "";
            int index = name.indexOf(95);
            if (index != -1) {
                version = name.substring(index + 1);
            }
            Object[] currentVersion = this.getVersionElements(version);
            if (maxVersion == null) {
                result = i;
                maxVersion = currentVersion;
            } else if (this.compareVersion(maxVersion, currentVersion) < 0) {
                result = i;
                maxVersion = currentVersion;
            }
            ++i;
        }
        return result;
    }

    private int compareVersion(Object[] left, Object[] right) {
        int result = ((Integer)left[0]).compareTo((Integer)right[0]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[1]).compareTo((Integer)right[1]);
        if (result != 0) {
            return result;
        }
        result = ((Integer)left[2]).compareTo((Integer)right[2]);
        if (result != 0) {
            return result;
        }
        return ((String)left[3]).compareTo((String)right[3]);
    }

    private Object[] getVersionElements(String version) {
        if (version.endsWith(".jar")) {
            version = version.substring(0, version.length() - 4);
        }
        Object[] result = new Object[]{new Integer(0), new Integer(0), new Integer(0), ""};
        StringTokenizer t = new StringTokenizer(version, ".");
        int i = 0;
        while (t.hasMoreTokens() && i < 4) {
            String token = t.nextToken();
            if (i < 3) {
                try {
                    result[i++] = new Integer(token);
                    continue;
                }
                catch (Exception exception) {
                    break;
                }
            }
            result[i++] = token;
        }
        return result;
    }

    Object getBundle(String symbolicName) {
        if (this.bundleContext == null) {
            return null;
        }
        try {
            Method methodLoadBundle = this.bundleContext.getClass().getMethod("getBundles", new Class[0]);
            Object objects = methodLoadBundle.invoke(this.bundleContext, new Object[0]);
            if (objects instanceof Object[]) {
                Object[] bundles = (Object[])objects;
                int i = 0;
                while (i < bundles.length) {
                    Object bundle = bundles[i];
                    Method methodGetSymbolicName = bundle.getClass().getMethod("getSymbolicName", new Class[0]);
                    Object name = methodGetSymbolicName.invoke(bundle, new Object[0]);
                    if (symbolicName.equals(name)) {
                        return bundle;
                    }
                    ++i;
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, ex.getMessage());
        }
        return null;
    }

    protected class ChildFirstURLClassLoader
    extends URLClassLoader {
        public ChildFirstURLClassLoader(URL[] urls) {
            super(urls);
        }

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        public ChildFirstURLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
            super(urls, parent, factory);
        }

        public URL getResource(String name) {
            ClassLoader parent;
            URL resource = this.findResource(name);
            if (resource == null && (parent = this.getParent()) != null) {
                resource = parent.getResource(name);
            }
            return resource;
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> clazz = this.findLoadedClass(name);
            if (clazz == null) {
                try {
                    clazz = this.findClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ClassLoader parent = this.getParent();
                    clazz = parent != null ? parent.loadClass(name) : ChildFirstURLClassLoader.getSystemClassLoader().loadClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
    }
}

