/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.errors.PackProtocolException;
import org.eclipse.jgit.errors.UnpackException;
import org.eclipse.jgit.http.server.GitSmartHttpTools;
import org.eclipse.jgit.http.server.HttpServerText;
import org.eclipse.jgit.http.server.ReceivePackErrorHandler;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.http.server.SmartOutputStream;
import org.eclipse.jgit.http.server.SmartServiceInfoRefs;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.InternalHttpServerGlue;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.RefAdvertiser;
import org.eclipse.jgit.transport.resolver.ReceivePackFactory;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;

class ReceivePackServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    @Nullable
    private final ReceivePackErrorHandler handler;

    ReceivePackServlet(@Nullable ReceivePackErrorHandler handler) {
        this.handler = handler;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        if (!"application/x-git-receive-pack-request".equals(req.getContentType())) {
            rsp.sendError(415);
            return;
        }
        SmartOutputStream out = new SmartOutputStream(req, rsp, false){

            public void flush() throws IOException {
                this.doFlush();
            }
        };
        ReceivePack rp = (ReceivePack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
        rp.setBiDirectionalPipe(false);
        rsp.setContentType("application/x-git-receive-pack-result");
        if (this.handler != null) {
            this.handler.receive(req, rsp, () -> {
                rp.receiveWithExceptionPropagation(ServletUtils.getInputStream(req), (OutputStream)((Object)out), null);
                out.close();
            });
        } else {
            try {
                rp.receive(ServletUtils.getInputStream(req), (OutputStream)((Object)out), null);
                out.close();
            }
            catch (CorruptObjectException e) {
                this.getServletContext().log(MessageFormat.format(HttpServerText.get().receivedCorruptObject, e.getMessage(), ServletUtils.identify(rp.getRepository())));
                ServletUtils.consumeRequestBody(req);
                out.close();
            }
            catch (PackProtocolException | UnpackException e) {
                this.log(rp.getRepository(), e.getCause());
                ServletUtils.consumeRequestBody(req);
                out.close();
            }
            catch (Throwable e) {
                this.log(rp.getRepository(), e);
                if (!rsp.isCommitted()) {
                    rsp.reset();
                    GitSmartHttpTools.sendError(req, rsp, 500);
                }
                return;
            }
        }
    }

    private void log(Repository git, Throwable e) {
        this.getServletContext().log(MessageFormat.format(HttpServerText.get().internalErrorDuringReceivePack, ServletUtils.identify(git)), e);
    }

    static class Factory
    implements Filter {
        private final ReceivePackFactory<HttpServletRequest> receivePackFactory;

        Factory(ReceivePackFactory<HttpServletRequest> receivePackFactory) {
            this.receivePackFactory = receivePackFactory;
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            ReceivePack rp;
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse rsp = (HttpServletResponse)response;
            try {
                rp = this.receivePackFactory.create((Object)req, ServletUtils.getRepository((ServletRequest)req));
            }
            catch (ServiceNotAuthorizedException e) {
                rsp.sendError(401, e.getMessage());
                return;
            }
            catch (ServiceNotEnabledException e) {
                GitSmartHttpTools.sendError(req, rsp, 403, e.getMessage());
                return;
            }
            try {
                req.setAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack", (Object)rp);
                chain.doFilter((ServletRequest)req, (ServletResponse)rsp);
            }
            finally {
                req.removeAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            }
        }

        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void destroy() {
        }
    }

    static class InfoRefs
    extends SmartServiceInfoRefs {
        private final ReceivePackFactory<HttpServletRequest> receivePackFactory;

        InfoRefs(ReceivePackFactory<HttpServletRequest> receivePackFactory, List<Filter> filters) {
            super("git-receive-pack", filters);
            this.receivePackFactory = receivePackFactory;
        }

        @Override
        protected void begin(HttpServletRequest req, Repository db) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
            ReceivePack rp = this.receivePackFactory.create((Object)req, db);
            InternalHttpServerGlue.setPeerUserAgent((ReceivePack)rp, (String)req.getHeader("User-Agent"));
            req.setAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack", (Object)rp);
        }

        @Override
        protected void advertise(HttpServletRequest req, RefAdvertiser.PacketLineOutRefAdvertiser pck) throws IOException, ServiceNotEnabledException, ServiceNotAuthorizedException {
            ReceivePack rp = (ReceivePack)req.getAttribute("org.eclipse.jgit.transport.UploadPackOrReceivePack");
            try {
                rp.sendAdvertisedRefs((RefAdvertiser)pck);
            }
            finally {
                rp.getRevWalk().close();
            }
        }
    }
}

