/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.util.TemporaryBuffer;

class SmartOutputStream
extends TemporaryBuffer {
    private static final int LIMIT = 32768;
    private final HttpServletRequest req;
    private final HttpServletResponse rsp;
    private boolean compressStream;
    private boolean startedOutput;

    SmartOutputStream(HttpServletRequest req, HttpServletResponse rsp, boolean compressStream) {
        super(32768);
        this.req = req;
        this.rsp = rsp;
        this.compressStream = compressStream;
    }

    protected OutputStream overflow() throws IOException {
        this.startedOutput = true;
        Object out = this.rsp.getOutputStream();
        if (this.compressStream && ServletUtils.acceptsGzipEncoding(this.req)) {
            this.rsp.setHeader("Content-Encoding", "gzip");
            out = new GZIPOutputStream((OutputStream)out);
        }
        return out;
    }

    public void close() throws IOException {
        super.close();
        if (!this.startedOutput) {
            if (256L < this.length() && ServletUtils.acceptsGzipEncoding(this.req)) {
                TemporaryBuffer.Heap gzbuf = new TemporaryBuffer.Heap(32768);
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (GZIPOutputStream gzip = new GZIPOutputStream((OutputStream)gzbuf);){
                        this.writeTo(gzip, null);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    if (gzbuf.length() < this.length()) {
                        this.rsp.setHeader("Content-Encoding", "gzip");
                        this.writeResponse((TemporaryBuffer)gzbuf);
                        return;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.writeResponse(this);
        }
    }

    private void writeResponse(TemporaryBuffer out) throws IOException {
        this.rsp.setContentLength((int)out.length());
        Throwable throwable = null;
        Object var3_4 = null;
        try (ServletOutputStream os = this.rsp.getOutputStream();){
            out.writeTo((OutputStream)os, null);
            os.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

