/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.ignore.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.ignore.internal.AbstractMatcher;
import org.eclipse.jgit.ignore.internal.IMatcher;
import org.eclipse.jgit.ignore.internal.NameMatcher;
import org.eclipse.jgit.ignore.internal.Strings;
import org.eclipse.jgit.ignore.internal.WildCardMatcher;
import org.eclipse.jgit.ignore.internal.WildMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PathMatcher
extends AbstractMatcher {
    private static final WildMatcher WILD = WildMatcher.INSTANCE;
    private final List<IMatcher> matchers;
    private final char slash;
    private boolean beginning;

    PathMatcher(String pattern, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        super(pattern, dirOnly);
        this.slash = Strings.getPathSeparator(pathSeparator);
        this.beginning = pattern.indexOf(this.slash) == 0;
        this.matchers = this.isSimplePathWithSegments(pattern) ? null : PathMatcher.createMatchers(Strings.split(pattern, this.slash), pathSeparator, dirOnly);
    }

    private boolean isSimplePathWithSegments(String path) {
        return !Strings.isWildCard(path) && Strings.count(path, this.slash, true) > 0;
    }

    private static List<IMatcher> createMatchers(List<String> segments, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        ArrayList<IMatcher> matchers = new ArrayList<IMatcher>(segments.size());
        for (int i = 0; i < segments.size(); ++i) {
            String segment = segments.get(i);
            IMatcher matcher = PathMatcher.createNameMatcher0(segment, pathSeparator, dirOnly);
            if (matcher == WILD && i > 0 && matchers.get(matchers.size() - 1) == WILD) continue;
            matchers.add(matcher);
        }
        return matchers;
    }

    public static IMatcher createPathMatcher(String pattern, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        char slash;
        int slashIdx = (pattern = pattern.trim()).indexOf(slash = Strings.getPathSeparator(pathSeparator), 1);
        if (slashIdx > 0 && slashIdx < pattern.length() - 1) {
            return new PathMatcher(pattern, pathSeparator, dirOnly);
        }
        return PathMatcher.createNameMatcher0(pattern, pathSeparator, dirOnly);
    }

    private static IMatcher createNameMatcher0(String segment, Character pathSeparator, boolean dirOnly) throws InvalidPatternException {
        if ("**".equals(segment) || "/**".equals(segment)) {
            return WILD;
        }
        if (Strings.isWildCard(segment)) {
            return new WildCardMatcher(segment, pathSeparator, dirOnly);
        }
        return new NameMatcher(segment, pathSeparator, dirOnly);
    }

    @Override
    public boolean matches(String path, boolean assumeDirectory) {
        if (this.matchers == null) {
            return this.simpleMatch(path, assumeDirectory);
        }
        return this.iterate(path, 0, path.length(), assumeDirectory);
    }

    private boolean simpleMatch(String path, boolean assumeDirectory) {
        boolean hasSlash;
        boolean bl = hasSlash = path.indexOf(this.slash) == 0;
        if (this.beginning && !hasSlash) {
            path = this.slash + path;
        }
        if (!this.beginning && hasSlash) {
            path = path.substring(1);
        }
        if (path.equals(this.pattern)) {
            return !this.dirOnly || assumeDirectory;
        }
        return path.startsWith(this.pattern + '/');
    }

    @Override
    public boolean matches(String segment, int startIncl, int endExcl, boolean assumeDirectory) {
        throw new UnsupportedOperationException("Path matcher works only on entire paths");
    }

    boolean iterate(String path, int startIncl, int endExcl, boolean assumeDirectory) {
        int matcher = 0;
        int right = startIncl;
        boolean match = false;
        int lastWildmatch = -1;
        while (true) {
            int left = ++right;
            if ((right = path.indexOf(this.slash, right)) == -1) {
                if (left < endExcl) {
                    match = this.matches(matcher, path, left, endExcl, assumeDirectory);
                }
                if (match) {
                    if (matcher == this.matchers.size() - 2 && this.matchers.get(matcher + 1) == WILD) {
                        return true;
                    }
                    if (matcher < this.matchers.size() - 1 && this.matchers.get(matcher) == WILD) {
                        match = this.matches(++matcher, path, left, endExcl, assumeDirectory);
                    } else if (this.dirOnly) {
                        return false;
                    }
                }
                return match && matcher + 1 == this.matchers.size();
            }
            if (right - left <= 0) continue;
            match = this.matches(matcher, path, left, right, assumeDirectory);
            if (match) {
                if (this.matchers.get(matcher) == WILD) {
                    lastWildmatch = matcher;
                    right = left - 1;
                }
                if (++matcher == this.matchers.size()) {
                    return true;
                }
            } else if (lastWildmatch != -1) {
                matcher = lastWildmatch + 1;
            } else {
                return false;
            }
            ++right;
        }
    }

    boolean matches(int matcherIdx, String path, int startIncl, int endExcl, boolean assumeDirectory) {
        IMatcher matcher = this.matchers.get(matcherIdx);
        return matcher.matches(path, startIncl, endExcl, assumeDirectory);
    }
}

