/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lib;

import java.io.IOException;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.revwalk.RevBlob;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.util.TemporaryBuffer;

public class TreeFormatter {
    private byte[] buf;
    private int ptr;
    private TemporaryBuffer.Heap overflowBuffer;

    public static int entrySize(FileMode mode, int nameLen) {
        return mode.copyToLength() + nameLen + 20 + 2;
    }

    public TreeFormatter() {
        this(8192);
    }

    public TreeFormatter(int size) {
        this.buf = new byte[size];
    }

    public void append(String name, RevCommit commit) {
        this.append(name, FileMode.GITLINK, (AnyObjectId)commit);
    }

    public void append(String name, RevTree tree) {
        this.append(name, FileMode.TREE, (AnyObjectId)tree);
    }

    public void append(String name, RevBlob blob) {
        this.append(name, FileMode.REGULAR_FILE, (AnyObjectId)blob);
    }

    public void append(String name, FileMode mode, AnyObjectId id) {
        this.append(Constants.encode(name), mode, id);
    }

    public void append(byte[] name, FileMode mode, AnyObjectId id) {
        this.append(name, 0, name.length, mode, id);
    }

    public void append(byte[] nameBuf, int namePos, int nameLen, FileMode mode, AnyObjectId id) {
        if (this.fmtBuf(nameBuf, namePos, nameLen, mode)) {
            id.copyRawTo(this.buf, this.ptr);
            this.ptr += 20;
        } else {
            try {
                this.fmtOverflowBuffer(nameBuf, namePos, nameLen, mode);
                id.copyRawTo(this.overflowBuffer);
            }
            catch (IOException badBuffer) {
                throw new RuntimeException(badBuffer);
            }
        }
    }

    public void append(byte[] nameBuf, int namePos, int nameLen, FileMode mode, byte[] idBuf, int idPos) {
        if (this.fmtBuf(nameBuf, namePos, nameLen, mode)) {
            System.arraycopy(idBuf, idPos, this.buf, this.ptr, 20);
            this.ptr += 20;
        } else {
            try {
                this.fmtOverflowBuffer(nameBuf, namePos, nameLen, mode);
                this.overflowBuffer.write(idBuf, idPos, 20);
            }
            catch (IOException badBuffer) {
                throw new RuntimeException(badBuffer);
            }
        }
    }

    private boolean fmtBuf(byte[] nameBuf, int namePos, int nameLen, FileMode mode) {
        if (this.buf == null || this.buf.length < this.ptr + TreeFormatter.entrySize(mode, nameLen)) {
            return false;
        }
        mode.copyTo(this.buf, this.ptr);
        this.ptr += mode.copyToLength();
        this.buf[this.ptr++] = 32;
        System.arraycopy(nameBuf, namePos, this.buf, this.ptr, nameLen);
        this.ptr += nameLen;
        this.buf[this.ptr++] = 0;
        return true;
    }

    private void fmtOverflowBuffer(byte[] nameBuf, int namePos, int nameLen, FileMode mode) throws IOException {
        if (this.buf != null) {
            this.overflowBuffer = new TemporaryBuffer.Heap(Integer.MAX_VALUE);
            this.overflowBuffer.write(this.buf, 0, this.ptr);
            this.buf = null;
        }
        mode.copyTo(this.overflowBuffer);
        this.overflowBuffer.write(32);
        this.overflowBuffer.write(nameBuf, namePos, nameLen);
        this.overflowBuffer.write(0);
    }

    public ObjectId insertTo(ObjectInserter ins) throws IOException {
        if (this.buf != null) {
            return ins.insert(2, this.buf, 0, this.ptr);
        }
        long len = this.overflowBuffer.length();
        return ins.insert(2, len, this.overflowBuffer.openInputStream());
    }

    public ObjectId computeId(ObjectInserter ins) {
        if (this.buf != null) {
            return ins.idFor(2, this.buf, 0, this.ptr);
        }
        long len = this.overflowBuffer.length();
        try {
            return ins.idFor(2, len, this.overflowBuffer.openInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] toByteArray() {
        if (this.buf != null) {
            byte[] r = new byte[this.ptr];
            System.arraycopy(this.buf, 0, r, 0, this.ptr);
            return r;
        }
        try {
            return this.overflowBuffer.toByteArray();
        }
        catch (IOException err) {
            throw new RuntimeException(err);
        }
    }

    public String toString() {
        byte[] raw = this.toByteArray();
        CanonicalTreeParser p = new CanonicalTreeParser();
        p.reset(raw);
        StringBuilder r = new StringBuilder();
        r.append("Tree={");
        if (!p.eof()) {
            r.append('\n');
            try {
                new ObjectChecker().checkTree(raw);
            }
            catch (CorruptObjectException error) {
                r.append("*** ERROR: ").append(error.getMessage()).append("\n");
                r.append('\n');
            }
        }
        while (!p.eof()) {
            FileMode mode = p.getEntryFileMode();
            r.append(mode);
            r.append(' ');
            r.append(Constants.typeString(mode.getObjectType()));
            r.append(' ');
            r.append(p.getEntryObjectId().name());
            r.append(' ');
            r.append(p.getEntryPathString());
            r.append('\n');
            p.next();
        }
        r.append("}");
        return r.toString();
    }
}

