/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import org.eclipse.jgit.errors.CorruptObjectException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;

public abstract class SystemReader {
    private static final SystemReader DEFAULT;
    private static Boolean isMacOS;
    private static Boolean isWindows;
    private static SystemReader INSTANCE;
    private ObjectChecker platformChecker;

    public static SystemReader getInstance() {
        return INSTANCE;
    }

    public static void setInstance(SystemReader newReader) {
        isMacOS = null;
        isWindows = null;
        if (newReader == null) {
            INSTANCE = DEFAULT;
        } else {
            newReader.init();
            INSTANCE = newReader;
        }
    }

    private void init() {
        if (this.platformChecker == null) {
            this.setPlatformChecker();
        }
    }

    protected final void setPlatformChecker() {
        this.platformChecker = new ObjectChecker().setSafeForWindows(this.isWindows()).setSafeForMacOS(this.isMacOS());
    }

    public abstract String getHostname();

    public abstract String getenv(String var1);

    public abstract String getProperty(String var1);

    public abstract FileBasedConfig openUserConfig(Config var1, FS var2);

    public abstract FileBasedConfig openSystemConfig(Config var1, FS var2);

    public abstract long getCurrentTime();

    public abstract int getTimezone(long var1);

    public TimeZone getTimeZone() {
        return TimeZone.getDefault();
    }

    public Locale getLocale() {
        return Locale.getDefault();
    }

    public SimpleDateFormat getSimpleDateFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    public SimpleDateFormat getSimpleDateFormat(String pattern, Locale locale) {
        return new SimpleDateFormat(pattern, locale);
    }

    public DateFormat getDateTimeInstance(int dateStyle, int timeStyle) {
        return DateFormat.getDateTimeInstance(dateStyle, timeStyle);
    }

    public boolean isWindows() {
        if (isWindows == null) {
            String osDotName = this.getOsName();
            isWindows = osDotName.startsWith("Windows");
        }
        return isWindows;
    }

    public boolean isMacOS() {
        if (isMacOS == null) {
            String osDotName = this.getOsName();
            isMacOS = "Mac OS X".equals(osDotName) || "Darwin".equals(osDotName);
        }
        return isMacOS;
    }

    private String getOsName() {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return SystemReader.this.getProperty("os.name");
            }
        });
    }

    public void checkPath(String path) throws CorruptObjectException {
        this.platformChecker.checkPath(path);
    }

    static {
        Default r = new Default();
        super.init();
        INSTANCE = DEFAULT = r;
    }

    private static class Default
    extends SystemReader {
        private volatile String hostname;

        private Default() {
        }

        @Override
        public String getenv(String variable) {
            return System.getenv(variable);
        }

        @Override
        public String getProperty(String key) {
            return System.getProperty(key);
        }

        @Override
        public FileBasedConfig openSystemConfig(Config parent, FS fs) {
            File configFile = fs.getGitSystemConfig();
            if (configFile == null) {
                return new FileBasedConfig(null, fs){

                    @Override
                    public void load() {
                    }

                    @Override
                    public boolean isOutdated() {
                        return false;
                    }
                };
            }
            return new FileBasedConfig(parent, configFile, fs);
        }

        @Override
        public FileBasedConfig openUserConfig(Config parent, FS fs) {
            File home = fs.userHome();
            return new FileBasedConfig(parent, new File(home, ".gitconfig"), fs);
        }

        @Override
        public String getHostname() {
            if (this.hostname == null) {
                try {
                    InetAddress localMachine = InetAddress.getLocalHost();
                    this.hostname = localMachine.getCanonicalHostName();
                }
                catch (UnknownHostException e) {
                    this.hostname = "localhost";
                }
                assert (this.hostname != null);
            }
            return this.hostname;
        }

        @Override
        public long getCurrentTime() {
            return System.currentTimeMillis();
        }

        @Override
        public int getTimezone(long when) {
            return this.getTimeZone().getOffset(when) / 60000;
        }
    }
}

