/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    private static final Log LOG = ExoLogger.getLogger("org.exoplatform.commons.utils.Tools");
    private static volatile Map<String, TimeZone> TIME_ZONES = new HashMap<String, TimeZone>();

    public static <E> Set<E> set(E ... elements) throws IllegalArgumentException {
        if (elements == null) {
            throw new IllegalArgumentException("No null element array accepted");
        }
        HashSet<E> set = new HashSet<E>();
        if (elements.length > 0) {
            for (E element : elements) {
                set.add(element);
            }
        }
        return set;
    }

    public static Set<String> parseCommaList(String s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("No null string list accepted");
        }
        HashSet<String> set = new HashSet<String>();
        for (String v : s.split(",")) {
            if ((v = v.trim()).length() <= 0) continue;
            set.add(v);
        }
        return set;
    }

    public static Properties asProperties(Map<String, String> map) throws IllegalArgumentException {
        if (map == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        return props;
    }

    public static Map<String, String> asMap(Properties props) throws IllegalArgumentException {
        if (props == null) {
            throw new IllegalArgumentException("No null properties accepted");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : props.keySet()) {
            Object value = props.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            map.put((String)key, (String)value);
        }
        return map;
    }

    public static boolean endsWithIgnoreCase(String s, String end) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException();
        }
        if (end == null) {
            throw new IllegalArgumentException();
        }
        if (s.length() < end.length()) {
            return false;
        }
        String suffix = s.substring(s.length() - end.length());
        return suffix.equalsIgnoreCase(end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TimeZone getTimeZone(String ID) {
        if (ID == null) {
            throw new IllegalArgumentException("ID of the timezone cannot be null");
        }
        if (ID.length() == 0) {
            throw new IllegalArgumentException("ID of the timezone cannot be empty");
        }
        TimeZone tz = TIME_ZONES.get(ID);
        if (tz != null) return tz;
        Class<TimeZone> clazz = TimeZone.class;
        synchronized (TimeZone.class) {
            tz = TIME_ZONES.get(ID);
            if (tz != null) return tz;
            tz = TimeZone.getTimeZone(ID);
            HashMap<String, TimeZone> tzs = new HashMap<String, TimeZone>(TIME_ZONES);
            tzs.put(ID, tz);
            TIME_ZONES = tzs;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return tz;
        }
    }

    public static Class<?> forName(String type, Object callerObject) throws ClassNotFoundException {
        return Tools.forName(type, callerObject.getClass());
    }

    public static Class<?> forName(String type, Class<?> callerClass) throws ClassNotFoundException {
        try {
            return Class.forName(type, true, callerClass.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            ClassLoader cl;
            block12: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("The class " + type + " could not be found in the Class loader of " + callerClass);
                }
                cl = Thread.currentThread().getContextClassLoader();
                try {
                    if (cl != null) {
                        return Class.forName(type, true, cl);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("No thread context Class loader could be found to load the class " + type);
                    }
                }
                catch (ClassNotFoundException e1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("The class " + type + " could not be found in the thread context Class loader");
                    }
                    cl = null;
                }
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (Exception e1) {
                    if (!LOG.isTraceEnabled()) break block12;
                    LOG.trace((Object)("The system Class loader could not be found to load the class " + type), e1);
                }
            }
            if (cl != null) {
                return Class.forName(type, true, cl);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("The system Class loader could not be found to load the class " + type);
            }
            throw e;
        }
    }

    public static Class<?> loadClass(String type, Object callerObject) throws ClassNotFoundException {
        return Tools.loadClass(type, callerObject.getClass());
    }

    public static Class<?> loadClass(String type, Class<?> callerClass) throws ClassNotFoundException {
        ClassLoader localCl = callerClass.getClassLoader();
        try {
            return localCl.loadClass(type);
        }
        catch (ClassNotFoundException e) {
            ClassLoader cl;
            block12: {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("The class " + type + " could not be found in the Class loader of " + callerClass);
                }
                cl = Thread.currentThread().getContextClassLoader();
                try {
                    if (cl != null) {
                        return cl.loadClass(type);
                    }
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("No thread context Class loader could be found to load the class " + type);
                    }
                }
                catch (ClassNotFoundException e1) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("The class " + type + " could not be found in the thread context Class loader");
                    }
                    cl = null;
                }
                try {
                    cl = ClassLoader.getSystemClassLoader();
                }
                catch (Exception e1) {
                    if (!LOG.isTraceEnabled()) break block12;
                    LOG.trace((Object)("The system Class loader could not be found to load the class " + type), e1);
                }
            }
            if (cl != null) {
                return cl.loadClass(type);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("The system Class loader could not be found to load the class " + type);
            }
            throw e;
        }
    }
}

