/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.management.annotations.ManagedBy;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheConfigPlugin;
import org.exoplatform.services.cache.SimpleExoCache;
import org.exoplatform.services.cache.impl.CacheServiceManaged;
import org.exoplatform.services.cache.impl.LoggingCacheListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagedBy(value=CacheServiceManaged.class)
public class CacheServiceImpl
implements CacheService {
    private HashMap<String, ExoCacheConfig> configs_ = new HashMap();
    private final ConcurrentHashMap<String, ExoCache<? extends Serializable, ?>> cacheMap_ = new ConcurrentHashMap();
    private ExoCacheConfig defaultConfig_;
    private LoggingCacheListener loggingListener_;
    CacheServiceManaged managed;

    public CacheServiceImpl(InitParams params) throws Exception {
        List configs = params.getObjectParamValues(ExoCacheConfig.class);
        for (ExoCacheConfig config : configs) {
            this.configs_.put(config.getName(), config);
        }
        this.defaultConfig_ = this.configs_.get("default");
        this.loggingListener_ = new LoggingCacheListener();
    }

    public void addExoCacheConfig(ComponentPlugin plugin) {
        this.addExoCacheConfig((ExoCacheConfigPlugin)plugin);
    }

    @Override
    public void addExoCacheConfig(ExoCacheConfigPlugin plugin) {
        List<ExoCacheConfig> configs = plugin.getConfigs();
        for (ExoCacheConfig config : configs) {
            this.configs_.put(config.getName(), config);
        }
    }

    @Override
    public <K extends Serializable, V> ExoCache<K, V> getCacheInstance(String region) {
        if (region == null) {
            throw new NullPointerException("region cannot be null");
        }
        if (region.length() == 0) {
            throw new IllegalArgumentException("region cannot be empty");
        }
        ExoCache<? extends Serializable, ?> cache = this.cacheMap_.get(region);
        if (cache == null) {
            try {
                cache = this.createCacheInstance(region);
                ExoCache<Serializable, ?> existing = this.cacheMap_.putIfAbsent(region, cache);
                if (existing != null) {
                    cache = existing;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return cache;
    }

    private synchronized ExoCache<? extends Serializable, ?> createCacheInstance(String region) throws Exception {
        ExoCache cache;
        ExoCacheConfig config = this.configs_.get(region);
        if (config == null) {
            config = this.defaultConfig_;
        }
        if (config.getImplementation() == null) {
            cache = new SimpleExoCache();
        } else {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = cl.loadClass(config.getImplementation());
            cache = (ExoCache)clazz.newInstance();
        }
        cache.setName(region);
        cache.setLabel(config.getLabel());
        cache.setMaxSize(config.getMaxSize());
        cache.setLiveTime(config.getLiveTime());
        cache.setLogEnabled(config.isLogEnabled());
        if (cache.isLogEnabled()) {
            cache.addCacheListener(this.loggingListener_);
        }
        if (this.managed != null) {
            this.managed.registerCache(cache);
        }
        return cache;
    }

    @Override
    public Collection<ExoCache<? extends Serializable, ?>> getAllCacheInstances() {
        return this.cacheMap_.values();
    }
}

