/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl;

import java.io.Serializable;
import org.exoplatform.management.ManagementAware;
import org.exoplatform.management.ManagementContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.impl.CacheServiceImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Managed
@NameTemplate(value={@Property(key="service", value="cachemanager")})
@ManagedDescription(value="Cache manager")
public class CacheServiceManaged
implements ManagementAware {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.cache.CacheServiceManaged");
    private ManagementContext context;
    protected CacheServiceImpl cacheService;

    public CacheServiceManaged(CacheServiceImpl cacheService) {
        this.cacheService = cacheService;
        cacheService.managed = this;
    }

    @Managed
    @ManagedDescription(value="Clear all registered cache instances")
    public void clearCaches() {
        for (ExoCache<Serializable, ?> o : this.cacheService.getAllCacheInstances()) {
            try {
                o.clearCache();
            }
            catch (Exception wtf) {
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace((Object)("An exception occurred: " + wtf.getMessage()));
            }
        }
    }

    public void setContext(ManagementContext context) {
        this.context = context;
    }

    void registerCache(ExoCache<? extends Serializable, ?> cache) {
        if (this.context != null) {
            this.context.register(cache);
        }
    }

    void unregisterCache(ExoCache<? extends Serializable, ?> cache) {
        if (this.context != null) {
            this.context.unregister(cache);
        }
    }
}

