/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.concurrent;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.concurrent.CacheState;
import org.exoplatform.services.cache.concurrent.ListenerContext;
import org.exoplatform.services.cache.concurrent.ObjectRef;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentFIFOExoCache<K extends Serializable, V>
implements ExoCache<K, V> {
    private static int DEFAULT_MAX_SIZE = 50;
    private final Log log;
    private volatile long liveTimeMillis;
    volatile int maxSize;
    private CopyOnWriteArrayList<ListenerContext<K, V>> listeners;
    private CacheState<K, V> state;
    AtomicInteger hits = new AtomicInteger();
    AtomicInteger misses = new AtomicInteger();
    private String label;
    private String name;
    private boolean logEnabled = false;

    public ConcurrentFIFOExoCache() {
        this(DEFAULT_MAX_SIZE);
    }

    public ConcurrentFIFOExoCache(Log log) {
        this(DEFAULT_MAX_SIZE, log);
    }

    public ConcurrentFIFOExoCache(int maxSize) {
        this(null, maxSize);
    }

    public ConcurrentFIFOExoCache(int maxSize, Log log) {
        this(null, maxSize, log);
    }

    public ConcurrentFIFOExoCache(String name, int maxSize) {
        this(name, maxSize, null);
    }

    public ConcurrentFIFOExoCache(String name, int maxSize, Log log) {
        this.maxSize = maxSize;
        this.name = name;
        this.state = new CacheState(this, log);
        this.liveTimeMillis = -1L;
        this.log = log;
        this.listeners = new CopyOnWriteArrayList();
    }

    public void assertConsistent() {
        this.state.assertConsistency();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String s) {
        this.name = s;
    }

    @Override
    public String getLabel() {
        if (this.label == null) {
            if (this.name.length() > 30) {
                String shortLabel = this.name.substring(this.name.lastIndexOf(".") + 1);
                this.setLabel(shortLabel);
                return shortLabel;
            }
            return this.name;
        }
        return this.label;
    }

    @Override
    public void setLabel(String name) {
        this.label = name;
    }

    @Override
    public long getLiveTime() {
        long tmp = this.getLiveTimeMillis();
        return tmp == -1L ? -1L : tmp / 1000L;
    }

    @Override
    public void setLiveTime(long period) {
        this.setLiveTimeMillis(period * 1000L);
    }

    public long getLiveTimeMillis() {
        return this.liveTimeMillis;
    }

    public void setLiveTimeMillis(long liveTimeMillis) {
        if (liveTimeMillis < 0L) {
            liveTimeMillis = -1L;
        }
        this.liveTimeMillis = liveTimeMillis;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int max) {
        this.maxSize = max;
    }

    @Override
    public V get(Serializable name) {
        if (name == null) {
            return null;
        }
        return this.state.get(name);
    }

    @Override
    public void put(K name, V obj) {
        if (name == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        if (this.liveTimeMillis != 0L) {
            long expirationTime = this.liveTimeMillis > 0L ? System.currentTimeMillis() + this.liveTimeMillis : Long.MAX_VALUE;
            this.state.put(expirationTime, name, obj);
        }
    }

    @Override
    public void putMap(Map<? extends K, ? extends V> objs) {
        if (objs == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        long expirationTime = this.liveTimeMillis > 0L ? System.currentTimeMillis() + this.liveTimeMillis : Long.MAX_VALUE;
        for (Serializable serializable : objs.keySet()) {
            if (serializable != null) continue;
            throw new IllegalArgumentException("No null cache key accepted");
        }
        for (Map.Entry entry : objs.entrySet()) {
            this.state.put(expirationTime, (Serializable)entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Serializable name) {
        if (name == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        return this.state.remove(name);
    }

    @Override
    public List<? extends V> getCachedObjects() {
        LinkedList list = new LinkedList();
        for (ObjectRef objectRef : this.state.map.values()) {
            Object object = objectRef.getObject();
            if (!objectRef.isValid()) continue;
            list.add(object);
        }
        return list;
    }

    @Override
    public List<? extends V> removeCachedObjects() {
        List<V> list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    @Override
    public void clearCache() {
        this.state = new CacheState(this, this.log);
    }

    @Override
    public void select(CachedObjectSelector<? super K, ? super V> selector) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException("No null selector");
        }
        for (Map.Entry entry : this.state.map.entrySet()) {
            ObjectRef info;
            Serializable key = (Serializable)entry.getKey();
            if (!selector.select(key, info = entry.getValue())) continue;
            selector.onSelect(this, key, info);
        }
    }

    @Override
    public int getCacheSize() {
        return this.state.queue.size();
    }

    @Override
    public int getCacheHit() {
        return this.hits.get();
    }

    @Override
    public int getCacheMiss() {
        return this.misses.get();
    }

    @Override
    public synchronized void addCacheListener(CacheListener<? super K, ? super V> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        this.listeners.add(new ListenerContext<K, V>(listener, this));
    }

    @Override
    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    @Override
    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    void onExpire(K key, V obj) {
        if (!this.listeners.isEmpty()) {
            for (ListenerContext<K, V> context : this.listeners) {
                context.onExpire(key, obj);
            }
        }
    }

    void onRemove(K key, V obj) {
        if (!this.listeners.isEmpty()) {
            for (ListenerContext<K, V> context : this.listeners) {
                context.onRemove(key, obj);
            }
        }
    }

    void onPut(K key, V obj) {
        if (!this.listeners.isEmpty()) {
            for (ListenerContext<K, V> context : this.listeners) {
                context.onPut(key, obj);
            }
        }
    }

    void onGet(K key, V obj) {
        if (!this.listeners.isEmpty()) {
            for (ListenerContext<K, V> context : this.listeners) {
                context.onGet(key, obj);
            }
        }
    }

    void onClearCache() {
        if (!this.listeners.isEmpty()) {
            for (ListenerContext<K, V> context : this.listeners) {
                context.onClearCache();
            }
        }
    }
}

