/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.command.action;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.exoplatform.services.command.action.Action;
import org.exoplatform.services.command.action.ActionMatcher;
import org.exoplatform.services.command.action.Condition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionCatalog {
    private Map<ActionMatcher, Action> commands = new HashMap<ActionMatcher, Action>();

    public Set<Action> getAllActions() {
        return new HashSet<Action>(this.commands.values());
    }

    public Map<ActionMatcher, Action> getAllEntries() {
        return this.commands;
    }

    public Set<Action> getActions(Condition conditions) {
        HashSet<Action> actions = new HashSet<Action>();
        for (Map.Entry<ActionMatcher, Action> entry : this.commands.entrySet()) {
            if (!entry.getKey().match(conditions)) continue;
            actions.add(entry.getValue());
        }
        return actions;
    }

    public Action getAction(Condition conditions, int index) {
        Iterator<Action> actions = this.getActions(conditions).iterator();
        int i = 0;
        while (actions.hasNext()) {
            Action c = actions.next();
            if (i == index) {
                return c;
            }
            ++i;
        }
        return null;
    }

    public void addAction(ActionMatcher matcher, Action action) {
        this.commands.put(matcher, action);
    }

    public void clear() {
        this.commands.clear();
    }
}

