/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.naming;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.xml.stream.XMLStreamException;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.Property;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.BindReferencePlugin;
import org.exoplatform.services.naming.InitialContextBinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitialContextInitializer {
    public static final String PROPERTIES_DEFAULT = "default-properties";
    public static final String PROPERTIES_MANDATORY = "mandatory-properties";
    private static Log log = ExoLogger.getLogger((String)"exo.kernel.component.common.InitialContextInitializer");
    private List<BindReferencePlugin> bindReferencesPlugins;
    private String defaultContextFactory;
    private final InitialContext initialContext;
    private final InitialContextBinder binder;

    public InitialContextInitializer(InitParams params) throws NamingException, ConfigurationException, FileNotFoundException, XMLStreamException {
        Iterator propsParams = params.getPropertiesParamIterator();
        while (propsParams.hasNext()) {
            PropertiesParam propParam = (PropertiesParam)propsParams.next();
            boolean isDefault = propParam.getName().equals(PROPERTIES_DEFAULT);
            boolean isMandatory = propParam.getName().equals(PROPERTIES_MANDATORY);
            Iterator props = propParam.getPropertyIterator();
            while (props.hasNext()) {
                Property prop = (Property)props.next();
                String propName = prop.getName();
                String propValue = prop.getValue();
                String existedProp = System.getProperty(propName);
                if (isMandatory) {
                    this.setSystemProperty(propName, propValue, propParam.getName());
                    continue;
                }
                if (!isDefault) continue;
                if (existedProp == null) {
                    this.setSystemProperty(propName, propValue, propParam.getName());
                    continue;
                }
                log.info((Object)("Using default system property: " + propName + " = " + existedProp));
            }
        }
        this.initialContext = new InitialContext();
        this.bindReferencesPlugins = new ArrayList<BindReferencePlugin>();
        this.binder = new InitialContextBinder(this);
    }

    private void setSystemProperty(String propName, String propValue, String propParamName) {
        System.setProperty(propName, propValue);
        if (propName.equals("java.naming.factory.initial")) {
            this.defaultContextFactory = propValue;
        }
        log.info((Object)("Using mandatory system property: " + propName + " = " + System.getProperty(propName)));
    }

    private InitialContextInitializer(String name, Reference reference) throws NamingException, FileNotFoundException, XMLStreamException {
        if (System.getProperty("java.naming.factory.initial") == null) {
            System.setProperty("java.naming.factory.initial", this.defaultContextFactory);
        }
        this.initialContext = new InitialContext();
        this.initialContext.rebind(name, (Object)reference);
        this.binder = new InitialContextBinder(this);
    }

    public void recall() {
        for (BindReferencePlugin plugin : this.bindReferencesPlugins) {
            try {
                InitialContext ic = new InitialContext();
                ic.bind(plugin.getBindName(), (Object)plugin.getReference());
                log.info((Object)("Reference bound (by recall()): " + plugin.getBindName()));
            }
            catch (NameAlreadyBoundException e) {
                log.debug((Object)("Name already bound: " + plugin.getBindName()));
            }
            catch (NamingException e) {
                log.error((Object)("Could not bind: " + plugin.getBindName()), (Throwable)e);
            }
        }
    }

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof BindReferencePlugin) {
            BindReferencePlugin brplugin = (BindReferencePlugin)plugin;
            try {
                this.initialContext.rebind(brplugin.getBindName(), (Object)brplugin.getReference());
                log.info((Object)("Reference bound: " + brplugin.getBindName()));
                this.bindReferencesPlugins.add((BindReferencePlugin)plugin);
            }
            catch (NamingException e) {
                log.error((Object)("Could not bind: " + brplugin.getBindName()), (Throwable)e);
            }
        }
    }

    public ComponentPlugin removePlugin(String name) {
        return null;
    }

    public Collection getPlugins() {
        return this.bindReferencesPlugins;
    }

    public String getDefaultContextFactory() {
        return this.defaultContextFactory;
    }

    public synchronized InitialContext getInitialContext() {
        return this.initialContext;
    }

    public static void initialize(String name, Reference reference) throws NamingException, FileNotFoundException, XMLStreamException {
        new InitialContextInitializer(name, reference);
    }

    public void bind(String bindName, String className, String factory, String factoryLocation, Map<String, String> refAddr) throws NamingException, FileNotFoundException, XMLStreamException {
        this.binder.bind(bindName, className, factory, factoryLocation, refAddr);
    }
}

