/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheFactory;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheCreator;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheCreatorPlugin;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheFactoryConfigPlugin;
import org.exoplatform.services.cache.impl.infinispan.generic.GenericExoCacheCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.manager.DefaultCacheManager;

public class ExoCacheFactoryImpl
implements ExoCacheFactory {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.ext.cache.impl.infinispan.v4.ExoCacheFactoryImpl");
    private static final String CACHE_CONFIG_TEMPLATE_KEY = "cache.config.template";
    private final ExoContainerContext ctx;
    private final ConfigurationManager configManager;
    private final DefaultCacheManager cacheManager;
    private final Map<Class<? extends ExoCacheConfig>, ExoCacheCreator> mappingConfigTypeCreators = new HashMap<Class<? extends ExoCacheConfig>, ExoCacheCreator>();
    private final Map<String, ExoCacheCreator> mappingImplCreators = new HashMap<String, ExoCacheCreator>();
    private final Map<String, String> mappingCacheNameConfig = new HashMap<String, String>();
    private final Map<GlobalConfiguration, DefaultCacheManager> mappingGlobalConfigCacheManager = new HashMap<GlobalConfiguration, DefaultCacheManager>();
    private final ExoCacheCreator defaultCreator = new GenericExoCacheCreator();

    public ExoCacheFactoryImpl(ExoContainerContext ctx, InitParams params, ConfigurationManager configManager) throws ExoCacheInitException {
        this(ctx, ExoCacheFactoryImpl.getValueParam(params, CACHE_CONFIG_TEMPLATE_KEY), configManager);
    }

    ExoCacheFactoryImpl(ExoContainerContext ctx, String cacheConfigTemplate, ConfigurationManager configManager) throws ExoCacheInitException {
        this.ctx = ctx;
        this.configManager = configManager;
        if (cacheConfigTemplate == null) {
            throw new RuntimeException("The parameter 'cache.config.template' must be set");
        }
        this.cacheManager = this.initCacheManager(cacheConfigTemplate);
        this.mappingGlobalConfigCacheManager.put(this.cacheManager.getGlobalConfiguration(), this.cacheManager);
    }

    private DefaultCacheManager initCacheManager(String cacheConfigTemplate) throws ExoCacheInitException {
        InputStream is = null;
        try {
            is = this.configManager.getInputStream(cacheConfigTemplate);
        }
        catch (Exception e) {
            throw new ExoCacheInitException("The configuration of the CacheManager cannot be loaded from '" + cacheConfigTemplate + "'", (Throwable)e);
        }
        if (is == null) {
            throw new ExoCacheInitException("The configuration of the CacheManager cannot be found at '" + cacheConfigTemplate + "'");
        }
        DefaultCacheManager cacheManager = null;
        try {
            cacheManager = new DefaultCacheManager(is, false);
        }
        catch (Exception e) {
            throw new ExoCacheInitException("Cannot initialize the CacheManager corresponding to the configuration '" + cacheConfigTemplate + "'", (Throwable)e);
        }
        GlobalConfiguration config = cacheManager.getGlobalConfiguration();
        this.configureJGroups(config);
        return cacheManager;
    }

    private void configureJGroups(GlobalConfiguration config) throws ExoCacheInitException {
        if (this.loadJGroupsConfig(config)) {
            config.setClusterName(config.getClusterName() + "-" + this.ctx.getName());
        }
    }

    private boolean loadJGroupsConfig(GlobalConfiguration config) throws ExoCacheInitException {
        InputStream is;
        Properties properties = config.getTransportProperties();
        if (properties == null || !properties.containsKey("configurationFile")) {
            return false;
        }
        String jgroupsFileLocation = properties.getProperty("configurationFile");
        try {
            URL url = this.configManager.getURL(jgroupsFileLocation);
            is = url == null ? null : url.openStream();
        }
        catch (Exception e) {
            throw new ExoCacheInitException("The jgroups configuration cannot be loaded from '" + jgroupsFileLocation + "'", (Throwable)e);
        }
        if (is != null) {
            try {
                properties.setProperty("configurationXml", this.readStream(is));
            }
            catch (IOException e) {
                throw new ExoCacheInitException("The jgroups configuration cannot be read from '" + jgroupsFileLocation + "'");
            }
            properties.remove("configurationFile");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readStream(InputStream inputStream) throws IOException {
        StringBuilder out = new StringBuilder(4096);
        byte[] b = new byte[4096];
        try {
            int length;
            while ((length = inputStream.read(b)) != -1) {
                out.append(new String(b, 0, length));
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {
                LOG.debug((Object)"Cannot close stream", (Throwable)e);
            }
        }
        return out.toString();
    }

    public ExoCache<Serializable, Object> createCache(ExoCacheConfig config) throws ExoCacheInitException {
        ExoCache<Serializable, Object> eXoCache;
        final String region = config.getName();
        String customConfig = this.mappingCacheNameConfig.get(region);
        try {
            DefaultCacheManager cacheManager;
            Configuration conf;
            if (customConfig != null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("A custom configuration has been set for the cache '" + region + "'."));
                }
                DefaultCacheManager customCacheManager = new DefaultCacheManager(this.configManager.getInputStream(customConfig), false);
                GlobalConfiguration gc = customCacheManager.getGlobalConfiguration();
                this.configureJGroups(gc);
                DefaultCacheManager currentCacheManager = this.mappingGlobalConfigCacheManager.get(gc);
                if (currentCacheManager == null) {
                    currentCacheManager = customCacheManager;
                    this.mappingGlobalConfigCacheManager.put(gc, customCacheManager);
                }
                conf = currentCacheManager.getDefaultConfiguration().clone();
                cacheManager = currentCacheManager;
            } else {
                cacheManager = this.cacheManager;
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("The configuration template will be used for the the cache '" + region + "'."));
                }
                conf = cacheManager.getDefaultConfiguration().clone();
                if (!config.isDistributed() && !config.isRepicated()) {
                    conf.setCacheMode(Configuration.CacheMode.LOCAL);
                }
            }
            this.resetConfiguration(conf);
            ExoCacheCreator creator = this.getExoCacheCreator(config);
            eXoCache = creator.create(config, conf, new Callable<Cache<Serializable, Object>>(){

                @Override
                public Cache<Serializable, Object> call() throws Exception {
                    cacheManager.defineConfiguration(region, conf);
                    return cacheManager.getCache(region);
                }
            });
        }
        catch (Exception e) {
            throw new ExoCacheInitException("The cache '" + region + "' could not be initialized", (Throwable)e);
        }
        return eXoCache;
    }

    public void addCreator(ExoCacheCreatorPlugin plugin) {
        List<ExoCacheCreator> creators = plugin.getCreators();
        for (ExoCacheCreator creator : creators) {
            this.mappingConfigTypeCreators.put(creator.getExpectedConfigType(), creator);
            Set<String> implementations = creator.getExpectedImplementations();
            if (implementations == null) {
                throw new NullPointerException("The set of implementations cannot be null");
            }
            for (String imp : implementations) {
                this.mappingImplCreators.put(imp, creator);
            }
        }
    }

    public void addConfig(ExoCacheFactoryConfigPlugin plugin) {
        Map<String, String> configs = plugin.getConfigs();
        this.mappingCacheNameConfig.putAll(configs);
    }

    private static String getValueParam(InitParams params, String key) {
        String result;
        if (params == null) {
            return null;
        }
        ValueParam vp = params.getValueParam(key);
        if (vp == null || (result = vp.getValue()) == null || (result = result.trim()).length() == 0) {
            return null;
        }
        return result;
    }

    protected ExoCacheCreator getExoCacheCreator(ExoCacheConfig config) {
        ExoCacheCreator creator = this.mappingConfigTypeCreators.get(config.getClass());
        if (creator == null && (creator = this.mappingImplCreators.get(config.getImplementation())) == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("No cache creator has been found for the the cache '" + config.getName() + "', the default one will be used."));
            }
            return this.defaultCreator;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("The cache '" + config.getName() + "' will be created with '" + creator.getClass() + "'."));
        }
        return creator;
    }

    protected void resetConfiguration(Configuration config) {
        config.setInvocationBatchingEnabled(true);
        config.setEvictionStrategy(EvictionStrategy.NONE);
        config.setEvictionMaxEntries(-1);
        config.setExpirationLifespan(-1L);
        config.setExpirationMaxIdle(-1L);
        config.setEvictionWakeUpInterval(5000L);
    }
}

