/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.infinispan.generic;

import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.Callable;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.cache.impl.infinispan.AbstractExoCache;
import org.exoplatform.services.cache.impl.infinispan.ExoCacheCreator;
import org.exoplatform.services.cache.impl.infinispan.generic.GenericExoCacheConfig;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;

public class GenericExoCacheCreator
implements ExoCacheCreator {
    protected String defaultStrategy = "LRU";
    protected long defaultMaxIdle = -1L;
    protected long defaultWakeUpInterval = 5000L;
    protected Set<String> implementations;

    @Override
    public Set<String> getExpectedImplementations() {
        return this.implementations;
    }

    @Override
    public Class<? extends ExoCacheConfig> getExpectedConfigType() {
        return GenericExoCacheConfig.class;
    }

    @Override
    public ExoCache<Serializable, Object> create(ExoCacheConfig config, Configuration cacheConfig, Callable<Cache<Serializable, Object>> cacheGetter) throws ExoCacheInitException {
        if (config instanceof GenericExoCacheConfig) {
            GenericExoCacheConfig gConfig = (GenericExoCacheConfig)config;
            return this.create(config, cacheConfig, cacheGetter, gConfig.getStrategy(), gConfig.getMaxEntries(), gConfig.getLifespan(), gConfig.getMaxIdle() == 0L ? this.defaultMaxIdle : gConfig.getMaxIdle(), gConfig.getWakeUpInterval() == 0L ? this.defaultWakeUpInterval : gConfig.getWakeUpInterval());
        }
        long period = config.getLiveTime();
        return this.create(config, cacheConfig, cacheGetter, config.getImplementation() == null ? this.defaultStrategy : config.getImplementation(), config.getMaxSize(), period > 0L ? period * 1000L : -1L, this.defaultMaxIdle, this.defaultWakeUpInterval);
    }

    private ExoCache<Serializable, Object> create(ExoCacheConfig config, Configuration cacheConfig, Callable<Cache<Serializable, Object>> cacheGetter, String strategy, int maxEntries, long lifespan, long maxIdle, long wakeUpInterval) throws ExoCacheInitException {
        cacheConfig.setEvictionStrategy(strategy);
        cacheConfig.setEvictionMaxEntries(maxEntries);
        cacheConfig.setExpirationLifespan(lifespan);
        cacheConfig.setExpirationMaxIdle(maxIdle);
        cacheConfig.setEvictionWakeUpInterval(wakeUpInterval);
        try {
            return new GenericExoCache(cacheConfig, config, cacheGetter.call());
        }
        catch (Exception e) {
            throw new ExoCacheInitException("Cannot create the cache '" + config.getName() + "'", (Throwable)e);
        }
    }

    public static class GenericExoCache
    extends AbstractExoCache<Serializable, Object> {
        private final Configuration cacheConfig;

        public GenericExoCache(Configuration cacheConfig, ExoCacheConfig config, Cache<Serializable, Object> cache) {
            super(config, cache);
            this.cacheConfig = cacheConfig;
        }

        public void setMaxSize(int max) {
            this.cacheConfig.setEvictionMaxEntries(max);
        }

        public void setLiveTime(long period) {
            this.cacheConfig.setExpirationLifespan(period);
        }

        public void setMaxIdle(long maxIdle) {
            this.cacheConfig.setExpirationMaxIdle(maxIdle);
        }

        public void setWakeUpInterval(long wakeUpInterval) {
            this.cacheConfig.setEvictionWakeUpInterval(wakeUpInterval);
        }

        @ManagedName(value="MaxEntries")
        @ManagedDescription(value="Maximum number of entries in a cache instance. -1 means no limit.")
        public int getMaxSize() {
            return this.cacheConfig.getEvictionMaxEntries();
        }

        @ManagedName(value="Lifespan")
        @ManagedDescription(value="Maximum lifespan of a cache entry, after which the entry is expired cluster-wide. -1 means the entries never expire.")
        public long getLiveTime() {
            return this.cacheConfig.getExpirationLifespan();
        }

        @Managed
        @ManagedName(value="MaxIdle")
        @ManagedDescription(value="Maximum idle time a cache entry will be maintained in the cache. If the idle time is exceeded, the entry will be expired cluster-wide. -1 means the entries never expire.")
        public long getMaxIdle() {
            return this.cacheConfig.getExpirationMaxIdle();
        }

        @Managed
        @ManagedName(value="WakeUpInterval")
        @ManagedDescription(value="Interval between subsequent eviction runs. If you wish to disable the periodic eviction process altogether, set wakeupInterval to -1.")
        public long getWakeUpInterval() {
            return this.cacheConfig.getEvictionWakeUpInterval();
        }
    }
}

