/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ispn;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.util.TemplateConfigurationHelper;
import org.exoplatform.services.cache.ExoCacheInitException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.util.TypedProperties;

public class Utils {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.ext.cache.impl.infinispan.v5.Utils");

    private Utils() {
    }

    public static boolean loadJGroupsConfig(ConfigurationManager cfm, GlobalConfiguration config, GlobalConfigurationBuilder configBuilder) throws ExoCacheInitException {
        TypedProperties properties = config.transport().properties();
        if (properties == null || !properties.containsKey("configurationFile")) {
            return false;
        }
        String filename = properties.getProperty("configurationFile");
        InputStream inputStream = TemplateConfigurationHelper.getInputStream((ConfigurationManager)cfm, (String)filename);
        if (inputStream == null) {
            throw new IllegalStateException("The jgroups configuration cannot be loaded from '" + filename + "'");
        }
        try {
            properties.setProperty("configurationXml", Utils.readStream(inputStream));
        }
        catch (IOException e) {
            throw new IllegalStateException("The jgroups configuration cannot be read from '" + filename + "'", e);
        }
        properties.remove("configurationFile");
        configBuilder.transport().withProperties((Properties)properties);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStream(InputStream inputStream) throws IOException {
        StringBuilder out = new StringBuilder(4096);
        byte[] b = new byte[4096];
        try {
            int length;
            while ((length = inputStream.read(b)) != -1) {
                out.append(new String(b, 0, length));
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOG.debug((Object)"Cannot close stream", (Throwable)e);
            }
        }
        return out.toString();
    }
}

