/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.jboss;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.exoplatform.services.cache.CacheInfo;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.cache.ObjectCacheInfo;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.Fqn;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.notifications.annotation.NodeEvicted;
import org.jboss.cache.notifications.annotation.NodeModified;
import org.jboss.cache.notifications.annotation.NodeRemoved;
import org.jboss.cache.notifications.event.NodeEvictedEvent;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.notifications.event.NodeRemovedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractExoCache<K extends Serializable, V>
implements ExoCache<K, V> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.ext.cache.impl.jboss.v3.AbstractExoCache");
    private final AtomicInteger hits = new AtomicInteger(0);
    private final AtomicInteger misses = new AtomicInteger(0);
    private String label;
    private String name;
    private boolean distributed;
    private boolean replicated;
    private boolean logEnabled;
    private final CopyOnWriteArrayList<ListenerContext<K, V>> listeners;
    protected final CacheSPI<K, V> cache;

    public AbstractExoCache(ExoCacheConfig config, Cache<K, V> cache) {
        this.cache = (CacheSPI)cache;
        this.listeners = new CopyOnWriteArrayList();
        this.setDistributed(config.isDistributed());
        this.setLabel(config.getLabel());
        this.setName(config.getName());
        this.setLogEnabled(config.isLogEnabled());
        this.setReplicated(config.isRepicated());
        cache.getConfiguration().setInvocationBatchingEnabled(true);
        cache.addCacheListener((Object)new CacheEventListener());
    }

    public void addCacheListener(CacheListener<? super K, ? super V> listener) {
        if (listener == null) {
            throw new NullPointerException();
        }
        this.listeners.add(new ListenerContext<K, V>(listener, this));
    }

    public void clearCache() {
        NodeSPI rootNode = this.cache.getRoot();
        for (Node node : rootNode.getChildren()) {
            if (node == null) continue;
            this.remove((Serializable)this.getKey(node));
        }
        this.onClearCache();
    }

    public V get(Serializable name) {
        if (name == null) {
            return null;
        }
        Object result = this.cache.get(this.getFqn(name), (Object)name);
        if (result == null) {
            this.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
        }
        this.onGet(name, result);
        return (V)result;
    }

    public int getCacheHit() {
        return this.hits.get();
    }

    public int getCacheMiss() {
        return this.misses.get();
    }

    public int getCacheSize() {
        return this.cache.getNumberOfNodes();
    }

    public List<V> getCachedObjects() {
        LinkedList<Object> list = new LinkedList<Object>();
        for (Node node : this.cache.getRoot().getChildren()) {
            Object value;
            if (node == null || (value = node.get(this.getKey(node))) == null) continue;
            list.add(value);
        }
        return list;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void put(K key, V value) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("No null cache key accepted");
        }
        this.putOnly(key, value);
        this.onPut(key, value);
    }

    protected V putOnly(K key, V value) {
        try {
            return (V)this.cache.put(this.getFqn((Serializable)key), key, value);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void putMap(Map<? extends K, ? extends V> objs) throws NullPointerException, IllegalArgumentException {
        if (objs == null) {
            throw new NullPointerException("No null map accepted");
        }
        for (Serializable name : objs.keySet()) {
            if (name != null) continue;
            throw new IllegalArgumentException("No null cache key accepted");
        }
        this.cache.startBatch();
        int total = 0;
        try {
            for (Map.Entry<K, V> entry : objs.entrySet()) {
                V value = this.putOnly((Serializable)entry.getKey(), entry.getValue());
                if (value != null) continue;
                ++total;
            }
            this.cache.endBatch(true);
            for (Map.Entry<K, V> entry : objs.entrySet()) {
                this.onPut((Serializable)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            this.cache.endBatch(false);
            LOG.warn((Object)"An error occurs while executing the putMap method", (Throwable)e);
        }
    }

    public V remove(Serializable name) throws NullPointerException {
        if (name == null) {
            throw new NullPointerException("No null cache key accepted");
        }
        Fqn<Serializable> fqn = this.getFqn(name);
        NodeSPI node = this.cache.peek(fqn, false);
        Object result = null;
        if (node != null) {
            result = node.getDirect((Object)name);
            if (this.cache.removeNode(fqn)) {
                this.onRemove(name, result);
            }
        }
        return (V)result;
    }

    public List<V> removeCachedObjects() {
        List<V> list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    public void select(CachedObjectSelector<? super K, ? super V> selector) throws Exception {
        if (selector == null) {
            throw new IllegalArgumentException("No null selector");
        }
        for (Node node : this.cache.getRoot().getChildren()) {
            Object value;
            ObjectCacheInfo info;
            K key;
            if (node == null || !selector.select(key = this.getKey(node), info = new ObjectCacheInfo<V>(value = ((NodeSPI)node).getDirect(key)){
                final /* synthetic */ Object val$value;
                {
                    this.val$value = object;
                }

                public V get() {
                    return this.val$value;
                }

                public long getExpireTime() {
                    return -1L;
                }
            })) continue;
            selector.onSelect((ExoCache)this, key, info);
        }
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    private K getKey(Node<K, V> node) {
        return this.getKey(node.getFqn());
    }

    private K getKey(Fqn fqn) {
        return (K)((Serializable)fqn.get(0));
    }

    protected Fqn<Serializable> getFqn(Serializable name) {
        return Fqn.fromElements((Object[])new Serializable[]{name});
    }

    void onExpire(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onExpire(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onRemove(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onRemove(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onPut(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onPut(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onGet(K key, V obj) {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onGet(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onClearCache() {
        if (this.listeners.isEmpty()) {
            return;
        }
        for (ListenerContext<K, V> context : this.listeners) {
            try {
                context.onClearCache();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenerContext<K extends Serializable, V>
    implements CacheListenerContext,
    CacheInfo {
        private final ExoCache<K, V> cache;
        final CacheListener<? super K, ? super V> listener;

        public ListenerContext(CacheListener<? super K, ? super V> listener, ExoCache<K, V> cache) {
            this.listener = listener;
            this.cache = cache;
        }

        public CacheInfo getCacheInfo() {
            return this;
        }

        public String getName() {
            return this.cache.getName();
        }

        public int getMaxSize() {
            return this.cache.getMaxSize();
        }

        public long getLiveTime() {
            return this.cache.getLiveTime();
        }

        public int getSize() {
            return this.cache.getCacheSize();
        }

        void onExpire(K key, V obj) throws Exception {
            this.listener.onExpire((CacheListenerContext)this, key, obj);
        }

        void onRemove(K key, V obj) throws Exception {
            this.listener.onRemove((CacheListenerContext)this, key, obj);
        }

        void onPut(K key, V obj) throws Exception {
            this.listener.onPut((CacheListenerContext)this, key, obj);
        }

        void onGet(K key, V obj) throws Exception {
            this.listener.onGet((CacheListenerContext)this, key, obj);
        }

        void onClearCache() throws Exception {
            this.listener.onClearCache((CacheListenerContext)this);
        }
    }

    @org.jboss.cache.notifications.annotation.CacheListener
    public class CacheEventListener {
        @NodeEvicted
        public void nodeEvicted(NodeEvictedEvent ne) {
            if (ne.isPre()) {
                NodeSPI node = AbstractExoCache.this.cache.peek(ne.getFqn(), true);
                Serializable key = AbstractExoCache.this.getKey(ne.getFqn());
                AbstractExoCache.this.onExpire(key, node == null ? null : node.getDirect((Object)key));
            }
        }

        @NodeRemoved
        public void nodeRemoved(NodeRemovedEvent ne) {
            if (ne.isPre() && !ne.isOriginLocal()) {
                Serializable key = AbstractExoCache.this.getKey(ne.getFqn());
                Map data = ne.getData();
                AbstractExoCache.this.onRemove(key, data == null ? null : (Object)data.get(key));
            }
        }

        @NodeModified
        public void nodeModified(NodeModifiedEvent ne) {
            if (!ne.isOriginLocal() && !ne.isPre()) {
                Serializable key = AbstractExoCache.this.getKey(ne.getFqn());
                Map data = ne.getData();
                AbstractExoCache.this.onPut(key, data == null ? null : (Object)data.get(key));
            }
        }
    }
}

