/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cache.impl.memcached;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.internal.OperationFuture;
import org.apache.ws.commons.util.Base64;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.services.cache.CacheInfo;
import org.exoplatform.services.cache.CacheListener;
import org.exoplatform.services.cache.CacheListenerContext;
import org.exoplatform.services.cache.CachedObjectSelector;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cache.ExoCacheConfig;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MCExoCache<K extends Serializable, V>
implements ExoCache<K, V> {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.component.ext.cache.impl.memcached.v1.AbstractExoCache");
    private final AtomicInteger hits = new AtomicInteger(0);
    private final AtomicInteger misses = new AtomicInteger(0);
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicReference<String> lastNamespace = new AtomicReference();
    private String label;
    private String name;
    private final String fullName;
    private boolean distributed;
    private boolean replicated;
    private boolean logEnabled;
    private int expirationTimeout;
    protected final MemcachedClient cache;
    private static final ConcurrentMap<String, List<ListenerContext>> ALL_LISTENERS = new ConcurrentHashMap<String, List<ListenerContext>>();

    public MCExoCache(ExoContainerContext ctx, ExoCacheConfig config, MemcachedClient cache, long expirationTimeout) {
        this.fullName = ctx.getName() + "-" + config.getName();
        this.cache = cache;
        this.expirationTimeout = (int)(expirationTimeout / 1000L);
        this.setDistributed(config.isDistributed());
        this.setLabel(config.getLabel());
        this.setName(config.getName());
        this.setLogEnabled(config.isLogEnabled());
        this.setReplicated(config.isRepicated());
    }

    String getFullName() {
        return this.fullName;
    }

    public void addCacheListener(CacheListener<? super K, ? super V> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("The listener cannot be null");
        }
        List<ListenerContext> lListeners = this.getOrCreateListeners();
        lListeners.add(new ListenerContext<K, V>(listener, this));
    }

    private List<ListenerContext> getOrCreateListeners() {
        List<ListenerContext> oldValue;
        List<ListenerContext> lListeners = this.getListeners();
        if (lListeners == null && (oldValue = ALL_LISTENERS.putIfAbsent(this.fullName, lListeners = new CopyOnWriteArrayList<ListenerContext>())) != null) {
            lListeners = oldValue;
        }
        return lListeners;
    }

    private List<ListenerContext> getListeners() {
        return (List)ALL_LISTENERS.get(this.fullName);
    }

    private String getNamespace() {
        return this.getNamespace(3);
    }

    private String getNamespace(int triesLeft) {
        String value;
        String oldNamespace = this.lastNamespace.get();
        CASValue casValue = this.cache.getAndTouch(this.fullName, this.expirationTimeout);
        if (casValue == null || casValue.getValue() == null) {
            value = UUID.randomUUID().toString();
            OperationFuture resp = this.cache.add(this.fullName, this.expirationTimeout, (Object)value);
            Boolean result = null;
            try {
                result = (Boolean)resp.get();
            }
            catch (InterruptedException e) {
                LOG.error((Object)"Could not get the namespace", (Throwable)e);
            }
            catch (ExecutionException e) {
                LOG.error((Object)"Could not get the namespace", (Throwable)e);
            }
            if (result == null || !result.booleanValue()) {
                if (result == null && triesLeft == 0) {
                    throw new RuntimeException("The namespace could not be found");
                }
                LOG.debug((Object)"Could not get the namespace, so we need to retry");
                return this.getNamespace(triesLeft - 1);
            }
        } else {
            value = (String)casValue.getValue();
        }
        if (this.lastNamespace.compareAndSet(oldNamespace, value) && oldNamespace != null && !oldNamespace.equals(value)) {
            this.count.set(0);
        }
        return value;
    }

    private String getKeyFullName(Serializable name) {
        return this.getKeyFullName(this.getNamespace(), name);
    }

    private String getKeyFullName(String namespace, Serializable name) {
        StringBuilder sb = new StringBuilder();
        sb.append(namespace);
        sb.append(':');
        sb.append(MCExoCache.toString(name));
        return sb.toString();
    }

    private static String toString(Serializable key) {
        if (key instanceof String) {
            return (String)((Object)key);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(baos);
            oos.writeObject(key);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not serialize the key " + key, e);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    LOG.trace((Object)"Could not close the object output stream", (Throwable)e);
                }
            }
        }
        return Base64.encode((byte[])baos.toByteArray());
    }

    public void clearCache() {
        Boolean result;
        String namespace = UUID.randomUUID().toString();
        String oldNamespace = this.lastNamespace.get();
        OperationFuture resp = this.cache.set(this.fullName, this.expirationTimeout, (Object)namespace);
        try {
            result = (Boolean)resp.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not clear the cache ", e);
        }
        if (result != null && result.booleanValue()) {
            this.lastNamespace.compareAndSet(oldNamespace, namespace);
            this.count.set(0);
            this.onClearCache();
        }
    }

    public V get(Serializable name) {
        Object result;
        if (name == null) {
            return null;
        }
        CASValue casValue = this.cache.getAndTouch(this.getKeyFullName(name), this.expirationTimeout);
        Object object = result = casValue == null ? null : casValue.getValue();
        if (result == null) {
            this.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
        }
        this.onGet(name, result);
        return (V)result;
    }

    public int getCacheHit() {
        return this.hits.get();
    }

    public int getCacheMiss() {
        return this.misses.get();
    }

    @Managed
    @ManagedName(value="Size")
    @ManagedDescription(value="The local cache size as it is not possible to get the global cache size")
    public int getCacheSize() {
        return this.count.get();
    }

    public List<V> getCachedObjects() {
        throw new UnsupportedOperationException("Cannot get the cached objects");
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public boolean isDistributed() {
        return this.distributed;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isReplicated() {
        return this.replicated;
    }

    public void put(K key, V value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        if (value == null) {
            return;
        }
        this.putOnly(this.getNamespace(), key, value);
        this.onPut(key, value);
    }

    protected void putOnly(String namespace, K key, V value) {
        Boolean result;
        OperationFuture resp = this.cache.add(this.getKeyFullName(namespace, (Serializable)key), this.expirationTimeout, value);
        try {
            result = (Boolean)resp.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not add the new value for the key " + key, e);
        }
        if (result == null || !result.booleanValue()) {
            resp = this.cache.replace(this.getKeyFullName(namespace, (Serializable)key), this.expirationTimeout, value);
            try {
                result = (Boolean)resp.get();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not replace the old value of the key " + key, e);
            }
            if (result == null || !result.booleanValue()) {
                this.putOnly(namespace, key, value);
            }
        } else if (namespace.equals(this.lastNamespace.get())) {
            this.count.incrementAndGet();
        }
    }

    public void putMap(Map<? extends K, ? extends V> objs) throws IllegalArgumentException {
        if (objs == null) {
            throw new IllegalArgumentException("No null map accepted");
        }
        for (Serializable name : objs.keySet()) {
            if (name != null) continue;
            throw new IllegalArgumentException("No null cache key accepted");
        }
        try {
            String namespace = this.getNamespace();
            for (Map.Entry<K, V> entry : objs.entrySet()) {
                this.putOnly(namespace, (Serializable)entry.getKey(), entry.getValue());
                this.onPut((Serializable)entry.getKey(), entry.getValue());
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"An error occurs while executing the putMap method", (Throwable)e);
        }
    }

    public V remove(Serializable name) throws IllegalArgumentException {
        Boolean result;
        if (name == null) {
            throw new IllegalArgumentException("No null cache key accepted");
        }
        String namespace = this.getNamespace();
        Object value = this.cache.get(this.getKeyFullName(namespace, name));
        OperationFuture resp = this.cache.delete(this.getKeyFullName(namespace, name));
        try {
            result = (Boolean)resp.get();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not remove the value for the key " + name, e);
        }
        if (result != null && result.booleanValue()) {
            if (namespace.equals(this.lastNamespace.get())) {
                this.count.decrementAndGet();
            }
            this.onRemove(name, value);
        }
        return (V)value;
    }

    public List<V> removeCachedObjects() {
        List<V> list = this.getCachedObjects();
        this.clearCache();
        return list;
    }

    public void select(CachedObjectSelector<? super K, ? super V> selector) throws Exception {
        throw new UnsupportedOperationException("Cannot select a sub part of the cache dynamically");
    }

    public void setDistributed(boolean distributed) {
        this.distributed = distributed;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setReplicated(boolean replicated) {
        this.replicated = replicated;
    }

    void onExpire(K key, V obj) {
        List<ListenerContext> listeners = this.getListeners();
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onExpire(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onRemove(K key, V obj) {
        List<ListenerContext> listeners = this.getListeners();
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onRemove(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onPut(K key, V obj) {
        List<ListenerContext> listeners = this.getListeners();
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onPut(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onGet(K key, V obj) {
        List<ListenerContext> listeners = this.getListeners();
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onGet(key, obj);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    void onClearCache() {
        List<ListenerContext> listeners = this.getListeners();
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        for (ListenerContext context : listeners) {
            try {
                context.onClearCache();
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)"Cannot execute the CacheListener properly", (Throwable)e);
            }
        }
    }

    @Managed
    @ManagedName(value="ExpirationTimeout")
    @ManagedDescription(value="This is the timeout after which the cache entry must be evicted.")
    public long getExpirationTimeout() {
        return this.expirationTimeout;
    }

    @Managed
    public void setExpirationTimeout(long expirationTimeout) {
        this.expirationTimeout = (int)(expirationTimeout / 1000L);
    }

    public void setMaxSize(int max) {
        throw new UnsupportedOperationException("The max size cannot be modified");
    }

    public void setLiveTime(long period) {
        this.expirationTimeout = (int)period;
    }

    public int getMaxSize() {
        return -1;
    }

    public long getLiveTime() {
        return this.expirationTimeout;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ListenerContext<K extends Serializable, V>
    implements CacheListenerContext,
    CacheInfo {
        private final ExoCache<K, V> cache;
        final CacheListener<? super K, ? super V> listener;

        public ListenerContext(CacheListener<? super K, ? super V> listener, ExoCache<K, V> cache) {
            this.listener = listener;
            this.cache = cache;
        }

        public CacheInfo getCacheInfo() {
            return this;
        }

        public String getName() {
            return this.cache.getName();
        }

        public int getMaxSize() {
            return this.cache.getMaxSize();
        }

        public long getLiveTime() {
            return this.cache.getLiveTime();
        }

        public int getSize() {
            return this.cache.getCacheSize();
        }

        void onExpire(K key, V obj) throws Exception {
            this.listener.onExpire((CacheListenerContext)this, key, obj);
        }

        void onRemove(K key, V obj) throws Exception {
            this.listener.onRemove((CacheListenerContext)this, key, obj);
        }

        void onPut(K key, V obj) throws Exception {
            this.listener.onPut((CacheListenerContext)this, key, obj);
        }

        void onGet(K key, V obj) throws Exception {
            this.listener.onGet((CacheListenerContext)this, key, obj);
        }

        void onClearCache() throws Exception {
            this.listener.onClearCache((CacheListenerContext)this);
        }
    }
}

