/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.exoplatform.container.AbstractComponentAdapter;
import org.exoplatform.container.AbstractInterceptor;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.guice.ModuleProvider;
import org.exoplatform.container.spi.ComponentAdapter;
import org.exoplatform.container.spi.ContainerException;
import org.exoplatform.container.xml.Component;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GuiceContainer
extends AbstractInterceptor {
    private static final long serialVersionUID = -6662420267945445921L;
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ext.provider.impl.guice.v3.GuiceContainer");
    private Injector injector;

    public <T> T getComponentInstance(Object componentKey, Class<T> bindType, boolean autoRegistration) {
        Object result = super.getComponentInstance(componentKey, bindType, autoRegistration);
        if (result == null && this.injector != null) {
            Binding binding;
            if (componentKey instanceof Class && !((Class)componentKey).isAnnotation()) {
                binding = this.injector.getExistingBinding(Key.get((Class)((Class)componentKey)));
            } else if (componentKey instanceof String) {
                binding = this.injector.getExistingBinding(Key.get(bindType, (Annotation)Names.named((String)((String)componentKey))));
            } else if (componentKey instanceof Class) {
                binding = this.injector.getExistingBinding(Key.get(bindType, (Class)((Class)componentKey)));
            } else {
                return null;
            }
            if (binding == null || binding.getProvider().toString().startsWith(ComponentAdapterProvider.class.getName())) {
                return null;
            }
            result = bindType.cast(binding.getProvider().get());
        }
        return (T)result;
    }

    public <T> T getComponentInstanceOfType(Class<T> componentType, boolean autoRegistration) {
        Object result = super.getComponentInstanceOfType(componentType, autoRegistration);
        if (result == null && this.injector != null) {
            Binding binding = this.injector.getExistingBinding(Key.get(componentType));
            if (binding == null || binding.getProvider().toString().startsWith(ComponentAdapterProvider.class.getName())) {
                return null;
            }
            result = componentType.cast(binding.getProvider().get());
        }
        return (T)result;
    }

    public <T> ComponentAdapter<T> getComponentAdapter(Object componentKey, Class<T> bindType, boolean autoRegistration) {
        ComponentAdapter<T> result = super.getComponentAdapter(componentKey, bindType, autoRegistration);
        if (result == null && this.injector != null) {
            Binding binding;
            if (componentKey instanceof Class && !((Class)componentKey).isAnnotation()) {
                binding = this.injector.getExistingBinding(Key.get((Class)((Class)componentKey)));
            } else if (componentKey instanceof String) {
                binding = this.injector.getExistingBinding(Key.get(bindType, (Annotation)Names.named((String)((String)componentKey))));
            } else if (componentKey instanceof Class) {
                binding = this.injector.getExistingBinding(Key.get(bindType, (Class)((Class)componentKey)));
            } else {
                return null;
            }
            if (binding == null || binding.getProvider().toString().startsWith(ComponentAdapterProvider.class.getName())) {
                return null;
            }
            result = this.createComponentAdapter(bindType, binding);
        }
        return result;
    }

    private <T> ComponentAdapter<T> createComponentAdapter(final Class<T> type, final Binding<?> binding) {
        return new AbstractComponentAdapter<T>(type, type){
            private static final long serialVersionUID = 4241559622835718141L;

            public T getComponentInstance() throws ContainerException {
                return type.cast(binding.getProvider().get());
            }

            public boolean isSingleton() {
                return false;
            }
        };
    }

    public <T> ComponentAdapter<T> getComponentAdapterOfType(Class<T> componentType, boolean autoRegistration) {
        ComponentAdapter<T> result = super.getComponentAdapterOfType(componentType, autoRegistration);
        if (result == null && this.injector != null) {
            Binding binding = this.injector.getExistingBinding(Key.get(componentType));
            if (binding == null || binding.getProvider().toString().startsWith(ComponentAdapterProvider.class.getName())) {
                return null;
            }
            result = this.createComponentAdapter(componentType, binding);
        }
        return result;
    }

    public <T> List<ComponentAdapter<T>> getComponentAdaptersOfType(Class<T> componentType) {
        ArrayList<ComponentAdapter<T>> result = super.getComponentAdaptersOfType(componentType);
        if (this.injector != null) {
            result = new ArrayList<ComponentAdapter<T>>(result);
            for (Binding b : this.injector.getAllBindings().values()) {
                if (b.getProvider().toString().startsWith(ComponentAdapterProvider.class.getName()) || !componentType.isAssignableFrom(b.getKey().getTypeLiteral().getRawType())) continue;
                result.add(this.createComponentAdapter(b.getKey().getTypeLiteral().getRawType(), b));
            }
        }
        return result;
    }

    public <T> List<T> getComponentInstancesOfType(Class<T> componentType) throws ContainerException {
        ArrayList<T> result = super.getComponentInstancesOfType(componentType);
        if (this.injector != null) {
            result = new ArrayList<T>(result);
            for (Binding b : this.injector.getAllBindings().values()) {
                if (b.getProvider().toString().startsWith(ComponentAdapterProvider.class.getName()) || !componentType.isAssignableFrom(b.getKey().getTypeLiteral().getRawType())) continue;
                result.add(componentType.cast(b.getProvider().get()));
            }
        }
        return result;
    }

    public void start() {
        ConfigurationManager cm = (ConfigurationManager)super.getComponentInstanceOfType(ConfigurationManager.class, false);
        Component component = cm.getComponent(ModuleProvider.class);
        if (component == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No ModuleProvider has been defined, thus the GuiceContainer will be disabled. To enable the Guice Integration please define a ModuleProvider");
            }
        } else {
            ModuleProvider provider = (ModuleProvider)super.getComponentInstanceOfType(ModuleProvider.class, false);
            this.injector = Guice.createInjector((Module[])new Module[]{provider.getModule(), new AbstractModule(){

                protected void configure() {
                    Collection adapters = GuiceContainer.this.delegate.getComponentAdapters();
                    Binder binder = this.binder();
                    for (ComponentAdapter adapter : adapters) {
                        Class type;
                        Object key = adapter.getComponentKey();
                        Named annotation = null;
                        Class annotationType = null;
                        if (key instanceof Class && !((Class)key).isAnnotation()) {
                            type = (Class)key;
                        } else {
                            if (key instanceof String) {
                                annotation = Names.named((String)((String)key));
                            } else if (key instanceof Class) {
                                annotationType = (Class)key;
                            }
                            type = adapter.getComponentImplementation();
                        }
                        if (annotation == null && annotationType == null) {
                            binder.bind(type).toProvider(new ComponentAdapterProvider(type, adapter));
                            continue;
                        }
                        ComponentAdapterProvider provider = new ComponentAdapterProvider(type, adapter);
                        GuiceContainer.bindAll(binder, type, provider, (Annotation)annotation, annotationType);
                    }
                }
            }});
            LOG.info((Object)("A GuiceContainer has been enabled using the ModuleProvider " + provider.getClass()));
        }
        super.start();
    }

    private static void bindAll(Binder binder, Class<?> clazz, ComponentAdapterProvider provider, Annotation annotation, Class<? extends Annotation> annotationType) {
        if (clazz == null || clazz.equals(Object.class)) {
            return;
        }
        if (annotation == null) {
            binder.bind(clazz).annotatedWith(annotationType).toProvider((Provider)provider);
        } else {
            binder.bind(clazz).annotatedWith(annotation).toProvider((Provider)provider);
        }
        for (Class<?> c : clazz.getInterfaces()) {
            GuiceContainer.bindAll(binder, c, provider, annotation, annotationType);
        }
        GuiceContainer.bindAll(binder, clazz.getSuperclass(), provider, annotation, annotationType);
    }

    public void stop() {
        super.stop();
        this.injector = null;
    }

    public String getId() {
        return "GuiceIntegration";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ComponentAdapterProvider<T>
    implements Provider<T> {
        private final Class<T> type;
        private final ComponentAdapter<T> adapter;

        private ComponentAdapterProvider(Class<T> type, ComponentAdapter<T> adapter) {
            this.type = type;
            this.adapter = adapter;
        }

        public T get() {
            return this.type.cast(this.adapter.getComponentInstance());
        }
    }
}

