/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.spring;

import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.container.spring.ApplicationContextProvider;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValuesParam;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class AnnotationConfigApplicationContextProvider
implements ApplicationContextProvider {
    private static final String CONFIG_CLASSES_PARAM_NAME = "config.classes";
    private final ValuesParam params;

    public AnnotationConfigApplicationContextProvider(InitParams p) {
        if (p == null || p.getValuesParam(CONFIG_CLASSES_PARAM_NAME) == null) {
            throw new IllegalArgumentException("The values parameter config.classes is mandatory, please set at least one value.");
        }
        this.params = p.getValuesParam(CONFIG_CLASSES_PARAM_NAME);
    }

    public ApplicationContext getApplicationContext(ApplicationContext parent) {
        try {
            AnnotationConfigApplicationContext ctx = new AnnotationConfigApplicationContext();
            ctx.setParent(parent);
            for (String value : this.params.getValues()) {
                Class clazz = ClassLoading.forName((String)value, AnnotationConfigApplicationContextProvider.class);
                ctx.register(new Class[]{clazz});
            }
            ctx.refresh();
            return ctx;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create the ApplicationContext", e);
        }
    }
}

