/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Mode {
    MULTI_THREADED,
    AUTO_SOLVE_DEP_ISSUES,
    DISABLE_MT_ON_STARTUP_COMPLETE;

    private static final Log LOG;
    public static final String MULTI_THREADED_PARAM_NAME = "org.exoplatform.container.mt.enabled";
    public static final String AUTO_SOLVE_DEP_ISSUES_PARAM_NAME = "org.exoplatform.container.as.enabled";
    public static final String DISABLE_MT_ON_STARTUP_COMPLETE_PARAM_NAME = "org.exoplatform.container.dmtosc.enabled";
    private static volatile Set<Mode> MODES;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setModes(Mode ... modes) {
        Set<Object> sModes = modes == null || modes.length == 0 ? Collections.emptySet() : new HashSet<Mode>(Arrays.asList(modes));
        Class<Mode> clazz = Mode.class;
        synchronized (Mode.class) {
            MODES = Collections.unmodifiableSet(sModes);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearModes() {
        Class<Mode> clazz = Mode.class;
        synchronized (Mode.class) {
            MODES = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static boolean hasMode(Mode mode) {
        return Mode.getModes().contains((Object)mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean removeModes(Mode ... modes) {
        if (modes == null || modes.length == 0) {
            return false;
        }
        Class<Mode> clazz = Mode.class;
        synchronized (Mode.class) {
            HashSet<Mode> modesSet = new HashSet<Mode>(Mode.getModes());
            for (Mode m : modes) {
                if (modesSet.remove((Object)m)) continue;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            MODES = Collections.unmodifiableSet(modesSet);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<Mode> getModes() {
        Set<Mode> modes = MODES;
        if (modes != null) return modes;
        Class<Mode> clazz = Mode.class;
        synchronized (Mode.class) {
            modes = MODES;
            if (modes != null) return modes;
            HashSet<Mode> sModes = new HashSet<Mode>();
            String sValue = PropertyManager.getProperty((String)MULTI_THREADED_PARAM_NAME);
            if ((sValue == null || Boolean.valueOf(sValue).booleanValue()) && Runtime.getRuntime().availableProcessors() > 1) {
                sModes.add(MULTI_THREADED);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The 'multi-threaded' mode of the kernel has been enabled");
                }
                if ((sValue = PropertyManager.getProperty((String)DISABLE_MT_ON_STARTUP_COMPLETE_PARAM_NAME)) == null || Boolean.valueOf(sValue).booleanValue()) {
                    sModes.add(DISABLE_MT_ON_STARTUP_COMPLETE);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"The 'multi-threaded' mode of the kernel will be disabled once fully started");
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The 'multi-threaded' mode of the kernel won't be disabled once fully started");
                }
            } else if (LOG.isDebugEnabled()) {
                if (Runtime.getRuntime().availableProcessors() == 1) {
                    LOG.debug((Object)"The 'multi-threaded' mode of the kernel is disabled since you must have more than one processor");
                } else {
                    LOG.debug((Object)"The 'multi-threaded' mode of the kernel is disabled");
                }
            }
            if ((sValue = PropertyManager.getProperty((String)AUTO_SOLVE_DEP_ISSUES_PARAM_NAME)) == null || Boolean.valueOf(sValue).booleanValue()) {
                sModes.add(AUTO_SOLVE_DEP_ISSUES);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The 'auto solve dependency issues' mode of the kernel has been enabled");
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The 'auto solve dependency issues' mode of the kernel is disabled");
            }
            MODES = modes = Collections.unmodifiableSet(sModes);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return modes;
        }
    }

    static {
        LOG = ExoLogger.getLogger((String)"exo.kernel.container.mt.Mode");
    }
}

