/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collections;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.container.configuration.Namespaces;
import org.exoplatform.container.configuration.NoKernelNamespaceSAXFilter;
import org.exoplatform.container.configuration.ProfileDOMFilter;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUnmarshaller {
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.container.ConfigurationUnmarshaller");
    private static final String[] KERNEL_NAMESPACES = Namespaces.getKernelNamespaces();
    private final Set<String> profiles;

    public ConfigurationUnmarshaller(Set<String> profiles) {
        this.profiles = profiles;
    }

    public ConfigurationUnmarshaller() {
        this.profiles = Collections.emptySet();
    }

    public boolean isValid(URL url) throws NullPointerException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", KERNEL_NAMESPACES);
        factory.setNamespaceAware(true);
        factory.setValidating(true);
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Reporter reporter = new Reporter(url);
            builder.setErrorHandler(reporter);
            builder.setEntityResolver(Namespaces.resolver);
            builder.parse(url.openStream());
            return reporter.valid;
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Got a parser configuration exception when doing XSD validation");
            return false;
        }
        catch (SAXException e) {
            log.error((Object)"Got a sax exception when doing XSD validation");
            return false;
        }
    }

    public Configuration unmarshall(URL url) throws Exception {
        boolean valid;
        if (PropertyManager.isDevelopping() && !(valid = this.isValid(url))) {
            log.info((Object)("The configuration file " + url + " was not found valid according to its XSD"));
        }
        DocumentBuilderFactory factory = null;
        try {
            Method dbfniMethod = DocumentBuilderFactory.class.getMethod("newInstance", String.class, ClassLoader.class);
            factory = (DocumentBuilderFactory)dbfniMethod.invoke(null, "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl", Thread.currentThread().getContextClassLoader());
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof FactoryConfigurationError) {
                log.debug((Object)"Was not able to find document builder factory class in Java > 5, will use default", cause);
            }
            throw e;
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (factory == null) {
            factory = DocumentBuilderFactory.newInstance();
        }
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(url.openStream());
        ProfileDOMFilter filter = new ProfileDOMFilter(this.profiles);
        filter.process(doc.getDocumentElement());
        StringWriter buffer = new StringWriter();
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler hd = tf.newTransformerHandler();
        StreamResult result = new StreamResult(buffer);
        hd.setResult(result);
        Transformer serializer = tf.newTransformer();
        serializer.setOutputProperty("encoding", "UTF8");
        serializer.setOutputProperty("indent", "yes");
        SAXResult saxResult = new SAXResult(new NoKernelNamespaceSAXFilter(hd));
        serializer.transform(new DOMSource(doc), saxResult);
        String document = buffer.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("About to parse configuration file " + document));
        }
        IBindingFactory bfact = BindingDirectory.getFactory(Configuration.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        return (Configuration)uctx.unmarshalDocument((Reader)new StringReader(document), null);
    }

    private class Reporter
    implements ErrorHandler {
        private final URL url;
        private boolean valid;

        private Reporter(URL url) {
            this.url = url;
            this.valid = true;
        }

        public void warning(SAXParseException exception) throws SAXException {
            log.warn((Object)exception.getMessage(), (Throwable)exception);
        }

        public void error(SAXParseException exception) throws SAXException {
            if (exception.getMessage().equals("cvc-elt.1: Cannot find the declaration of element 'configuration'.")) {
                log.info((Object)("The document " + this.url + " does not contain a schema declaration, it should have an " + "XML declaration similar to\n" + "<configuration\n" + "   xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n" + "   xsi:schemaLocation=\"http://www.exoplaform.org/xml/ns/kernel_1_1.xsd http://www.exoplaform.org/xml/ns/kernel_1_1.xsd\"\n" + "   xmlns=\"http://www.exoplaform.org/xml/ns/kernel_1_1.xsd\">"));
            } else {
                log.error((Object)("In document " + this.url + "  at (" + exception.getLineNumber() + "," + exception.getColumnNumber() + ") :" + exception.getMessage()));
            }
            this.valid = false;
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            log.fatal((Object)("In document " + this.url + "  at (" + exception.getLineNumber() + "," + exception.getColumnNumber() + ") :" + exception.getMessage()));
            this.valid = false;
        }
    }
}

