/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.commons.utils.Tools;
import org.exoplatform.container.ContainerBuilder;
import org.exoplatform.container.PropertyConfigurator;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationManagerImpl;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestPropertyManagerConfigurator
extends TestCase {
    private Map<String, String> previous;

    private Map<String, String> reset() {
        Map current = Tools.asMap((Properties)System.getProperties());
        HashMap<String, String> additions = new HashMap<String, String>();
        if (this.previous != null) {
            for (Map.Entry entry : current.entrySet()) {
                String propertyName = (String)entry.getKey();
                String propertyValue = (String)entry.getValue();
                if (this.previous.containsKey(propertyName)) continue;
                additions.put(propertyName, propertyValue);
            }
            System.setProperties(Tools.asProperties(this.previous));
        }
        this.previous = current;
        return additions;
    }

    protected void tearDown() throws Exception {
        PropertyManager.refresh();
    }

    public void testFromXML() throws Exception {
        this.reset();
        URL propertiesURL = TestPropertyManagerConfigurator.class.getResource("property-configurator.xml");
        TestPropertyManagerConfigurator.assertNotNull((Object)propertiesURL);
        System.setProperty("exo.properties.url", propertiesURL.toString());
        System.setProperty("property_2", "property_value_2");
        PropertiesParam propertiesParam = new PropertiesParam();
        InitParams params = new InitParams();
        params.put((Object)"properties", (Object)propertiesParam);
        new PropertyConfigurator(params, (ConfigurationManager)new ConfigurationManagerImpl(new HashSet()));
        Map<String, String> additions = this.reset();
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1", (String)additions.get("property_1"));
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_2", (String)additions.get("property_2"));
        TestPropertyManagerConfigurator.assertEquals((String)"${property_3}", (String)additions.get("property_3"));
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1-property_value_2", (String)additions.get("property_4"));
    }

    public void testSimple() {
        this.reset();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setProperty("property_1", "property_value_1");
        InitParams params = new InitParams();
        params.put((Object)"properties", (Object)propertiesParam);
        new PropertyConfigurator(params, (ConfigurationManager)new ConfigurationManagerImpl(new HashSet()));
        Map<String, String> additions = this.reset();
        TestPropertyManagerConfigurator.assertEquals(Collections.singletonMap("property_1", "property_value_1"), additions);
    }

    public void testFromConfig() throws Exception {
        this.reset();
        System.setProperty("property_2", "property_value_2");
        URL url = TestPropertyManagerConfigurator.class.getResource("property-configurator-configuration.xml");
        TestPropertyManagerConfigurator.assertNotNull((Object)url);
        ContainerBuilder.bootstrap(url, new String[0]);
        Map<String, String> additions = this.reset();
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1", (String)additions.get("property_1"));
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_2", (String)additions.get("property_2"));
        TestPropertyManagerConfigurator.assertEquals((String)"${property_3}", (String)additions.get("property_3"));
    }

    public void testFromConfigWithProfile() throws Exception {
        this.reset();
        URL url = TestPropertyManagerConfigurator.class.getResource("property-configurator-with-profile-configuration.xml");
        TestPropertyManagerConfigurator.assertNotNull((Object)url);
        ContainerBuilder.bootstrap(url, "foo");
        Map<String, String> additions = this.reset();
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1_foo", (String)additions.get("property_1"));
    }

    public void testFromConfigByParam() throws Exception {
        this.reset();
        URL propertiesURL = TestPropertyManagerConfigurator.class.getResource("property-configurator.properties");
        TestPropertyManagerConfigurator.assertNotNull((Object)propertiesURL);
        System.setProperty("properties.url", propertiesURL.toString());
        System.setProperty("property_2", "property_value_2");
        URL url = TestPropertyManagerConfigurator.class.getResource("property-configurator-with-path-configuration.xml");
        ContainerBuilder.bootstrap(url, new String[0]);
        Map<String, String> additions = this.reset();
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1", (String)additions.get("property_1"));
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_2", (String)additions.get("property_2"));
        TestPropertyManagerConfigurator.assertEquals((String)"${property_3}", (String)additions.get("property_3"));
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1-property_value_2", (String)additions.get("property_4"));
    }

    public void testFromPropertiesByParam() throws Exception {
        this.reset();
        URL propertiesURL = TestPropertyManagerConfigurator.class.getResource("property-configurator.properties");
        TestPropertyManagerConfigurator.assertNotNull((Object)propertiesURL);
        System.setProperty("property_2", "property_value_2");
        ValueParam propertiesPathParam = new ValueParam();
        propertiesPathParam.setName("properties.url");
        propertiesPathParam.setValue(propertiesURL.toString());
        InitParams params = new InitParams();
        params.put((Object)"properties.url", (Object)propertiesPathParam);
        new PropertyConfigurator(params, (ConfigurationManager)new ConfigurationManagerImpl(new HashSet()));
        Map<String, String> additions = this.reset();
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1", (String)additions.get("property_1"));
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_2", (String)additions.get("property_2"));
        TestPropertyManagerConfigurator.assertEquals((String)"${property_3}", (String)additions.get("property_3"));
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1-property_value_2", (String)additions.get("property_4"));
    }

    public void testFromProperties() throws Exception {
        this.reset();
        URL propertiesURL = TestPropertyManagerConfigurator.class.getResource("property-configurator.properties");
        TestPropertyManagerConfigurator.assertNotNull((Object)propertiesURL);
        System.setProperty("exo.properties.url", propertiesURL.toString());
        System.setProperty("property_2", "property_value_2");
        PropertiesParam propertiesParam = new PropertiesParam();
        InitParams params = new InitParams();
        params.put((Object)"properties", (Object)propertiesParam);
        new PropertyConfigurator(params, (ConfigurationManager)new ConfigurationManagerImpl(new HashSet()));
        Map<String, String> additions = this.reset();
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1", (String)additions.get("property_1"));
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_2", (String)additions.get("property_2"));
        TestPropertyManagerConfigurator.assertEquals((String)"${property_3}", (String)additions.get("property_3"));
        TestPropertyManagerConfigurator.assertEquals((String)"property_value_1-property_value_2", (String)additions.get("property_4"));
    }
}

