/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.jmx.AbstractTestContainer;
import org.exoplatform.container.management.ManageableComponentAdapter;
import org.exoplatform.container.multitenancy.bridge.DummyTenantsContainerContext;
import org.exoplatform.container.spi.ComponentAdapter;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestTenantsContainer
extends AbstractTestContainer {
    protected Object getLastRegisteredKey(ExoContainer container) {
        return ((DummyTenantsContainerContext)container.tenantsContainerContext).lastRegisteredKey;
    }

    protected Object getLastUnregisteredKey(ExoContainer container) {
        return ((DummyTenantsContainerContext)container.tenantsContainerContext).lastUnregisteredKey;
    }

    protected Object getLastGetKey(ExoContainer container) {
        return ((DummyTenantsContainerContext)container.tenantsContainerContext).lastGetKey;
    }

    protected Object getLastGetListKey(ExoContainer container) {
        return ((DummyTenantsContainerContext)container.tenantsContainerContext).lastGetListKey;
    }

    protected List<Class<?>> getRegisteredTypes(ExoContainer container, Class<?> type) {
        return ((DummyTenantsContainerContext)container.tenantsContainerContext).getRegisteredTypes(type);
    }

    public void testTenantContextConfigured() {
        RootContainer root = this.createRootContainer("test-tenants-container.xml");
        TestTenantsContainer.assertNotNull((Object)root.tenantsContainerContext);
    }

    public void testTenantContextNotConfigured() {
        RootContainer root = this.createRootContainer("empty-config.xml");
        TestTenantsContainer.assertNull((Object)root.tenantsContainerContext);
    }

    public void testRegisterComponent() {
        RootContainer root = this.createRootContainer("test-tenants-container.xml");
        ManageableComponentAdapter adapter = new ManageableComponentAdapter((ExoContainer)root, null, C1.class, C1.class);
        root.registerComponentImplementation(C1.class, C1.class);
        TestTenantsContainer.assertEquals(C1.class, (Object)this.getLastRegisteredKey((ExoContainer)root));
    }

    public void testNotRegisterComponentInstance() {
        RootContainer root = this.createRootContainer("test-tenants-container.xml");
        ComponentAdapter adapter = root.registerComponentInstance((Object)new C2());
        TestTenantsContainer.assertNotNull((Object)adapter);
        TestTenantsContainer.assertNull((Object)this.getLastRegisteredKey((ExoContainer)root));
        TestTenantsContainer.assertNotNull((Object)root.getComponentInstanceOfType(C2.class));
    }

    public void testGetComponents() {
        RootContainer root = this.createRootContainer("test-tenants-container.xml");
        root.registerComponentImplementation(C1.class, C1.class);
        TestTenantsContainer.assertEquals(C1.class, (Object)this.getLastRegisteredKey((ExoContainer)root));
        root.registerComponentImplementation(C2.class, C2.class);
        TestTenantsContainer.assertEquals(C2.class, (Object)this.getLastRegisteredKey((ExoContainer)root));
        try {
            root.getComponentAdaptersOfType(Startable.class);
        }
        catch (Throwable e) {
            e.printStackTrace();
            TestTenantsContainer.fail((String)e.getMessage());
        }
        TestTenantsContainer.assertEquals(Startable.class, (Object)this.getLastGetListKey((ExoContainer)root));
        List<Class<?>> startable = this.getRegisteredTypes((ExoContainer)root, Startable.class);
        TestTenantsContainer.assertEquals((int)2, (int)startable.size());
        TestTenantsContainer.assertTrue((boolean)startable.contains(C1.class));
        TestTenantsContainer.assertTrue((boolean)startable.contains(C2.class));
    }

    public static class C2
    implements Startable {
        public boolean started;

        public void start() {
            this.started = true;
        }

        public void stop() {
        }
    }

    public static class C1
    implements Startable {
        public boolean started;

        public void start() {
            this.started = true;
        }

        public void stop() {
        }
    }
}

