/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.multitenancy.bridge;

import java.security.PrivilegedAction;
import junit.framework.TestCase;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.multitenancy.CurrentTenantNotSetException;
import org.exoplatform.container.multitenancy.Tenant;
import org.exoplatform.container.multitenancy.bridge.CurrentTenantLookup;
import org.exoplatform.container.multitenancy.bridge.TenantsServiceImpl;

public class TestTenantsServiceImpl
extends TestCase {
    protected ExoContainer parent;
    protected TenantsServiceImpl tenants;

    protected void setUp() throws Exception {
        super.setUp();
        final RootContainer root = new RootContainer();
        SecurityHelper.doPrivilegedAction((PrivilegedAction)new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                RootContainer singleton = RootContainer.getInstance();
                root.registerComponentInstance(ConfigurationManager.class, singleton.getComponentInstance(ConfigurationManager.class));
                root.start(true);
                return null;
            }
        });
        this.parent = root.getPortalContainer(PortalContainer.DEFAULT_PORTAL_CONTAINER_NAME);
        this.tenants = (TenantsServiceImpl)this.parent.getComponentInstanceOfType(TenantsServiceImpl.class);
    }

    public void testHasNoPluginsByDefault() {
        TestTenantsServiceImpl.assertTrue((this.tenants.lookups.size() == 0 ? 1 : 0) != 0);
        TestTenantsServiceImpl.assertTrue((this.tenants.observers.size() == 0 ? 1 : 0) != 0);
    }

    public void testAddSupportedPlugin() {
        SupportedPlugin plugin = new SupportedPlugin();
        this.tenants.addPlugin((ComponentPlugin)plugin);
        TestTenantsServiceImpl.assertTrue((boolean)this.tenants.lookups.contains((Object)plugin));
    }

    public void testAddNotSupportedPlugin() {
        NotSupportedPlugin plugin = new NotSupportedPlugin();
        this.tenants.addPlugin((ComponentPlugin)plugin);
        TestTenantsServiceImpl.assertFalse((boolean)this.tenants.lookups.contains((Object)plugin));
    }

    public void testGetCurrentTanant() {
        try {
            this.tenants.getCurrentTenant();
            TestTenantsServiceImpl.fail((String)"Current Tenant should not be set by default (without eXo Cloud environment)");
        }
        catch (CurrentTenantNotSetException currentTenantNotSetException) {
            // empty catch block
        }
    }

    public void testHasCurrentTanant() {
        TestTenantsServiceImpl.assertFalse((boolean)this.tenants.hasCurrentTenant());
    }

    public static class NotSupportedPlugin
    extends BaseComponentPlugin {
    }

    public static class SupportedPlugin
    extends BaseComponentPlugin
    implements CurrentTenantLookup {
        public Tenant getCurrentTenant() throws CurrentTenantNotSetException {
            throw new CurrentTenantNotSetException("not supported");
        }

        public boolean hasCurrentTenant() {
            return false;
        }
    }
}

