/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.ar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

class ArchiveURLConnection
extends URLConnection {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.kernel.container.ArchiveURLConnection");
    private File directAccess;
    private ZipFile zipFile;
    private List<String> nameEntries;

    ArchiveURLConnection(URL url) {
        super(url);
    }

    public void connect() throws IOException {
        this.connected = true;
        String file = this.url.getFile();
        int index = file.indexOf("!/");
        if (index == -1) {
            this.directAccess = new File(file);
            if (!this.directAccess.exists()) {
                throw new FileNotFoundException("Cannot find the file at " + file);
            }
            if (this.directAccess.isDirectory()) {
                throw new IOException("A file was expected at " + file);
            }
            return;
        }
        File f = new File(file.substring(0, index));
        if (!f.exists()) {
            throw new FileNotFoundException("Cannot find the file at " + f.getAbsolutePath());
        }
        if (f.isDirectory()) {
            throw new IOException("A zip file was expected at " + f.getAbsolutePath());
        }
        this.zipFile = new ZipFile(f);
        try {
            int fromIndex = index + 2;
            index = file.indexOf("!/", fromIndex);
            String nameEntry = index == -1 ? file.substring(fromIndex) : file.substring(fromIndex, index);
            ZipEntry entry = this.zipFile.getEntry(nameEntry);
            if (entry == null) {
                throw new FileNotFoundException("Cannot find the file at " + file.substring(0, index == -1 ? file.length() : index));
            }
            if (this.zipFile.getEntry(nameEntry + "/") != null) {
                throw new IOException("A " + (index == -1 ? "" : "zip") + " file was expected at " + file.substring(0, index == -1 ? file.length() : index));
            }
            this.nameEntries = new ArrayList<String>();
            this.nameEntries.add(nameEntry);
            if (index == -1) {
                return;
            }
            nameEntry = file.substring(index + 2);
            this.nameEntries.add(nameEntry);
        }
        catch (IOException e) {
            try {
                this.zipFile.close();
            }
            catch (IOException e2) {
                LOG.debug((Object)"Could not close the zip file");
            }
            throw e;
        }
        catch (RuntimeException e) {
            try {
                this.zipFile.close();
            }
            catch (IOException e2) {
                LOG.debug((Object)"Could not close the zip file");
            }
            throw e;
        }
    }

    public int getContentLength() {
        if (this.connected) {
            ZipEntry entry;
            if (this.directAccess != null) {
                return (int)this.directAccess.length();
            }
            if (this.zipFile != null && this.nameEntries != null && this.nameEntries.size() == 1 && (entry = this.zipFile.getEntry(this.nameEntries.get(0))) != null) {
                return (int)entry.getSize();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream() throws IOException {
        ArchiveInputStream archiveInputStream;
        block24: {
            if (!this.connected) {
                this.connect();
            }
            if (this.directAccess != null) {
                return new FileInputStream(this.directAccess);
            }
            if (this.zipFile == null) {
                throw new IOException("no zip file defined");
            }
            if (this.nameEntries == null || this.nameEntries.isEmpty()) {
                throw new IOException("no entry name specified");
            }
            ZipEntry entry = this.zipFile.getEntry(this.nameEntries.get(0));
            if (entry == null) {
                throw new FileNotFoundException("The entry " + this.nameEntries.get(0) + " could not be found");
            }
            if (this.nameEntries.size() == 1) {
                return new ArchiveInputStream(this.zipFile.getInputStream(entry));
            }
            String nameEntry = this.nameEntries.get(1);
            ZipInputStream zis = new ZipInputStream(this.zipFile.getInputStream(entry));
            boolean closeZis = true;
            try {
                ZipEntry subZP;
                ZipEntry found = null;
                while ((subZP = zis.getNextEntry()) != null) {
                    if (!subZP.getName().equals(nameEntry) && !subZP.getName().equals(nameEntry + "/")) continue;
                    found = subZP;
                    break;
                }
                if (found == null) {
                    throw new FileNotFoundException("Cannot find the file at " + this.url.getFile());
                }
                if (found.isDirectory()) {
                    throw new IOException("A file was expected at " + this.url.getFile());
                }
                closeZis = false;
                archiveInputStream = new ArchiveInputStream(zis);
                if (!closeZis) break block24;
            }
            catch (Throwable throwable) {
                try {
                    if (closeZis) {
                        try {
                            zis.close();
                        }
                        catch (IOException e) {
                            LOG.debug((Object)"Could not close the zip input stream");
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    try {
                        this.zipFile.close();
                    }
                    catch (IOException e2) {
                        LOG.debug((Object)"Could not close the zip file");
                    }
                    throw e;
                }
                catch (RuntimeException e) {
                    try {
                        this.zipFile.close();
                    }
                    catch (IOException e2) {
                        LOG.debug((Object)"Could not close the zip file");
                    }
                    throw e;
                }
            }
            try {
                zis.close();
            }
            catch (IOException e) {
                LOG.debug((Object)"Could not close the zip input stream");
            }
        }
        return archiveInputStream;
    }

    private class ArchiveInputStream
    extends FilterInputStream {
        protected ArchiveInputStream(InputStream in) {
            super(in);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            try {
                super.close();
            }
            finally {
                try {
                    ArchiveURLConnection.this.zipFile.close();
                }
                catch (IOException e2) {
                    LOG.debug((Object)"Could not close the zip file");
                }
            }
        }
    }
}

