/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import org.exoplatform.container.component.ThreadContext;
import org.exoplatform.container.component.ThreadContextHolder;
import org.exoplatform.container.context.AdvancedContext;
import org.exoplatform.container.context.CreationContext;
import org.exoplatform.container.context.CreationContextStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContext<K>
implements AdvancedContext<K>,
ThreadContextHolder {
    private final ThreadLocal<ThreadLocalData> data = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        void var5_11;
        ThreadLocalData tld = this.data.get();
        if (tld == null) {
            throw new ContextNotActiveException();
        }
        String id = this.getId(contextual);
        T t = this.getFromCache(tld, id);
        if (t != null) {
            return t;
        }
        CreationContextStorage storage = this.getStorage();
        T t2 = this.getInstance(storage, id);
        if (t2 != null) return var5_11;
        if (creationalContext == null) {
            return null;
        }
        if (this.isSharable()) {
            Lock lock = this.getLock(id);
            try {
                lock.lock();
                T t3 = this.getInstance(storage, id);
                if (t3 != null) return var5_11;
                Object object = storage.setInstance(id, new CreationContext<Object>(contextual, creationalContext, contextual.create(creationalContext)));
                this.putInCache(tld, id, object);
                return var5_11;
            }
            finally {
                lock.unlock();
            }
        } else {
            Object object = storage.setInstance(id, new CreationContext<Object>(contextual, creationalContext, contextual.create(creationalContext)));
            this.putInCache(tld, id, object);
        }
        return var5_11;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    @Override
    public void destroy(Contextual contextual) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        String id = this.getId(contextual);
        CreationContextStorage storage = this.getStorage();
        CreationContext creationContext = storage.getCreationContext(id);
        if (creationContext != null) {
            if (creationContext.getInstance() != null && creationContext.getCreationalContext() != null) {
                contextual.destroy(creationContext.getInstance(), creationContext.getCreationalContext());
            }
            storage.removeInstance(id);
        }
    }

    public boolean isActive() {
        return this.data.get() != null;
    }

    @Override
    public void activate(K key) {
        this.setStorage(this.createStorage(key));
    }

    @Override
    public void deactivate(K key) {
        this.setStorage(null);
    }

    @Override
    public void register(K key) {
    }

    @Override
    public void unregister(K key) {
        this.destroy(this.createStorage(key));
    }

    protected <T> String getId(Contextual<T> contextual) {
        if (contextual instanceof PassivationCapable) {
            return ((PassivationCapable)contextual).getId();
        }
        throw new UnsupportedOperationException("Only contextuals that implement the PassivationCapable interface are supported");
    }

    protected abstract boolean isSharable();

    protected abstract Lock getLock(String var1);

    protected abstract CreationContextStorage createStorage(K var1);

    protected CreationContextStorage getStorage() {
        ThreadLocalData tld = this.data.get();
        return tld == null ? null : tld.storage;
    }

    protected void setStorage(CreationContextStorage storage) {
        if (storage == null) {
            this.data.remove();
        } else {
            this.data.set(new ThreadLocalData(storage));
        }
    }

    protected void destroy() {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        CreationContextStorage storage = this.getStorage();
        this.destroy(storage);
    }

    protected void destroy(CreationContextStorage storage) {
        Set<String> ids = storage.getAllIds();
        if (ids != null) {
            for (String id : ids) {
                CreationContext creationContext = storage.getCreationContext(id);
                if (creationContext == null) continue;
                if (creationContext.getContextual() != null && creationContext.getInstance() != null && creationContext.getCreationalContext() != null) {
                    creationContext.getContextual().destroy(creationContext.getInstance(), creationContext.getCreationalContext());
                }
                storage.removeInstance(id);
            }
        }
    }

    protected <T> T getInstance(CreationContextStorage storage, String id) {
        CreationContext creationContext = storage.getCreationContext(id);
        return creationContext == null ? null : (T)creationContext.getInstance();
    }

    protected <T> T getFromCache(ThreadLocalData data, String id) {
        Map<String, Object> map = data.cache;
        return (T)(map == null ? null : map.get(id));
    }

    protected void putInCache(ThreadLocalData data, String id, Object o) {
        Map<String, Object> map = data.cache;
        if (map == null) {
            data.cache = map = new HashMap<String, Object>();
        }
        map.put(id, o);
    }

    @Override
    public ThreadContext getThreadContext() {
        return new ThreadContext(this.data);
    }

    protected static class ThreadLocalData {
        protected final CreationContextStorage storage;
        protected Map<String, Object> cache;

        private ThreadLocalData(CreationContextStorage storage) {
            this.storage = storage;
        }
    }
}

