/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.multitenancy.bridge;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.component.ThreadContext;
import org.exoplatform.container.component.ThreadContextHolder;
import org.exoplatform.container.multitenancy.CurrentTenantNotSetException;
import org.exoplatform.container.multitenancy.Tenant;
import org.exoplatform.container.multitenancy.TenantsService;
import org.exoplatform.container.multitenancy.TenantsStateListener;
import org.exoplatform.container.multitenancy.bridge.CurrentTenantLookup;
import org.exoplatform.container.multitenancy.bridge.TenantStateObserver;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TenantsServiceImpl
implements TenantsService,
ThreadContextHolder {
    protected static final Log LOG = ExoLogger.getLogger(TenantsServiceImpl.class);
    protected final List<CurrentTenantLookup> lookups = new ArrayList<CurrentTenantLookup>();
    protected final List<TenantStateObserver> observers = new ArrayList<TenantStateObserver>();

    public void addPlugin(ComponentPlugin plugin) {
        if (plugin instanceof CurrentTenantLookup) {
            this.lookups.add((CurrentTenantLookup)((Object)plugin));
            LOG.info((Object)("CurrentTenantLookup instance registered: " + plugin.toString()));
        } else if (plugin instanceof TenantStateObserver) {
            this.observers.add((TenantStateObserver)((Object)plugin));
            LOG.info((Object)("TenantStateObserver instance registered: " + plugin.toString()));
        } else {
            LOG.warn((Object)("Not supported component plugin: " + plugin.getName() + ", type " + plugin.getClass()));
        }
    }

    public void addListener(TenantsStateListener listener) {
        for (TenantStateObserver o : this.observers) {
            o.addListener(listener);
        }
    }

    public void removeListener(TenantsStateListener listener) {
        for (TenantStateObserver o : this.observers) {
            o.removeListener(listener);
        }
    }

    public Tenant getCurrentTenant() throws CurrentTenantNotSetException {
        for (CurrentTenantLookup l : this.lookups) {
            if (!l.hasCurrentTenant()) continue;
            return l.getCurrentTenant();
        }
        throw new CurrentTenantNotSetException("Current Tenant not set.");
    }

    public boolean hasCurrentTenant() {
        for (CurrentTenantLookup l : this.lookups) {
            if (!l.hasCurrentTenant()) continue;
            return true;
        }
        return false;
    }

    public ThreadContext getThreadContext() {
        ArrayList<ThreadContext> tcs = null;
        for (CurrentTenantLookup l : this.lookups) {
            ThreadContextHolder holder;
            ThreadContext tc;
            if (!(l instanceof ThreadContextHolder) || (tc = (holder = (ThreadContextHolder)((Object)l)).getThreadContext()) == null) continue;
            if (tcs == null) {
                tcs = new ArrayList<ThreadContext>();
            }
            tcs.add(tc);
        }
        return tcs == null ? null : ThreadContext.merge(tcs);
    }
}

