/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.kernel.it;

import java.util.Map;
import javax.transaction.TransactionManager;
import org.exoplatform.commons.Environment;
import org.exoplatform.container.RootContainer;
import org.exoplatform.kernel.demos.mc.InjectingBean;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.jboss.dependency.spi.Controller;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.junit.Assert;
import org.junit.Test;

public class MCInjectionTest {
    protected Log log = ExoLogger.getLogger((String)"exo.kernel.mc-int-tests.MCInjectionTest");
    protected String beanName = "InjectingBean";
    protected InjectingBean bean;
    protected boolean inJboss;
    protected boolean mcIntActive = true;

    protected void init() {
        this.log.info((Object)"init() method called");
        RootContainer rootContainer = RootContainer.getInstance();
        this.bean = (InjectingBean)rootContainer.getComponentInstance((Object)this.beanName);
        this.log.info((Object)("Retrieved " + this.beanName + ": " + this.bean));
        Assert.assertNotNull((String)(this.beanName + " not installed"), (Object)this.bean);
        this.inJboss = Environment.getInstance().getPlatform() == 3;
        this.log.info((Object)("Running inside JBoss? " + this.inJboss));
    }

    @Test
    public void test() {
        this.init();
        this.tests();
    }

    protected void tests() {
        this.testFieldInjection();
        this.testTypeMatchingMethodInjection();
        this.testNameLookupMethodInjection();
        this.testNameLookupMapInjection();
        this.testPropertyValueMethodInjection();
        this.testTransactionManager();
        this.testInstallMethod();
        this.testStarted();
    }

    protected void testTransactionManager() {
        TransactionManager tm = this.bean.getTransactionManager();
        if (this.inJboss && this.mcIntActive) {
            try {
                int status = tm.getStatus();
                this.log.info((Object)("Status before tx: " + tm.getStatus()));
                tm.begin();
                Assert.assertFalse((String)"TX status didn't change: ", (status == tm.getStatus() ? 1 : 0) != 0);
                this.log.info((Object)("Status in tx: " + tm.getStatus()));
                tm.commit();
                Assert.assertTrue((String)"TX status didn't return to original: ", (status == tm.getStatus() ? 1 : 0) != 0);
                this.log.info((Object)("Status after tx: " + tm.getStatus()));
            }
            catch (Exception ex) {
                throw new RuntimeException("Failed to use TransactionManager: ", ex);
            }
        } else {
            Assert.assertNull((String)"Injection should not have worked", (Object)tm);
        }
        this.log.info((Object)"testTransactionManager passed");
    }

    protected void testFieldInjection() {
        boolean found;
        boolean bl = found = this.bean.getInjectedBean() != null;
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Field injection not executed", (boolean)found);
        } else {
            Assert.assertFalse((String)"Field injection should not have worked", (boolean)found);
        }
        this.log.info((Object)"testFieldInjection passed");
    }

    protected void testTypeMatchingMethodInjection() {
        boolean found;
        boolean bl = found = this.bean.getBean() != null;
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Method injection by type matching not executed", (boolean)found);
        } else {
            Assert.assertFalse((String)"Method injection by type matching should not have worked", (boolean)found);
        }
        this.log.info((Object)"testTypeMatchingMethodInjection passed");
    }

    protected void testNameLookupMethodInjection() {
        boolean found;
        boolean bl = found = this.bean.getConfigurator() != null;
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Method injection by name lookup not executed", (boolean)found);
        } else {
            Assert.assertFalse((String)"Method injection by name lookup should not have worked", (boolean)found);
        }
        this.log.info((Object)"testNameLookupMethodInjection passed");
    }

    protected void testNameLookupMapInjection() {
        boolean found;
        Map bindings = this.bean.getBindings();
        boolean bl = found = bindings != null;
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Name lookup Map injection not executed", (boolean)found);
            Assert.assertEquals((String)"Bindings size", (long)bindings.size(), (long)6L);
            Assert.assertTrue((String)"Controller not bound", (boolean)(bindings.get(Controller.class) instanceof Controller));
            Assert.assertTrue((String)"Kernel not bound", (boolean)(bindings.get(Kernel.class) instanceof Kernel));
            Assert.assertTrue((String)"KernelController not bound", (boolean)(bindings.get(KernelController.class) instanceof KernelController));
            Assert.assertTrue((String)"KernelBus not bound", (boolean)(bindings.get(KernelBus.class) instanceof KernelBus));
            Assert.assertTrue((String)"KernelRegistry not bound", (boolean)(bindings.get(KernelRegistry.class) instanceof KernelRegistry));
            Assert.assertTrue((String)"KernelConfigurator not bound", (boolean)(bindings.get(KernelConfigurator.class) instanceof KernelConfigurator));
        } else {
            Assert.assertFalse((String)"Name lookup Map injection should not have worked", (boolean)found);
        }
        this.log.info((Object)"testNameLookupMapInjection passed");
    }

    protected void testPropertyValueMethodInjection() {
        boolean found;
        String propertyValue = this.bean.getSomeStringProperty();
        boolean bl = found = propertyValue != null;
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Property value method injection not executed", (boolean)found);
            Assert.assertEquals((String)"Invalid injected value", (Object)propertyValue, (Object)"[This is some property value]");
        } else {
            Assert.assertFalse((String)"Property value method injection should not have worked", (boolean)found);
        }
        this.log.info((Object)"testPropertyValueMethodInjection passed");
    }

    protected void testInstallMethod() {
        boolean installOk = this.bean.isInstallOk();
        if (this.inJboss && this.mcIntActive) {
            Assert.assertTrue((String)"Install method not executed as expected", (boolean)installOk);
        } else {
            Assert.assertFalse((String)"Install method should not have worked", (boolean)installOk);
        }
        this.log.info((Object)"testInstallMethod passed");
    }

    protected void testStarted() {
        Assert.assertEquals((String)"start() method not called exactly once", (long)1L, (long)this.bean.getStartCount());
        this.log.info((Object)"testStarted passed");
    }
}

