/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng;

import java.sql.SQLException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.firebirdsql.gds.VaxEncoding;
import org.firebirdsql.gds.ng.FbDatabase;
import org.firebirdsql.gds.ng.FbTransaction;
import org.firebirdsql.gds.ng.InfoProcessor;
import org.firebirdsql.gds.ng.TransactionState;
import org.firebirdsql.gds.ng.listeners.ExceptionListener;
import org.firebirdsql.gds.ng.listeners.ExceptionListenerDispatcher;
import org.firebirdsql.gds.ng.listeners.TransactionListener;
import org.firebirdsql.gds.ng.listeners.TransactionListenerDispatcher;

public abstract class AbstractFbTransaction
implements FbTransaction {
    private static final Set<TransactionState> ALLOWED_INITIAL_STATES = Collections.unmodifiableSet(EnumSet.of(TransactionState.ACTIVE, TransactionState.PREPARED));
    protected final ExceptionListenerDispatcher exceptionListenerDispatcher = new ExceptionListenerDispatcher(this);
    private final FbDatabase database;
    private final Object syncObject;
    protected final TransactionListenerDispatcher transactionListenerDispatcher = new TransactionListenerDispatcher();
    private volatile TransactionState state = TransactionState.ACTIVE;

    protected AbstractFbTransaction(TransactionState initialState, FbDatabase database) {
        if (!ALLOWED_INITIAL_STATES.contains((Object)initialState)) {
            throw new IllegalArgumentException(String.format("Illegal initial transaction state: %s, allowed states are: %s", new Object[]{initialState, ALLOWED_INITIAL_STATES}));
        }
        this.syncObject = database.getSynchronizationObject();
        this.state = initialState;
        this.database = database;
    }

    @Override
    public final TransactionState getState() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void switchState(TransactionState newState) throws SQLException {
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            TransactionState currentState = this.state;
            if (currentState == newState) {
                return;
            }
            if (!currentState.isValidTransition(newState)) {
                throw new SQLException(String.format("Unable to change transaction state: state %s is not valid after %s", new Object[]{newState, currentState}));
            }
            this.state = newState;
            this.transactionListenerDispatcher.transactionStateChanged(this, newState, currentState);
        }
    }

    @Override
    public final void addTransactionListener(TransactionListener listener) {
        this.transactionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void addWeakTransactionListener(TransactionListener listener) {
        this.transactionListenerDispatcher.addWeakListener(listener);
    }

    @Override
    public final void removeTransactionListener(TransactionListener listener) {
        this.transactionListenerDispatcher.removeListener(listener);
    }

    @Override
    public final void addExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.addListener(listener);
    }

    @Override
    public final void removeExceptionListener(ExceptionListener listener) {
        this.exceptionListenerDispatcher.removeListener(listener);
    }

    @Override
    public <T> T getTransactionInfo(byte[] requestItems, int bufferLength, InfoProcessor<T> infoProcessor) throws SQLException {
        byte[] responseBuffer = this.getTransactionInfo(requestItems, bufferLength);
        try {
            return infoProcessor.process(responseBuffer);
        }
        catch (SQLException e) {
            this.exceptionListenerDispatcher.errorOccurred(e);
            throw e;
        }
    }

    @Override
    public long getTransactionId() throws SQLException {
        return this.getTransactionInfo(new byte[]{4}, 16, new InfoProcessor<Long>(){

            @Override
            public Long process(byte[] infoResponse) throws SQLException {
                if (infoResponse[0] != 4) {
                    throw new SQLException("Unexpected response buffer");
                }
                int length = VaxEncoding.iscVaxInteger2(infoResponse, 1);
                return VaxEncoding.iscVaxLong(infoResponse, 3, length);
            }
        });
    }

    protected final Object getSynchronizationObject() {
        return this.syncObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            try {
                if (this.getState() == TransactionState.ACTIVE) {
                    this.rollback();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        finally {
            super.finalize();
        }
    }

    protected FbDatabase getDatabase() {
        return this.database;
    }
}

