/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.impl.GDSFactory;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.impl.GDSType;
import org.firebirdsql.gds.ng.DatatypeCoder;
import org.firebirdsql.gds.ng.DefaultDatatypeCoder;
import org.firebirdsql.gds.ng.fields.RowDescriptor;
import org.firebirdsql.gds.ng.fields.RowDescriptorBuilder;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.fields.RowValueBuilder;
import org.firebirdsql.jca.FBManagedConnectionFactory;
import org.firebirdsql.jdbc.AbstractGeneratedKeysQuery;
import org.firebirdsql.jdbc.FBConnection;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FBPreparedStatement;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBStatement;
import org.firebirdsql.jdbc.FirebirdDatabaseMetaData;
import org.firebirdsql.jdbc.FirebirdVersionMetaData;
import org.firebirdsql.jdbc.InternalTransactionCoordinator;
import org.firebirdsql.jdbc.escape.FBEscapedFunctionHelper;
import org.firebirdsql.jdbc.field.JdbcTypeConverter;
import org.firebirdsql.logging.Logger;
import org.firebirdsql.logging.LoggerFactory;
import org.firebirdsql.util.FirebirdSupportInfo;

public class FBDatabaseMetaData
implements FirebirdDatabaseMetaData {
    private static final Logger log = LoggerFactory.getLogger(FBDatabaseMetaData.class);
    private static final String SPACES_31 = "                               ";
    private static final String SPACES_15 = "               ";
    private static final int OBJECT_NAME_LENGTH_BEFORE_V4_0 = 31;
    private static final int OBJECT_NAME_LENGTH_V4_0 = 63;
    private static final int OBJECT_NAME_LENGTH = 63;
    private static final int DRIVER_MAJOR_VERSION = 3;
    private static final int DRIVER_MINOR_VERSION = 0;
    private static final String DRIVER_VERSION = "3.0";
    private static final int SUBTYPE_NUMERIC = 1;
    private static final int SUBTYPE_DECIMAL = 2;
    protected static final DatatypeCoder datatypeCoder = new DefaultDatatypeCoder(EncodingFactory.createInstance(StandardCharsets.UTF_8));
    private static final byte[] TRUE_BYTES = FBDatabaseMetaData.getBytes("T");
    private static final byte[] FALSE_BYTES = FBDatabaseMetaData.getBytes("F");
    private static final byte[] YES_BYTES = FBDatabaseMetaData.getBytes("YES");
    private static final byte[] NO_BYTES = FBDatabaseMetaData.getBytes("NO");
    private static final byte[] EMPTY_STRING_BYTES = FBDatabaseMetaData.getBytes("");
    private static final byte[] CASESENSITIVE = TRUE_BYTES;
    private static final byte[] CASEINSENSITIVE = FALSE_BYTES;
    private static final byte[] UNSIGNED = TRUE_BYTES;
    private static final byte[] SIGNED = FALSE_BYTES;
    private static final byte[] FIXEDSCALE = TRUE_BYTES;
    private static final byte[] VARIABLESCALE = FALSE_BYTES;
    private static final byte[] NOTAUTOINC = FALSE_BYTES;
    private static final byte[] INT_ZERO = FBDatabaseMetaData.createInt(0);
    private static final byte[] SHORT_ZERO = FBDatabaseMetaData.createShort(0);
    private static final byte[] SHORT_ONE = FBDatabaseMetaData.createShort(1);
    private static final byte[] RADIX_BINARY = FBDatabaseMetaData.createInt(2);
    private static final byte[] RADIX_TEN = FBDatabaseMetaData.createInt(10);
    private static final byte[] RADIX_TEN_SHORT = FBDatabaseMetaData.createShort(10);
    private static final byte[] RADIX_BINARY_SHORT = FBDatabaseMetaData.createShort(2);
    private static final byte[] TYPE_PRED_NONE = FBDatabaseMetaData.createShort(0);
    private static final byte[] TYPE_PRED_BASIC = FBDatabaseMetaData.createShort(2);
    private static final byte[] TYPE_SEARCHABLE = FBDatabaseMetaData.createShort(3);
    private static final byte[] TYPE_NULLABLE = FBDatabaseMetaData.createShort(1);
    private static final byte[] PROCEDURE_NO_RESULT = FBDatabaseMetaData.createShort(1);
    private static final byte[] PROCEDURE_RETURNS_RESULT = FBDatabaseMetaData.createShort(2);
    private static final byte[] PROCEDURE_NO_NULLS = FBDatabaseMetaData.createShort(0);
    private static final byte[] PROCEDURE_NULLABLE = FBDatabaseMetaData.createShort(1);
    private static final byte[] PROCEDURE_COLUMN_IN = FBDatabaseMetaData.createShort(1);
    private static final byte[] PROCEDURE_COLUMN_OUT = FBDatabaseMetaData.createShort(4);
    private static final byte[] FLOAT_PRECISION = FBDatabaseMetaData.createInt(7);
    private static final byte[] DOUBLE_PRECISION = FBDatabaseMetaData.createInt(15);
    private static final byte[] BIGINT_PRECISION = FBDatabaseMetaData.createInt(19);
    private static final byte[] INTEGER_PRECISION = FBDatabaseMetaData.createInt(10);
    private static final byte[] SMALLINT_PRECISION = FBDatabaseMetaData.createInt(5);
    private static final byte[] DATE_PRECISION = FBDatabaseMetaData.createInt(10);
    private static final byte[] TIME_PRECISION = FBDatabaseMetaData.createInt(8);
    private static final byte[] TIMESTAMP_PRECISION = FBDatabaseMetaData.createInt(19);
    private static final byte[] NUMERIC_PRECISION = FBDatabaseMetaData.createInt(18);
    private static final byte[] DECIMAL_PRECISION = FBDatabaseMetaData.createInt(18);
    private static final byte[] BOOLEAN_PRECISION = FBDatabaseMetaData.createInt(1);
    private static final byte[] COLUMN_NO_NULLS = FBDatabaseMetaData.createInt(0);
    private static final byte[] COLUMN_NULLABLE = FBDatabaseMetaData.createInt(1);
    private static final byte[] IMPORTED_KEY_NO_ACTION = FBDatabaseMetaData.createShort(3);
    private static final byte[] IMPORTED_KEY_CASCADE = FBDatabaseMetaData.createShort(0);
    private static final byte[] IMPORTED_KEY_SET_NULL = FBDatabaseMetaData.createShort(2);
    private static final byte[] IMPORTED_KEY_SET_DEFAULT = FBDatabaseMetaData.createShort(4);
    private static final byte[] IMPORTED_KEY_NOT_DEFERRABLE = FBDatabaseMetaData.createShort(7);
    private static final byte[] TABLE_INDEX_OTHER = FBDatabaseMetaData.createShort(3);
    private static final byte[] ASC_BYTES = FBDatabaseMetaData.getBytes("A");
    private static final byte[] DESC_BYTES = FBDatabaseMetaData.getBytes("D");
    private GDSHelper gdsHelper;
    private FBConnection connection;
    private final FirebirdSupportInfo firebirdSupportInfo;
    protected final Map<String, FBPreparedStatement> statements = new HashMap<String, FBPreparedStatement>();
    private final FirebirdVersionMetaData versionMetaData;
    private static final String GET_PROCEDURES_START = "select cast(RDB$PROCEDURE_NAME as varchar(63)) as PROCEDURE_NAME,RDB$DESCRIPTION as REMARKS,RDB$PROCEDURE_OUTPUTS as PROCEDURE_TYPE from RDB$PROCEDURES where ";
    private static final String GET_PROCEDURES_END = "1 = 1 order by 1";
    private static final String GET_PROCEDURE_COLUMNS_START = "select cast(PP.RDB$PROCEDURE_NAME as varchar(63)) as PROCEDURE_NAME,cast(PP.RDB$PARAMETER_NAME as varchar(63)) as COLUMN_NAME,PP.RDB$PARAMETER_TYPE as COLUMN_TYPE,F.RDB$FIELD_TYPE as FIELD_TYPE,F.RDB$FIELD_SUB_TYPE as FIELD_SUB_TYPE,F.RDB$FIELD_PRECISION as FIELD_PRECISION,F.RDB$FIELD_SCALE as FIELD_SCALE,F.RDB$FIELD_LENGTH as FIELD_LENGTH,F.RDB$NULL_FLAG as NULL_FLAG,PP.RDB$DESCRIPTION as REMARKS,F.RDB$CHARACTER_LENGTH AS CHAR_LEN,PP.RDB$PARAMETER_NUMBER + 1 AS PARAMETER_NUMBER,F.RDB$CHARACTER_SET_ID from RDB$PROCEDURE_PARAMETERS PP,RDB$FIELDS F where ";
    private static final String GET_PROCEDURE_COLUMNS_END = " PP.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME order by PP.RDB$PROCEDURE_NAME,PP.RDB$PARAMETER_TYPE desc,PP.RDB$PARAMETER_NUMBER ";
    public static final String TABLE = "TABLE";
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String VIEW = "VIEW";
    public static final String GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    public static final String[] ALL_TYPES_2_5 = new String[]{"TABLE", "SYSTEM TABLE", "VIEW", "GLOBAL TEMPORARY"};
    public static final String[] ALL_TYPES_2_1 = new String[]{"TABLE", "SYSTEM TABLE", "VIEW"};
    public static final String[] ALL_TYPES = ALL_TYPES_2_5;
    private static final String GET_TABLE_ORDER_BY = " order by 4, 3";
    private static final String LEGACY_IS_TABLE = " rdb$relation_type is null and rdb$view_blr is null ";
    private static final String LEGACY_IS_VIEW = " rdb$relation_type is null and rdb$view_blr is not null ";
    private static final String TABLE_COLUMNS_2_5 = " select cast(null as varchar(63)) as TABLE_CAT,cast(null as varchar(63)) as TABLE_SCHEM,cast(RDB$RELATION_NAME as varchar(63)) as TABLE_NAME,cast(case  when rdb$relation_type = 0 or  rdb$relation_type is null and rdb$view_blr is null  then case when RDB$SYSTEM_FLAG = 1 then 'SYSTEM TABLE' else 'TABLE' end  when rdb$relation_type = 1 or  rdb$relation_type is null and rdb$view_blr is not null  then 'VIEW'  when rdb$relation_type = 2 then 'TABLE'  when rdb$relation_type = 3 then 'SYSTEM TABLE'  when rdb$relation_type in (4, 5) then 'GLOBAL TEMPORARY'end as varchar(31)) as TABLE_TYPE,RDB$DESCRIPTION as REMARKS,cast(null as varchar(63)) as TYPE_CAT,cast(null as varchar(63)) as TYPE_SCHEM,cast(null as varchar(31)) as TYPE_NAME,cast(null as varchar(63)) as SELF_REFERENCING_COL_NAME,cast(null as varchar(31)) as REF_GENERATION,cast(RDB$OWNER_NAME as varchar(63)) as OWNER_NAME from RDB$RELATIONS ";
    private static final String TABLE_COLUMNS_FORMAT_2_1 = " select cast(null as varchar(63)) as TABLE_CAT,cast(null as varchar(63)) as TABLE_SCHEM,cast(RDB$RELATION_NAME as varchar(63)) as TABLE_NAME,cast('%s' as varchar(31)) as TABLE_TYPE,RDB$DESCRIPTION as REMARKS,cast(null as varchar(63)) as TYPE_CAT,cast(null as varchar(63)) as TYPE_SCHEM,cast(null as varchar(31)) as TYPE_NAME,cast(null as varchar(63)) as SELF_REFERENCING_COL_NAME,cast(null as varchar(31)) as REF_GENERATION,cast(RDB$OWNER_NAME as varchar(63)) as OWNER_NAME from RDB$RELATIONS ";
    private static final String TABLE_COLUMNS_SYSTEM_2_1 = String.format(" select cast(null as varchar(63)) as TABLE_CAT,cast(null as varchar(63)) as TABLE_SCHEM,cast(RDB$RELATION_NAME as varchar(63)) as TABLE_NAME,cast('%s' as varchar(31)) as TABLE_TYPE,RDB$DESCRIPTION as REMARKS,cast(null as varchar(63)) as TYPE_CAT,cast(null as varchar(63)) as TYPE_SCHEM,cast(null as varchar(31)) as TYPE_NAME,cast(null as varchar(63)) as SELF_REFERENCING_COL_NAME,cast(null as varchar(31)) as REF_GENERATION,cast(RDB$OWNER_NAME as varchar(63)) as OWNER_NAME from RDB$RELATIONS ", "SYSTEM TABLE");
    private static final String TABLE_COLUMNS_NORMAL = String.format(" select cast(null as varchar(63)) as TABLE_CAT,cast(null as varchar(63)) as TABLE_SCHEM,cast(RDB$RELATION_NAME as varchar(63)) as TABLE_NAME,cast('%s' as varchar(31)) as TABLE_TYPE,RDB$DESCRIPTION as REMARKS,cast(null as varchar(63)) as TYPE_CAT,cast(null as varchar(63)) as TYPE_SCHEM,cast(null as varchar(31)) as TYPE_NAME,cast(null as varchar(63)) as SELF_REFERENCING_COL_NAME,cast(null as varchar(31)) as REF_GENERATION,cast(RDB$OWNER_NAME as varchar(63)) as OWNER_NAME from RDB$RELATIONS ", "TABLE");
    private static final String TABLE_COLUMNS_VIEW = String.format(" select cast(null as varchar(63)) as TABLE_CAT,cast(null as varchar(63)) as TABLE_SCHEM,cast(RDB$RELATION_NAME as varchar(63)) as TABLE_NAME,cast('%s' as varchar(31)) as TABLE_TYPE,RDB$DESCRIPTION as REMARKS,cast(null as varchar(63)) as TYPE_CAT,cast(null as varchar(63)) as TYPE_SCHEM,cast(null as varchar(31)) as TYPE_NAME,cast(null as varchar(63)) as SELF_REFERENCING_COL_NAME,cast(null as varchar(31)) as REF_GENERATION,cast(RDB$OWNER_NAME as varchar(63)) as OWNER_NAME from RDB$RELATIONS ", "VIEW");
    private static final String GET_TABLES_ALL_2_1 = TABLE_COLUMNS_SYSTEM_2_1 + " where ? = 'T' and RDB$SYSTEM_FLAG = 1 and rdb$view_blr is null" + " union" + TABLE_COLUMNS_NORMAL + " where ? = 'T' and RDB$SYSTEM_FLAG = 0 and rdb$view_blr is null" + " union" + TABLE_COLUMNS_VIEW + " where ? = 'T' and rdb$view_blr is not null " + " order by 4, 3";
    private static final String GET_TABLES_EXACT_2_1 = TABLE_COLUMNS_SYSTEM_2_1 + " where ? = 'T' and RDB$SYSTEM_FLAG = 1 and rdb$view_blr is null" + " and cast(RDB$RELATION_NAME as varchar(" + 73 + ")) = ? " + " union" + TABLE_COLUMNS_NORMAL + " where ? = 'T' and RDB$SYSTEM_FLAG = 0 and rdb$view_blr is null" + " and cast(RDB$RELATION_NAME as varchar(" + 73 + ")) = ? " + " union" + TABLE_COLUMNS_VIEW + " where ? = 'T' and rdb$view_blr is not null" + " and cast(RDB$RELATION_NAME as varchar(" + 73 + ")) = ? " + " order by 4, 3";
    private static final String GET_TABLES_LIKE_2_1 = TABLE_COLUMNS_SYSTEM_2_1 + " where ? = 'T' and RDB$SYSTEM_FLAG = 1 and rdb$view_blr is null" + " and RDB$RELATION_NAME || '" + "                               " + "' like ? escape '\\'" + " union" + TABLE_COLUMNS_NORMAL + " where ? = 'T' and RDB$SYSTEM_FLAG = 0 and rdb$view_blr is null" + " and RDB$RELATION_NAME || '" + "                               " + "' like ? escape '\\'" + " union" + TABLE_COLUMNS_VIEW + " where ? = 'T' and rdb$view_blr is not null" + " and RDB$RELATION_NAME || '" + "                               " + "' like ? escape '\\' " + " order by 4, 3";
    private static final String GET_COLUMNS_COMMON = "SELECT cast(RF.RDB$RELATION_NAME as varchar(63)) AS RELATION_NAME,cast(RF.RDB$FIELD_NAME as varchar(63)) AS FIELD_NAME,F.RDB$FIELD_TYPE AS FIELD_TYPE,F.RDB$FIELD_SUB_TYPE AS FIELD_SUB_TYPE,F.RDB$FIELD_PRECISION AS FIELD_PRECISION,F.RDB$FIELD_SCALE AS FIELD_SCALE,F.RDB$FIELD_LENGTH AS FIELD_LENGTH,F.RDB$CHARACTER_LENGTH AS CHAR_LEN,RF.RDB$DESCRIPTION AS REMARKS,RF.RDB$DEFAULT_SOURCE AS DEFAULT_SOURCE,F.RDB$DEFAULT_SOURCE AS DOMAIN_DEFAULT_SOURCE,RF.RDB$FIELD_POSITION + 1 AS FIELD_POSITION,RF.RDB$NULL_FLAG AS NULL_FLAG,F.RDB$NULL_FLAG AS SOURCE_NULL_FLAG,F.RDB$COMPUTED_BLR AS COMPUTED_BLR,F.RDB$CHARACTER_SET_ID,";
    private static final String GET_COLUMNS_3_0_START = "SELECT cast(RF.RDB$RELATION_NAME as varchar(63)) AS RELATION_NAME,cast(RF.RDB$FIELD_NAME as varchar(63)) AS FIELD_NAME,F.RDB$FIELD_TYPE AS FIELD_TYPE,F.RDB$FIELD_SUB_TYPE AS FIELD_SUB_TYPE,F.RDB$FIELD_PRECISION AS FIELD_PRECISION,F.RDB$FIELD_SCALE AS FIELD_SCALE,F.RDB$FIELD_LENGTH AS FIELD_LENGTH,F.RDB$CHARACTER_LENGTH AS CHAR_LEN,RF.RDB$DESCRIPTION AS REMARKS,RF.RDB$DEFAULT_SOURCE AS DEFAULT_SOURCE,F.RDB$DEFAULT_SOURCE AS DOMAIN_DEFAULT_SOURCE,RF.RDB$FIELD_POSITION + 1 AS FIELD_POSITION,RF.RDB$NULL_FLAG AS NULL_FLAG,F.RDB$NULL_FLAG AS SOURCE_NULL_FLAG,F.RDB$COMPUTED_BLR AS COMPUTED_BLR,F.RDB$CHARACTER_SET_ID,CASE WHEN RF.RDB$IDENTITY_TYPE IS NULL THEN CAST('NO' AS VARCHAR(3)) ELSE CAST('YES' AS VARCHAR(3)) END AS IS_IDENTITY,CASE RF.RDB$IDENTITY_TYPE WHEN 0 THEN CAST('ALWAYS' AS VARCHAR(10)) WHEN 1 THEN CAST('BY DEFAULT' AS VARCHAR(10)) ELSE NULL END AS JB_IDENTITY_TYPE FROM RDB$RELATION_FIELDS RF,RDB$FIELDS F WHERE ";
    private static final String GET_COLUMNS_START = "SELECT cast(RF.RDB$RELATION_NAME as varchar(63)) AS RELATION_NAME,cast(RF.RDB$FIELD_NAME as varchar(63)) AS FIELD_NAME,F.RDB$FIELD_TYPE AS FIELD_TYPE,F.RDB$FIELD_SUB_TYPE AS FIELD_SUB_TYPE,F.RDB$FIELD_PRECISION AS FIELD_PRECISION,F.RDB$FIELD_SCALE AS FIELD_SCALE,F.RDB$FIELD_LENGTH AS FIELD_LENGTH,F.RDB$CHARACTER_LENGTH AS CHAR_LEN,RF.RDB$DESCRIPTION AS REMARKS,RF.RDB$DEFAULT_SOURCE AS DEFAULT_SOURCE,F.RDB$DEFAULT_SOURCE AS DOMAIN_DEFAULT_SOURCE,RF.RDB$FIELD_POSITION + 1 AS FIELD_POSITION,RF.RDB$NULL_FLAG AS NULL_FLAG,F.RDB$NULL_FLAG AS SOURCE_NULL_FLAG,F.RDB$COMPUTED_BLR AS COMPUTED_BLR,F.RDB$CHARACTER_SET_ID,'NO' AS IS_IDENTITY,CAST(NULL AS VARCHAR(10)) AS JB_IDENTITY_TYPE FROM RDB$RELATION_FIELDS RF,RDB$FIELDS F WHERE ";
    public static final String GET_COLUMNS_END = " RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME order by RF.RDB$RELATION_NAME, RF.RDB$FIELD_POSITION";
    private static final int smallint_type = 7;
    private static final int integer_type = 8;
    private static final int quad_type = 9;
    private static final int float_type = 10;
    private static final int d_float_type = 11;
    private static final int date_type = 12;
    private static final int time_type = 13;
    private static final int char_type = 14;
    private static final int int64_type = 16;
    private static final int double_type = 27;
    private static final int timestamp_type = 35;
    private static final int varchar_type = 37;
    private static final int blob_type = 261;
    private static final short boolean_type = 23;
    private static final String GET_COLUMN_PRIVILEGES_START = "select cast(RF.RDB$RELATION_NAME as varchar(63)) as TABLE_NAME,cast(RF.RDB$FIELD_NAME as varchar(63)) as COLUMN_NAME,cast(UP.RDB$GRANTOR as varchar(63)) as GRANTOR,cast(UP.RDB$USER as varchar(63)) as GRANTEE,cast(UP.RDB$PRIVILEGE as varchar(6)) as PRIVILEGE,UP.RDB$GRANT_OPTION as IS_GRANTABLE from RDB$RELATION_FIELDS RF,RDB$FIELDS F,RDB$USER_PRIVILEGES UP where RF.RDB$RELATION_NAME = UP.RDB$RELATION_NAME and RF.RDB$FIELD_SOURCE = F.RDB$FIELD_NAME  and (UP.RDB$FIELD_NAME is null or UP.RDB$FIELD_NAME = RF.RDB$FIELD_NAME) and CAST(UP.RDB$RELATION_NAME AS VARCHAR(73)) = ? and ((";
    private static final String GET_COLUMN_PRIVILEGES_END = " UP.RDB$OBJECT_TYPE = 0) or (RF.RDB$FIELD_NAME is null and UP.RDB$OBJECT_TYPE = 0)) order by 2,5 ";
    private static final Map<String, byte[]> PRIVILEGE_MAPPING;
    private static final String GET_TABLE_PRIVILEGES_START = "select cast(RDB$RELATION_NAME as varchar(63)) as TABLE_NAME,cast(RDB$GRANTOR as varchar(63)) as GRANTOR,cast(RDB$USER as varchar(63)) as GRANTEE,cast(RDB$PRIVILEGE as varchar(6)) as PRIVILEGE,RDB$GRANT_OPTION as IS_GRANTABLE from RDB$USER_PRIVILEGES where ";
    private static final String GET_TABLE_PRIVILEGES_END = " RDB$OBJECT_TYPE = 0 and RDB$FIELD_NAME is null order by 1, 4";
    private static final String GET_BEST_ROW_IDENT = "SELECT CAST(rf.rdb$field_name AS varchar(63)) AS column_name,f.rdb$field_type AS field_type,f.rdb$field_sub_type AS field_sub_type,f.rdb$field_scale AS field_scale,f.rdb$field_precision AS field_precision,f.RDB$CHARACTER_SET_ID FROM rdb$relation_constraints rc INNER JOIN rdb$index_segments idx ON idx.rdb$index_name = rc.rdb$index_name INNER JOIN rdb$relation_fields rf ON rf.rdb$field_name = idx.rdb$field_name     AND rf.rdb$relation_name = rc.rdb$relation_name INNER JOIN rdb$fields f ON f.rdb$field_name = rf.rdb$field_source WHERE CAST(rc.rdb$relation_name AS VARCHAR(73)) = ? AND rc.rdb$constraint_type = 'PRIMARY KEY'";
    private static final String GET_PRIMARY_KEYS = "select cast(RC.RDB$RELATION_NAME as varchar(63)) as TABLE_NAME,cast(ISGMT.RDB$FIELD_NAME as varchar(63)) as COLUMN_NAME,CAST((ISGMT.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,cast(RC.RDB$CONSTRAINT_NAME as varchar(63)) as PK_NAME from RDB$RELATION_CONSTRAINTS RC INNER JOIN RDB$INDEX_SEGMENTS ISGMT ON RC.RDB$INDEX_NAME = ISGMT.RDB$INDEX_NAME where CAST(RC.RDB$RELATION_NAME AS VARCHAR(73)) = ? and RC.RDB$CONSTRAINT_TYPE = 'PRIMARY KEY' order by ISGMT.RDB$FIELD_NAME ";
    private static final String GET_IMPORTED_KEYS = "select cast(PK.RDB$RELATION_NAME as varchar(63)) as PKTABLE_NAME,cast(ISP.RDB$FIELD_NAME as varchar(63)) as PKCOLUMN_NAME,cast(FK.RDB$RELATION_NAME as varchar(63)) as FKTABLE_NAME,cast(ISF.RDB$FIELD_NAME as varchar(63)) as FKCOLUMN_NAME,CAST((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,cast(RC.RDB$UPDATE_RULE as varchar(11)) as UPDATE_RULE,cast(RC.RDB$DELETE_RULE as varchar(11)) as DELETE_RULE,cast(PK.RDB$CONSTRAINT_NAME as varchar(63)) as PK_NAME,cast(FK.RDB$CONSTRAINT_NAME as varchar(63)) as FK_NAME from RDB$RELATION_CONSTRAINTS PK,RDB$RELATION_CONSTRAINTS FK,RDB$REF_CONSTRAINTS RC,RDB$INDEX_SEGMENTS ISP,RDB$INDEX_SEGMENTS ISF WHERE CAST(FK.RDB$RELATION_NAME AS VARCHAR(73)) = ? and  FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION order by 1, 5 ";
    private static final Map<String, byte[]> ACTION_MAPPING;
    private static final String GET_EXPORTED_KEYS = "select cast(PK.RDB$RELATION_NAME as varchar(63)) as PKTABLE_NAME,cast(ISP.RDB$FIELD_NAME as varchar(63)) as PKCOLUMN_NAME,cast(FK.RDB$RELATION_NAME as varchar(63)) as FKTABLE_NAME,cast(ISF.RDB$FIELD_NAME as varchar(63)) as FKCOLUMN_NAME,CAST((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,cast(RC.RDB$UPDATE_RULE as varchar(11)) as UPDATE_RULE,cast(RC.RDB$DELETE_RULE as varchar(11)) as DELETE_RULE,cast(PK.RDB$CONSTRAINT_NAME as varchar(63)) as PK_NAME,cast(FK.RDB$CONSTRAINT_NAME as varchar(63)) as FK_NAME from RDB$RELATION_CONSTRAINTS PK,RDB$RELATION_CONSTRAINTS FK,RDB$REF_CONSTRAINTS RC,RDB$INDEX_SEGMENTS ISP,RDB$INDEX_SEGMENTS ISF WHERE CAST(PK.RDB$RELATION_NAME AS VARCHAR(73)) = ? and FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION order by 3, 5 ";
    private static final String GET_CROSS_KEYS = "select cast(PK.RDB$RELATION_NAME as varchar(63)) as PKTABLE_NAME,cast(ISP.RDB$FIELD_NAME as varchar(63)) as PKCOLUMN_NAME,cast(FK.RDB$RELATION_NAME as varchar(63)) as FKTABLE_NAME,cast(ISF.RDB$FIELD_NAME as varchar(63)) as FKCOLUMN_NAME,CAST((ISP.RDB$FIELD_POSITION + 1) as SMALLINT) as KEY_SEQ,cast(RC.RDB$UPDATE_RULE as varchar(11)) as UPDATE_RULE,cast(RC.RDB$DELETE_RULE as varchar(11)) as DELETE_RULE,cast(PK.RDB$CONSTRAINT_NAME as varchar(63)) as PK_NAME,cast(FK.RDB$CONSTRAINT_NAME as varchar(63)) as FK_NAME from RDB$RELATION_CONSTRAINTS PK,RDB$RELATION_CONSTRAINTS FK,RDB$REF_CONSTRAINTS RC,RDB$INDEX_SEGMENTS ISP,RDB$INDEX_SEGMENTS ISF WHERE CAST(PK.RDB$RELATION_NAME AS VARCHAR(73)) = ? and CAST(FK.RDB$RELATION_NAME AS VARCHAR(73)) = ? and  FK.RDB$CONSTRAINT_NAME = RC.RDB$CONSTRAINT_NAME and PK.RDB$CONSTRAINT_NAME = RC.RDB$CONST_NAME_UQ and ISP.RDB$INDEX_NAME = PK.RDB$INDEX_NAME and ISF.RDB$INDEX_NAME = FK.RDB$INDEX_NAME and ISP.RDB$FIELD_POSITION = ISF.RDB$FIELD_POSITION order by 3, 5 ";
    private static final String GET_INDEX_INFO = "SELECT cast(ind.RDB$RELATION_NAME as varchar(63)) AS TABLE_NAME,ind.RDB$UNIQUE_FLAG AS UNIQUE_FLAG,cast(ind.RDB$INDEX_NAME as varchar(63)) as INDEX_NAME,ise.rdb$field_position + 1 as ORDINAL_POSITION,cast(ise.rdb$field_name as varchar(63)) as COLUMN_NAME,ind.RDB$EXPRESSION_SOURCE as EXPRESSION_SOURCE,ind.RDB$INDEX_TYPE as ASC_OR_DESC FROM rdb$indices ind LEFT JOIN rdb$index_segments ise ON ind.rdb$index_name = ise.rdb$index_name WHERE CAST(ind.rdb$relation_name AS VARCHAR(73)) = ? ORDER BY 2, 3, 4";
    private static final int JDBC_MAJOR_VERSION = 4;
    private static final int JDBC_MINOR_VERSION;

    protected FBDatabaseMetaData(FBConnection c) throws SQLException {
        this.gdsHelper = c.getGDSHelper();
        this.connection = c;
        this.firebirdSupportInfo = FirebirdSupportInfo.supportInfoFor(c);
        this.versionMetaData = FirebirdVersionMetaData.getVersionMetaDataFor(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            for (FBStatement fBStatement : new ArrayList<FBPreparedStatement>(this.statements.values())) {
                try {
                    fBStatement.close();
                }
                catch (SQLException e) {
                    log.warn("error in DatabaseMetaData.close", e);
                }
            }
        }
        finally {
            this.statements.clear();
        }
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public String getURL() throws SQLException {
        GDSType gdsType = ((FBManagedConnectionFactory)this.connection.mc.getManagedConnectionFactory()).getGDSType();
        return GDSFactory.getJdbcUrl(gdsType, this.connection.mc.getDatabase());
    }

    @Override
    public String getUserName() throws SQLException {
        return this.gdsHelper.getUserName();
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        return this.gdsHelper.compareToVersion(2, 0) >= 0;
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        return this.gdsHelper.compareToVersion(2, 0) < 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return this.gdsHelper.getDatabaseProductName();
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductVersion();
    }

    @Override
    public String getDriverName() throws SQLException {
        return "Jaybird JCA/JDBC driver";
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return DRIVER_VERSION;
    }

    @Override
    public int getDriverMajorVersion() {
        return 3;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        return false;
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return true;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return "\"";
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return this.versionMetaData.getSqlKeywords();
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return FBDatabaseMetaData.collectionToCommaSeparatedList(FBEscapedFunctionHelper.getSupportedNumericFunctions());
    }

    private static String collectionToCommaSeparatedList(Collection<String> collection) {
        StringBuilder sb = new StringBuilder();
        for (String item : collection) {
            sb.append(item);
            sb.append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return FBDatabaseMetaData.collectionToCommaSeparatedList(FBEscapedFunctionHelper.getSupportedStringFunctions());
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return FBDatabaseMetaData.collectionToCommaSeparatedList(FBEscapedFunctionHelper.getSupportedSystemFunctions());
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return FBDatabaseMetaData.collectionToCommaSeparatedList(FBEscapedFunctionHelper.getSupportedTimeDateFunctions());
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return "\\";
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "$";
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "PROCEDURE";
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return null;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return false;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return true;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 32765;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        if (this.gdsHelper.compareToVersion(4, 0) < 0) {
            return 31;
        }
        return 63;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return Short.MAX_VALUE;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 31;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        if (this.gdsHelper.compareToVersion(2, 0) < 0) {
            return 252;
        }
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        if (this.gdsHelper.compareToVersion(4, 0) < 0) {
            return 31;
        }
        return 63;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        if (this.gdsHelper.compareToVersion(1, 5) >= 0) {
            return 65531;
        }
        return 0;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 65536;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        if (this.gdsHelper.compareToVersion(4, 0) < 0) {
            return 31;
        }
        return 63;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 31;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        switch (level) {
            case 0: {
                return false;
            }
            case 2: {
                return true;
            }
            case 1: {
                return false;
            }
            case 4: {
                return true;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(9, datatypeCoder).at(0).simple(448, 63, "PROCEDURE_CAT", "PROCEDURES").addField().at(1).simple(448, 63, "PROCEDURE_SCHEM", "ROCEDURES").addField().at(2).simple(448, 63, "PROCEDURE_NAME", "PROCEDURES").addField().at(3).simple(448, 31, "FUTURE1", "PROCEDURES").addField().at(4).simple(448, 31, "FUTURE2", "PROCEDURES").addField().at(5).simple(448, 31, "FUTURE3", "PROCEDURES").addField().at(6).simple(448, Integer.MAX_VALUE, "REMARKS", "PROCEDURES").addField().at(7).simple(500, 0, "PROCEDURE_TYPE", "PROCEDURES").addField().at(8).simple(448, 63, "SPECIFIC_NAME", "PROCEDURES").addField().toRowDescriptor();
        Clause procedureClause = new Clause("RDB$PROCEDURE_NAME", procedureNamePattern);
        String sql = GET_PROCEDURES_START;
        sql = sql + procedureClause.getCondition();
        sql = sql + GET_PROCEDURES_END;
        List<String> params = procedureClause.hasCondition() ? Collections.singletonList(procedureClause.getValue()) : Collections.emptyList();
        try (ResultSet rs = this.doQuery(sql, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
            do {
                rows.add(valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(rs.getString("PROCEDURE_NAME"))).at(6).set(FBDatabaseMetaData.getBytes(rs.getString("REMARKS"))).at(7).set(rs.getShort("PROCEDURE_TYPE") == 0 ? PROCEDURE_NO_RESULT : PROCEDURE_RETURNS_RESULT).at(8).set(valueBuilder.get(2)).toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(rowDescriptor, rows);
            return fBResultSet;
        }
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(20, datatypeCoder).at(0).simple(448, 63, "PROCEDURE_CAT", "COLUMNINFO").addField().at(1).simple(448, 63, "PROCEDURE_SCHEM", "COLUMNINFO").addField().at(2).simple(448, 63, "PROCEDURE_NAME", "COLUMNINFO").addField().at(3).simple(448, 63, "COLUMN_NAME", "COLUMNINFO").addField().at(4).simple(500, 0, "COLUMN_TYPE", "COLUMNINFO").addField().at(5).simple(496, 0, "DATA_TYPE", "COLUMNINFO").addField().at(6).simple(448, 31, "TYPE_NAME", "COLUMNINFO").addField().at(7).simple(496, 0, "PRECISION", "COLUMNINFO").addField().at(8).simple(496, 0, "LENGTH", "COLUMNINFO").addField().at(9).simple(500, 0, "SCALE", "COLUMNINFO").addField().at(10).simple(500, 0, "RADIX", "COLUMNINFO").addField().at(11).simple(500, 0, "NULLABLE", "COLUMNINFO").addField().at(12).simple(448, Integer.MAX_VALUE, "REMARKS", "COLUMNINFO").addField().at(13).simple(448, 31, "COLUMN_DEF", "COLUMNINFO").addField().at(14).simple(496, 0, "SQL_DATA_TYPE", "COLUMNINFO").addField().at(15).simple(496, 0, "SQL_DATETIME_SUB", "COLUMNINFO").addField().at(16).simple(496, 0, "CHAR_OCTET_LENGTH", "COLUMNINFO").addField().at(17).simple(496, 0, "ORDINAL_POSITION", "COLUMNINFO").addField().at(18).simple(448, 3, "IS_NULLABLE", "COLUMNINFO").addField().at(19).simple(448, 63, "SPECIFIC_NAME", "COLUMNINFO").addField().toRowDescriptor();
        Clause procedureClause = new Clause("PP.RDB$PROCEDURE_NAME", procedureNamePattern);
        Clause columnClause = new Clause("PP.RDB$PARAMETER_NAME", columnNamePattern);
        String sql = GET_PROCEDURE_COLUMNS_START;
        sql = sql + procedureClause.getCondition();
        sql = sql + columnClause.getCondition();
        sql = sql + GET_PROCEDURE_COLUMNS_END;
        ArrayList<String> params = new ArrayList<String>(2);
        if (procedureClause.hasCondition()) {
            params.add(procedureClause.getValue());
        }
        if (columnClause.hasCondition()) {
            params.add(columnClause.getValue());
        }
        try (ResultSet rs = this.doQuery(sql, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
            do {
                short columnType = rs.getShort("COLUMN_TYPE");
                short fieldType = rs.getShort("FIELD_TYPE");
                short fieldSubType = rs.getShort("FIELD_SUB_TYPE");
                short fieldScale = rs.getShort("FIELD_SCALE");
                int characterSetId = rs.getInt("RDB$CHARACTER_SET_ID");
                short nullFlag = rs.getShort("NULL_FLAG");
                int dataType = FBDatabaseMetaData.getDataType(fieldType, fieldSubType, fieldScale, characterSetId);
                valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(rs.getString("PROCEDURE_NAME"))).at(3).set(FBDatabaseMetaData.getBytes(rs.getString("COLUMN_NAME"))).at(4).set(columnType == 0 ? PROCEDURE_COLUMN_IN : PROCEDURE_COLUMN_OUT).at(5).set(FBDatabaseMetaData.createInt(dataType)).at(6).set(FBDatabaseMetaData.getBytes(FBDatabaseMetaData.getDataTypeName(fieldType, fieldSubType, fieldScale))).at(8).set(FBDatabaseMetaData.createInt(rs.getShort("FIELD_LENGTH"))).at(10).set(RADIX_TEN_SHORT).at(11).set(nullFlag == 1 ? PROCEDURE_NO_NULLS : PROCEDURE_NULLABLE).at(12).set(FBDatabaseMetaData.getBytes(rs.getString("REMARKS"))).at(17).set(FBDatabaseMetaData.createInt(rs.getInt("PARAMETER_NUMBER"))).at(18).set(nullFlag == 1 ? NO_BYTES : YES_BYTES).at(19).set(valueBuilder.get(2));
                switch (dataType) {
                    case 2: 
                    case 3: {
                        valueBuilder.at(7).set(FBDatabaseMetaData.createInt(rs.getShort("FIELD_PRECISION"))).at(9).set(FBDatabaseMetaData.createShort(-1 * fieldScale));
                        break;
                    }
                    case -3: 
                    case -2: 
                    case 1: 
                    case 12: {
                        short charLen = rs.getShort("CHAR_LEN");
                        if (!rs.wasNull()) {
                            valueBuilder.at(7).set(FBDatabaseMetaData.createInt(charLen));
                        } else {
                            valueBuilder.at(8).set(valueBuilder.get(8));
                        }
                        valueBuilder.at(16).set(valueBuilder.get(8));
                        break;
                    }
                    case 6: {
                        valueBuilder.at(7).set(FLOAT_PRECISION);
                        break;
                    }
                    case 8: {
                        valueBuilder.at(7).set(DOUBLE_PRECISION);
                        break;
                    }
                    case -5: {
                        valueBuilder.at(7).set(BIGINT_PRECISION).at(9).set(SHORT_ZERO);
                        break;
                    }
                    case 4: {
                        valueBuilder.at(7).set(INTEGER_PRECISION).at(9).set(SHORT_ZERO);
                        break;
                    }
                    case 5: {
                        valueBuilder.at(7).set(SMALLINT_PRECISION).at(9).set(SHORT_ZERO);
                        break;
                    }
                    case 91: {
                        valueBuilder.at(7).set(DATE_PRECISION);
                        break;
                    }
                    case 92: {
                        valueBuilder.at(7).set(TIME_PRECISION);
                        break;
                    }
                    case 93: {
                        valueBuilder.at(7).set(TIMESTAMP_PRECISION);
                        break;
                    }
                    case 16: {
                        valueBuilder.at(7).set(BOOLEAN_PRECISION).at(10).set(RADIX_BINARY_SHORT);
                    }
                }
                rows.add(valueBuilder.toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(rowDescriptor, rows);
            return fBResultSet;
        }
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        if (this.hasGlobalTemporaryTables()) {
            return this.getTables_2_5(tableNamePattern, types);
        }
        return this.getTables_2_1(tableNamePattern, types);
    }

    private ResultSet getTables_2_5(String tableNamePattern, String[] types) throws SQLException {
        List<String> params;
        if (types == null) {
            types = ALL_TYPES_2_5;
        }
        Clause nameClause = new Clause("RDB$RELATION_NAME", tableNamePattern);
        String sql = TABLE_COLUMNS_2_5;
        if (nameClause.hasCondition()) {
            sql = sql + " where " + nameClause.getCondition();
            params = Collections.singletonList(nameClause.getValue());
        } else {
            params = Collections.emptyList();
        }
        HashSet<String> typeSet = new HashSet<String>(Arrays.asList(types));
        if (!typeSet.containsAll(Arrays.asList(ALL_TYPES_2_5))) {
            StringBuilder typeCondition = new StringBuilder(112);
            if (typeSet.contains(SYSTEM_TABLE) && typeSet.contains(TABLE)) {
                typeCondition.append(" (rdb$relation_type in (0, 2, 3) or  rdb$relation_type is null and rdb$view_blr is null ) ");
            } else if (typeSet.contains(SYSTEM_TABLE)) {
                typeCondition.append(" (rdb$relation_type in (0, 3) or  rdb$relation_type is null and rdb$view_blr is null ) and rdb$system_flag = 1 ");
            } else if (typeSet.contains(TABLE)) {
                typeCondition.append(" (rdb$relation_type in (0, 2) or  rdb$relation_type is null and rdb$view_blr is null ) and rdb$system_flag = 0 ");
            }
            if (typeSet.contains(VIEW)) {
                if (typeCondition.length() > 0) {
                    typeCondition.append(" or ");
                }
                typeCondition.append(" (rdb$relation_type = 1 or  rdb$relation_type is null and rdb$view_blr is not null ) ");
            }
            if (typeSet.contains(GLOBAL_TEMPORARY)) {
                if (typeCondition.length() > 0) {
                    typeCondition.append(" or ");
                }
                typeCondition.append(" rdb$relation_type in (4, 5) ");
            }
            if (typeCondition.length() == 0) {
                typeCondition.append(" 1 = 0 ");
            }
            sql = sql + (nameClause.hasCondition() ? " (" + typeCondition + ") " : " where " + typeCondition + " ");
        } else if (nameClause.hasCondition()) {
            sql = sql + " 1=1 ";
        }
        sql = sql + GET_TABLE_ORDER_BY;
        return this.doQuery(sql, params);
    }

    private ResultSet getTables_2_1(String tableNamePattern, String[] types) throws SQLException {
        ArrayList<String> params;
        String sql;
        if (types == null) {
            types = ALL_TYPES_2_1;
        }
        if (FBDatabaseMetaData.isAllCondition(tableNamePattern)) {
            sql = GET_TABLES_ALL_2_1;
            params = new ArrayList<String>(3);
            params.add(this.getWantsSystemTables(types));
            params.add(this.getWantsTables(types));
            params.add(this.getWantsViews(types));
        } else if (FBDatabaseMetaData.hasNoWildcards(tableNamePattern)) {
            tableNamePattern = FBDatabaseMetaData.stripEscape(tableNamePattern);
            sql = GET_TABLES_EXACT_2_1;
            params = new ArrayList(6);
            params.add(this.getWantsSystemTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsViews(types));
            params.add(tableNamePattern);
        } else {
            tableNamePattern = tableNamePattern + SPACES_15 + "%";
            sql = GET_TABLES_LIKE_2_1;
            params = new ArrayList(6);
            params.add(this.getWantsSystemTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsTables(types));
            params.add(tableNamePattern);
            params.add(this.getWantsViews(types));
            params.add(tableNamePattern);
        }
        return this.doQuery(sql, params);
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(1, datatypeCoder).at(0).simple(448, 63, "TABLE_CAT", "TABLECATALOGS").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(1, datatypeCoder).at(0).simple(448, 31, "TABLE_TYPE", "TABLETYPES").addField().toRowDescriptor();
        String[] types = this.hasGlobalTemporaryTables() ? ALL_TYPES_2_5 : ALL_TYPES_2_1;
        ArrayList<RowValue> rows = new ArrayList<RowValue>(types.length);
        for (String type : types) {
            rows.add(RowValue.of(rowDescriptor, new byte[][]{FBDatabaseMetaData.getBytes(type)}));
        }
        return new FBResultSet(rowDescriptor, rows);
    }

    private boolean hasGlobalTemporaryTables() throws SQLException {
        return this.getOdsMajorVersion() == 11 && this.getOdsMinorVersion() >= 2 || this.getOdsMajorVersion() > 11;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(26, datatypeCoder).at(0).simple(448, 63, "TABLE_CAT", "COLUMNINFO").addField().at(1).simple(448, 63, "TABLE_SCHEM", "COLUMNINFO").addField().at(2).simple(448, 63, "TABLE_NAME", "COLUMNINFO").addField().at(3).simple(448, 63, "COLUMN_NAME", "COLUMNINFO").addField().at(4).simple(496, 0, "DATA_TYPE", "COLUMNINFO").addField().at(5).simple(449, 31, "TYPE_NAME", "COLUMNINFO").addField().at(6).simple(496, 0, "COLUMN_SIZE", "COLUMNINFO").addField().at(7).simple(496, 0, "BUFFER_LENGTH", "COLUMNINFO").addField().at(8).simple(496, 0, "DECIMAL_DIGITS", "COLUMNINFO").addField().at(9).simple(496, 0, "NUM_PREC_RADIX", "COLUMNINFO").addField().at(10).simple(496, 0, "NULLABLE", "COLUMNINFO").addField().at(11).simple(449, Integer.MAX_VALUE, "REMARKS", "COLUMNINFO").addField().at(12).simple(449, 31, "COLUMN_DEF", "COLUMNINFO").addField().at(13).simple(496, 0, "SQL_DATA_TYPE", "COLUMNINFO").addField().at(14).simple(496, 0, "SQL_DATETIME_SUB", "COLUMNINFO").addField().at(15).simple(496, 0, "CHAR_OCTET_LENGTH", "COLUMNINFO").addField().at(16).simple(496, 0, "ORDINAL_POSITION", "COLUMNINFO").addField().at(17).simple(448, 3, "IS_NULLABLE", "COLUMNINFO").addField().at(18).simple(448, 63, this.getScopeCatalogColumnName(), "COLUMNINFO").addField().at(19).simple(448, 63, "SCOPE_SCHEMA", "COLUMNINFO").addField().at(20).simple(448, 63, "SCOPE_TABLE", "COLUMNINFO").addField().at(21).simple(500, 0, "SOURCE_DATA_TYPE", "COLUMNINFO").addField().at(22).simple(448, 3, "IS_AUTOINCREMENT", "COLUMNINFO").addField().at(23).simple(448, 3, "IS_GENERATEDCOLUMN", "COLUMNINFO").addField().at(24).simple(448, 3, "JB_IS_IDENTITY", "COLUMNINFO").addField().at(25).simple(448, 10, "JB_IDENTITY_TYPE", "COLUMNINFO").addField().toRowDescriptor();
        Clause tableClause = new Clause("RF.RDB$RELATION_NAME", tableNamePattern);
        Clause columnClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
        String sql = this.hasIdentityColumns() ? GET_COLUMNS_3_0_START : GET_COLUMNS_START;
        sql = sql + tableClause.getCondition();
        sql = sql + columnClause.getCondition();
        sql = sql + GET_COLUMNS_END;
        ArrayList<String> params = new ArrayList<String>(2);
        if (tableClause.hasCondition()) {
            params.add(tableClause.getValue());
        }
        if (columnClause.hasCondition()) {
            params.add(columnClause.getValue());
        }
        try (ResultSet rs = this.doQuery(sql, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
            do {
                short fieldType = rs.getShort("FIELD_TYPE");
                short fieldSubType = rs.getShort("FIELD_SUB_TYPE");
                short fieldScale = rs.getShort("FIELD_SCALE");
                int characterSetId = rs.getInt("RDB$CHARACTER_SET_ID");
                int dataType = FBDatabaseMetaData.getDataType(fieldType, fieldSubType, fieldScale, characterSetId);
                valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(rs.getString("RELATION_NAME"))).at(3).set(FBDatabaseMetaData.getBytes(rs.getString("FIELD_NAME"))).at(4).set(FBDatabaseMetaData.createInt(dataType)).at(5).set(FBDatabaseMetaData.getBytes(FBDatabaseMetaData.getDataTypeName(fieldType, fieldSubType, fieldScale))).at(9).set(RADIX_TEN);
                switch (dataType) {
                    case 2: 
                    case 3: {
                        valueBuilder.at(6).set(FBDatabaseMetaData.createInt(rs.getShort("FIELD_PRECISION"))).at(8).set(FBDatabaseMetaData.createInt(fieldScale * -1));
                        break;
                    }
                    case -3: 
                    case -2: 
                    case 1: 
                    case 12: {
                        valueBuilder.at(15).set(FBDatabaseMetaData.createInt(rs.getShort("FIELD_LENGTH")));
                        short charLen = rs.getShort("CHAR_LEN");
                        if (!rs.wasNull()) {
                            valueBuilder.at(6).set(FBDatabaseMetaData.createInt(charLen));
                            break;
                        }
                        valueBuilder.at(6).set(valueBuilder.get(15));
                        break;
                    }
                    case 6: {
                        valueBuilder.at(6).set(FLOAT_PRECISION);
                        break;
                    }
                    case 8: {
                        valueBuilder.at(6).set(DOUBLE_PRECISION);
                        break;
                    }
                    case -5: {
                        valueBuilder.at(6).set(BIGINT_PRECISION).at(8).set(INT_ZERO);
                        break;
                    }
                    case 4: {
                        valueBuilder.at(6).set(INTEGER_PRECISION).at(8).set(INT_ZERO);
                        break;
                    }
                    case 5: {
                        valueBuilder.at(6).set(SMALLINT_PRECISION).at(8).set(INT_ZERO);
                        break;
                    }
                    case 91: {
                        valueBuilder.at(6).set(DATE_PRECISION);
                        break;
                    }
                    case 92: {
                        valueBuilder.at(6).set(TIME_PRECISION);
                        break;
                    }
                    case 93: {
                        valueBuilder.at(6).set(TIMESTAMP_PRECISION);
                        break;
                    }
                    case 16: {
                        valueBuilder.at(6).set(BOOLEAN_PRECISION).at(9).set(RADIX_BINARY);
                    }
                }
                short nullFlag = rs.getShort("NULL_FLAG");
                short sourceNullFlag = rs.getShort("SOURCE_NULL_FLAG");
                valueBuilder.at(10).set(nullFlag == 1 || sourceNullFlag == 1 ? COLUMN_NO_NULLS : COLUMN_NULLABLE).at(11).set(FBDatabaseMetaData.getBytes(rs.getString("REMARKS")));
                String column_def = rs.getString("DEFAULT_SOURCE");
                if (column_def == null) {
                    column_def = rs.getString("DOMAIN_DEFAULT_SOURCE");
                }
                if (column_def != null) {
                    int defaultPos = column_def.toUpperCase().indexOf("DEFAULT");
                    if (defaultPos >= 0) {
                        column_def = column_def.substring(7).trim();
                    }
                    valueBuilder.at(12).set(FBDatabaseMetaData.getBytes(column_def));
                }
                valueBuilder.at(16).set(FBDatabaseMetaData.createInt(rs.getInt("FIELD_POSITION"))).at(17).set(nullFlag == 1 || sourceNullFlag == 1 ? NO_BYTES : YES_BYTES);
                boolean isIdentity = Objects.equals("YES", rs.getString("IS_IDENTITY"));
                if (isIdentity) {
                    valueBuilder.at(22).set(YES_BYTES);
                } else {
                    switch (dataType) {
                        case -6: 
                        case -5: 
                        case 4: 
                        case 5: {
                            valueBuilder.at(22).set(EMPTY_STRING_BYTES);
                            break;
                        }
                        case 2: 
                        case 3: {
                            if (fieldScale == 0) {
                                valueBuilder.at(22).set(EMPTY_STRING_BYTES);
                                break;
                            }
                            valueBuilder.at(22).set(NO_BYTES);
                            break;
                        }
                        default: {
                            valueBuilder.at(22).set(NO_BYTES);
                        }
                    }
                }
                rs.getString("COMPUTED_BLR");
                boolean isGenerated = !rs.wasNull() || isIdentity;
                valueBuilder.at(23).set(isGenerated ? YES_BYTES : NO_BYTES);
                valueBuilder.at(24).set(isIdentity ? YES_BYTES : NO_BYTES);
                valueBuilder.at(25).set(FBDatabaseMetaData.getBytes(rs.getString("JB_IDENTITY_TYPE")));
                rows.add(valueBuilder.toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(rowDescriptor, rows);
            return fBResultSet;
        }
    }

    private boolean hasIdentityColumns() throws SQLException {
        return this.getOdsMajorVersion() >= 12;
    }

    private String getScopeCatalogColumnName() {
        String scopeCatalog = this.getJDBCMajorVersion() > 4 || this.getJDBCMajorVersion() == 4 && this.getJDBCMinorVersion() >= 1 ? "SCOPE_CATALOG" : "SCOPE_CATLOG";
        return scopeCatalog;
    }

    private static int getDataType(int fieldType, int fieldSubType, int fieldScale, int characterSetId) {
        if (fieldType == 261 && fieldSubType > 1) {
            return 1111;
        }
        int jdbcType = JdbcTypeConverter.fromMetaDataToJdbcType(fieldType, fieldSubType, fieldScale);
        if (characterSetId == 1) {
            if (jdbcType == 1) {
                return -2;
            }
            if (jdbcType == 12) {
                return -3;
            }
        }
        return jdbcType;
    }

    private static String getDataTypeName(int sqltype, int sqlsubtype, int sqlscale) {
        switch (sqltype) {
            case 7: {
                if (sqlsubtype == 1 || sqlsubtype == 0 && sqlscale < 0) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "SMALLINT";
            }
            case 8: {
                if (sqlsubtype == 1 || sqlsubtype == 0 && sqlscale < 0) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "INTEGER";
            }
            case 11: 
            case 27: {
                if (sqlsubtype == 1 || sqlsubtype == 0 && sqlscale < 0) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "DOUBLE PRECISION";
            }
            case 10: {
                return "FLOAT";
            }
            case 14: {
                return "CHAR";
            }
            case 37: {
                return "VARCHAR";
            }
            case 35: {
                return "TIMESTAMP";
            }
            case 13: {
                return "TIME";
            }
            case 12: {
                return "DATE";
            }
            case 16: {
                if (sqlsubtype == 1 || sqlsubtype == 0 && sqlscale < 0) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "BIGINT";
            }
            case 261: {
                if (sqlsubtype < 0) {
                    return "BLOB SUB_TYPE <0";
                }
                if (sqlsubtype == 0) {
                    return "BLOB SUB_TYPE 0";
                }
                if (sqlsubtype == 1) {
                    return "BLOB SUB_TYPE 1";
                }
                return "BLOB SUB_TYPE " + sqlsubtype;
            }
            case 9: {
                return "ARRAY";
            }
            case 23: {
                return "BOOLEAN";
            }
        }
        return "NULL";
    }

    private static byte[] mapPrivilege(String firebirdPrivilege) {
        return PRIVILEGE_MAPPING.get(firebirdPrivilege);
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(8, datatypeCoder).at(0).simple(448, 63, "TABLE_CAT", "COLUMNPRIV").addField().at(1).simple(448, 63, "TABLE_SCHEM", "COLUMNPRIV").addField().at(2).simple(448, 63, "TABLE_NAME", "COLUMNPRIV").addField().at(3).simple(448, 63, "COLUMN_NAME", "COLUMNPRIV").addField().at(4).simple(448, 63, "GRANTOR", "COLUMNPRIV").addField().at(5).simple(448, 63, "GRANTEE", "COLUMNPRIV").addField().at(6).simple(448, 31, "PRIVILEGE", "COLUMNPRIV").addField().at(7).simple(448, 31, "IS_GRANTABLE", "COLUMNPRIV").addField().toRowDescriptor();
        Clause columnClause = new Clause("RF.RDB$FIELD_NAME", columnNamePattern);
        String sql = GET_COLUMN_PRIVILEGES_START;
        sql = sql + columnClause.getCondition();
        sql = sql + GET_COLUMN_PRIVILEGES_END;
        ArrayList<String> params = new ArrayList<String>(2);
        params.add(table);
        if (columnClause.hasCondition()) {
            params.add(columnClause.getValue());
        }
        try (ResultSet rs = this.doQuery(sql, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
            do {
                rows.add(valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(rs.getString("TABLE_NAME"))).at(3).set(FBDatabaseMetaData.getBytes(rs.getString("COLUMN_NAME"))).at(4).set(FBDatabaseMetaData.getBytes(rs.getString("GRANTOR"))).at(5).set(FBDatabaseMetaData.getBytes(rs.getString("GRANTEE"))).at(6).set(FBDatabaseMetaData.mapPrivilege(rs.getString("PRIVILEGE"))).at(7).set(rs.getShort("IS_GRANTABLE") == 0 ? NO_BYTES : YES_BYTES).toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(rowDescriptor, rows);
            return fBResultSet;
        }
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = this.buildTablePrivilegeRSMetaData();
        Clause tableClause = new Clause("RDB$RELATION_NAME", tableNamePattern);
        String sql = GET_TABLE_PRIVILEGES_START;
        sql = sql + tableClause.getCondition();
        sql = sql + GET_TABLE_PRIVILEGES_END;
        List<String> params = tableClause.hasCondition() ? Collections.singletonList(tableClause.getValue()) : Collections.emptyList();
        try (ResultSet rs = this.doQuery(sql, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            FBResultSet fBResultSet = this.processTablePrivileges(rowDescriptor, rs);
            return fBResultSet;
        }
    }

    protected final RowDescriptor buildTablePrivilegeRSMetaData() {
        return new RowDescriptorBuilder(7, datatypeCoder).at(0).simple(448, 63, "TABLE_CAT", "TABLEPRIV").addField().at(1).simple(448, 63, "TABLE_SCHEM", "TABLEPRIV").addField().at(2).simple(448, 63, "TABLE_NAME", "TABLEPRIV").addField().at(3).simple(448, 63, "GRANTOR", "TABLEPRIV").addField().at(4).simple(448, 63, "GRANTEE", "TABLEPRIV").addField().at(5).simple(448, 31, "PRIVILEGE", "TABLEPRIV").addField().at(6).simple(448, 31, "IS_GRANTABLE", "TABLEPRIV").addField().toRowDescriptor();
    }

    protected final FBResultSet processTablePrivileges(RowDescriptor rowDescriptor, ResultSet fbTablePrivileges) throws SQLException {
        ArrayList<RowValue> rows = new ArrayList<RowValue>();
        RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
        do {
            rows.add(valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(fbTablePrivileges.getString("TABLE_NAME"))).at(3).set(FBDatabaseMetaData.getBytes(fbTablePrivileges.getString("GRANTOR"))).at(4).set(FBDatabaseMetaData.getBytes(fbTablePrivileges.getString("GRANTEE"))).at(5).set(FBDatabaseMetaData.mapPrivilege(fbTablePrivileges.getString("PRIVILEGE"))).at(6).set(fbTablePrivileges.getShort("IS_GRANTABLE") == 0 ? NO_BYTES : YES_BYTES).toRowValue(true));
        } while (fbTablePrivileges.next());
        return new FBResultSet(rowDescriptor, rows);
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        List<RowValue> rows;
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(8, datatypeCoder).at(0).simple(500, 0, "SCOPE", "ROWIDENTIFIER").addField().at(1).simple(448, 63, "COLUMN_NAME", "ROWIDENTIFIER").addField().at(2).simple(500, 0, "DATA_TYPE", "ROWIDENTIFIER").addField().at(3).simple(448, 31, "TYPE_NAME", "ROWIDENTIFIER").addField().at(4).simple(496, 0, "COLUMN_SIZE", "ROWIDENTIFIER").addField().at(5).simple(496, 0, "BUFFER_LENGTH", "ROWIDENTIFIER").addField().at(6).simple(500, 0, "DECIMAL_DIGITS", "ROWIDENTIFIER").addField().at(7).simple(500, 0, "PSEUDO_COLUMN", "ROWIDENTIFIER").addField().toRowDescriptor();
        RowValueBuilder rowValueBuilder = new RowValueBuilder(rowDescriptor);
        String quoteLikeTable = FBDatabaseMetaData.escapeWildcards(table);
        try (ResultSet tables = this.getTables(catalog, schema, quoteLikeTable, null);){
            if (!tables.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            rows = this.getPrimaryKeyIdentifier(tables.getString(3), scope, rowValueBuilder);
        }
        if (rows.size() == 0) {
            rows.add(rowValueBuilder.at(0).set(FBDatabaseMetaData.createShort(scope)).at(1).set(FBDatabaseMetaData.getBytes("RDB$DB_KEY")).at(2).set(FBDatabaseMetaData.createShort(FBDatabaseMetaData.getDataType(14, 0, 0, 1))).at(3).set(FBDatabaseMetaData.getBytes(FBDatabaseMetaData.getDataTypeName(14, 0, 0))).at(4).set(FBDatabaseMetaData.createInt(0)).at(6).set(FBDatabaseMetaData.createShort(0)).at(7).set(FBDatabaseMetaData.createShort(2)).toRowValue(true));
        }
        return new FBResultSet(rowDescriptor, rows);
    }

    private List<RowValue> getPrimaryKeyIdentifier(String table, int scope, RowValueBuilder valueBuilder) throws SQLException {
        try (ResultSet rs = this.doQuery(GET_BEST_ROW_IDENT, Collections.singletonList(table));){
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            while (rs.next()) {
                short fieldType = rs.getShort("FIELD_TYPE");
                short fieldSubType = rs.getShort("FIELD_SUB_TYPE");
                short fieldScale = rs.getShort("FIELD_SCALE");
                int characterSetId = rs.getInt("RDB$CHARACTER_SET_ID");
                rows.add(valueBuilder.at(0).set(FBDatabaseMetaData.createShort(scope)).at(1).set(FBDatabaseMetaData.getBytes(rs.getString("COLUMN_NAME"))).at(2).set(FBDatabaseMetaData.createShort(FBDatabaseMetaData.getDataType(fieldType, fieldSubType, fieldScale, characterSetId))).at(3).set(FBDatabaseMetaData.getBytes(FBDatabaseMetaData.getDataTypeName(fieldType, fieldSubType, fieldScale))).at(4).set(FBDatabaseMetaData.createInt(rs.getInt("FIELD_PRECISION"))).at(6).set(FBDatabaseMetaData.createShort(fieldScale)).at(7).set(FBDatabaseMetaData.createShort(1)).toRowValue(true));
            }
            ArrayList<RowValue> arrayList = rows;
            return arrayList;
        }
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(8, datatypeCoder).at(0).simple(500, 0, "SCOPE", "VERSIONCOL").addField().at(1).simple(448, 63, "COLUMN_NAME", "VERSIONCOL").addField().at(2).simple(500, 0, "DATA_TYPE", "VERSIONCOL").addField().at(3).simple(448, 31, "TYPE_NAME", "VERSIONCOL").addField().at(4).simple(496, 0, "COLUMN_SIZE", "VERSIONCOL").addField().at(5).simple(496, 0, "BUFFER_LENGTH", "VERSIONCOL").addField().at(6).simple(500, 0, "DECIMAL_DIGITS", "VERSIONCOL").addField().at(7).simple(500, 0, "PSEUDO_COLUMN", "VERSIONCOL").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(6, datatypeCoder).at(0).simple(448, 63, "TABLE_CAT", "COLUMNINFO").addField().at(1).simple(448, 63, "TABLE_SCHEM", "COLUMNINFO").addField().at(2).simple(448, 63, "TABLE_NAME", "COLUMNINFO").addField().at(3).simple(448, 63, "COLUMN_NAME", "COLUMNINFO").addField().at(4).simple(500, 0, "KEY_SEQ", "COLUMNINFO").addField().at(5).simple(448, 63, "PK_NAME", "COLUMNINFO").addField().toRowDescriptor();
        List<String> params = Collections.singletonList(table);
        try (ResultSet rs = this.doQuery(GET_PRIMARY_KEYS, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
            do {
                rows.add(valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(rs.getString("TABLE_NAME"))).at(3).set(FBDatabaseMetaData.getBytes(rs.getString("COLUMN_NAME"))).at(4).set(FBDatabaseMetaData.createShort(rs.getShort("KEY_SEQ"))).at(5).set(FBDatabaseMetaData.getBytes(rs.getString("PK_NAME"))).toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(rowDescriptor, rows);
            return fBResultSet;
        }
    }

    private static byte[] mapAction(String fbAction) {
        return ACTION_MAPPING.get(fbAction);
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(14, datatypeCoder).at(0).simple(448, 63, "PKTABLE_CAT", "COLUMNINFO").addField().at(1).simple(448, 63, "PKTABLE_SCHEM", "COLUMNINFO").addField().at(2).simple(448, 63, "PKTABLE_NAME", "COLUMNINFO").addField().at(3).simple(448, 63, "PKCOLUMN_NAME", "COLUMNINFO").addField().at(4).simple(448, 63, "FKTABLE_CAT", "COLUMNINFO").addField().at(5).simple(448, 63, "FKTABLE_SCHEM", "COLUMNINFO").addField().at(6).simple(448, 63, "FKTABLE_NAME", "COLUMNINFO").addField().at(7).simple(448, 63, "FKCOLUMN_NAME", "COLUMNINFO").addField().at(8).simple(500, 0, "KEY_SEQ", "COLUMNINFO").addField().at(9).simple(500, 0, "UPDATE_RULE", "COLUMNINFO").addField().at(10).simple(500, 0, "DELETE_RULE", "COLUMNINFO").addField().at(11).simple(448, 63, "FK_NAME", "COLUMNINFO").addField().at(12).simple(448, 63, "PK_NAME", "COLUMNINFO").addField().at(13).simple(500, 0, "DEFERRABILITY", "COLUMNINFO").addField().toRowDescriptor();
        List<String> params = Collections.singletonList(table);
        try (ResultSet rs = this.doQuery(GET_IMPORTED_KEYS, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
            do {
                rows.add(valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(rs.getString("PKTABLE_NAME"))).at(3).set(FBDatabaseMetaData.getBytes(rs.getString("PKCOLUMN_NAME"))).at(6).set(FBDatabaseMetaData.getBytes(rs.getString("FKTABLE_NAME"))).at(7).set(FBDatabaseMetaData.getBytes(rs.getString("FKCOLUMN_NAME"))).at(8).set(FBDatabaseMetaData.createShort(rs.getShort("KEY_SEQ"))).at(9).set(FBDatabaseMetaData.mapAction(rs.getString("UPDATE_RULE"))).at(10).set(FBDatabaseMetaData.mapAction(rs.getString("DELETE_RULE"))).at(11).set(FBDatabaseMetaData.getBytes(rs.getString("FK_NAME"))).at(12).set(FBDatabaseMetaData.getBytes(rs.getString("PK_NAME"))).at(13).set(IMPORTED_KEY_NOT_DEFERRABLE).toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(rowDescriptor, rows);
            return fBResultSet;
        }
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(14, datatypeCoder).at(0).simple(448, 63, "PKTABLE_CAT", "COLUMNINFO").addField().at(1).simple(448, 63, "PKTABLE_SCHEM", "COLUMNINFO").addField().at(2).simple(448, 63, "PKTABLE_NAME", "COLUMNINFO").addField().at(3).simple(448, 63, "PKCOLUMN_NAME", "COLUMNINFO").addField().at(4).simple(448, 63, "FKTABLE_CAT", "COLUMNINFO").addField().at(5).simple(448, 63, "FKTABLE_SCHEM", "COLUMNINFO").addField().at(6).simple(448, 63, "FKTABLE_NAME", "COLUMNINFO").addField().at(7).simple(448, 63, "FKCOLUMN_NAME", "COLUMNINFO").addField().at(8).simple(500, 0, "KEY_SEQ", "COLUMNINFO").addField().at(9).simple(500, 0, "UPDATE_RULE", "COLUMNINFO").addField().at(10).simple(500, 0, "DELETE_RULE", "COLUMNINFO").addField().at(11).simple(448, 63, "FK_NAME", "COLUMNINFO").addField().at(12).simple(448, 63, "PK_NAME", "COLUMNINFO").addField().at(13).simple(500, 0, "DEFERRABILITY", "COLUMNINFO").addField().toRowDescriptor();
        List<String> params = Collections.singletonList(table);
        try (ResultSet rs = this.doQuery(GET_EXPORTED_KEYS, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
            do {
                rows.add(valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(rs.getString("PKTABLE_NAME"))).at(3).set(FBDatabaseMetaData.getBytes(rs.getString("PKCOLUMN_NAME"))).at(6).set(FBDatabaseMetaData.getBytes(rs.getString("FKTABLE_NAME"))).at(7).set(FBDatabaseMetaData.getBytes(rs.getString("FKCOLUMN_NAME"))).at(8).set(FBDatabaseMetaData.createShort(rs.getShort("KEY_SEQ"))).at(9).set(FBDatabaseMetaData.mapAction(rs.getString("UPDATE_RULE"))).at(10).set(FBDatabaseMetaData.mapAction(rs.getString("DELETE_RULE"))).at(11).set(FBDatabaseMetaData.getBytes(rs.getString("FK_NAME"))).at(12).set(FBDatabaseMetaData.getBytes(rs.getString("PK_NAME"))).at(13).set(IMPORTED_KEY_NOT_DEFERRABLE).toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(rowDescriptor, rows);
            return fBResultSet;
        }
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(14, datatypeCoder).at(0).simple(448, 63, "PKTABLE_CAT", "COLUMNINFO").addField().at(1).simple(448, 63, "PKTABLE_SCHEM", "COLUMNINFO").addField().at(2).simple(448, 63, "PKTABLE_NAME", "COLUMNINFO").addField().at(3).simple(448, 63, "PKCOLUMN_NAME", "COLUMNINFO").addField().at(4).simple(448, 63, "FKTABLE_CAT", "COLUMNINFO").addField().at(5).simple(448, 63, "FKTABLE_SCHEM", "COLUMNINFO").addField().at(6).simple(448, 63, "FKTABLE_NAME", "COLUMNINFO").addField().at(7).simple(448, 63, "FKCOLUMN_NAME", "COLUMNINFO").addField().at(8).simple(500, 0, "KEY_SEQ", "COLUMNINFO").addField().at(9).simple(500, 0, "UPDATE_RULE", "COLUMNINFO").addField().at(10).simple(500, 0, "DELETE_RULE", "COLUMNINFO").addField().at(11).simple(448, 63, "FK_NAME", "COLUMNINFO").addField().at(12).simple(448, 63, "PK_NAME", "COLUMNINFO").addField().at(13).simple(500, 0, "DEFERRABILITY", "COLUMNINFO").addField().toRowDescriptor();
        List<String> params = Arrays.asList(primaryTable, foreignTable);
        try (ResultSet rs = this.doQuery(GET_CROSS_KEYS, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
            do {
                rows.add(valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(rs.getString("PKTABLE_NAME"))).at(3).set(FBDatabaseMetaData.getBytes(rs.getString("PKCOLUMN_NAME"))).at(6).set(FBDatabaseMetaData.getBytes(rs.getString("FKTABLE_NAME"))).at(7).set(FBDatabaseMetaData.getBytes(rs.getString("FKCOLUMN_NAME"))).at(8).set(FBDatabaseMetaData.createShort(rs.getShort("KEY_SEQ"))).at(9).set(FBDatabaseMetaData.mapAction(rs.getString("UPDATE_RULE"))).at(10).set(FBDatabaseMetaData.mapAction(rs.getString("DELETE_RULE"))).at(11).set(FBDatabaseMetaData.getBytes(rs.getString("FK_NAME"))).at(12).set(FBDatabaseMetaData.getBytes(rs.getString("PK_NAME"))).at(13).set(IMPORTED_KEY_NOT_DEFERRABLE).toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(rowDescriptor, rows);
            return fBResultSet;
        }
    }

    private static byte[] createShort(int value) {
        assert (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) : String.format("Value \"%d\" outside range of short", value);
        return datatypeCoder.encodeShort(value);
    }

    private static byte[] createInt(int value) {
        return datatypeCoder.encodeInt(value);
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(18, datatypeCoder).at(0).simple(448, 31, "TYPE_NAME", "TYPEINFO").addField().at(1).simple(500, 0, "DATA_TYPE", "TYPEINFO").addField().at(2).simple(496, 0, "PRECISION", "TYPEINFO").addField().at(3).simple(448, 1, "LITERAL_PREFIX", "TYPEINFO").addField().at(4).simple(448, 1, "LITERAL_SUFFIX", "TYPEINFO").addField().at(5).simple(448, 31, "CREATE_PARAMS", "TYPEINFO").addField().at(6).simple(500, 0, "NULLABLE", "TYPEINFO").addField().at(7).simple(452, 1, "CASE_SENSITIVE", "TYPEINFO").addField().at(8).simple(500, 0, "SEARCHABLE", "TYPEINFO").addField().at(9).simple(452, 1, "UNSIGNED_ATTRIBUTE", "TYPEINFO").addField().at(10).simple(452, 1, "FIXED_PREC_SCALE", "TYPEINFO").addField().at(11).simple(452, 1, "AUTO_INCREMENT", "TYPEINFO").addField().at(12).simple(448, 31, "LOCAL_TYPE_NAME", "TYPEINFO").addField().at(13).simple(500, 0, "MINIMUM_SCALE", "TYPEINFO").addField().at(14).simple(500, 0, "MAXIMUM_SCALE", "TYPEINFO").addField().at(15).simple(496, 0, "SQL_DATA_TYPE", "TYPEINFO").addField().at(16).simple(496, 0, "SQL_DATETIME_SUB", "TYPEINFO").addField().at(17).simple(496, 0, "NUM_PREC_RADIX", "TYPEINFO").addField().toRowDescriptor();
        byte[] blobTypePred = this.firebirdSupportInfo.supportsFullSearchableBlobs() ? TYPE_SEARCHABLE : TYPE_PRED_BASIC;
        ArrayList<RowValue> rows = new ArrayList<RowValue>(19);
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("BIGINT"), FBDatabaseMetaData.createShort(-5), BIGINT_PRECISION, null, null, null, TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(580), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("BLOB SUB_TYPE BINARY"), FBDatabaseMetaData.createShort(-4), INT_ZERO, null, null, null, TYPE_NULLABLE, CASESENSITIVE, blobTypePred, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(520), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("VARCHAR"), FBDatabaseMetaData.createShort(-3), FBDatabaseMetaData.createInt(32765), null, null, null, TYPE_NULLABLE, CASESENSITIVE, TYPE_SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(448), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("CHAR"), FBDatabaseMetaData.createShort(-2), FBDatabaseMetaData.createInt(Short.MAX_VALUE), null, null, null, TYPE_NULLABLE, CASESENSITIVE, TYPE_SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(452), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("BLOB SUB_TYPE TEXT"), FBDatabaseMetaData.createShort(-1), INT_ZERO, null, null, null, TYPE_NULLABLE, CASESENSITIVE, blobTypePred, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(520), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("CHAR"), FBDatabaseMetaData.createShort(1), FBDatabaseMetaData.createInt(Short.MAX_VALUE), FBDatabaseMetaData.getBytes("'"), FBDatabaseMetaData.getBytes("'"), FBDatabaseMetaData.getBytes("length"), TYPE_NULLABLE, CASESENSITIVE, TYPE_SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(452), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("NUMERIC"), FBDatabaseMetaData.createShort(2), NUMERIC_PRECISION, null, null, FBDatabaseMetaData.getBytes("precision,scale"), TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, NUMERIC_PRECISION, FBDatabaseMetaData.createInt(580), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("DECIMAL"), FBDatabaseMetaData.createShort(3), DECIMAL_PRECISION, null, null, FBDatabaseMetaData.getBytes("precision,scale"), TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, DECIMAL_PRECISION, FBDatabaseMetaData.createInt(580), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("INTEGER"), FBDatabaseMetaData.createShort(4), INTEGER_PRECISION, null, null, null, TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(496), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("SMALLINT"), FBDatabaseMetaData.createShort(5), SMALLINT_PRECISION, null, null, null, TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, SIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(500), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("FLOAT"), FBDatabaseMetaData.createShort(6), FLOAT_PRECISION, null, null, null, TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(482), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("DOUBLE PRECISION"), FBDatabaseMetaData.createShort(8), DOUBLE_PRECISION, null, null, null, TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, SIGNED, VARIABLESCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(480), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("VARCHAR"), FBDatabaseMetaData.createShort(12), FBDatabaseMetaData.createInt(32765), FBDatabaseMetaData.getBytes("'"), FBDatabaseMetaData.getBytes("'"), FBDatabaseMetaData.getBytes("length"), TYPE_NULLABLE, CASESENSITIVE, TYPE_SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(448), null, RADIX_TEN));
        if (this.getDatabaseMajorVersion() >= 3) {
            rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("BOOLEAN"), FBDatabaseMetaData.createShort(16), BOOLEAN_PRECISION, null, null, null, TYPE_NULLABLE, CASEINSENSITIVE, TYPE_PRED_BASIC, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(32764), null, RADIX_BINARY));
        }
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("DATE"), FBDatabaseMetaData.createShort(91), DATE_PRECISION, null, null, null, TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(570), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("TIME"), FBDatabaseMetaData.createShort(92), TIME_PRECISION, null, null, null, TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(560), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("TIMESTAMP"), FBDatabaseMetaData.createShort(93), TIMESTAMP_PRECISION, null, null, null, TYPE_NULLABLE, CASEINSENSITIVE, TYPE_SEARCHABLE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(510), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("ARRAY"), FBDatabaseMetaData.createShort(1111), INT_ZERO, null, null, null, TYPE_NULLABLE, CASESENSITIVE, TYPE_PRED_NONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(540), null, RADIX_TEN));
        rows.add(RowValue.of(rowDescriptor, FBDatabaseMetaData.getBytes("BLOB SUB_TYPE <0 "), FBDatabaseMetaData.createShort(2004), INT_ZERO, null, null, null, TYPE_NULLABLE, CASESENSITIVE, TYPE_PRED_NONE, UNSIGNED, FIXEDSCALE, NOTAUTOINC, null, SHORT_ZERO, SHORT_ZERO, FBDatabaseMetaData.createInt(520), null, RADIX_TEN));
        return new FBResultSet(rowDescriptor, rows);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(13, datatypeCoder).at(0).simple(448, 63, "TABLE_CAT", "INDEXINFO").addField().at(1).simple(448, 63, "TABLE_SCHEM", "INDEXINFO").addField().at(2).simple(448, 63, "TABLE_NAME", "INDEXINFO").addField().at(3).simple(452, 1, "NON_UNIQUE", "INDEXINFO").addField().at(4).simple(448, 63, "INDEX_QUALIFIER", "INDEXINFO").addField().at(5).simple(448, 63, "INDEX_NAME", "INDEXINFO").addField().at(6).simple(500, 0, "TYPE", "INDEXINFO").addField().at(7).simple(500, 0, "ORDINAL_POSITION", "INDEXINFO").addField().at(8).simple(448, Integer.MAX_VALUE, "COLUMN_NAME", "INDEXINFO").addField().at(9).simple(448, 31, "ASC_OR_DESC", "INDEXINFO").addField().at(10).simple(496, 0, "CARDINALITY", "INDEXINFO").addField().at(11).simple(496, 0, "PAGES", "INDEXINFO").addField().at(12).simple(448, 31, "FILTER_CONDITION", "INDEXINFO").addField().toRowDescriptor();
        List<String> params = Collections.singletonList(table);
        try (ResultSet rs = this.doQuery(GET_INDEX_INFO, params);){
            if (!rs.next()) {
                FBResultSet fBResultSet = new FBResultSet(rowDescriptor, Collections.emptyList());
                return fBResultSet;
            }
            ArrayList<RowValue> rows = new ArrayList<RowValue>();
            RowValueBuilder valueBuilder = new RowValueBuilder(rowDescriptor);
            do {
                boolean isNotUnique;
                boolean bl = isNotUnique = rs.getInt("UNIQUE_FLAG") == 0;
                if (unique && isNotUnique) continue;
                valueBuilder.at(2).set(FBDatabaseMetaData.getBytes(rs.getString("TABLE_NAME"))).at(3).set(isNotUnique ? TRUE_BYTES : FALSE_BYTES).at(5).set(FBDatabaseMetaData.getBytes(rs.getString("INDEX_NAME"))).at(6).set(TABLE_INDEX_OTHER);
                String columnName = rs.getString("COLUMN_NAME");
                if (rs.wasNull()) {
                    valueBuilder.at(7).set(SHORT_ONE);
                    String expressionSource = rs.getString("EXPRESSION_SOURCE");
                    if (expressionSource != null) {
                        valueBuilder.at(8).set(FBDatabaseMetaData.getBytes(expressionSource));
                    }
                } else {
                    valueBuilder.at(7).set(FBDatabaseMetaData.createShort(rs.getShort("ORDINAL_POSITION"))).at(8).set(FBDatabaseMetaData.getBytes(columnName));
                }
                int ascOrDesc = rs.getInt("ASC_OR_DESC");
                if (ascOrDesc == 0) {
                    valueBuilder.at(9).set(ASC_BYTES);
                } else if (ascOrDesc == 1) {
                    valueBuilder.at(9).set(DESC_BYTES);
                }
                rows.add(valueBuilder.toRowValue(true));
            } while (rs.next());
            FBResultSet fBResultSet = new FBResultSet(rowDescriptor, rows);
            return fBResultSet;
        }
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                return concurrency == 1007 || concurrency == 1008;
            }
        }
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        return 1004 == type || 1005 == type;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return true;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(7, datatypeCoder).at(0).simple(448, 63, "TYPE_CAT", "UDT").addField().at(1).simple(448, 63, "TYPE_SCHEM", "UDT").addField().at(2).simple(448, 31, "TYPE_NAME", "UDT").addField().at(3).simple(448, 31, "CLASS_NAME", "UDT").addField().at(4).simple(496, 0, "DATA_TYPE", "UDT").addField().at(5).simple(448, 31, "REMARKS", "UDT").addField().at(6).simple(500, 0, "BASE_TYPE", "UDT").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(21, datatypeCoder).at(0).simple(448, 63, "TYPE_CAT", "ATTRIBUTES").addField().at(1).simple(448, 63, "TYPE_SCHEM", "ATTRIBUTES").addField().at(2).simple(448, 31, "TYPE_NAME", "ATTRIBUTES").addField().at(3).simple(448, 31, "ATTR_NAME", "ATTRIBUTES").addField().at(4).simple(496, 0, "DATA_TYPE", "ATTRIBUTES").addField().at(5).simple(448, 31, "ATTR_TYPE_NAME", "ATTRIBUTES").addField().at(6).simple(496, 0, "ATTR_SIZE", "ATTRIBUTES").addField().at(7).simple(496, 0, "DECIMAL_DIGITS", "ATTRIBUTES").addField().at(8).simple(496, 0, "NUM_PREC_RADIX", "ATTRIBUTES").addField().at(9).simple(496, 0, "NULLABLE", "ATTRIBUTES").addField().at(10).simple(448, 80, "REMARKS", "ATTRIBUTES").addField().at(11).simple(448, 31, "ATTR_DEF", "ATTRIBUTES").addField().at(12).simple(496, 0, "SQL_DATA_TYPE", "ATTRIBUTES").addField().at(13).simple(496, 0, "SQL_DATETIME_SUB", "ATTRIBUTES").addField().at(14).simple(496, 0, "CHAR_OCTET_LENGTH", "ATTRIBUTES").addField().at(15).simple(500, 0, "ORDINAL_POSITION", "ATTRIBUTES").addField().at(16).simple(448, 31, "IS_NULLABLE", "ATTRIBUTES").addField().at(17).simple(448, 63, "SCOPE_CATALOG", "ATTRIBUTES").addField().at(18).simple(448, 63, "SCOPE_SCHEMA", "ATTRIBUTES").addField().at(19).simple(448, 63, "SCOPE_TABLE", "ATTRIBUTES").addField().at(20).simple(500, 0, "SOURCE_DATA_TYPE", "ATTRIBUTES").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return this.firebirdSupportInfo.supportsSavepoint();
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return AbstractGeneratedKeysQuery.isGeneratedKeysSupportLoaded() && this.firebirdSupportInfo.supportsInsertReturning();
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(6, datatypeCoder).at(0).simple(448, 63, "TYPE_CAT", "SUPERTYPES").addField().at(1).simple(448, 63, "TYPE_SCHEM", "SUPERTYPES").addField().at(2).simple(448, 31, "TYPE_NAME", "SUPERTYPES").addField().at(3).simple(448, 63, "SUPERTYPE_CAT", "SUPERTYPES").addField().at(4).simple(448, 63, "SUPERTYPE_SCHEM", "SUPERTYPES").addField().at(5).simple(448, 31, "SUPERTYPE_NAME", "SUPERTYPES").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(4, datatypeCoder).at(0).simple(448, 63, "TABLE_CAT", "SUPERTABLES").addField().at(1).simple(448, 63, "TABLE_SCHEM", "SUPERTABLES").addField().at(2).simple(448, 63, "TABLE_NAME", "SUPERTABLES").addField().at(3).simple(448, 63, "SUPERTABLE_NAME", "SUPERTABLES").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return holdability == 2 || holdability == 1;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 2;
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductMajorVersion();
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return this.gdsHelper.getDatabaseProductMinorVersion();
    }

    @Override
    public int getOdsMajorVersion() throws SQLException {
        return this.gdsHelper.getCurrentDatabase().getOdsMajor();
    }

    @Override
    public int getOdsMinorVersion() throws SQLException {
        return this.gdsHelper.getCurrentDatabase().getOdsMinor();
    }

    @Override
    public int getDatabaseDialect() throws SQLException {
        return this.gdsHelper.getCurrentDatabase().getDatabaseDialect();
    }

    @Override
    public int getConnectionDialect() throws SQLException {
        return this.gdsHelper.getCurrentDatabase().getConnectionDialect();
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(4, datatypeCoder).at(0).simple(448, 31, "NAME", "CLIENTINFO").addField().at(1).simple(496, 4, "MAX_LEN", "CLIENTINFO").addField().at(2).simple(448, 31, "DEFAULT", "CLIENTINFO").addField().at(3).simple(448, 31, "DESCRIPTION", "CLIENTINFO").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(17, datatypeCoder).at(0).simple(448, 63, "FUNCTION_CAT", "FUNCTION_COLUMNS").addField().at(1).simple(448, 63, "FUNCTION_SCHEM", "FUNCTION_COLUMNS").addField().at(2).simple(448, 63, "FUNCTION_NAME", "FUNCTION_COLUMNS").addField().at(3).simple(448, 63, "COLUMN_NAME", "FUNCTION_COLUMNS").addField().at(4).simple(500, 0, "COLUMN_TYPE", "FUNCTION_COLUMNS").addField().at(5).simple(496, 0, "DATA_TYPE", "FUNCTION_COLUMNS").addField().at(6).simple(448, 31, "TYPE_NAME", "FUNCTION_COLUMNS").addField().at(7).simple(496, 0, "PRECISION", "FUNCTION_COLUMNS").addField().at(8).simple(496, 0, "LENGTH", "FUNCTION_COLUMNS").addField().at(9).simple(500, 0, "SCALE", "FUNCTION_COLUMNS").addField().at(10).simple(500, 0, "RADIX", "FUNCTION_COLUMNS").addField().at(11).simple(500, 0, "NULLABLE", "FUNCTION_COLUMNS").addField().at(12).simple(448, 80, "REMARKS", "FUNCTION_COLUMNS").addField().at(13).simple(496, 0, "CHAR_OCTET_LENGTH", "FUNCTION_COLUMNS").addField().at(14).simple(496, 0, "ORDINAL_POSITION", "FUNCTION_COLUMNS").addField().at(15).simple(448, 31, "IS_NULLABLE", "FUNCTION_COLUMNS").addField().at(16).simple(448, 63, "SPECIFIC_NAME", "FUNCTION_COLUMNS").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(6, datatypeCoder).at(0).simple(448, 63, "FUNCTION_CAT", "FUNCTIONS").addField().at(1).simple(448, 63, "FUNCTION_SCHEM", "FUNCTIONS").addField().at(2).simple(448, 63, "FUNCTION_NAME", "FUNCTIONS").addField().at(3).simple(448, 80, "REMARKS", "FUNCTIONS").addField().at(4).simple(500, 0, "FUNCTION_TYPE", "FUNCTIONS").addField().at(5).simple(448, 63, "SPECIFIC_NAME", "FUNCTIONS").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        RowDescriptor rowDescriptor = new RowDescriptorBuilder(2, datatypeCoder).at(0).simple(448, 63, "TABLE_SCHEM", "TABLESCHEMAS").addField().at(1).simple(448, 63, "TABLE_CATALOG", "TABLESCHEMAS").addField().toRowDescriptor();
        return new FBResultSet(rowDescriptor, Collections.emptyList());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface.isAssignableFrom(FBDatabaseMetaData.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Unable to unwrap to class " + iface.getName());
        }
        return iface.cast(this);
    }

    protected static boolean isAllCondition(String pattern) {
        return pattern == null || "%".equals(pattern);
    }

    public static boolean hasNoWildcards(String pattern) {
        if (pattern == null) {
            return true;
        }
        for (int pos = 0; pos < pattern.length(); ++pos) {
            char nextCh;
            char ch = pattern.charAt(pos);
            if (ch == '_' || ch == '%') {
                return false;
            }
            if (ch != '\\' || pos >= pattern.length() - 1 || (nextCh = pattern.charAt(pos + 1)) != '\\' && nextCh != '%' && nextCh != '_') continue;
            ++pos;
        }
        return true;
    }

    public static String stripEscape(String pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuilder stripped = new StringBuilder(pattern.length());
        for (int pos = 0; pos < pattern.length(); ++pos) {
            char ch = pattern.charAt(pos);
            if (ch != '\\') {
                stripped.append(ch);
                continue;
            }
            if (pos >= pattern.length() - 1 || pattern.charAt(pos + 1) != '\\') continue;
            stripped.append('\\');
            ++pos;
        }
        return stripped.toString();
    }

    public static String escapeWildcards(String objectName) {
        return objectName != null ? objectName.replaceAll("([\\\\_%])", "\\\\$1") : null;
    }

    protected String getWantsSystemTables(String[] types) {
        for (String type : types) {
            if (!SYSTEM_TABLE.equals(type)) continue;
            return "T";
        }
        return "F";
    }

    protected String getWantsTables(String[] types) {
        for (String type : types) {
            if (!TABLE.equals(type)) continue;
            return "T";
        }
        return "F";
    }

    protected String getWantsViews(String[] types) {
        for (String type : types) {
            if (!VIEW.equals(type)) continue;
            return "T";
        }
        return "F";
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new FBDriverNotCapableException();
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        return false;
    }

    @Override
    public String getProcedureSourceCode(String procedureName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$PROCEDURE_SOURCE From RDB$PROCEDURES Where RDB$PROCEDURE_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(procedureName);
        try (ResultSet rs = this.doQuery(sql, params);){
            if (rs.next()) {
                sResult = rs.getString(1);
            }
        }
        return sResult;
    }

    @Override
    public String getTriggerSourceCode(String triggerName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$TRIGGER_SOURCE From RDB$TRIGGERS Where RDB$TRIGGER_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(triggerName);
        try (ResultSet rs = this.doQuery(sql, params);){
            if (rs.next()) {
                sResult = rs.getString(1);
            }
        }
        return sResult;
    }

    @Override
    public String getViewSourceCode(String viewName) throws SQLException {
        String sResult = null;
        String sql = "Select RDB$VIEW_SOURCE From RDB$RELATIONS Where RDB$RELATION_NAME = ?";
        ArrayList<String> params = new ArrayList<String>();
        params.add(viewName);
        try (ResultSet rs = this.doQuery(sql, params);){
            if (rs.next()) {
                sResult = rs.getString(1);
            }
        }
        return sResult;
    }

    protected static byte[] getBytes(String value) {
        return value != null ? value.getBytes(StandardCharsets.UTF_8) : null;
    }

    private FBPreparedStatement getStatement(String sql, boolean standalone) throws SQLException {
        FBPreparedStatement s = this.statements.get(sql);
        if (s != null) {
            if (s.isClosed()) {
                this.statements.remove(sql);
            } else {
                return s;
            }
        }
        InternalTransactionCoordinator.MetaDataTransactionCoordinator metaDataTransactionCoordinator = new InternalTransactionCoordinator.MetaDataTransactionCoordinator(this.connection.txCoordinator);
        s = new FBPreparedStatement(this.gdsHelper, sql, 1004, 1007, 2, metaDataTransactionCoordinator, metaDataTransactionCoordinator, true, standalone, false);
        if (!standalone) {
            this.statements.put(sql, s);
        }
        return s;
    }

    protected ResultSet doQuery(String sql, List<String> params) throws SQLException {
        return this.doQuery(sql, params, false);
    }

    protected ResultSet doQuery(String sql, List<String> params, boolean standalone) throws SQLException {
        FBPreparedStatement s = this.getStatement(sql, standalone);
        for (int i = 0; i < params.size(); ++i) {
            s.setStringForced(i + 1, params.get(i));
        }
        return s.executeMetaDataQuery();
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        return JDBC_MINOR_VERSION;
    }

    private static String getSystemPropertyPrivileged(final String propertyName) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName);
            }
        });
    }

    static {
        HashMap<String, byte[]> tempMapping = new HashMap<String, byte[]>(7);
        tempMapping.put("A", FBDatabaseMetaData.getBytes("ALL"));
        tempMapping.put("S", FBDatabaseMetaData.getBytes("SELECT"));
        tempMapping.put("D", FBDatabaseMetaData.getBytes("DELETE"));
        tempMapping.put("I", FBDatabaseMetaData.getBytes("INSERT"));
        tempMapping.put("U", FBDatabaseMetaData.getBytes("UPDATE"));
        tempMapping.put("R", FBDatabaseMetaData.getBytes("REFERENCE"));
        tempMapping.put("M", FBDatabaseMetaData.getBytes("MEMBEROF"));
        PRIVILEGE_MAPPING = Collections.unmodifiableMap(tempMapping);
        HashMap<String, byte[]> tempMap = new HashMap<String, byte[]>();
        tempMap.put("NO ACTION", IMPORTED_KEY_NO_ACTION);
        tempMap.put("RESTRICT", IMPORTED_KEY_NO_ACTION);
        tempMap.put("CASCADE", IMPORTED_KEY_CASCADE);
        tempMap.put("SET NULL", IMPORTED_KEY_SET_NULL);
        tempMap.put("SET DEFAULT", IMPORTED_KEY_SET_DEFAULT);
        ACTION_MAPPING = Collections.unmodifiableMap(tempMap);
        int tempVersion = 1;
        try {
            String javaImplementation = FBDatabaseMetaData.getSystemPropertyPrivileged("java.specification.version");
            if (javaImplementation != null) {
                if ("9".compareTo(javaImplementation) <= 0) {
                    tempVersion = 3;
                } else if ("1.8".compareTo(javaImplementation) <= 0) {
                    tempVersion = 2;
                } else if ("1.7".compareTo(javaImplementation) <= 0) {
                    tempVersion = 1;
                }
            }
        }
        catch (RuntimeException ex) {
            tempVersion = 1;
        }
        JDBC_MINOR_VERSION = tempVersion;
    }

    protected static final class Clause {
        private final String condition;
        private final String value;

        public Clause(String columnName, String pattern) {
            if (FBDatabaseMetaData.isAllCondition(pattern)) {
                this.condition = "";
                this.value = null;
            } else if (FBDatabaseMetaData.hasNoWildcards(pattern)) {
                this.value = FBDatabaseMetaData.stripEscape(pattern);
                this.condition = "CAST(" + columnName + " AS VARCHAR(" + 73 + ")) = ? and ";
            } else {
                this.value = pattern + FBDatabaseMetaData.SPACES_15 + "%";
                this.condition = columnName + " || '" + FBDatabaseMetaData.SPACES_31 + "' like ? escape '\\' and ";
            }
        }

        public String getCondition() {
            return this.condition;
        }

        public String getValue() {
            return this.value;
        }

        public boolean hasCondition() {
            return !this.condition.isEmpty();
        }
    }
}

