/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.FbStatement;
import org.firebirdsql.gds.ng.fields.RowValue;
import org.firebirdsql.gds.ng.listeners.DefaultStatementListener;
import org.firebirdsql.jdbc.CompletionReason;
import org.firebirdsql.jdbc.FBFetcher;
import org.firebirdsql.jdbc.FBObjectListener;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.Synchronizable;

class FBStatementFetcher
implements FBFetcher {
    private boolean closed;
    private boolean wasFetched;
    protected final GDSHelper gdsHelper;
    protected final FBObjectListener.FetcherListener fetcherListener;
    protected final int maxRows;
    protected int fetchSize;
    protected final Synchronizable syncProvider;
    protected final FbStatement stmt;
    private List<RowValue> rows = new ArrayList<RowValue>();
    private final RowListener rowListener = new RowListener();
    private boolean allRowsFetched;
    protected RowValue _nextRow;
    private int rowNum = 0;
    private int rowPosition = 0;
    private boolean isEmpty = false;
    private boolean isBeforeFirst = false;
    private boolean isFirst = false;
    private boolean isLast = false;
    private boolean isAfterLast = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FBStatementFetcher(GDSHelper gdsHelper, Synchronizable syncProvider, FbStatement stmth, FBObjectListener.FetcherListener fetcherListener, int maxRows, int fetchSize) throws SQLException {
        this.gdsHelper = gdsHelper;
        this.stmt = stmth;
        this.stmt.addStatementListener(this.rowListener);
        this.syncProvider = syncProvider;
        this.fetcherListener = fetcherListener;
        this.maxRows = maxRows;
        this.fetchSize = fetchSize;
        Object object = syncProvider.getSynchronizationObject();
        synchronized (object) {
            this.isEmpty = false;
            this.isBeforeFirst = false;
            this.isFirst = false;
            this.isLast = false;
            this.isAfterLast = false;
            this.allRowsFetched = false;
        }
    }

    protected RowValue getNextRow() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this._nextRow;
    }

    protected void setNextRow(RowValue nextRow) {
        this._nextRow = nextRow;
        if (!this.wasFetched) {
            this.wasFetched = true;
            if (this._nextRow == null) {
                this.isEmpty = true;
            } else {
                this.isBeforeFirst = true;
            }
        }
    }

    @Override
    public boolean next() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        this.setIsBeforeFirst(false);
        this.setIsFirst(false);
        this.setIsLast(false);
        this.setIsAfterLast(false);
        if (this.isEmpty()) {
            return false;
        }
        if (this.getNextRow() == null || this.maxRows != 0 && this.getRowNum() == this.maxRows) {
            this.setIsAfterLast(true);
            this.allRowsFetched = true;
            this.fetcherListener.allRowsFetched(this);
            this.setRowNum(0);
            return false;
        }
        this.fetcherListener.rowChanged(this, this.getNextRow());
        this.fetch();
        this.setRowNum(this.getRowNum() + 1);
        if (this.getRowNum() == 1) {
            this.setIsFirst(true);
        }
        if (this.getNextRow() == null || this.maxRows != 0 && this.getRowNum() == this.maxRows) {
            this.setIsLast(true);
        }
        return true;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.notScrollable();
        return false;
    }

    @Override
    public boolean first() throws SQLException {
        this.notScrollable();
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.notScrollable();
        return false;
    }

    @Override
    public boolean previous() throws SQLException {
        this.notScrollable();
        return false;
    }

    @Override
    public boolean relative(int row) throws SQLException {
        this.notScrollable();
        return false;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.notScrollable();
    }

    @Override
    public void afterLast() throws SQLException {
        this.notScrollable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetch() throws SQLException {
        Object object = this.syncProvider.getSynchronizationObject();
        synchronized (object) {
            int fetchSize;
            this.checkClosed();
            int maxRows = 0;
            if (this.maxRows != 0) {
                maxRows = this.maxRows - this.rowNum;
            }
            if ((fetchSize = this.fetchSize) == 0) {
                fetchSize = 400;
            }
            if (maxRows != 0 && fetchSize > maxRows) {
                fetchSize = maxRows;
            }
            if (!this.allRowsFetched && (this.rows.isEmpty() || this.rows.size() == this.rowPosition)) {
                this.rows.clear();
                this.stmt.fetchRows(fetchSize);
                this.rowPosition = 0;
            }
            if (this.rows.size() > this.rowPosition) {
                this.setNextRow(this.rows.get(this.rowPosition));
                this.rows.set(this.rowPosition, null);
                ++this.rowPosition;
            } else {
                this.setNextRow(null);
            }
        }
    }

    @Override
    public void close() throws SQLException {
        this.close(CompletionReason.OTHER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(CompletionReason completionReason) throws SQLException {
        this.closed = true;
        try {
            this.stmt.closeCursor(completionReason.isTransactionEnd());
        }
        finally {
            this.stmt.removeStatementListener(this.rowListener);
            this.rows = Collections.emptyList();
            this.fetcherListener.fetcherClosed(this);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.closed) {
            throw new FBSQLException("Result set is already closed.");
        }
    }

    @Override
    public int getRowNum() {
        return this.rowNum;
    }

    public void setRowNum(int rowNumValue) {
        this.rowNum = rowNumValue;
    }

    @Override
    public boolean isEmpty() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isEmpty;
    }

    public void setIsEmpty(boolean isEmptyValue) {
        this.isEmpty = isEmptyValue;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isBeforeFirst;
    }

    public void setIsBeforeFirst(boolean isBeforeFirstValue) {
        this.isBeforeFirst = isBeforeFirstValue;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isFirst;
    }

    public void setIsFirst(boolean isFirstValue) {
        this.isFirst = isFirstValue;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isLast;
    }

    public void setIsLast(boolean isLastValue) {
        this.isLast = isLastValue;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (!this.wasFetched) {
            this.fetch();
        }
        return this.isAfterLast;
    }

    public void setIsAfterLast(boolean isAfterLastValue) {
        this.isAfterLast = isAfterLastValue;
    }

    @Override
    public void deleteRow() throws SQLException {
    }

    @Override
    public void insertRow(RowValue data) throws SQLException {
    }

    @Override
    public void updateRow(RowValue data) throws SQLException {
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    private void notScrollable() throws SQLException {
        throw new FbExceptionBuilder().nonTransientException(337248279).toFlatSQLException();
    }

    private class RowListener
    extends DefaultStatementListener {
        private RowListener() {
        }

        @Override
        public void receivedRow(FbStatement sender, RowValue rowValue) {
            FBStatementFetcher.this.rows.add(rowValue);
        }

        @Override
        public void allRowsFetched(FbStatement sender) {
            FBStatementFetcher.this.allRowsFetched = true;
        }
    }
}

