/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.ng.wire.version11;

import java.io.IOException;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.WarningMessageCallback;
import org.firebirdsql.gds.ng.wire.DeferredAction;
import org.firebirdsql.gds.ng.wire.ProtocolDescriptor;
import org.firebirdsql.gds.ng.wire.Response;
import org.firebirdsql.gds.ng.wire.WireDatabaseConnection;
import org.firebirdsql.gds.ng.wire.version10.V10Database;

public class V11Database
extends V10Database {
    protected V11Database(WireDatabaseConnection connection, ProtocolDescriptor descriptor) {
        super(connection, descriptor);
    }

    @Override
    public final void enqueueDeferredAction(DeferredAction deferredAction) {
        this.wireOperations.enqueueDeferredAction(deferredAction);
    }

    @Override
    public void releaseObject(int operation, int objectId) throws SQLException {
        this.checkAttached();
        Object object = this.getSynchronizationObject();
        synchronized (object) {
            try {
                this.doReleaseObjectPacket(operation, objectId);
                switch (operation) {
                    case 38: 
                    case 39: {
                        this.enqueueDeferredAction(new DeferredAction(){

                            @Override
                            public void processResponse(Response response) {
                                V11Database.this.processReleaseObjectResponse(response);
                            }

                            @Override
                            public WarningMessageCallback getWarningMessageCallback() {
                                return null;
                            }
                        });
                        return;
                    }
                }
                throw new IllegalArgumentException(String.format("Unexpected operation in V11Databsase.releaseObject: %d", operation));
            }
            catch (IOException ex) {
                throw new FbExceptionBuilder().exception(335544727).cause(ex).toSQLException();
            }
        }
    }
}

