/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.dmn.rest.service.api.repository;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.query.Query;
import org.flowable.common.engine.api.query.QueryProperty;
import org.flowable.common.rest.api.DataResponse;
import org.flowable.common.rest.api.PaginateListUtil;
import org.flowable.dmn.api.DmnDeployment;
import org.flowable.dmn.api.DmnDeploymentBuilder;
import org.flowable.dmn.api.DmnDeploymentQuery;
import org.flowable.dmn.api.DmnRepositoryService;
import org.flowable.dmn.engine.impl.DeploymentQueryProperty;
import org.flowable.dmn.engine.impl.deployer.DmnResourceUtil;
import org.flowable.dmn.rest.service.api.DmnRestApiInterceptor;
import org.flowable.dmn.rest.service.api.DmnRestResponseFactory;
import org.flowable.dmn.rest.service.api.repository.DmnDeploymentResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Api(tags={"Deployment"}, description="Manage Decision Deployments", authorizations={@Authorization(value="basicAuth")})
public class DmnDeploymentCollectionResource {
    private static Map<String, QueryProperty> allowedSortProperties = new HashMap<String, QueryProperty>();
    @Autowired
    protected DmnRestResponseFactory dmnRestResponseFactory;
    @Autowired
    protected DmnRepositoryService dmnRepositoryService;
    @Autowired(required=false)
    protected DmnRestApiInterceptor restApiInterceptor;

    @ApiOperation(value="List of decision deployments", tags={"Deployment"}, nickname="listDecisionDeployments")
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", dataType="string", value="Only return decision deployments with the given name.", paramType="query"), @ApiImplicitParam(name="nameLike", dataType="string", value="Only return decision deployments with a name like the given name.", paramType="query"), @ApiImplicitParam(name="category", dataType="string", value="Only return decision deployments with the given category.", paramType="query"), @ApiImplicitParam(name="categoryNotEquals", dataType="string", value="Only return decision deployments which do not have the given category.", paramType="query"), @ApiImplicitParam(name="parentDeploymentId", dataType="string", value="Only return decision deployments with the given parent deployment id.", paramType="query"), @ApiImplicitParam(name="parentDeploymentIdLike", dataType="string", value="Only return decision deployments with a parent deployment id like the given value.", paramType="query"), @ApiImplicitParam(name="tenantId", dataType="string", value="Only return decision deployments with the given tenantId.", paramType="query"), @ApiImplicitParam(name="tenantIdLike", dataType="string", value="Only return decision deployments with a tenantId like the given value.", paramType="query"), @ApiImplicitParam(name="withoutTenantId", dataType="boolean", value="If true, only returns decision deployments without a tenantId set. If false, the withoutTenantId parameter is ignored.", paramType="query"), @ApiImplicitParam(name="sort", dataType="string", value="Property to sort on, to be used together with the order.", allowableValues="id,name,deployTime,tenantId", paramType="query")})
    @ApiResponses(value={@ApiResponse(code=200, message="Indicates the request was successful.")})
    @GetMapping(value={"/dmn-repository/deployments"}, produces={"application/json"})
    public DataResponse<DmnDeploymentResponse> getDeployments(@ApiParam(hidden=true) @RequestParam Map<String, String> allRequestParams) {
        boolean withoutTenantId;
        DmnDeploymentQuery deploymentQuery = this.dmnRepositoryService.createDeploymentQuery();
        if (allRequestParams.containsKey("name")) {
            deploymentQuery.deploymentName(allRequestParams.get("name"));
        }
        if (allRequestParams.containsKey("nameLike")) {
            deploymentQuery.deploymentNameLike(allRequestParams.get("nameLike"));
        }
        if (allRequestParams.containsKey("category")) {
            deploymentQuery.deploymentCategory(allRequestParams.get("category"));
        }
        if (allRequestParams.containsKey("categoryNotEquals")) {
            deploymentQuery.deploymentCategoryNotEquals(allRequestParams.get("categoryNotEquals"));
        }
        if (allRequestParams.containsKey("parentDeploymentId")) {
            deploymentQuery.parentDeploymentId(allRequestParams.get("parentDeploymentId"));
        }
        if (allRequestParams.containsKey("parentDeploymentIdLike")) {
            deploymentQuery.parentDeploymentIdLike(allRequestParams.get("parentDeploymentIdLike"));
        }
        if (allRequestParams.containsKey("tenantId")) {
            deploymentQuery.deploymentTenantId(allRequestParams.get("tenantId"));
        }
        if (allRequestParams.containsKey("tenantIdLike")) {
            deploymentQuery.deploymentTenantIdLike(allRequestParams.get("tenantIdLike"));
        }
        if (allRequestParams.containsKey("withoutTenantId") && (withoutTenantId = Boolean.parseBoolean(allRequestParams.get("withoutTenantId")))) {
            deploymentQuery.deploymentWithoutTenantId();
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.accessDeploymentsWithQuery(deploymentQuery);
        }
        return PaginateListUtil.paginateList(allRequestParams, (Query)deploymentQuery, (String)"id", allowedSortProperties, this.dmnRestResponseFactory::createDmnDeploymentResponseList);
    }

    @ApiOperation(value="Create a new decision deployment", nickname="uploadDecisionDeployment", tags={"Deployment"}, consumes="multipart/form-data", produces="application/json", notes="The request body should contain data of type multipart/form-data. There should be exactly one file in the request, any additional files will be ignored. The deployment name is the name of the file-field passed in. If multiple resources need to be deployed in a single deployment, compress the resources in a zip and make sure the file-name ends with .bar or .zip.\n\nAn additional parameter (form-field) can be passed in the request body with name tenantId. The value of this field will be used as the id of the tenant this deployment is done in.")
    @ApiResponses(value={@ApiResponse(code=201, message="Indicates the deployment was created."), @ApiResponse(code=400, message="Indicates there was no content present in the request body or the content mime-type is not supported for deployment. The status-description contains additional information.")})
    @ApiImplicitParams(value={@ApiImplicitParam(name="file", paramType="form", dataType="java.io.File")})
    @PostMapping(value={"/dmn-repository/deployments"}, produces={"application/json"}, consumes={"multipart/form-data"})
    public DmnDeploymentResponse uploadDeployment(@ApiParam(name="tenantId") @RequestParam(value="tenantId", required=false) String tenantId, HttpServletRequest request, HttpServletResponse response) {
        MultipartHttpServletRequest multipartRequest;
        if (!(request instanceof MultipartHttpServletRequest)) {
            throw new FlowableIllegalArgumentException("Multipart request is required");
        }
        if (this.restApiInterceptor != null) {
            this.restApiInterceptor.executeNewDeploymentForTenantId(tenantId);
        }
        if ((multipartRequest = (MultipartHttpServletRequest)request).getFileMap().size() == 0) {
            throw new FlowableIllegalArgumentException("Multipart request with file content is required");
        }
        MultipartFile file = (MultipartFile)multipartRequest.getFileMap().values().iterator().next();
        try {
            DmnDeploymentBuilder deploymentBuilder = this.dmnRepositoryService.createDeployment();
            String fileName = file.getOriginalFilename();
            if (StringUtils.isEmpty((CharSequence)fileName) || !DmnResourceUtil.isDmnResource((String)fileName)) {
                fileName = file.getName();
            }
            if (!DmnResourceUtil.isDmnResource((String)fileName)) {
                throw new FlowableIllegalArgumentException("File must be of type .dmn");
            }
            deploymentBuilder.addInputStream(fileName, file.getInputStream());
            deploymentBuilder.name(fileName);
            if (tenantId != null) {
                deploymentBuilder.tenantId(tenantId);
            }
            if (this.restApiInterceptor != null) {
                this.restApiInterceptor.enhanceDeployment(deploymentBuilder);
            }
            DmnDeployment deployment = deploymentBuilder.deploy();
            response.setStatus(HttpStatus.CREATED.value());
            return this.dmnRestResponseFactory.createDmnDeploymentResponse(deployment);
        }
        catch (Exception e) {
            if (e instanceof FlowableException) {
                throw (FlowableException)e;
            }
            throw new FlowableException(e.getMessage(), (Throwable)e);
        }
    }

    static {
        allowedSortProperties.put("id", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_ID);
        allowedSortProperties.put("name", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_NAME);
        allowedSortProperties.put("deployTime", (QueryProperty)DeploymentQueryProperty.DEPLOY_TIME);
        allowedSortProperties.put("tenantId", (QueryProperty)DeploymentQueryProperty.DEPLOYMENT_TENANT_ID);
    }
}

