/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.eventregistry;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.runtime.ProcessInstanceBuilder;
import org.flowable.eventregistry.api.runtime.EventInstance;
import org.flowable.eventregistry.impl.consumer.BaseEventRegistryEventConsumer;
import org.flowable.eventregistry.impl.consumer.CorrelationKey;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.api.EventSubscriptionQuery;
import org.flowable.eventsubscription.service.impl.EventSubscriptionQueryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BpmnEventRegistryEventConsumer
extends BaseEventRegistryEventConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BpmnEventRegistryEventConsumer.class);
    protected ProcessEngineConfigurationImpl processEngineConfiguration;

    public BpmnEventRegistryEventConsumer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super((AbstractEngineConfiguration)processEngineConfiguration);
        this.processEngineConfiguration = processEngineConfiguration;
    }

    public String getConsumerKey() {
        return "bpmnEventConsumer";
    }

    protected void eventReceived(EventInstance eventInstance) {
        Collection correlationKeys = this.generateCorrelationKeys(eventInstance.getCorrelationParameterInstances());
        List eventSubscriptions = this.findEventSubscriptions("bpmn", eventInstance, correlationKeys);
        RuntimeService runtimeService = this.processEngineConfiguration.getRuntimeService();
        for (EventSubscription eventSubscription : eventSubscriptions) {
            this.handleEventSubscription(runtimeService, eventSubscription, eventInstance, correlationKeys);
        }
    }

    protected void handleEventSubscription(RuntimeService runtimeService, EventSubscription eventSubscription, EventInstance eventInstance, Collection<CorrelationKey> correlationKeys) {
        if (eventSubscription.getExecutionId() != null) {
            HashMap<String, Object> transientVariableMap = new HashMap<String, Object>();
            transientVariableMap.put("eventInstance", eventInstance);
            runtimeService.trigger(eventSubscription.getExecutionId(), null, transientVariableMap);
        } else if (eventSubscription.getProcessDefinitionId() != null && eventSubscription.getProcessInstanceId() == null && eventSubscription.getExecutionId() == null) {
            String startCorrelationConfiguration;
            ProcessInstanceBuilder processInstanceBuilder = runtimeService.createProcessInstanceBuilder().processDefinitionId(eventSubscription.getProcessDefinitionId()).transientVariable("eventInstance", eventInstance);
            if (eventInstance.getTenantId() != null && !Objects.equals("", eventInstance.getTenantId())) {
                processInstanceBuilder.overrideProcessDefinitionTenantId(eventInstance.getTenantId());
            }
            if (correlationKeys != null && Objects.equals(startCorrelationConfiguration = this.getStartCorrelationConfiguration(eventSubscription), "storeAsUniqueReferenceId")) {
                CorrelationKey correlationKeyWithAllParameters = this.getCorrelationKeyWithAllParameters(correlationKeys);
                long processInstanceCount = runtimeService.createProcessInstanceQuery().processDefinitionId(eventSubscription.getProcessDefinitionId()).processInstanceReferenceId(correlationKeyWithAllParameters.getValue()).processInstanceReferenceType("event-to-bpmn-2.0-process").count();
                if (processInstanceCount > 0L) {
                    LOGGER.debug("Event received to start a new process instance, but a unique instance already exists.");
                    return;
                }
                processInstanceBuilder.referenceId(correlationKeyWithAllParameters.getValue());
                processInstanceBuilder.referenceType("event-to-bpmn-2.0-process");
            }
            processInstanceBuilder.startAsync();
        }
    }

    protected String getStartCorrelationConfiguration(EventSubscription eventSubscription) {
        BpmnModel bpmnModel = this.processEngineConfiguration.getRepositoryService().getBpmnModel(eventSubscription.getProcessDefinitionId());
        if (bpmnModel != null) {
            List startEvents = bpmnModel.getMainProcess().findFlowElementsOfType(StartEvent.class);
            for (StartEvent startEvent : startEvents) {
                List correlationCfgExtensions;
                List eventTypes = (List)startEvent.getExtensionElements().get("eventType");
                if (eventTypes == null || eventTypes.isEmpty() || !Objects.equals(eventSubscription.getEventType(), ((ExtensionElement)eventTypes.get(0)).getElementText()) || (correlationCfgExtensions = startEvent.getExtensionElements().getOrDefault("startEventCorrelationConfiguration", Collections.emptyList())).isEmpty()) continue;
                return ((ExtensionElement)correlationCfgExtensions.get(0)).getElementText();
            }
        }
        return null;
    }

    protected EventSubscriptionQuery createEventSubscriptionQuery() {
        return new EventSubscriptionQueryImpl(this.commandExecutor, this.processEngineConfiguration.getEventSubscriptionServiceConfiguration());
    }
}

