/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.history.async.json.transformer;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.history.async.json.transformer.AbstractNeedsProcessInstanceHistoryJsonTransformer;
import org.flowable.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.flowable.job.service.impl.history.async.util.AsyncHistoryJsonUtil;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;

public class ProcessInstancePropertyChangedHistoryJsonTransformer
extends AbstractNeedsProcessInstanceHistoryJsonTransformer {
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_BUSINESS_KEY = "businessKey";

    public ProcessInstancePropertyChangedHistoryJsonTransformer(ProcessEngineConfigurationImpl processEngineConfiguration) {
        super(processEngineConfiguration);
    }

    public List<String> getTypes() {
        return Collections.singletonList("process-instance-property-changed");
    }

    public void transformJson(HistoryJobEntity job, ObjectNode historicalData, CommandContext commandContext) {
        String processInstanceId = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"processInstanceId");
        String property = AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)"property");
        if (StringUtils.isNotEmpty((CharSequence)processInstanceId) && StringUtils.isNotEmpty((CharSequence)property)) {
            HistoricProcessInstanceEntity historicProcessInstance = (HistoricProcessInstanceEntity)this.processEngineConfiguration.getHistoricProcessInstanceEntityManager().findById(processInstanceId);
            if (PROPERTY_NAME.equals(property)) {
                historicProcessInstance.setName(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)PROPERTY_NAME));
            } else if (PROPERTY_BUSINESS_KEY.equals(property)) {
                historicProcessInstance.setBusinessKey(AsyncHistoryJsonUtil.getStringFromJson((ObjectNode)historicalData, (String)PROPERTY_BUSINESS_KEY));
            }
        }
    }
}

