/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.dynamic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.flowable.bpmn.model.Activity;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BoundaryEvent;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.CallActivity;
import org.flowable.bpmn.model.CompensateEventDefinition;
import org.flowable.bpmn.model.EventDefinition;
import org.flowable.bpmn.model.EventSubProcess;
import org.flowable.bpmn.model.ExtensionElement;
import org.flowable.bpmn.model.ExternalWorkerServiceTask;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowElementsContainer;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.MessageEventDefinition;
import org.flowable.bpmn.model.MultiInstanceLoopCharacteristics;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.ServiceTask;
import org.flowable.bpmn.model.Signal;
import org.flowable.bpmn.model.SignalEventDefinition;
import org.flowable.bpmn.model.StartEvent;
import org.flowable.bpmn.model.SubProcess;
import org.flowable.bpmn.model.Task;
import org.flowable.bpmn.model.TimerEventDefinition;
import org.flowable.bpmn.model.UserTask;
import org.flowable.bpmn.model.ValuedDataObject;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.delegate.Expression;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.util.CollectionUtil;
import org.flowable.engine.ManagementService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.event.impl.FlowableEventBuilder;
import org.flowable.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.flowable.engine.impl.delegate.ActivityBehavior;
import org.flowable.engine.impl.dynamic.EnableActivityContainer;
import org.flowable.engine.impl.dynamic.MoveExecutionEntityContainer;
import org.flowable.engine.impl.dynamic.ProcessInstanceChangeState;
import org.flowable.engine.impl.event.EventDefinitionExpressionUtil;
import org.flowable.engine.impl.jobexecutor.TimerEventHandler;
import org.flowable.engine.impl.persistence.deploy.DeploymentManager;
import org.flowable.engine.impl.persistence.entity.ExecutionEntity;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityManager;
import org.flowable.engine.impl.persistence.entity.ProcessDefinitionEntityManager;
import org.flowable.engine.impl.runtime.ChangeActivityStateBuilderImpl;
import org.flowable.engine.impl.runtime.EnableActivityIdContainer;
import org.flowable.engine.impl.runtime.MoveActivityIdContainer;
import org.flowable.engine.impl.runtime.MoveExecutionIdContainer;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.engine.impl.util.CountingEntityUtil;
import org.flowable.engine.impl.util.EntityLinkUtil;
import org.flowable.engine.impl.util.Flowable5Util;
import org.flowable.engine.impl.util.IOParameterUtil;
import org.flowable.engine.impl.util.JobUtil;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.engine.impl.util.ProcessInstanceHelper;
import org.flowable.engine.impl.util.TaskHelper;
import org.flowable.engine.impl.util.TimerUtil;
import org.flowable.engine.interceptor.MigrationContext;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.Execution;
import org.flowable.eventsubscription.api.EventSubscription;
import org.flowable.eventsubscription.service.EventSubscriptionService;
import org.flowable.eventsubscription.service.impl.persistence.entity.EventSubscriptionEntity;
import org.flowable.job.api.DeadLetterJobQuery;
import org.flowable.job.api.ExternalWorkerJobQuery;
import org.flowable.job.api.SuspendedJobQuery;
import org.flowable.job.api.TimerJobQuery;
import org.flowable.job.service.JobService;
import org.flowable.job.service.TimerJobService;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntityImpl;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntityImpl;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntityImpl;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntityImpl;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.service.TaskService;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDynamicStateManager {
    protected final Logger LOGGER = LoggerFactory.getLogger(this.getClass());

    public List<MoveExecutionEntityContainer> resolveMoveExecutionEntityContainers(ChangeActivityStateBuilderImpl changeActivityStateBuilder, Map<String, Object> variables, CommandContext commandContext) {
        ArrayList<MoveExecutionEntityContainer> moveExecutionEntityContainerList = new ArrayList<MoveExecutionEntityContainer>();
        if (changeActivityStateBuilder.getMoveExecutionIdList().size() > 0) {
            for (MoveExecutionIdContainer executionContainer : changeActivityStateBuilder.getMoveExecutionIdList()) {
                HashMap<String, List> executionsByParent = new HashMap<String, List>();
                HashMap<String, List> miExecutionsByParent = new HashMap<String, List>();
                for (String executionId : executionContainer.getExecutionIds()) {
                    ExecutionEntity execution = this.resolveActiveExecution(executionId, commandContext);
                    List executionEntities = !execution.isMultiInstanceRoot() ? executionsByParent.computeIfAbsent(execution.getParentId(), k -> new ArrayList()) : miExecutionsByParent.computeIfAbsent(execution.getParentId(), k -> new ArrayList());
                    executionEntities.add(execution);
                }
                miExecutionsByParent.values().forEach(executions -> {
                    MoveExecutionEntityContainer moveExecutionEntityContainer = new MoveExecutionEntityContainer((List<ExecutionEntity>)executions, executionContainer.getMoveToActivityIds());
                    if (((ExecutionEntity)executions.get(0)).getVariablesLocal() != null && !((ExecutionEntity)executions.get(0)).getVariablesLocal().isEmpty()) {
                        moveExecutionEntityContainer.addLocalVariableMap(((ExecutionEntity)executions.get(0)).getActivityId(), ((ExecutionEntity)executions.get(0)).getVariablesLocal());
                    }
                    if (executionContainer.getNewAssigneeId() != null) {
                        moveExecutionEntityContainer.setNewAssigneeId(executionContainer.getNewAssigneeId());
                    }
                    if (executionContainer.getNewOwnerId() != null) {
                        moveExecutionEntityContainer.setNewOwnerId(executionContainer.getNewOwnerId());
                    }
                    moveExecutionEntityContainerList.add(moveExecutionEntityContainer);
                });
                executionsByParent.values().forEach(executions -> {
                    if (!miExecutionsByParent.isEmpty() && executions.size() > 1 && (((ExecutionEntity)executions.get(0)).getCurrentFlowElement() instanceof Task || ((ExecutionEntity)executions.get(0)).getCurrentFlowElement() instanceof CallActivity)) {
                        for (ExecutionEntity execution : executions) {
                            ArrayList<ExecutionEntity> miExecutionList = new ArrayList<ExecutionEntity>();
                            miExecutionList.add(execution);
                            MoveExecutionEntityContainer moveExecutionEntityContainer = new MoveExecutionEntityContainer(miExecutionList, executionContainer.getMoveToActivityIds());
                            if (execution.getVariablesLocal() != null && !execution.getVariablesLocal().isEmpty()) {
                                moveExecutionEntityContainer.addLocalVariableMap(execution.getActivityId(), execution.getVariablesLocal());
                            }
                            if (executionContainer.getNewAssigneeId() != null) {
                                moveExecutionEntityContainer.setNewAssigneeId(executionContainer.getNewAssigneeId());
                            }
                            if (executionContainer.getNewOwnerId() != null) {
                                moveExecutionEntityContainer.setNewOwnerId(executionContainer.getNewOwnerId());
                            }
                            moveExecutionEntityContainerList.add(moveExecutionEntityContainer);
                        }
                    } else {
                        MoveExecutionEntityContainer moveExecutionEntityContainer = new MoveExecutionEntityContainer((List<ExecutionEntity>)executions, executionContainer.getMoveToActivityIds());
                        for (ExecutionEntity execution : executions) {
                            if (execution.getVariablesLocal() == null || execution.getVariablesLocal().isEmpty()) continue;
                            moveExecutionEntityContainer.addLocalVariableMap(execution.getActivityId(), execution.getVariablesLocal());
                        }
                        if (executionContainer.getNewAssigneeId() != null) {
                            moveExecutionEntityContainer.setNewAssigneeId(executionContainer.getNewAssigneeId());
                        }
                        if (executionContainer.getNewOwnerId() != null) {
                            moveExecutionEntityContainer.setNewOwnerId(executionContainer.getNewOwnerId());
                        }
                        moveExecutionEntityContainerList.add(moveExecutionEntityContainer);
                    }
                });
            }
        }
        if (changeActivityStateBuilder.getMoveActivityIdList().size() > 0) {
            for (MoveActivityIdContainer activityContainer : changeActivityStateBuilder.getMoveActivityIdList()) {
                HashMap activitiesExecutionsByMultiInstanceParentId = new HashMap();
                ArrayList<ExecutionEntity> activitiesExecutionsNotInMultiInstanceParent = new ArrayList<ExecutionEntity>();
                for (String activityId : activityContainer.getActivityIds()) {
                    List<ExecutionEntity> activityExecutions = this.resolveActiveExecutions(changeActivityStateBuilder.getProcessInstanceId(), activityId, commandContext);
                    if (activityExecutions.isEmpty()) continue;
                    ExecutionEntity miExecution = null;
                    boolean isInsideMultiInstance = false;
                    for (ExecutionEntity possibleMIExecution : activityExecutions) {
                        if (possibleMIExecution.isMultiInstanceRoot()) {
                            miExecution = possibleMIExecution;
                            isInsideMultiInstance = true;
                            break;
                        }
                        if (!this.isExecutionInsideMultiInstance(possibleMIExecution)) continue;
                        isInsideMultiInstance = true;
                    }
                    if (isInsideMultiInstance) {
                        Stream<Object> executionEntitiesStream = activityExecutions.stream();
                        if (miExecution != null) {
                            executionEntitiesStream = executionEntitiesStream.filter(DelegateExecution::isMultiInstanceRoot);
                        }
                        executionEntitiesStream.forEach(childExecution -> {
                            String parentId = childExecution.isMultiInstanceRoot() ? childExecution.getId() : childExecution.getParentId();
                            List executionEntities = activitiesExecutionsByMultiInstanceParentId.computeIfAbsent(parentId, k -> new ArrayList());
                            executionEntities.add(childExecution);
                        });
                        continue;
                    }
                    ExecutionEntity execution = activityExecutions.iterator().next();
                    activitiesExecutionsNotInMultiInstanceParent.add(execution);
                }
                Stream.concat(activitiesExecutionsByMultiInstanceParentId.values().stream(), Stream.of(activitiesExecutionsNotInMultiInstanceParent)).filter(executions -> executions != null && !executions.isEmpty()).forEach(executions -> moveExecutionEntityContainerList.add(this.createMoveExecutionEntityContainer(activityContainer, (List<ExecutionEntity>)executions, commandContext)));
            }
        }
        return moveExecutionEntityContainerList;
    }

    public List<EnableActivityContainer> resolveEnableActivityContainers(ChangeActivityStateBuilderImpl changeActivityStateBuilder) {
        ArrayList<EnableActivityContainer> enableActivityContainerList = new ArrayList<EnableActivityContainer>();
        if (!changeActivityStateBuilder.getEnableActivityIdList().isEmpty()) {
            for (EnableActivityIdContainer enableActivityIdContainer : changeActivityStateBuilder.getEnableActivityIdList()) {
                EnableActivityContainer enableActivityContainer = new EnableActivityContainer(enableActivityIdContainer.getActivityIds());
                enableActivityContainerList.add(enableActivityContainer);
            }
        }
        return enableActivityContainerList;
    }

    protected ExecutionEntity resolveActiveExecution(String executionId, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity execution = (ExecutionEntity)executionEntityManager.findById(executionId);
        if (execution == null) {
            throw new FlowableException("Execution could not be found with id " + executionId);
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, execution.getProcessDefinitionId())) {
            throw new FlowableException("Flowable 5 process definitions are not supported");
        }
        return execution;
    }

    protected List<ExecutionEntity> resolveActiveExecutions(String processInstanceId, String activityId, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity processExecution = (ExecutionEntity)executionEntityManager.findById(processInstanceId);
        if (processExecution == null) {
            throw new FlowableException("Execution could not be found with id " + processInstanceId);
        }
        if (!processExecution.isProcessInstanceType()) {
            throw new FlowableException("Execution is not a process instance type execution for id " + processInstanceId);
        }
        if (Flowable5Util.isFlowable5ProcessDefinitionId(commandContext, processExecution.getProcessDefinitionId())) {
            throw new FlowableException("Flowable 5 process definitions are not supported");
        }
        List<ExecutionEntity> childExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(processExecution.getId());
        List<ExecutionEntity> executions = childExecutions.stream().filter(e -> e.getCurrentActivityId() != null).filter(e -> e.getCurrentActivityId().equals(activityId)).collect(Collectors.toList());
        if (executions.isEmpty()) {
            throw new FlowableException("Active execution could not be found with activity id " + activityId);
        }
        return executions;
    }

    protected MoveExecutionEntityContainer createMoveExecutionEntityContainer(MoveActivityIdContainer activityContainer, List<ExecutionEntity> executions, CommandContext commandContext) {
        MoveExecutionEntityContainer moveExecutionEntityContainer = new MoveExecutionEntityContainer(executions, activityContainer.getMoveToActivityIds());
        activityContainer.getNewAssigneeId().ifPresent(moveExecutionEntityContainer::setNewAssigneeId);
        activityContainer.getNewOwnerId().ifPresent(moveExecutionEntityContainer::setNewOwnerId);
        if (activityContainer.isMoveToParentProcess()) {
            ExecutionEntity processInstanceExecution = executions.get(0).getProcessInstance();
            ExecutionEntity superExecution = processInstanceExecution.getSuperExecution();
            if (superExecution == null) {
                throw new FlowableException("No parent process found for execution with activity id " + executions.get(0).getCurrentActivityId());
            }
            moveExecutionEntityContainer.setMoveToParentProcess(true);
            moveExecutionEntityContainer.setSuperExecution(superExecution);
        } else if (activityContainer.isMoveToSubProcessInstance()) {
            moveExecutionEntityContainer.setMoveToSubProcessInstance(true);
            moveExecutionEntityContainer.setCallActivityId(activityContainer.getCallActivityId());
            moveExecutionEntityContainer.setCallActivitySubProcessVersion(activityContainer.getCallActivitySubProcessVersion());
        }
        return moveExecutionEntityContainer;
    }

    protected void prepareMoveExecutionEntityContainer(MoveExecutionEntityContainer moveExecutionContainer, ProcessDefinition migrateToProcessDefinition, CommandContext commandContext) {
        ExpressionManager expressionManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getExpressionManager();
        BpmnModel bpmnModelToMigrateTo = null;
        if (migrateToProcessDefinition != null) {
            bpmnModelToMigrateTo = ProcessDefinitionUtil.getBpmnModel(migrateToProcessDefinition.getId());
        }
        boolean canContainerDirectMigrate = moveExecutionContainer.getMoveToActivityIds().size() == 1 && moveExecutionContainer.getExecutions().size() == 1;
        for (String activityId : moveExecutionContainer.getMoveToActivityIds()) {
            FlowElement newFlowElement;
            FlowElement currentFlowElement;
            String currentActivityId;
            if (moveExecutionContainer.isMoveToParentProcess()) {
                String parentProcessDefinitionId = moveExecutionContainer.getSuperExecution().getProcessDefinitionId();
                BpmnModel modelOfCallActivity = ProcessDefinitionUtil.getBpmnModel(moveExecutionContainer.getExecutions().get(0).getProcessDefinitionId());
                currentActivityId = moveExecutionContainer.getExecutions().get(0).getCurrentActivityId();
                currentFlowElement = this.resolveFlowElementFromBpmnModel(modelOfCallActivity, currentActivityId);
                if (bpmnModelToMigrateTo != null) {
                    newFlowElement = this.resolveFlowElementFromBpmnModel(bpmnModelToMigrateTo, activityId);
                } else {
                    BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(parentProcessDefinitionId);
                    newFlowElement = this.resolveFlowElementFromBpmnModel(bpmnModel, activityId);
                }
                canContainerDirectMigrate = false;
            } else if (moveExecutionContainer.isMoveToSubProcessInstance()) {
                firstExecution = moveExecutionContainer.getExecutions().get(0);
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(firstExecution.getProcessDefinitionId());
                currentActivityId = firstExecution.getCurrentActivityId();
                currentFlowElement = this.resolveFlowElementFromBpmnModel(bpmnModel, currentActivityId);
                String processDefinitionIdOfCallActivity = null;
                processDefinitionIdOfCallActivity = migrateToProcessDefinition != null ? migrateToProcessDefinition.getId() : firstExecution.getProcessDefinitionId();
                CallActivity callActivity = null;
                callActivity = bpmnModelToMigrateTo != null ? (CallActivity)this.resolveFlowElementFromBpmnModel(bpmnModelToMigrateTo, moveExecutionContainer.getCallActivityId()) : (CallActivity)this.resolveFlowElementFromBpmnModel(bpmnModel, moveExecutionContainer.getCallActivityId());
                moveExecutionContainer.setCallActivity(callActivity);
                ProcessDefinition callActivityProcessDefinition = ProcessDefinitionUtil.getProcessDefinition(processDefinitionIdOfCallActivity);
                String tenantId = callActivityProcessDefinition.getTenantId();
                Integer calledProcessVersion = moveExecutionContainer.getCallActivitySubProcessVersion();
                String calledProcessDefKey = callActivity.getCalledElement();
                if (this.isExpression(calledProcessDefKey)) {
                    try {
                        calledProcessDefKey = expressionManager.createExpression(calledProcessDefKey).getValue((VariableContainer)firstExecution.getProcessInstance()).toString();
                    }
                    catch (FlowableException e) {
                        throw new FlowableException("Cannot resolve calledElement expression '" + calledProcessDefKey + "' of callActivity '" + callActivity.getId() + "'", (Throwable)e);
                    }
                }
                moveExecutionContainer.setSubProcessDefKey(calledProcessDefKey);
                ProcessDefinition subProcessDefinition = this.resolveProcessDefinition(calledProcessDefKey, calledProcessVersion, tenantId, commandContext);
                BpmnModel subProcessModel = ProcessDefinitionUtil.getBpmnModel(subProcessDefinition.getId());
                moveExecutionContainer.setSubProcessDefinition(subProcessDefinition);
                moveExecutionContainer.setSubProcessModel(subProcessModel);
                newFlowElement = this.resolveFlowElementFromBpmnModel(subProcessModel, activityId);
                canContainerDirectMigrate = false;
            } else {
                firstExecution = moveExecutionContainer.getExecutions().get(0);
                bpmnModel = ProcessDefinitionUtil.getBpmnModel(firstExecution.getProcessDefinitionId());
                currentActivityId = firstExecution.getCurrentActivityId();
                currentFlowElement = this.resolveFlowElementFromBpmnModel(bpmnModel, currentActivityId);
                newFlowElement = bpmnModelToMigrateTo != null ? this.resolveFlowElementFromBpmnModel(bpmnModelToMigrateTo, activityId) : this.resolveFlowElementFromBpmnModel(bpmnModel, activityId);
            }
            moveExecutionContainer.addMoveToFlowElement(activityId, currentFlowElement, newFlowElement);
            moveExecutionContainer.addCurrentActivityToNewElement(currentActivityId, currentFlowElement, newFlowElement);
            canContainerDirectMigrate = canContainerDirectMigrate && this.isDirectFlowElementExecutionMigration(currentFlowElement, newFlowElement);
        }
        moveExecutionContainer.setDirectExecutionMigration(canContainerDirectMigrate && migrateToProcessDefinition != null);
    }

    protected FlowElement resolveFlowElementFromBpmnModel(BpmnModel bpmnModel, String activityId) {
        FlowElement flowElement = bpmnModel.getFlowElement(activityId);
        if (flowElement == null) {
            throw new FlowableException("Cannot find activity '" + activityId + "' in process definition with id '" + bpmnModel.getMainProcess().getId() + "'");
        }
        return flowElement;
    }

    protected void doMoveExecutionState(ProcessInstanceChangeState processInstanceChangeState, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        Map<String, List<ExecutionEntity>> activeEmbeddedSubProcesses = this.resolveActiveEmbeddedSubProcesses(processInstanceChangeState.getProcessInstanceId(), commandContext);
        processInstanceChangeState.setProcessInstanceActiveEmbeddedExecutions(activeEmbeddedSubProcesses);
        ExecutionEntity processInstanceExecution = (ExecutionEntity)executionEntityManager.findById(processInstanceChangeState.getProcessInstanceId());
        processInstanceExecution.setVariables(processInstanceChangeState.getProcessInstanceVariables());
        for (MoveExecutionEntityContainer moveExecutionContainer : processInstanceChangeState.getMoveExecutionEntityContainers()) {
            this.prepareMoveExecutionEntityContainer(moveExecutionContainer, processInstanceChangeState.getProcessDefinitionToMigrateTo(), commandContext);
            if (moveExecutionContainer.isMoveToParentProcess()) {
                String callActivityInstanceId = moveExecutionContainer.getExecutions().get(0).getProcessInstanceId();
                String deleteReason = "Change activity to parent process activity ids: " + this.printFlowElementIds(moveExecutionContainer.getMoveToFlowElements());
                this.safeDeleteSubProcessInstance(callActivityInstanceId, moveExecutionContainer.getExecutions(), deleteReason, commandContext);
            }
            List<ExecutionEntity> executionsToMove = moveExecutionContainer.isMoveToParentProcess() ? Collections.singletonList(moveExecutionContainer.getSuperExecution()) : moveExecutionContainer.getExecutions();
            List<MoveExecutionEntityContainer.FlowElementMoveEntry> moveToFlowElements = moveExecutionContainer.isMoveToSubProcessInstance() ? Collections.singletonList(new MoveExecutionEntityContainer.FlowElementMoveEntry((FlowElement)moveExecutionContainer.getCallActivity(), (FlowElement)moveExecutionContainer.getCallActivity())) : moveExecutionContainer.getMoveToFlowElements();
            String flowElementIdsLine = this.printFlowElementIds(moveToFlowElements);
            HashSet<String> executionIdsNotToDelete = new HashSet<String>();
            for (ExecutionEntity execution : executionsToMove) {
                MoveExecutionEntityContainer.FlowElementMoveEntry moveEntry;
                executionIdsNotToDelete.add(execution.getId());
                ArrayList<String> childExecutionsToKeep = new ArrayList<String>();
                if (execution.getCurrentFlowElement() instanceof CallActivity && moveExecutionContainer.isDirectExecutionMigration()) {
                    executionEntityManager.collectChildren(execution).stream().filter(executionEntity -> !Objects.equals(executionEntity.getProcessDefinitionId(), execution.getProcessDefinitionId())).map(Execution::getId).forEach(childExecutionsToKeep::add);
                }
                if (execution.getCurrentFlowElement() instanceof Activity && moveExecutionContainer.isDirectExecutionMigration() && (moveEntry = moveExecutionContainer.getCurrentActivityToNewElement(execution.getCurrentFlowElement().getId())) != null && moveEntry.getOriginalFlowElement().getId().equals(moveEntry.getNewFlowElement().getId()) && moveEntry.getOriginalFlowElement().getClass().getName().equals(moveEntry.getNewFlowElement().getClass().getName())) {
                    List boundaryEvents;
                    List newBoundaryEvents = ((Activity)moveEntry.getNewFlowElement()).getBoundaryEvents();
                    HashMap<String, BoundaryEvent> newBoundaryEventMap = new HashMap<String, BoundaryEvent>();
                    if (newBoundaryEvents != null && !newBoundaryEvents.isEmpty()) {
                        for (BoundaryEvent newBoundaryEvent : newBoundaryEvents) {
                            newBoundaryEventMap.put(newBoundaryEvent.getId(), newBoundaryEvent);
                        }
                    }
                    if ((boundaryEvents = ((Activity)execution.getCurrentFlowElement()).getBoundaryEvents()) != null && !boundaryEvents.isEmpty()) {
                        for (ExecutionEntity executionEntity2 : executionEntityManager.collectChildren(execution)) {
                            String sourceEventTypeValue;
                            List sourceEventTypeExtensionElements;
                            BoundaryEvent boundaryEvent;
                            if (executionEntity2.getCurrentFlowElement() == null || !(executionEntity2.getCurrentFlowElement() instanceof BoundaryEvent) || !newBoundaryEventMap.containsKey((boundaryEvent = (BoundaryEvent)executionEntity2.getCurrentFlowElement()).getId()) || !this.sameBoundaryEventDefinition(boundaryEvent, (BoundaryEvent)newBoundaryEventMap.get(boundaryEvent.getId()))) continue;
                            boolean hasEventSubscriptions = false;
                            if (boundaryEvent.getEventDefinitions() != null && !boundaryEvent.getEventDefinitions().isEmpty()) {
                                EventDefinition sourceEventDef = (EventDefinition)boundaryEvent.getEventDefinitions().get(0);
                                if (sourceEventDef instanceof SignalEventDefinition || sourceEventDef instanceof MessageEventDefinition) {
                                    hasEventSubscriptions = true;
                                }
                            } else if (!boundaryEvent.getExtensionElements().isEmpty() && (sourceEventTypeExtensionElements = (List)boundaryEvent.getExtensionElements().get("eventType")) != null && !sourceEventTypeExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(sourceEventTypeValue = ((ExtensionElement)sourceEventTypeExtensionElements.get(0)).getElementText()))) {
                                hasEventSubscriptions = true;
                            }
                            List eventSubscriptions = null;
                            if (hasEventSubscriptions) {
                                eventSubscriptions = CommandContextUtil.getEventSubscriptionService(commandContext).findEventSubscriptionsByExecution(executionEntity2.getId());
                            }
                            if (hasEventSubscriptions && (eventSubscriptions == null || eventSubscriptions.isEmpty())) continue;
                            executionEntity2.setProcessDefinitionId(processInstanceChangeState.getProcessDefinitionToMigrateTo().getId());
                            childExecutionsToKeep.add(executionEntity2.getId());
                        }
                    }
                }
                executionEntityManager.deleteChildExecutions(execution, childExecutionsToKeep, null, "Change parent activity to " + flowElementIdsLine, true, null);
                if (!moveExecutionContainer.isDirectExecutionMigration()) {
                    executionEntityManager.deleteExecutionAndRelatedData(execution, "Change activity to " + flowElementIdsLine, false, false, true, execution.getCurrentFlowElement());
                }
                if (execution.getParentId() == null) {
                    throw new FlowableException("Execution has no parent execution " + execution.getParentId());
                }
                ExecutionEntity continueParentExecution = processInstanceChangeState.getProcessDefinitionToMigrateTo() != null ? this.deleteDirectParentExecutions(execution.getParentId(), moveToFlowElements, executionIdsNotToDelete, processInstanceChangeState.getProcessDefinitionToMigrateTo(), moveExecutionContainer, commandContext) : this.deleteParentExecutions(execution.getParentId(), moveToFlowElements, executionIdsNotToDelete, commandContext);
                moveExecutionContainer.addContinueParentExecution(execution.getId(), continueParentExecution);
            }
            List<ExecutionEntity> newChildExecutions = this.createEmbeddedSubProcessAndExecutions(moveToFlowElements, executionsToMove, moveExecutionContainer, processInstanceChangeState, commandContext);
            if (moveExecutionContainer.isMoveToSubProcessInstance()) {
                CallActivity callActivity = moveExecutionContainer.getCallActivity();
                Process subProcess = moveExecutionContainer.getSubProcessModel().getProcessById(moveExecutionContainer.getSubProcessDefKey());
                ExecutionEntity callActivityInstanceExecution = this.createCallActivityInstance(callActivity, moveExecutionContainer.getSubProcessDefinition(), newChildExecutions.get(0), subProcess.getInitialFlowElement().getId(), commandContext);
                List<ExecutionEntity> moveExecutions = moveExecutionContainer.getExecutions();
                MoveExecutionEntityContainer subProcessMoveExecutionEntityContainer = new MoveExecutionEntityContainer(moveExecutions, moveExecutionContainer.getMoveToActivityIds());
                subProcessMoveExecutionEntityContainer.setNewAssigneeId(moveExecutionContainer.getNewAssigneeId());
                subProcessMoveExecutionEntityContainer.setNewOwnerId(moveExecutionContainer.getNewOwnerId());
                moveExecutions.forEach(executionEntity -> subProcessMoveExecutionEntityContainer.addContinueParentExecution(executionEntity.getId(), callActivityInstanceExecution));
                newChildExecutions = this.createEmbeddedSubProcessAndExecutions(moveExecutionContainer.getMoveToFlowElements(), moveExecutions, subProcessMoveExecutionEntityContainer, new ProcessInstanceChangeState(), commandContext);
            }
            if (!processInstanceChangeState.getLocalVariables().isEmpty()) {
                Map<String, Map<String, Object>> localVariables = processInstanceChangeState.getLocalVariables();
                Iterator<ExecutionEntity> newChildExecutionsIterator = newChildExecutions.iterator();
                while (newChildExecutionsIterator.hasNext()) {
                    block5: for (ExecutionEntity execution = newChildExecutionsIterator.next(); execution != null; execution = execution.getParent()) {
                        if (execution.getActivityId() == null || !localVariables.containsKey(execution.getActivityId())) continue;
                        if (execution.isScope() || execution.getCurrentFlowElement() instanceof UserTask) {
                            execution.setVariablesLocal((Map)localVariables.get(execution.getActivityId()));
                            continue;
                        }
                        ExecutionEntity scopedExecutionCandidate = execution;
                        while (scopedExecutionCandidate.getParent() != null) {
                            ExecutionEntity parentExecution = scopedExecutionCandidate.getParent();
                            if (parentExecution.isScope()) {
                                parentExecution.setVariablesLocal((Map)localVariables.get(execution.getActivityId()));
                                continue block5;
                            }
                            scopedExecutionCandidate = scopedExecutionCandidate.getParent();
                        }
                    }
                }
            }
            if (moveExecutionContainer.isDirectExecutionMigration()) continue;
            for (ExecutionEntity newChildExecution : newChildExecutions) {
                MigrationContext migrationContext;
                if (moveExecutionContainer.getNewAssigneeId() != null && moveExecutionContainer.hasNewExecutionId(newChildExecution.getId())) {
                    migrationContext = new MigrationContext();
                    migrationContext.setAssignee(moveExecutionContainer.getNewAssigneeId());
                    CommandContextUtil.getAgenda(commandContext).planContinueProcessWithMigrationContextOperation(newChildExecution, migrationContext);
                    continue;
                }
                if (moveExecutionContainer.getNewOwnerId() != null && moveExecutionContainer.hasNewExecutionId(newChildExecution.getId())) {
                    migrationContext = new MigrationContext();
                    migrationContext.setOwner(moveExecutionContainer.getNewOwnerId());
                    CommandContextUtil.getAgenda(commandContext).planContinueProcessWithMigrationContextOperation(newChildExecution, migrationContext);
                    continue;
                }
                if (newChildExecution.isMultiInstanceRoot() && (newChildExecution.getCurrentFlowElement() instanceof Task || newChildExecution.getCurrentFlowElement() instanceof CallActivity)) continue;
                if (newChildExecution.getCurrentFlowElement() instanceof Task && ((Task)newChildExecution.getCurrentFlowElement()).isAsynchronous()) {
                    JobService jobService = CommandContextUtil.getJobService(commandContext);
                    JobEntity job = JobUtil.createJob(newChildExecution, (BaseElement)newChildExecution.getCurrentFlowElement(), "async-continuation", CommandContextUtil.getProcessEngineConfiguration(commandContext));
                    Task task = (Task)newChildExecution.getCurrentFlowElement();
                    jobService.createAsyncJob(job, task.isExclusive());
                    jobService.scheduleAsyncJob(job);
                    continue;
                }
                CommandContextUtil.getAgenda(commandContext).planContinueProcessOperation(newChildExecution);
            }
        }
        this.processPendingEventSubProcessesStartEvents(processInstanceChangeState, commandContext);
        for (EnableActivityContainer enableActivityContainer : processInstanceChangeState.getEnableActivityContainers()) {
            if (enableActivityContainer.getActivityIds() == null || enableActivityContainer.getActivityIds().isEmpty()) continue;
            BpmnModel bpmnModel = null;
            ExecutionEntity parentExecution = (ExecutionEntity)executionEntityManager.findById(processInstanceChangeState.getProcessInstanceId());
            bpmnModel = processInstanceChangeState.getProcessDefinitionToMigrateTo() != null ? ProcessDefinitionUtil.getBpmnModel(processInstanceChangeState.getProcessDefinitionToMigrateTo().getId()) : ProcessDefinitionUtil.getBpmnModel(parentExecution.getProcessDefinitionId());
            ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
            ProcessInstanceHelper processInstanceHelper = processEngineConfiguration.getProcessInstanceHelper();
            for (String enableActivityId : enableActivityContainer.getActivityIds()) {
                FlowElement enableFlowElement = bpmnModel.getFlowElement(enableActivityId);
                if (enableFlowElement == null) {
                    throw new FlowableException("could not find element for activity id " + enableActivityId);
                }
                processInstanceHelper.processEventSubProcessStartEvent(enableFlowElement, parentExecution, processEngineConfiguration, commandContext);
            }
        }
    }

    protected void processPendingEventSubProcessesStartEvents(ProcessInstanceChangeState processInstanceChangeState, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ProcessInstanceHelper processInstanceHelper = processEngineConfiguration.getProcessInstanceHelper();
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        ManagementService managementService = processEngineConfiguration.getManagementService();
        for (Map.Entry<StartEvent, ExecutionEntity> pendingStartEventEntry : processInstanceChangeState.getPendingEventSubProcessesStartEvents().entrySet()) {
            StartEvent startEvent = pendingStartEventEntry.getKey();
            ExecutionEntity parentExecution = pendingStartEventEntry.getValue();
            EventDefinition eventDefinition = startEvent.getEventDefinitions().isEmpty() ? null : (EventDefinition)startEvent.getEventDefinitions().get(0);
            boolean processEventSubProcess = false;
            processEventSubProcess = eventDefinition instanceof TimerEventDefinition ? ((TimerJobQuery)managementService.createTimerJobQuery().executionId(parentExecution.getId())).list().isEmpty() : eventSubscriptionService.findEventSubscriptionsByExecution(parentExecution.getId()).isEmpty();
            if (!processEventSubProcess) continue;
            processInstanceHelper.processEventSubProcess(parentExecution, (EventSubProcess)startEvent.getSubProcess(), commandContext);
        }
    }

    protected abstract Map<String, List<ExecutionEntity>> resolveActiveEmbeddedSubProcesses(String var1, CommandContext var2);

    protected abstract boolean isDirectFlowElementExecutionMigration(FlowElement var1, FlowElement var2);

    protected void safeDeleteSubProcessInstance(String processInstanceId, List<ExecutionEntity> executionsPool, String deleteReason, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        List<ExecutionEntity> subProcessExecutions = executionEntityManager.findChildExecutionsByProcessInstanceId(processInstanceId);
        HashSet executionIdsToMove = executionsPool.stream().map(Execution::getId).collect(Collectors.toCollection(HashSet::new));
        Optional<ExecutionEntity> notIncludedExecution = subProcessExecutions.stream().filter(e -> !executionIdsToMove.contains(e.getId())).findAny();
        if (notIncludedExecution.isPresent()) {
            throw new FlowableException("Execution of sub process instance is not moved " + notIncludedExecution.get().getId());
        }
        executionEntityManager.deleteProcessInstance(processInstanceId, deleteReason, true);
    }

    protected ExecutionEntity deleteParentExecutions(String parentExecutionId, Collection<MoveExecutionEntityContainer.FlowElementMoveEntry> moveToFlowElements, CommandContext commandContext) {
        return this.deleteParentExecutions(parentExecutionId, moveToFlowElements, null, commandContext);
    }

    protected ExecutionEntity deleteParentExecutions(String parentExecutionId, Collection<MoveExecutionEntityContainer.FlowElementMoveEntry> moveToFlowElements, Collection<String> executionIdsNotToDelete, CommandContext commandContext) {
        SubProcess parentSubProcess;
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity parentExecution = (ExecutionEntity)executionEntityManager.findById(parentExecutionId);
        if (parentExecution != null && parentExecution.getCurrentFlowElement() instanceof SubProcess && !this.isSubProcessAncestorOfAnyNewFlowElements((parentSubProcess = (SubProcess)parentExecution.getCurrentFlowElement()).getId(), moveToFlowElements)) {
            ExecutionEntity toDeleteParentExecution = this.resolveParentExecutionToDelete(parentExecution, moveToFlowElements);
            ExecutionEntity finalDeleteExecution = null;
            finalDeleteExecution = toDeleteParentExecution != null ? toDeleteParentExecution : parentExecution;
            parentExecution = finalDeleteExecution.getParent();
            String flowElementIdsLine = this.printFlowElementIds(moveToFlowElements);
            executionEntityManager.deleteChildExecutions(finalDeleteExecution, executionIdsNotToDelete, null, "Change activity to " + flowElementIdsLine, true, null);
            executionEntityManager.deleteExecutionAndRelatedData(finalDeleteExecution, "Change activity to " + flowElementIdsLine, false, false, true, finalDeleteExecution.getCurrentFlowElement());
        }
        return parentExecution;
    }

    protected ExecutionEntity deleteDirectParentExecutions(String parentExecutionId, Collection<MoveExecutionEntityContainer.FlowElementMoveEntry> moveToFlowElements, Collection<String> executionIdsNotToDelete, ProcessDefinition procDefToMigrateTo, MoveExecutionEntityContainer moveExecutionContainer, CommandContext commandContext) {
        SubProcess parentSubProcess;
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ExecutionEntity parentExecution = (ExecutionEntity)executionEntityManager.findById(parentExecutionId);
        if (parentExecution.getCurrentFlowElement() instanceof SubProcess && !this.isSubProcessContainerOfAnyFlowElement((parentSubProcess = (SubProcess)parentExecution.getCurrentFlowElement()).getId(), moveToFlowElements)) {
            if (parentSubProcess.getLoopCharacteristics() == null || moveExecutionContainer.getMoveToFlowElement(parentSubProcess.getId()) != null) {
                ExecutionEntity toDeleteParentExecution = this.resolveParentExecutionToDelete(parentExecution, moveToFlowElements);
                ExecutionEntity finalDeleteExecution = null;
                finalDeleteExecution = toDeleteParentExecution != null ? toDeleteParentExecution : parentExecution;
                parentExecution = finalDeleteExecution.getParent();
                String flowElementIdsLine = this.printFlowElementIds(moveToFlowElements);
                executionEntityManager.deleteChildExecutions(finalDeleteExecution, executionIdsNotToDelete, null, "Change activity to " + flowElementIdsLine, true, null);
                executionEntityManager.deleteExecutionAndRelatedData(finalDeleteExecution, "Change activity to " + flowElementIdsLine, false, false, true, finalDeleteExecution.getCurrentFlowElement());
            } else {
                parentExecution.setProcessDefinitionId(procDefToMigrateTo.getId());
                if (!parentExecution.isMultiInstanceRoot()) {
                    parentExecution.getParent().setProcessDefinitionId(procDefToMigrateTo.getId());
                }
            }
        }
        return parentExecution;
    }

    protected boolean isSubProcessContainerOfAnyFlowElement(String subProcessId, Collection<MoveExecutionEntityContainer.FlowElementMoveEntry> moveToFlowElements) {
        Optional<SubProcess> isUsed = moveToFlowElements.stream().map(MoveExecutionEntityContainer.FlowElementMoveEntry::getNewFlowElement).map(FlowElement::getSubProcess).filter(Objects::nonNull).filter(elementSubProcess -> elementSubProcess.getId().equals(subProcessId)).findAny();
        return isUsed.isPresent();
    }

    protected ExecutionEntity resolveParentExecutionToDelete(ExecutionEntity execution, Collection<MoveExecutionEntityContainer.FlowElementMoveEntry> moveToFlowElements) {
        ExecutionEntity parentExecution = execution.getParent();
        if (parentExecution.isProcessInstanceType()) {
            return null;
        }
        if (!this.isSubProcessContainerOfAnyFlowElement(parentExecution.getActivityId(), moveToFlowElements)) {
            ExecutionEntity subProcessParentExecution = this.resolveParentExecutionToDelete(parentExecution, moveToFlowElements);
            if (subProcessParentExecution != null) {
                return subProcessParentExecution;
            }
            return parentExecution;
        }
        return null;
    }

    protected List<ExecutionEntity> createEmbeddedSubProcessAndExecutions(Collection<MoveExecutionEntityContainer.FlowElementMoveEntry> moveToFlowElements, List<ExecutionEntity> movingExecutions, MoveExecutionEntityContainer moveExecutionEntityContainer, ProcessInstanceChangeState processInstanceChangeState, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        HashMap<String, SubProcess> subProcessesToCreate = new HashMap<String, SubProcess>();
        for (MoveExecutionEntityContainer.FlowElementMoveEntry flowElementMoveEntry : moveToFlowElements) {
            FlowElement newFlowElement = flowElementMoveEntry.getNewFlowElement();
            SubProcess subProcess = newFlowElement.getSubProcess();
            if (this.isEventSubProcessStart(newFlowElement)) {
                subProcess = subProcess.getSubProcess();
            }
            while (subProcess != null) {
                if (!processInstanceChangeState.getProcessInstanceActiveEmbeddedExecutions().containsKey(subProcess.getId()) && !this.isSubProcessAncestorOfAnyExecution(subProcess.getId(), movingExecutions)) {
                    subProcessesToCreate.put(subProcess.getId(), subProcess);
                }
                subProcess = subProcess.getSubProcess();
            }
        }
        ExecutionEntity defaultContinueParentExecution = moveExecutionEntityContainer.getContinueParentExecution(movingExecutions.get(0).getId());
        Set<String> movingExecutionIds = movingExecutions.stream().map(Execution::getId).collect(Collectors.toSet());
        for (SubProcess subProcess : subProcessesToCreate.values()) {
            ExecutionEntity embeddedSubProcess;
            if (subProcess instanceof EventSubProcess) {
                embeddedSubProcess = this.createEmbeddedSubProcessHierarchy(subProcess, defaultContinueParentExecution, subProcessesToCreate, movingExecutionIds, processInstanceChangeState, commandContext);
                moveExecutionEntityContainer.addCreatedEventSubProcess(subProcess.getId(), embeddedSubProcess);
                continue;
            }
            if (processInstanceChangeState.getCreatedEmbeddedSubProcesses().containsKey(subProcess.getId())) continue;
            embeddedSubProcess = this.createEmbeddedSubProcessHierarchy(subProcess, defaultContinueParentExecution, subProcessesToCreate, movingExecutionIds, processInstanceChangeState, commandContext);
            processInstanceChangeState.addCreatedEmbeddedSubProcess(subProcess.getId(), embeddedSubProcess);
        }
        ArrayList<ExecutionEntity> newChildExecutions = new ArrayList<ExecutionEntity>();
        for (MoveExecutionEntityContainer.FlowElementMoveEntry flowElementMoveEntry : moveToFlowElements) {
            ExecutionEntity newChildExecution;
            FlowElement newFlowElement = flowElementMoveEntry.getNewFlowElement();
            ExecutionEntity parentExecution = newFlowElement.getSubProcess() != null && moveExecutionEntityContainer.getCreatedEventSubProcess(newFlowElement.getSubProcess().getId()) != null ? moveExecutionEntityContainer.getCreatedEventSubProcess(newFlowElement.getSubProcess().getId()) : (newFlowElement.getSubProcess() != null && processInstanceChangeState.getCreatedEmbeddedSubProcesses().containsKey(newFlowElement.getSubProcess().getId()) ? processInstanceChangeState.getCreatedEmbeddedSubProcesses().get(newFlowElement.getSubProcess().getId()) : ((newFlowElement instanceof Task || newFlowElement instanceof CallActivity) && this.isFlowElementMultiInstance(newFlowElement) && !movingExecutions.get(0).isMultiInstanceRoot() && processInstanceChangeState.getCreatedMultiInstanceRootExecution().containsKey(newFlowElement.getId()) ? processInstanceChangeState.getCreatedMultiInstanceRootExecution().get(newFlowElement.getId()) : defaultContinueParentExecution));
            if (this.isEventSubProcessStart(newFlowElement)) {
                processInstanceChangeState.addPendingEventSubProcessStartEvent((StartEvent)newFlowElement, parentExecution);
                continue;
            }
            if (moveExecutionEntityContainer.isDirectExecutionMigration() && this.isDirectFlowElementExecutionMigration(flowElementMoveEntry.originalFlowElement, flowElementMoveEntry.newFlowElement)) {
                newChildExecution = this.migrateExecutionEntity(parentExecution, movingExecutions.get(0), flowElementMoveEntry.getOriginalFlowElement(), newFlowElement, commandContext);
            } else {
                newChildExecution = executionEntityManager.createChildExecution(parentExecution);
                newChildExecution.setCurrentFlowElement(newFlowElement);
                moveExecutionEntityContainer.addNewExecutionId(newChildExecution.getId());
            }
            if (newChildExecution != null) {
                if (moveExecutionEntityContainer.getFlowElementLocalVariableMap().containsKey(newFlowElement.getId())) {
                    newChildExecution.setVariablesLocal(moveExecutionEntityContainer.getFlowElementLocalVariableMap().get(newFlowElement.getId()));
                }
                if (movingExecutions.get(0).isMultiInstanceRoot() && this.isFlowElementMultiInstance(newFlowElement) && this.hasSameMultiInstanceConfig(movingExecutions.get(0).getCurrentFlowElement(), newFlowElement)) {
                    newChildExecution.setMultiInstanceRoot(true);
                    newChildExecution.setActive(false);
                    processInstanceChangeState.addCreatedMultiInstanceRootExecution(newFlowElement.getId(), newChildExecution);
                }
                if (newFlowElement instanceof UserTask && !moveExecutionEntityContainer.hasNewExecutionId(newChildExecution.getId())) {
                    if (moveExecutionEntityContainer.getNewAssigneeId() != null) {
                        this.handleUserTaskNewAssignee(newChildExecution, moveExecutionEntityContainer.getNewAssigneeId(), commandContext);
                    }
                    if (moveExecutionEntityContainer.getNewOwnerId() != null) {
                        this.handleUserTaskNewOwner(newChildExecution, moveExecutionEntityContainer.getNewOwnerId(), commandContext);
                    }
                }
                if (newFlowElement instanceof CallActivity && !moveExecutionEntityContainer.isDirectExecutionMigration()) {
                    CallActivity callActivity;
                    List boundaryEvents;
                    if (!newChildExecution.isMultiInstanceRoot()) {
                        processEngineConfiguration.getActivityInstanceEntityManager().recordActivityStart(newChildExecution);
                        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
                        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
                            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_STARTED, newFlowElement.getId(), newFlowElement.getName(), newChildExecution.getId(), newChildExecution.getProcessInstanceId(), newChildExecution.getProcessDefinitionId(), newFlowElement), processEngineConfiguration.getEngineCfgKey());
                        }
                    }
                    if (CollectionUtil.isNotEmpty((Collection)(boundaryEvents = (callActivity = (CallActivity)newFlowElement).getBoundaryEvents()))) {
                        this.executeBoundaryEvents(boundaryEvents, newChildExecution);
                    }
                }
                newChildExecutions.add(newChildExecution);
            }
            if (!(newFlowElement instanceof Gateway)) continue;
            movingExecutions.stream().skip(1L).forEach(e -> {
                ExecutionEntity childExecution = executionEntityManager.createChildExecution(defaultContinueParentExecution);
                childExecution.setCurrentFlowElement(newFlowElement);
                newChildExecutions.add(childExecution);
            });
        }
        return newChildExecutions;
    }

    protected boolean isSubProcessAncestorOfAnyExecution(String subProcessId, List<ExecutionEntity> executions) {
        for (ExecutionEntity execution : executions) {
            FlowElement executionElement = execution.getCurrentFlowElement();
            if (!this.isSubProcessAncestor(subProcessId, executionElement)) continue;
            return true;
        }
        return false;
    }

    protected boolean isSubProcessAncestorOfAnyNewFlowElements(String subProcessId, Collection<MoveExecutionEntityContainer.FlowElementMoveEntry> flowElements) {
        for (MoveExecutionEntityContainer.FlowElementMoveEntry flowElementMoveEntry : flowElements) {
            if (!this.isSubProcessAncestor(subProcessId, flowElementMoveEntry.getNewFlowElement())) continue;
            return true;
        }
        return false;
    }

    private boolean isSubProcessAncestor(String subProcessId, FlowElement flowElement) {
        while (flowElement.getSubProcess() != null) {
            String execElemSubProcessId = flowElement.getSubProcess().getId();
            if (execElemSubProcessId != null && execElemSubProcessId.equals(subProcessId)) {
                return true;
            }
            flowElement = flowElement.getSubProcess();
        }
        return false;
    }

    protected List<FlowElement> getFlowElementsInSubProcess(SubProcess subProcess, Collection<FlowElement> flowElements) {
        return flowElements.stream().filter(e -> e.getSubProcess() != null).filter(e -> e.getSubProcess().getId().equals(subProcess.getId())).collect(Collectors.toList());
    }

    protected ExecutionEntity createEmbeddedSubProcessHierarchy(SubProcess subProcess, ExecutionEntity defaultParentExecution, Map<String, SubProcess> subProcessesToCreate, Set<String> movingExecutionIds, ProcessInstanceChangeState processInstanceChangeState, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        if (processInstanceChangeState.getProcessInstanceActiveEmbeddedExecutions().containsKey(subProcess.getId())) {
            return processInstanceChangeState.getProcessInstanceActiveEmbeddedExecutions().get(subProcess.getId()).get(0);
        }
        if (processInstanceChangeState.getCreatedEmbeddedSubProcesses().containsKey(subProcess.getId())) {
            return processInstanceChangeState.getCreatedEmbeddedSubProcesses().get(subProcess.getId());
        }
        ExecutionEntity parentSubProcess = defaultParentExecution;
        if (subProcess.getSubProcess() != null) {
            parentSubProcess = this.createEmbeddedSubProcessHierarchy(subProcess.getSubProcess(), defaultParentExecution, subProcessesToCreate, movingExecutionIds, processInstanceChangeState, commandContext);
            processInstanceChangeState.getCreatedEmbeddedSubProcesses().put(subProcess.getSubProcess().getId(), parentSubProcess);
        }
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        ExecutionEntity subProcessExecution = executionEntityManager.createChildExecution(parentSubProcess);
        subProcessExecution.setCurrentFlowElement((FlowElement)subProcess);
        subProcessExecution.setScope(true);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createActivityEvent(FlowableEngineEventType.ACTIVITY_STARTED, subProcess.getId(), subProcess.getName(), subProcessExecution.getId(), subProcessExecution.getProcessInstanceId(), subProcessExecution.getProcessDefinitionId(), (FlowElement)subProcess), processEngineConfiguration.getEngineCfgKey());
        }
        subProcessExecution.setVariablesLocal(this.processDataObjects(subProcess.getDataObjects()));
        processEngineConfiguration.getActivityInstanceEntityManager().recordActivityStart(subProcessExecution);
        List boundaryEvents = subProcess.getBoundaryEvents();
        if (CollectionUtil.isNotEmpty((Collection)boundaryEvents)) {
            this.executeBoundaryEvents(boundaryEvents, subProcessExecution);
        }
        if (subProcess instanceof EventSubProcess) {
            this.processCreatedEventSubProcess((EventSubProcess)subProcess, subProcessExecution, movingExecutionIds, commandContext);
        }
        ProcessInstanceHelper processInstanceHelper = processEngineConfiguration.getProcessInstanceHelper();
        List childEventSubProcesses = subProcess.findAllSubFlowElementInFlowMapOfType(EventSubProcess.class);
        childEventSubProcesses.stream().filter(childEventSubProcess -> !subProcessesToCreate.containsKey(childEventSubProcess.getId())).forEach(childEventSubProcess -> processInstanceHelper.processEventSubProcess(subProcessExecution, (EventSubProcess)childEventSubProcess, commandContext));
        return subProcessExecution;
    }

    protected Map<String, Object> processDataObjects(Collection<ValuedDataObject> dataObjects) {
        HashMap<String, Object> variablesMap = new HashMap<String, Object>();
        if (dataObjects != null) {
            variablesMap = new HashMap(dataObjects.size());
            for (ValuedDataObject dataObject : dataObjects) {
                variablesMap.put(dataObject.getName(), dataObject.getValue());
            }
        }
        return variablesMap;
    }

    protected void executeBoundaryEvents(Collection<BoundaryEvent> boundaryEvents, ExecutionEntity execution) {
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty((Collection)boundaryEvent.getEventDefinitions()) || boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition) continue;
            ExecutionEntity childExecutionEntity = CommandContextUtil.getExecutionEntityManager().createChildExecution(execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
            childExecutionEntity.setScope(false);
            CommandContextUtil.getProcessEngineConfiguration().getActivityInstanceEntityManager().recordActivityStart(childExecutionEntity);
            ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
            this.LOGGER.debug("Executing boundary event activityBehavior {} with execution {}", boundaryEventBehavior.getClass(), (Object)childExecutionEntity.getId());
            boundaryEventBehavior.execute(childExecutionEntity);
        }
    }

    protected ExecutionEntity createCallActivityInstance(CallActivity callActivity, ProcessDefinition subProcessDefinition, ExecutionEntity parentExecution, String initialActivityId, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        Process subProcess = ProcessDefinitionUtil.getProcess(subProcessDefinition.getId());
        if (subProcess == null) {
            throw new FlowableException("Cannot start a sub process instance. Process model " + subProcessDefinition.getName() + " (id = " + subProcessDefinition.getId() + ") could not be found");
        }
        String businessKey = null;
        if (!StringUtils.isEmpty((CharSequence)callActivity.getBusinessKey())) {
            Expression expression = expressionManager.createExpression(callActivity.getBusinessKey());
            businessKey = expression.getValue((VariableContainer)parentExecution).toString();
        } else if (callActivity.isInheritBusinessKey()) {
            ExecutionEntity processInstance = (ExecutionEntity)executionEntityManager.findById(parentExecution.getProcessInstanceId());
            businessKey = processInstance.getBusinessKey();
        }
        ExecutionEntity subProcessInstance = executionEntityManager.createSubprocessInstance(subProcessDefinition, parentExecution, businessKey, initialActivityId);
        EntityLinkUtil.createEntityLinks(parentExecution.getProcessInstanceId(), parentExecution.getId(), callActivity.getId(), subProcessInstance.getId(), "bpmn");
        CommandContextUtil.getActivityInstanceEntityManager(commandContext).recordSubProcessInstanceStart(parentExecution, subProcessInstance);
        FlowableEventDispatcher eventDispatcher = processEngineConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            CommandContextUtil.getProcessEngineConfiguration().getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.PROCESS_CREATED, subProcessInstance), processEngineConfiguration.getEngineCfgKey());
        }
        subProcessInstance.setVariables(this.processDataObjects(subProcess.getDataObjects()));
        HashMap variables = new HashMap();
        if (callActivity.isInheritVariables()) {
            Map executionVariables = parentExecution.getVariables();
            for (Map.Entry entry : executionVariables.entrySet()) {
                variables.put((String)entry.getKey(), entry.getValue());
            }
        }
        IOParameterUtil.processInParameters(callActivity.getInParameters(), (VariableContainer)parentExecution, variables::put, variables::put, expressionManager);
        if (!variables.isEmpty()) {
            subProcessInstance.setVariables(variables);
        }
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableEventBuilder.createEntityEvent(FlowableEngineEventType.ENTITY_INITIALIZED, subProcessInstance), processEngineConfiguration.getEngineCfgKey());
        }
        return subProcessInstance;
    }

    protected ExecutionEntity migrateExecutionEntity(ExecutionEntity parentExecutionEntity, ExecutionEntity childExecution, FlowElement originalElement, FlowElement newFlowElement, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        TaskService taskService = processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        ExpressionManager expressionManager = processEngineConfiguration.getExpressionManager();
        childExecution.setProcessInstanceId(parentExecutionEntity.getProcessInstanceId());
        childExecution.setProcessInstance(parentExecutionEntity.getProcessInstance());
        childExecution.setProcessDefinitionId(parentExecutionEntity.getProcessDefinitionId());
        ExecutionEntity oldParent = childExecution.getParent();
        if (oldParent != null && !oldParent.getId().equals(parentExecutionEntity.getId())) {
            oldParent.getExecutions().remove(childExecution);
        }
        childExecution.setParent(parentExecutionEntity);
        parentExecutionEntity.addChildExecution(childExecution);
        String oldActivityId = childExecution.getCurrentActivityId();
        if (!childExecution.getCurrentActivityId().equals(newFlowElement.getId())) {
            ((ExecutionEntityImpl)childExecution).setActivityId(newFlowElement.getId());
        }
        if (newFlowElement instanceof UserTask) {
            Object categoryValue;
            Object formKeyValue;
            Object descriptionValue;
            Object nameValue;
            TaskEntityImpl task = (TaskEntityImpl)((TaskQuery)taskService.createTaskQuery(processEngineConfiguration.getCommandExecutor(), (AbstractEngineConfiguration)processEngineConfiguration).executionId(childExecution.getId())).singleResult();
            task.setProcessDefinitionId(childExecution.getProcessDefinitionId());
            task.setTaskDefinitionKey(newFlowElement.getId());
            String name = null;
            if (newFlowElement.getName() != null && (nameValue = expressionManager.createExpression(newFlowElement.getName()).getValue((VariableContainer)childExecution)) != null) {
                name = nameValue.toString();
            }
            task.setName(name);
            String description = null;
            if (newFlowElement.getDocumentation() != null && (descriptionValue = expressionManager.createExpression(newFlowElement.getDocumentation()).getValue((VariableContainer)childExecution)) != null) {
                description = descriptionValue.toString();
            }
            task.setDescription(description);
            String newFormKey = null;
            String userTaskFormKey = ((UserTask)newFlowElement).getFormKey();
            if (userTaskFormKey != null && (formKeyValue = expressionManager.createExpression(userTaskFormKey).getValue((VariableContainer)childExecution)) != null) {
                newFormKey = formKeyValue.toString();
            }
            task.setFormKey(newFormKey);
            String newCategory = null;
            String userTaskCategory = ((UserTask)newFlowElement).getCategory();
            if (userTaskCategory != null && (categoryValue = expressionManager.createExpression(userTaskCategory).getValue((VariableContainer)childExecution)) != null) {
                newCategory = categoryValue.toString();
            }
            task.setCategory(newCategory);
            task.setProcessInstanceId(childExecution.getProcessInstanceId());
            processEngineConfiguration.getActivityInstanceEntityManager().syncUserTaskExecution(childExecution, newFlowElement, oldActivityId, (TaskEntity)task);
        }
        if (newFlowElement instanceof ServiceTask && (((ServiceTask)newFlowElement).isAsynchronous() || ((ServiceTask)newFlowElement).isAsynchronousLeave())) {
            this.handleServiceTaskJobUpdate(childExecution, commandContext);
        } else if (newFlowElement instanceof ExternalWorkerServiceTask) {
            this.handleExternalWorkerServiceTaskJobUpdate(childExecution, commandContext);
        }
        ArrayList<BoundaryEvent> finalBoundaryEvents = null;
        if (originalElement == null || !originalElement.getId().equals(newFlowElement.getId()) || !originalElement.getClass().getName().equals(newFlowElement.getClass().getName())) {
            finalBoundaryEvents = ((Activity)newFlowElement).getBoundaryEvents();
        } else {
            List boundaryEvents = ((Activity)newFlowElement).getBoundaryEvents();
            if (boundaryEvents != null && !boundaryEvents.isEmpty()) {
                HashMap<String, Pair> originalBoundaryEventMap = new HashMap<String, Pair>();
                for (ExecutionEntity executionEntity : processEngineConfiguration.getExecutionEntityManager().collectChildren(childExecution)) {
                    if (executionEntity.getCurrentFlowElement() == null || !(executionEntity.getCurrentFlowElement() instanceof BoundaryEvent)) continue;
                    originalBoundaryEventMap.put(executionEntity.getCurrentFlowElement().getId(), Pair.of((Object)((BoundaryEvent)executionEntity.getCurrentFlowElement()), (Object)executionEntity));
                }
                finalBoundaryEvents = new ArrayList<BoundaryEvent>();
                for (BoundaryEvent boundaryEvent : boundaryEvents) {
                    List eventSubscriptions;
                    String sourceEventTypeValue;
                    List sourceEventTypeExtensionElements;
                    if (!originalBoundaryEventMap.containsKey(boundaryEvent.getId()) || !this.sameBoundaryEventDefinition(boundaryEvent, (BoundaryEvent)((Pair)originalBoundaryEventMap.get(boundaryEvent.getId())).getLeft())) {
                        finalBoundaryEvents.add(boundaryEvent);
                        continue;
                    }
                    boolean hasEventSubscriptions = false;
                    if (boundaryEvent.getEventDefinitions() != null && !boundaryEvent.getEventDefinitions().isEmpty()) {
                        EventDefinition sourceEventDef = (EventDefinition)boundaryEvent.getEventDefinitions().get(0);
                        if (sourceEventDef instanceof SignalEventDefinition || sourceEventDef instanceof MessageEventDefinition) {
                            hasEventSubscriptions = true;
                        }
                    } else if (!boundaryEvent.getExtensionElements().isEmpty() && (sourceEventTypeExtensionElements = (List)boundaryEvent.getExtensionElements().get("eventType")) != null && !sourceEventTypeExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(sourceEventTypeValue = ((ExtensionElement)sourceEventTypeExtensionElements.get(0)).getElementText()))) {
                        hasEventSubscriptions = true;
                    }
                    if (!hasEventSubscriptions || (eventSubscriptions = CommandContextUtil.getEventSubscriptionService(commandContext).findEventSubscriptionsByExecution(((ExecutionEntity)((Pair)originalBoundaryEventMap.get(boundaryEvent.getId())).getRight()).getId())) != null && !eventSubscriptions.isEmpty()) continue;
                    finalBoundaryEvents.add(boundaryEvent);
                }
            }
        }
        if (finalBoundaryEvents != null && !finalBoundaryEvents.isEmpty()) {
            List<ExecutionEntity> boundaryEventsExecutions = this.createBoundaryEvents((List<BoundaryEvent>)finalBoundaryEvents, childExecution, commandContext);
            this.executeBoundaryEvents((List<BoundaryEvent>)finalBoundaryEvents, boundaryEventsExecutions);
        }
        if (this.LOGGER.isDebugEnabled()) {
            this.LOGGER.debug("Child execution {} updated with parent {}", (Object)childExecution, (Object)parentExecutionEntity.getId());
        }
        return childExecution;
    }

    protected void handleServiceTaskJobUpdate(ExecutionEntity childExecution, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ManagementService managementService = processEngineConfiguration.getManagementService();
        TimerJobEntityImpl timerJob = (TimerJobEntityImpl)((TimerJobQuery)managementService.createTimerJobQuery().executionId(childExecution.getId())).singleResult();
        if (timerJob != null) {
            timerJob.setProcessDefinitionId(childExecution.getProcessDefinitionId());
            return;
        }
        DeadLetterJobEntityImpl deadLetterJob = (DeadLetterJobEntityImpl)((DeadLetterJobQuery)managementService.createDeadLetterJobQuery().executionId(childExecution.getId())).singleResult();
        if (deadLetterJob != null) {
            deadLetterJob.setProcessDefinitionId(childExecution.getProcessDefinitionId());
            return;
        }
        SuspendedJobEntityImpl suspendedJob = (SuspendedJobEntityImpl)((SuspendedJobQuery)managementService.createSuspendedJobQuery().executionId(childExecution.getId())).singleResult();
        if (suspendedJob != null) {
            suspendedJob.setProcessDefinitionId(childExecution.getProcessDefinitionId());
            return;
        }
        ExternalWorkerJobEntityImpl externalWorkerJob = (ExternalWorkerJobEntityImpl)((ExternalWorkerJobQuery)managementService.createExternalWorkerJobQuery().executionId(childExecution.getId())).singleResult();
        if (externalWorkerJob != null) {
            externalWorkerJob.setProcessDefinitionId(childExecution.getProcessDefinitionId());
            return;
        }
    }

    protected void handleExternalWorkerServiceTaskJobUpdate(ExecutionEntity childExecution, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        ManagementService managementService = processEngineConfiguration.getManagementService();
        ExternalWorkerJobEntityImpl externalWorkerJob = (ExternalWorkerJobEntityImpl)((ExternalWorkerJobQuery)managementService.createExternalWorkerJobQuery().executionId(childExecution.getId())).singleResult();
        if (externalWorkerJob != null) {
            externalWorkerJob.setProcessDefinitionId(childExecution.getProcessDefinitionId());
            return;
        }
        DeadLetterJobEntityImpl deadLetterJob = (DeadLetterJobEntityImpl)((DeadLetterJobQuery)managementService.createDeadLetterJobQuery().executionId(childExecution.getId())).singleResult();
        if (deadLetterJob != null) {
            deadLetterJob.setProcessDefinitionId(childExecution.getProcessDefinitionId());
            return;
        }
        SuspendedJobEntityImpl suspendedJob = (SuspendedJobEntityImpl)((SuspendedJobQuery)managementService.createSuspendedJobQuery().executionId(childExecution.getId())).singleResult();
        if (suspendedJob != null) {
            suspendedJob.setProcessDefinitionId(childExecution.getProcessDefinitionId());
            return;
        }
    }

    protected void handleUserTaskNewAssignee(ExecutionEntity taskExecution, String newAssigneeId, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        TaskService taskService = processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        TaskEntityImpl task = (TaskEntityImpl)((TaskQuery)taskService.createTaskQuery(processEngineConfiguration.getCommandExecutor(), (AbstractEngineConfiguration)processEngineConfiguration).executionId(taskExecution.getId())).singleResult();
        if (task != null) {
            TaskHelper.changeTaskAssignee((TaskEntity)task, newAssigneeId);
        }
    }

    protected void handleUserTaskNewOwner(ExecutionEntity taskExecution, String newOwnerId, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        TaskService taskService = processEngineConfiguration.getTaskServiceConfiguration().getTaskService();
        TaskEntityImpl task = (TaskEntityImpl)((TaskQuery)taskService.createTaskQuery(processEngineConfiguration.getCommandExecutor(), (AbstractEngineConfiguration)processEngineConfiguration).executionId(taskExecution.getId())).singleResult();
        if (task != null) {
            TaskHelper.changeTaskOwner((TaskEntity)task, newOwnerId);
        }
    }

    protected boolean isEventSubProcessStart(FlowElement flowElement) {
        return flowElement instanceof StartEvent && flowElement.getSubProcess() != null && flowElement.getSubProcess() instanceof EventSubProcess;
    }

    protected List<ExecutionEntity> createBoundaryEvents(List<BoundaryEvent> boundaryEvents, ExecutionEntity execution, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        ArrayList<ExecutionEntity> boundaryEventExecutions = new ArrayList<ExecutionEntity>(boundaryEvents.size());
        for (BoundaryEvent boundaryEvent : boundaryEvents) {
            if (CollectionUtil.isEmpty((Collection)boundaryEvent.getEventDefinitions())) {
                String eventTypeValue;
                List eventTypeExtensionElements;
                boolean hasEventRegistryBoundaryEvent = false;
                if (!boundaryEvent.getExtensionElements().isEmpty() && (eventTypeExtensionElements = (List)boundaryEvent.getExtensionElements().get("eventType")) != null && !eventTypeExtensionElements.isEmpty() && StringUtils.isNotEmpty((CharSequence)(eventTypeValue = ((ExtensionElement)eventTypeExtensionElements.get(0)).getElementText()))) {
                    hasEventRegistryBoundaryEvent = true;
                }
                if (!hasEventRegistryBoundaryEvent) {
                    continue;
                }
            } else if (boundaryEvent.getEventDefinitions().get(0) instanceof CompensateEventDefinition) continue;
            ExecutionEntity childExecutionEntity = executionEntityManager.createChildExecution(execution);
            childExecutionEntity.setParentId(execution.getId());
            childExecutionEntity.setCurrentFlowElement((FlowElement)boundaryEvent);
            childExecutionEntity.setScope(false);
            boundaryEventExecutions.add(childExecutionEntity);
        }
        return boundaryEventExecutions;
    }

    protected void executeBoundaryEvents(List<BoundaryEvent> boundaryEvents, List<ExecutionEntity> boundaryEventExecutions) {
        if (!CollectionUtil.isEmpty(boundaryEventExecutions)) {
            Iterator<BoundaryEvent> boundaryEventsIterator = boundaryEvents.iterator();
            Iterator<ExecutionEntity> boundaryEventExecutionsIterator = boundaryEventExecutions.iterator();
            while (boundaryEventsIterator.hasNext() && boundaryEventExecutionsIterator.hasNext()) {
                BoundaryEvent boundaryEvent = boundaryEventsIterator.next();
                ExecutionEntity boundaryEventExecution = boundaryEventExecutionsIterator.next();
                ActivityBehavior boundaryEventBehavior = (ActivityBehavior)boundaryEvent.getBehavior();
                this.LOGGER.debug("Executing boundary event activityBehavior {} with execution {}", boundaryEventBehavior.getClass(), (Object)boundaryEventExecution.getId());
                boundaryEventBehavior.execute(boundaryEventExecution);
            }
        }
    }

    protected boolean isExecutionInsideMultiInstance(ExecutionEntity execution) {
        return this.getFlowElementMultiInstanceParentId(execution.getCurrentFlowElement()) != null;
    }

    protected String getFlowElementMultiInstanceParentId(FlowElement flowElement) {
        FlowElementsContainer parentContainer = flowElement.getParentContainer();
        while (parentContainer instanceof Activity) {
            if (this.isFlowElementMultiInstance((FlowElement)((Activity)parentContainer))) {
                return parentContainer.getId();
            }
            parentContainer = ((Activity)parentContainer).getParentContainer();
        }
        return null;
    }

    protected boolean isFlowElementMultiInstance(FlowElement flowElement) {
        if (flowElement instanceof Activity) {
            return ((Activity)flowElement).getLoopCharacteristics() != null;
        }
        return false;
    }

    protected boolean hasSameMultiInstanceConfig(FlowElement sourceElement, FlowElement targetElement) {
        MultiInstanceLoopCharacteristics sourceMIConfig = null;
        if (sourceElement instanceof Activity) {
            sourceMIConfig = ((Activity)sourceElement).getLoopCharacteristics();
        }
        MultiInstanceLoopCharacteristics targetMIConfig = null;
        if (targetElement instanceof Activity) {
            targetMIConfig = ((Activity)targetElement).getLoopCharacteristics();
        }
        if (sourceMIConfig == null || targetMIConfig == null) {
            return false;
        }
        if (sourceMIConfig.isSequential() != targetMIConfig.isSequential()) {
            return false;
        }
        if (sourceMIConfig.getLoopCardinality() != null && !sourceMIConfig.getLoopCardinality().equals(targetMIConfig.getLoopCardinality())) {
            return false;
        }
        return targetMIConfig.getLoopCardinality() == null || targetMIConfig.getLoopCardinality().equals(sourceMIConfig.getLoopCardinality());
    }

    protected void processCreatedEventSubProcess(EventSubProcess eventSubProcess, ExecutionEntity eventSubProcessExecution, Set<String> movingExecutionIds, CommandContext commandContext) {
        ProcessEngineConfigurationImpl processEngineConfiguration = CommandContextUtil.getProcessEngineConfiguration(commandContext);
        EventSubscriptionService eventSubscriptionService = processEngineConfiguration.getEventSubscriptionServiceConfiguration().getEventSubscriptionService();
        ExecutionEntityManager executionEntityManager = processEngineConfiguration.getExecutionEntityManager();
        TimerJobService timerJobService = processEngineConfiguration.getJobServiceConfiguration().getTimerJobService();
        List allStartEvents = eventSubProcess.findAllSubFlowElementInFlowMapOfType(StartEvent.class);
        for (StartEvent startEvent : allStartEvents) {
            if (startEvent.getEventDefinitions().isEmpty()) continue;
            Collection<ExecutionEntity> inactiveExecutionsByProcessInstanceId = executionEntityManager.findInactiveExecutionsByProcessInstanceId(eventSubProcessExecution.getProcessInstanceId());
            Optional<ExecutionEntity> startEventExecution = inactiveExecutionsByProcessInstanceId.stream().filter(execution -> execution.getActivityId().equals(startEvent.getId())).findFirst();
            EventDefinition eventDefinition = (EventDefinition)startEvent.getEventDefinitions().get(0);
            List eventSubscriptions = null;
            if (eventDefinition instanceof SignalEventDefinition) {
                eventSubscriptions = eventSubscriptionService.findEventSubscriptionsByProcessInstanceAndActivityId(eventSubProcessExecution.getProcessInstanceId(), startEvent.getId(), "signal");
            } else if (eventDefinition instanceof MessageEventDefinition) {
                eventSubscriptions = eventSubscriptionService.findEventSubscriptionsByProcessInstanceAndActivityId(eventSubProcessExecution.getProcessInstanceId(), startEvent.getId(), "message");
            }
            boolean isOnlyRemainingExecutionAtParentScope = this.isOnlyRemainingExecutionAtParentScope(eventSubProcessExecution, movingExecutionIds, commandContext);
            if (startEvent.isInterrupting() || isOnlyRemainingExecutionAtParentScope) {
                if (eventSubscriptions != null && !eventSubscriptions.isEmpty()) {
                    eventSubscriptions.forEach(arg_0 -> ((EventSubscriptionService)eventSubscriptionService).deleteEventSubscription(arg_0));
                }
                if (eventDefinition instanceof TimerEventDefinition && startEventExecution.isPresent()) {
                    List timerJobsByExecutionId = timerJobService.findTimerJobsByExecutionId(startEventExecution.get().getId());
                    timerJobsByExecutionId.forEach(arg_0 -> ((TimerJobService)timerJobService).deleteTimerJob(arg_0));
                }
                if (startEventExecution.isPresent()) {
                    executionEntityManager.deleteExecutionAndRelatedData(startEventExecution.get(), "event subprocess(" + startEvent.getId() + ")", false);
                }
                List<ExecutionEntity> childExecutions = executionEntityManager.collectChildren(eventSubProcessExecution.getParent());
                for (int i = childExecutions.size() - 1; i >= 0; --i) {
                    ExecutionEntity childExecutionEntity = childExecutions.get(i);
                    if (childExecutionEntity.isEnded() || childExecutionEntity.getId().equals(eventSubProcessExecution.getId()) || movingExecutionIds.contains(childExecutionEntity.getId())) continue;
                    executionEntityManager.deleteExecutionAndRelatedData(childExecutionEntity, "event subprocess(" + startEvent.getId() + ")", false);
                }
                continue;
            }
            if (eventDefinition instanceof MessageEventDefinition && (eventSubscriptions == null || eventSubscriptions.isEmpty())) {
                MessageEventDefinition messageEventDefinition = (MessageEventDefinition)eventDefinition;
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(eventSubProcessExecution.getProcessDefinitionId());
                if (bpmnModel.containsMessageId(messageEventDefinition.getMessageRef())) {
                    messageEventDefinition.setMessageRef(bpmnModel.getMessage(messageEventDefinition.getMessageRef()).getName());
                }
                ExecutionEntity messageExecution = processEngineConfiguration.getExecutionEntityManager().createChildExecution(eventSubProcessExecution.getParent());
                messageExecution.setCurrentFlowElement((FlowElement)startEvent);
                messageExecution.setEventScope(true);
                messageExecution.setActive(false);
                String messageName = EventDefinitionExpressionUtil.determineMessageName(commandContext, messageEventDefinition, null);
                EventSubscriptionEntity messageSubscription = (EventSubscriptionEntity)eventSubscriptionService.createEventSubscriptionBuilder().eventType("message").eventName(messageName).executionId(messageExecution.getId()).processInstanceId(messageExecution.getProcessInstanceId()).activityId(messageExecution.getCurrentActivityId()).processDefinitionId(messageExecution.getProcessDefinitionId()).tenantId(messageExecution.getTenantId()).create();
                CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)messageSubscription);
                messageExecution.getEventSubscriptions().add(messageSubscription);
                processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createMessageEvent(FlowableEngineEventType.ACTIVITY_MESSAGE_WAITING, messageSubscription.getActivityId(), messageSubscription.getEventName(), null, messageSubscription.getExecutionId(), messageSubscription.getProcessInstanceId(), messageSubscription.getProcessDefinitionId()), processEngineConfiguration.getEngineCfgKey());
            }
            if (eventDefinition instanceof SignalEventDefinition && (eventSubscriptions == null || eventSubscriptions.isEmpty())) {
                SignalEventDefinition signalEventDefinition = (SignalEventDefinition)eventDefinition;
                BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel(eventSubProcessExecution.getProcessDefinitionId());
                Signal signal = bpmnModel.getSignal(signalEventDefinition.getSignalRef());
                if (signal != null) {
                    signalEventDefinition.setSignalRef(signal.getName());
                }
                ExecutionEntity signalExecution = processEngineConfiguration.getExecutionEntityManager().createChildExecution(eventSubProcessExecution.getParent());
                signalExecution.setCurrentFlowElement((FlowElement)startEvent);
                signalExecution.setEventScope(true);
                signalExecution.setActive(false);
                String eventName = EventDefinitionExpressionUtil.determineSignalName(commandContext, signalEventDefinition, bpmnModel, null);
                EventSubscriptionEntity signalSubscription = (EventSubscriptionEntity)eventSubscriptionService.createEventSubscriptionBuilder().eventType("signal").eventName(eventName).signal(signal).executionId(signalExecution.getId()).processInstanceId(signalExecution.getProcessInstanceId()).activityId(signalExecution.getCurrentActivityId()).processDefinitionId(signalExecution.getProcessDefinitionId()).tenantId(signalExecution.getTenantId()).create();
                CountingEntityUtil.handleInsertEventSubscriptionEntityCount((EventSubscription)signalSubscription);
                signalExecution.getEventSubscriptions().add(signalSubscription);
                processEngineConfiguration.getEventDispatcher().dispatchEvent((FlowableEvent)FlowableEventBuilder.createSignalEvent(FlowableEngineEventType.ACTIVITY_SIGNAL_WAITING, signalSubscription.getActivityId(), signalSubscription.getEventName(), null, signalSubscription.getExecutionId(), signalSubscription.getProcessInstanceId(), signalSubscription.getProcessDefinitionId()), processEngineConfiguration.getEngineCfgKey());
            }
            if (!(eventDefinition instanceof TimerEventDefinition) || startEventExecution.isPresent()) continue;
            TimerEventDefinition timerEventDefinition = (TimerEventDefinition)eventDefinition;
            ExecutionEntity timerExecution = processEngineConfiguration.getExecutionEntityManager().createChildExecution(eventSubProcessExecution.getParent());
            timerExecution.setCurrentFlowElement((FlowElement)startEvent);
            timerExecution.setEventScope(true);
            timerExecution.setActive(false);
            TimerJobEntity timerJob = TimerUtil.createTimerEntityForTimerEventDefinition(timerEventDefinition, (FlowElement)startEvent, false, timerExecution, "trigger-timer", TimerEventHandler.createConfiguration(startEvent.getId(), timerEventDefinition.getEndDate(), timerEventDefinition.getCalendarName()));
            if (timerJob == null) continue;
            timerJobService.scheduleTimerJob(timerJob);
        }
    }

    protected boolean sameBoundaryEventDefinition(BoundaryEvent sourceEvent, BoundaryEvent targetEvent) {
        if (sourceEvent.getEventDefinitions() != null && !sourceEvent.getEventDefinitions().isEmpty() && (targetEvent.getEventDefinitions() == null || targetEvent.getEventDefinitions().isEmpty())) {
            return false;
        }
        if ((sourceEvent.getEventDefinitions() == null || sourceEvent.getEventDefinitions().isEmpty()) && targetEvent.getEventDefinitions() != null && !targetEvent.getEventDefinitions().isEmpty()) {
            return false;
        }
        if (sourceEvent.getEventDefinitions() != null && !sourceEvent.getEventDefinitions().isEmpty()) {
            EventDefinition sourceEventDef = (EventDefinition)sourceEvent.getEventDefinitions().get(0);
            EventDefinition targetEventDef = (EventDefinition)targetEvent.getEventDefinitions().get(0);
            if (!sourceEventDef.getClass().getName().equals(targetEventDef.getClass().getName())) {
                return false;
            }
            if (sourceEventDef instanceof SignalEventDefinition) {
                SignalEventDefinition signalSourceDef = (SignalEventDefinition)sourceEventDef;
                SignalEventDefinition signalTargetDef = (SignalEventDefinition)targetEventDef;
                if (StringUtils.isNotEmpty((CharSequence)signalSourceDef.getSignalRef()) && signalSourceDef.getSignalRef().equals(signalTargetDef.getSignalRef())) {
                    return true;
                }
                if (StringUtils.isNotEmpty((CharSequence)signalSourceDef.getSignalExpression()) && signalSourceDef.getSignalExpression().equals(signalTargetDef.getSignalRef())) {
                    return true;
                }
            } else if (sourceEventDef instanceof MessageEventDefinition) {
                MessageEventDefinition messageSourceDef = (MessageEventDefinition)sourceEventDef;
                MessageEventDefinition messageTargetDef = (MessageEventDefinition)targetEventDef;
                if (StringUtils.isNotEmpty((CharSequence)messageSourceDef.getMessageRef()) && messageSourceDef.getMessageRef().equals(messageTargetDef.getMessageRef())) {
                    return true;
                }
                if (StringUtils.isNotEmpty((CharSequence)messageSourceDef.getMessageExpression()) && messageSourceDef.getMessageExpression().equals(messageTargetDef.getMessageExpression())) {
                    return true;
                }
            } else if (sourceEventDef instanceof TimerEventDefinition) {
                TimerEventDefinition timerSourceDef = (TimerEventDefinition)sourceEventDef;
                TimerEventDefinition timerTargetDef = (TimerEventDefinition)targetEventDef;
                if (StringUtils.isNotEmpty((CharSequence)timerSourceDef.getTimeCycle()) && timerSourceDef.getTimeCycle().equals(timerTargetDef.getTimeCycle())) {
                    return true;
                }
                if (StringUtils.isNotEmpty((CharSequence)timerSourceDef.getTimeDate()) && timerSourceDef.getTimeDate().equals(timerTargetDef.getTimeDate())) {
                    return true;
                }
                if (StringUtils.isNotEmpty((CharSequence)timerSourceDef.getTimeDuration()) && timerSourceDef.getTimeDuration().equals(timerTargetDef.getTimeDuration())) {
                    return true;
                }
            }
        } else if (!sourceEvent.getExtensionElements().isEmpty() && !targetEvent.getExtensionElements().isEmpty()) {
            List sourceEventTypeExtensionElements = (List)sourceEvent.getExtensionElements().get("eventType");
            List targetEventTypeExtensionElements = (List)targetEvent.getExtensionElements().get("eventType");
            String sourceEventTypeValue = null;
            if (sourceEventTypeExtensionElements != null && !sourceEventTypeExtensionElements.isEmpty()) {
                sourceEventTypeValue = ((ExtensionElement)sourceEventTypeExtensionElements.get(0)).getElementText();
            }
            String targetEventTypeValue = null;
            if (targetEventTypeExtensionElements != null && !targetEventTypeExtensionElements.isEmpty()) {
                targetEventTypeValue = ((ExtensionElement)targetEventTypeExtensionElements.get(0)).getElementText();
            }
            if (StringUtils.isNotEmpty(sourceEventTypeValue) && StringUtils.isNotEmpty(targetEventTypeValue) && sourceEventTypeValue.equals(targetEventTypeValue)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isOnlyRemainingExecutionAtParentScope(ExecutionEntity executionEntity, Set<String> ignoreExecutionIds, CommandContext commandContext) {
        ExecutionEntityManager executionEntityManager = CommandContextUtil.getExecutionEntityManager(commandContext);
        List<ExecutionEntity> siblingExecutions = executionEntityManager.findChildExecutionsByParentExecutionId(executionEntity.getParentId());
        return siblingExecutions.stream().filter(DelegateExecution::isActive).filter(execution -> !execution.getId().equals(executionEntity.getId())).filter(execution -> !ignoreExecutionIds.contains(execution.getId())).count() == 0L;
    }

    protected boolean isExpression(String variableName) {
        return variableName.startsWith("${") || variableName.startsWith("#{");
    }

    protected ProcessDefinition resolveProcessDefinition(String processDefinitionKey, Integer processDefinitionVersion, String tenantId, CommandContext commandContext) {
        ProcessDefinitionEntityManager processDefinitionEntityManager = CommandContextUtil.getProcessDefinitionEntityManager(commandContext);
        ProcessDefinition processDefinition = processDefinitionVersion != null ? processDefinitionEntityManager.findProcessDefinitionByKeyAndVersionAndTenantId(processDefinitionKey, processDefinitionVersion, tenantId) : (tenantId == null || "".equals(tenantId) ? processDefinitionEntityManager.findLatestProcessDefinitionByKey(processDefinitionKey) : processDefinitionEntityManager.findLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId));
        if (processDefinition == null) {
            DeploymentManager deploymentManager = CommandContextUtil.getProcessEngineConfiguration(commandContext).getDeploymentManager();
            processDefinition = tenantId == null || "".equals(tenantId) ? deploymentManager.findDeployedLatestProcessDefinitionByKey(processDefinitionKey) : deploymentManager.findDeployedLatestProcessDefinitionByKeyAndTenantId(processDefinitionKey, tenantId);
        }
        return processDefinition;
    }

    private String printFlowElementIds(Collection<MoveExecutionEntityContainer.FlowElementMoveEntry> flowElements) {
        return flowElements.stream().map(MoveExecutionEntityContainer.FlowElementMoveEntry::getNewFlowElement).map(BaseElement::getId).collect(Collectors.joining(","));
    }
}

